<?php

// Modif YB OK

class AdminSearchController extends AdminSearchControllerCore
{
    private function priceministerOrdersTableExists()
    {
        $result = null;

        try {
            $result = Db::getInstance()->executeS('SHOW TABLES LIKE "'._DB_PREFIX_.'priceminister_orders"');
        } catch (Exception $e) {
            $e->getMessage();
        }

        if (!count($result)) {
            try {
                $result = Db::getInstance()->executeS('SHOW COLUMNS FROM `'._DB_PREFIX_.$this->_delivery.'`');
            } catch (Exception $e) {
                $e->getMessage();
            }
        }

        if (!is_array($result) || !count($result)) {
            return (false);
        }

        return (true);
    }

    private function feedbizOrdersTableExists()
    {
        $result = null;

        try {
            $result = Db::getInstance()->executeS('SHOW TABLES LIKE "'._DB_PREFIX_.'feedbiz_orders"');
        } catch (Exception $e) {
            $e->getMessage();
        }

        if (!count($result)) {
            try {
                $result = Db::getInstance()->executeS('SHOW COLUMNS FROM `'._DB_PREFIX_.$this->_delivery.'`');
            } catch (Exception $e) {
                $e->getMessage();
            }
        }

        if (!is_array($result) || !count($result)) {
            return (false);
        }

        return (true);
    }

    protected function initProductList()
    {
        parent::initProductList();
        $this->fields_list['products']["quantity"] = array(
            'title' => $this->l('Quantity'),
            'align' => 'center',
            'width' => 150
        );
    }

    public function postProcess()
    {
        $this->context = Context::getContext();
        $this->query = trim(Tools::getValue('bo_query'));
        $searchType = (int)Tools::getValue('bo_search_type');
        /* Handle empty search field */

        if (!empty($this->query)) {
            /* Order */
            if (!$searchType || $searchType == 3) {
                if (Validate::isLabel(trim($this->query))) {
                    /* , 'CDiscount', 'Jet', 'FNAC', 'Pixmania', 'RueDuCommerce', 'monEchelle', 'GoSport', 'Spartoo', 'Play' */
                    foreach (array('Amazon', 'CDiscount', 'FNAC') as $module) {
                        if (Module::isInstalled($module)) {
                            $module_name = Tools::strtolower($module);
                            $order_class = _PS_MODULE_DIR_.$module_name.'/classes/'.$module_name.'.order.class.php';

                            if (file_exists($order_class)) {
                                require_once($order_class);
                                $class_name = $module.'_Order';

                                if (method_exists($class_name, 'checkByMpId')) {
                                    $ret = $class_name::checkByMpId(trim($this->query));

                                    if (is_numeric($ret) && $ret > 0) {
                                        $id_order = (int)$ret;
                                    } elseif (isset($ret['id_order']) && is_numeric($ret['id_order']) && $ret['id_order'] > 0) {
                                        $id_order = (int)$ret['id_order'];
                                    } else {
                                        $id_order = 0;
                                    }

                                    if ($id_order) {
                                        Tools::redirectAdmin('index.php?tab=AdminOrders&id_order='.(int)$id_order.'&vieworder'.'&token='.Tools::getAdminTokenLite('AdminOrders'));
                                    }
                                }
                            }
                        }
                    }

                    if (Module::isInstalled('jet')) {
                        $sql = '
								SELECT `id_order`
								FROM (
									SELECT `id_order` FROM `'._DB_PREFIX_.'orders` WHERE `mp_order_id` = "'.pSQL(trim($this->query)).'"';

                        if ($this->priceministerOrdersTableExists()) {
                            $sql .= '
									UNION ALL
									SELECT `id_order` FROM `'._DB_PREFIX_.'priceminister_orders` WHERE `mp_order_id` = "'.pSQL(trim($this->query)).'"
								';
                        }

                        $sql .= '	) AS `id_order`';

                        $result = Db::getInstance()->getRow($sql);

                        if (isset($result['id_order']) && (int)$result['id_order']) {
                            Tools::redirectAdmin('index.php?tab=AdminOrders&id_order='.(int)$result['id_order'].'&vieworder'.'&token='.Tools::getAdminTokenLite('AdminOrders'));
                        }
                    }


                    if (Module::isInstalled('feedbiz')) {
                        $sql = '
								SELECT `id_order`
								FROM (
									SELECT `id_order` FROM `'._DB_PREFIX_.'orders` WHERE `mp_order_id` = "'.pSQL(trim($this->query)).'"';

                        if ($this->feedbizOrdersTableExists()) {
                            $sql .= '
									UNION ALL
									SELECT `id_order` FROM `'._DB_PREFIX_.'feedbiz_orders` WHERE `mp_number` = "'.pSQL(trim($this->query)).'"
								';
                        }

                        $sql .= '	) AS `id_order`';

                        $result = Db::getInstance()->getRow($sql);

                        if (isset($result['id_order']) && (int)$result['id_order']) {
                            Tools::redirectAdmin('index.php?tab=AdminOrders&id_order='.(int)$result['id_order'].'&vieworder'.'&token='.Tools::getAdminTokenLite('AdminOrders'));
                        }
                    }
                }
            }
        }
        parent::postProcess();

        $this->display = 'view';
    }
}
