/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from Common-Services Co., Ltd.
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: contact@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe Common-Services Co., Ltd.
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la Common-Services Co. Ltd. est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter Common-Services Co., Ltd. a l'adresse: contact@common-services.com
 *
 * @package   Amazon Market Place
 * @author    Olivier B.
 * @copyright Copyright (c) 2011-2018 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @license   Commercial license
 * Support by mail:  support.amazon@common-services.com
 */
var pageProfiles2 = false;

$(document).ready(function () {
    if (pageProfiles2) return;
    pageProfiles2 = true;

    var start_time = [];

    function logtime(action, end)
    {
        if (!window.console)
            return(false);

        if (typeof(start_time[action]) == 'undefined' || start_time[action] == null)
            start_time[action] = new Date().getTime();

        if (end)
        {
            var end_time = new Date().getTime();

            console.log('Logtime for '+action+' duration:', end_time - start_time[action]);

            start_time[action] = null;
        }
    }

    logtime('profiles.js overall', false);

    var tagify_bn_params = {
        delimiters: [13, 44, 59, 58],
        addTagPrompt: $('#text-add-browsenodes').val(),
        addTagOnBlur: true
    };

    $('#menudiv-profiles').delegate('input.profile-name', 'keypress', function () {
        var regex = new RegExp("[\+\&]");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (regex.test(key)) {
            event.preventDefault();
            return false;
        }
    });

    $('#menudiv-profiles label.tip[title], #menudiv-profiles label.tip2[title]').each(function () {
        $(this).qtip();
    });

    var sessionId = new Date().valueOf();
    var uniqueId = parseInt(sessionId) + 1;

    var chosen_params = {
        'width': '400px',
        'search_contains': true,
        'placeholder_text_single': $('#text-add-select-option').val(),
        'no_results_text': $('#text-add-select-no-result').val()
    };

    $('.profile-stored select.profile-universe, .profile-stored select.product_type', $('#menudiv-profiles')).chosen(chosen_params);

    /*
     *  PROFILES MANAGEMENT
     */

    $('#profile-add').click(function () {
        if (window.console)
            console.log('Add Profile');

        var cloned = $('#master-profile').clone().removeAttr('id').removeClass('master-profile').addClass('profile').prependTo('#profile-container').slideDown('slow');

        cloned.find('.profile-del').click(function () {
            $(this).parent().slideUp('slow', function () {
                $(this).remove();
            });
        });

        cloned.find('.profile-universe').change(function () {
            selectUniverse($(this));
        });
        // price rules
        cloned.find('.price-rule-type').change(function () {
            var type = $(this).val();
            if (type !== 'percent' && type !== 'value')
                return (false);
            $(this).parent().find('select[rel="percent"], select[rel="value"]').hide();
            $(this).parent().find('select[rel="' + type + '"]').show();
        });
        cloned.find('.price-rule-add').click(function () {
            var source_i = $(this).parent();
            var dest_i = $(this).parent().parent();
            var is_first_rule = $(dest_i).find('.price-rule').length;

            var from_val = Number(dest_i.find('input[rel=from]:last').val());
            var to_val = Number(dest_i.find('input[rel=to]:last').val());

            dest_i.find('input[rel=from]:last,input[rel=to]:last').removeClass('required');

            if (!dest_i.find('input[rel=from]:last').val().length || (is_first_rule !== 1 && !parseInt(from_val)))
                from_val = null;

            if (!dest_i.find('input[rel=to]:last').val().length || !parseInt(to_val))
                to_val = null;

            if (parseInt(from_val) && parseInt(to_val) && from_val > to_val && from_val >= (parseInt(source_i.find('input[rel=from]').val()) + 1)) {
                dest_i.find('input[rel=to]:last').val('');
                to_val = null;
            }
            else if (parseInt(from_val) && parseInt(to_val) && from_val > to_val) {
                dest_i.find('input[rel=from]:last').val('');
                from_val = null;
            }

            if (!to_val || (is_first_rule !== 1 && !from_val)) {
                if (from_val === null)
                    dest_i.find('input[rel=from]:last').addClass('required');
                if (to_val === null)
                    dest_i.find('input[rel=to]:last').addClass('required');
                return (false);
            }
            var cloned2 = source_i.clone().appendTo(dest_i);
            cloned2.find('input').val('');
            cloned2.find('input[rel=from]').val(parseInt(to_val + 1));

            cloned2.find('.price-rule-add, .price-rule-remove').toggle();
            cloned2.find('.price-rule-remove').
            click(function () {
                $(this).parent().remove();
            });
        });
        cloned.find('.price-rule-remove').click(function () {
            $(this).parent().remove();
        });

        if ($.isFunction($('.tagify').tagify))
            $('.browsenode', cloned).tagify(tagify_bn_params).attr('has', 'tagify');

        addTip(cloned);

        $('select.profile-universe', cloned).chosen(chosen_params);
    });

    function addTip(obj)
    {
        logtime('Loading profiles tips', false);
        $('label[rel]', obj).each(function () {

            var target_glossary_key = $(this).attr('rel');
            var target_glossary_div = $('#glossary div.glossary[rel="' + target_glossary_key + '"]');

            if (target_glossary_div && target_glossary_div.length) {
                if ($('span', this) && $('span', this))
                    var title = $('span', this).text();
                else
                    var title = null;

                $(this).qtip({

                    content: {
                        text: target_glossary_div.html(),
                        title: title
                    },
                    hide: {
                        fixed: true,
                        delay: 300
                    },
                    plugins: {}
                });
                $(this).addClass('tip');
            }
        });
        logtime('Loading profiles tips', true);
    }

    $('.profile-universe', $('#menudiv-profiles')).change(function (ev) {
        ev.preventDefault();
        if (window.console)
            console.log($(this));
        selectUniverse($(this));
    });


    $('#menudiv-profiles').delegate('.type_reload', 'click', function () {
        var source_select = $('select.profile-universe', $(this).parents().get(2));
        if (window.console)
            console.log(source_select);
        selectUniverse(source_select);
    });

    $('.profile-del-img', $('#menudiv-profiles')).click(function () {
        profile_id = $(this).attr('rel');
        $('#menudiv-profiles .profile[rel=' + profile_id + ']').slideUp('slow', function () {
            $(this).remove();
        });
        $('#profile-header-' + profile_id).slideUp('slow', function () {
            $(this).remove();
        });
    });

    $('.profile-edit-img', $('#menudiv-profiles')).click(function () {
        profile_id = $(this).attr('rel');
        $('#menudiv-profiles .profile[rel=' + profile_id + ']').slideToggle('slow');
    });


    // Fetch XSD
    //
    function selectUniverse(obj) {
        var source_div = $(obj).parents().get(3);
        var source_tab = $(obj).parents().get(2);

        var profile = $('input[name^="profiles[name]"]', source_div).val();
        var result = $('.fetch-result', source_tab);
        var selected = $(obj).val();
        var product_type = $('.product_type', source_tab);
        var mandatory_fields = $('.mandatory_fields', source_tab);

        if (window.console)
            console.log(source_div, source_tab);

        if (!profile || !profile.length) {
            alert($('#error_profile_name').val());
            $('select.profile-universe', source_div).val(null);
            return (false);
        }
        $('#ajax-error').html('').hide();

        var loader = $('.xsd-load', $(source_div));

        loader.show();
        mandatory_fields.parent().hide();

        var lang = $('.amazon-tab-selector.active', source_div).attr('rel');
        var id_lang = $('.amazon-tab-selector.active input[rel=id_lang]', source_div).val();

        $.ajax({
            type: 'POST',
            url: $('#xsd_operations_url').val() + '?callback=?',
            data: 'action=fetch&id_lang=' + id_lang + '&lang=' + lang + '&selected=' + selected + '&rand=' + new Date().valueOf() + '&callback=?',
            success: function (result) {
                loader.hide();
                mandatory_fields.html('');
                if (window.console) {
                    console.log(product_type, result);
                }
                product_type.html(result);
                product_type.unbind('change').change(function (obj) {
                    changeProductType(source_div, source_tab, product_type, selected);
                });
                $('select.product_type', source_div).trigger('chosen:updated');
                $('select.product_type', source_div).chosen(chosen_params);
            },
            error: function (result) {
                loader.hide();
                if (window.console)
                    console.log(result);
                $('#ajax-error').html($('#xsd_ajax_error').val()).show();
                if (result.status && result.status.length)
                    $('#ajax-error').append('<pre>Status:' + result.status + '</pre>');
                if (result.statusText && result.statusText.length)
                    $('#ajax-error').append('<pre>Status:' + result.statusText + '</pre>');
                if (result.responseText && result.responseText.length)
                    $('#ajax-error').append('<pre>' + result.responseText + '</pre>');
            }
        });
        return (false);
    }

    function changeProductType(source_div, source_tab, product_type, selected) {

        var profile = $('input[name^="profiles[name]"]', $(source_div)).val();
        var mandatory_fields = $('.mandatory_fields', $(source_tab));

        if (window.console)
            console.log(source_div, source_tab);

        var loader = $('.xsd-load', $(source_div));

        loader.show();
        mandatory_fields.parent().hide();

        var lang = $('.amazon-tab-selector.active', source_div).attr('rel');
        var id_lang = $('.amazon-tab-selector.active input[rel=id_lang]', source_div).val();

        $('#ajax-error').html('').hide();

        $.ajax({
            type: 'POST',
            url: $('#xsd_operations_url').val() + '?callback=?',
            dataType: 'json',
            data: 'action=extrafields&id_lang=' + id_lang + '&lang=' + lang + '&profile=' + encodeURIComponent(profile) + '&selected=' + $(product_type).val() + '&universe=' + selected + '&rand=' + new Date().valueOf(),
            beforeProcess: function (data) {
                $(mandatory_fields).html('');
            },
            success: function (result) {
                if (window.console)
                    console.log(result);
                loader.hide();
                if (result.errors) {
                    $('#ajax-error').html($('#xsd_ajax_error').val() + '<br />' + result.errors).show();
                    if (result.status && result.status.length)
                        $('#ajax-error').append('<pre>Status:' + result.status + '</pre>');
                    if (result.statusText && result.statusText.length)
                        $('#ajax-error').append('<pre>Status:' + result.statusText + '</pre>');
                    if (result.responseText && result.responseText.length)
                        $('#ajax-error').append('<pre>' + result.responseText + '</pre>');
                }

                mandatory_fields.html(result.fields).parent().show();
                addTip(mandatory_fields);
                $('.tip', mandatory_fields).not('label[rel]').qtip();
                $('.tip2', mandatory_fields).not('label[rel]').qtip();

                onChangeSortVariant(mandatory_fields);
                onChangeMultipleSelect(mandatory_fields);
                checkMaxInputVarsAgain();
            },
            error: function (result) {
                if (window.console)
                    console.log(result);
                loader.hide();
                $('#ajax-error').html($('#xsd_ajax_error').val()).show();
                if (result.status && result.status.length)
                    $('#ajax-error').append('<pre>Status:' + result.status + '</pre>');
                if (result.statusText && result.statusText.length)
                    $('#ajax-error').append('<pre>Status:' + result.statusText + '</pre>');
                if (result.responseText && result.responseText.length)
                    $('#ajax-error').append('<pre>' + result.responseText + '</pre>');
            }
        });
        return (true);
    }

    function onChangeSortVariant() {
        $('select.variation, select.variation-selected').change(function () {
            sortVariant($(this));
        });
    }

    $('select.variation, select.variation-selected').change(function () {
        sortVariant($(this));
    });

    function checkMaxInputVarsAgain()
    {
        logtime('checkMaxInputVarsAgain', false);
        var max_input_vars = parseInt($('#max_input_vars').val());
        var cur_input_vars = $('input, select, textarea, button').length;

        if (max_input_vars && max_input_vars < cur_input_vars) {
            $('#error-max_input_vars').show();
            $('#amz-env-infos').show();
            $('#error-max_input_vars').clone().prependTo($($('#profile-add').parents().get(1)).after());
        }
        logtime('checkMaxInputVarsAgain', true);
    }


    function sortVariant(obj) {
        if (!obj.val() || !obj.val().length)
            return (false);

        var variant_item_list = obj.find('option:selected').attr('rel');
        var variant_items = variant_item_list.split(',');
        var source_div = obj.parents().get(1);

        var variant_container = $(source_div).find('.variant-items-container');

        $(source_div).find('.variant-items-container div.specific-field-data select').removeClass('variation-mandatory');
        $(source_div).find('.variant-items-container div.specific-field-data').appendTo($(source_div).find('.variant-items-container-restore').get(0));

        if (variant_items.length) {
            $.each(variant_items, function (index, value) {
                $(source_div).find('div.variation[rel="' + value + '"]').appendTo(variant_container.get(0));
                $(source_div).find('div.variation[rel="' + value + '"]').find('select').addClass('variation-mandatory');
            });
        }

    }

    $('.profile-attribute', $('#menudiv-profiles')).change(function (ev) {
        return (changeMultipleSelect(this));
    });
    function onChangeMultipleSelect(fields_div) {
        $(fields_div).find('.profile-attribute').each(function (ind, val) {
            $(this).change(function (ev) {
                return (changeMultipleSelect(this));
            });
        });
    }

    function changeMultipleSelect(selector) {
	
	if($(selector).attr('rel') != 'default') {
	    if ($(selector).val() == '^d') {
		$(selector).parent().find('input').hide();
		$(selector).parent().find('input[rel="default"], select[rel="default"]').show();
	    }
	    else {
		$(selector).parent().find('input[rel="default"], select[rel="default"]').hide();
	    }
	}

        if ($(selector).attr('rel') && $(selector).attr('rel').length) {
            target_div = $(selector).parents().get(2);

            if ($(selector).val() && $(selector).val().length)
                $(target_div).find('.profile-amazon-unit[rel=' + $(selector).attr('rel') + ']').show();
            else
                $(target_div).find('.profile-amazon-unit[rel=' + $(selector).attr('rel') + ']').hide();
        }
    }

    $('#menudiv-profiles').delegate('.profile .bullet-point-edit-img', 'click', function (ev) {
        var profile = $(this).parents().get(3);
        var id_bullet_point = $(this).parent().attr('rel');

        BulletPointGenerator(profile, id_bullet_point);
    });

    $('#menudiv-profiles').delegate('.profile .bullet-point-item span a', 'click', function (ev) {
        ev.preventDefault();
        var target_item = $($(this).parents().get(2));

        if (window.console)
            console.log('Delete Bulletpoint', target_item);

        $('.bullet-point-item span', target_item).hide();
        $('input', target_item).val('');

    });


    $('#menudiv-profiles').delegate('.profile .delete-optionnals', 'click', function (ev) {
        var target_item = $($(this).parents().get(2));

        console.log(target_item);

        $('.specific-field-data.optionnal', target_item).each(function (i, item) {
            if (!$('select.profile-attribute :selected', item).val().length) {
                rel_attr = $(this).attr('rel');
                $(this).slideUp().remove(); // remove specific field section for this item
                if (rel_attr && rel_attr.length) // remove associated amazon attribute
                    $('.profile-amazon-unit[rel="' + rel_attr + '"]', $(this).parents().get(0)).remove();
            }
        });
    });

    /*
    function bulletPointGenerator(profile, id_bullet_point) {
        if (window.console)
            console.log('bulletPointGenerator', profile, id_bullet_point);

        var uniqueBulletPointId = 'bp-tmp-' + uniqueId++;
        var target_bullet_point = $('.bullet-point-container[rel=' + id_bullet_point + ']', profile);
        var bullet_point_data = $('input', target_bullet_point).val();

        target_bullet_point.attr('id', uniqueBulletPointId);

        var pAjax = new Object();

        pAjax.url = $('#amazon_tools_url').val() + '&id_lang=' + $('#id_lang').val() + '&action=bullet-point-generator&id=' + uniqueBulletPointId;
        pAjax.type = 'POST';
        pAjax.data_type = 'jsonp';
        pAjax.data = 'data=' + bullet_point_data;

        if (window.console)
            console.log(pAjax);

        $.ajax({
            type: pAjax.type,
            url: pAjax.url,
            dataType: pAjax.data_type,
            data: pAjax.data,
            success: function (data) {
                if (window.console)
                    console.log(data);

                if (data.html) {
                    $('#amazon-bulletpoint-box, #amazon-bulletpoint-overlay').remove();
                    $('<div id="amazon-bulletpoint-overlay">').appendTo('body');
                    $('<div id="amazon-bulletpoint-box">').appendTo('body');
                    $('#amazon-bulletpoint-box').html(data.html);
                    $('.bulletpoint-box').fadeIn();
                }
            },
            error: function (data) {
                console.log('error', data);
            }
        });
    }
    */

    $('#menudiv-profiles').delegate('.country-selector td', 'click', function () {

    //$('#menudiv-profiles').delegate('.amazon-tab-selector', 'click', function () {
        var target_profile = $($(this).parents().get(4));
        var target_selector = $('span.amazon-tab-selector', this);

        if (window.console) console.log(target_profile, this);

        if (!target_selector.hasClass('active')) {
            var iso_code = target_selector.attr('rel');

            $('.amazon-tab-selector', target_profile).removeClass('active');
            target_selector.addClass('active');
            $('.amazon-tab', target_profile).hide();
            $('.amazon-tab[rel="' + iso_code + '"]', target_profile).show();
        }
    });

    if ($.isFunction($('.tagify').tagify)) {
        $('#menudiv-profiles #profile-items .profile .browsenode').tagify(tagify_bn_params);
        $('#menudiv-profiles #profile-items .profile input.browsenode').attr('has', 'tagify');
    }


    // Fetch XSD
    //
    function loadSpecificFields() {
        var target_field = $('.mandatory_fields input[rel=has_data][value="0"]', '#menudiv-profiles .specific-fields').first();

        if (!$(target_field).length)
            return;

        var target_div = $(target_field).parent();
        var profile = $($(target_div).parents().get(1));
        var subprofile = $($(target_div).parents().get(0));

        logtime('Loading profile datas for ' + profile, false);

        var loader = $('.xsd-load', profile);

        //if (!$('.mandatory_fields input[rel=has_data][value=0]', subprofile).length)
        //    return;

        var mandatory_fields = $('.mandatory_fields', subprofile);
        var profile_id_lang = $('.mandatory_fields input[rel=profile_id_lang]', subprofile).val();
        var profile_key = $('.mandatory_fields input[rel=profile_key]', subprofile).val();

        var lang = $('.amazon-tab-selector.active', profile).attr('rel');

        mandatory_fields.parent().hide();
        loader.show();

        if ($('select.product_type', profile).length && $('select.product_type', profile).val().length) {
            $('#menu-profiles .profiles-loader').show();

            $.ajax({
                type: 'POST',
                url: $('#xsd_operations_url').val() + '?callback=?',
                data: 'action=load&id_lang=' + profile_id_lang + '&lang=' + lang + '&profile_key=' + profile_key + '&rand=' + new Date().valueOf() + '&callback=?',
                success: function (result) {
                    loader.hide();

                    if (typeof(result) == 'object' && result.error) {
                        mandatory_fields.html(null).parent().hide();
                    }
                    else if (result && result.length) {
                        mandatory_fields.html(result).parent().show();

                        addTip(mandatory_fields);
                        $('.tip', mandatory_fields).not('label[rel]').qtip();
                        $('.tip2', mandatory_fields).not('label[rel]').qtip();

                        onChangeSortVariant(mandatory_fields);
                        onChangeMultipleSelect(mandatory_fields);
                    }
                    $(target_field).remove();

                    if (window.console)
                        console.log('loadSpecificFields: Recurse', profile, subprofile);

                    $('#menu-profiles .profiles-loader').hide();

                    logtime('Loading profile datas for ' + profile, true);

                    loadSpecificFields();//recurse
                },
                error: function (result) {
                    loader.hide();

                    $('#menu-profiles .profiles-loader').hide();

                    if (window.console)
                        console.log(result);
                    $('#ajax-error').html($('#xsd_ajax_error').val()).show();
                    if (result.status && result.status.length)
                        $('#ajax-error').append('<pre>Status:' + result.status + '</pre>');
                    if (result.statusText && result.statusText.length)
                        $('#ajax-error').append('<pre>Status:' + result.statusText + '</pre>');
                    if (result.responseText && result.responseText.length)
                        $('#ajax-error').append('<pre>' + result.responseText + '</pre>');
                }
            });
        }
        else {
            mandatory_fields.html(null).parent().hide();
            $(target_field).remove();
            loadSpecificFields();//recurse
        }
    }

    loadSpecificFields();


    logtime('profiles.js overall', true)
});