{*
* 2007-2017 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    Cedric Fontaine <contact@prestashop.com>
*  @copyright 2007-2017 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
<div class="col-lg-12">
    <div class="panel">
        <fieldset>
            <legend><img src="../img/admin/money.gif">{l s='Refund via BlueSnap' mod='bluesnap'}</legend>
			{if $bluesnap_error}
				<div class="alert alert-danger">{$bluesnap_error|escape:'htmlall':'UTF-8'}</div>
			{else}
				{if !$bluesnap_refunded}
					<form method="post" action="" name="refund">
						<div>{l s='BlueSnap order reference number:' mod='bluesnap'} <b>{$bluesnap_reference_number|escape:'htmlall':'UTF-8'}</b></div>
                        <div class="col-md-3 col-xs-12">
						<input type="text" name="bluesnap_amount" value="{toolsConvertPrice price=$bluesnap_amount|string_format:'%.2f'}" />
                        <input type="hidden" name="bluesnap_reference_number" value="{$bluesnap_reference_number|escape:'htmlall':'UTF-8'}" /></div>
						<div class="col-md-6 col-xs-12">
                        <input type="submit" name="process_bluesnap_refund" value ="{l s='Process Refund' mod='bluesnap'}" class="btn btn-default" /></div><br />
					</form><div class="clearfix"><br /></div>

                    {if $bluesnap_refund_amount>0}<div class="alert alert-warning">{l s='Refunded' mod='bluesnap'} {displayPrice price=$bluesnap_refund_amount currency=$id_currency}</div>{/if}
				{else}
					<div class="alert alert-warning">{l s='Refunded' mod='bluesnap'} {displayPrice price=$bluesnap_refund_amount currency=$id_currency}</div>
				{/if}
			{/if}
        </fieldset>

        {literal}
        <script type="text/javascript">
            $("input[name=process_bluesnap_refund]").click(function(){
                if (confirm('{/literal}{l s='Are you sure you want to refund this order? This action cannot be undone' mod='bluesnap'}{literal}')) {
                    return true;
                } else {
                    event.stopPropagation();
                    event.preventDefault();
                };
            });
        </script>
        {/literal}
    </div>
</div>