{*
* 2007-2017 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    Cedric Fontaine <contact@prestashop.com>
*  @copyright 2007-2017 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<div class="row">
    <div class="col-xs-12 col-md-6">
        <div class="payment_module" id="bluesnap_payment_module">
        {if !$bluesnap_isadmin}
        {* fraud device indicator *}
        <iframe width="1" height="1" frameborder="0" scrolling="no" src="https://{if $bluesnap_sandbox}sandbox{else}www{/if}.bluesnap.com/servlet/logo.htm?s={$bluesnap_uuid|escape:'htmlall':'UTF-8'}">
		</iframe><img width="1" height="1" src="https://{if $bluesnap_sandbox}sandbox{else}www{/if}.bluesnap.com/servlet/logo.gif?s={$bluesnap_uuid|escape:'htmlall':'UTF-8'}">
		{* End fraud device indicator *}
		{/if}
		<div id="bluesnaperror" class="alert alert-warning" {if $bluesnap_error==''}style="display:none;"{/if}>
	        <div id="tokenexpired" style="display:none;">{l s='The payment security token has expired. Please reload the page in order to get a new token and refill the form.' mod='bluesnap'} <a href="#" class="btn" id="tokenexpiredurl" onClick="window.location.reload();">{l s='Refresh the page' mod='bluesnap'}</a>
	        </div>
	        {if $bluesnap_error}
	        	{if $bluesnap_error==1}
	        		{l s='Your payment could not be processed at this time. Please make sure the card information was entered correctly and resubmit. If the problem persists, please contact your credit card company to authorize the purchase.' mod='bluesnap'}
	        	{/if}
	        	{if $bluesnap_error==2}
	        		{l s='Unfortunately your selected Card brand and Currency combination is not available. Please try a different card or contact our support team.' mod='bluesnap'}
	        	{/if}
				{if $bluesnap_error==3}
					{l s='Your payment could not be processed at this time as this card brand is not supported. Please select a new payment method and try again.' mod='bluesnap'}
				{/if}
	        {/if}
        </div>
        <h3>{l s='Credit/Debit Cards' mod='bluesnap'}</h3>
			{* Classic Credit card form *}
			<div id="bluesnap-ajax-loader"><img src="{$module_dir|escape:'html':'UTF-8'}/views/img/ajax-loader.gif" alt="" /> {l s='Transaction in progress, please wait.' mod='bluesnap'}</div>
			{if sizeof($existingCustomer)>0 && !$is_guest}
				<form data-ajax="false" action="{$link->getModuleLink('bluesnap', 'validation', [], true)|escape:'html'}" method="POST" id="bluesnap-payment-form-saved">
				<div class="row">
				<div class="col-xs-12 col-md-6 form-group">
				<label>{l s='Use saved card' mod='bluesnap' mod='bluesnap'}</label><br />
				{foreach from=$existingCustomer item=customer}
					<input type="radio" name="bluesnap_vaulted" value="{$customer.uid|escape:'htmlall':'UTF-8'}">&nbsp;{$customer.ccdata|escape:'htmlall':'UTF-8'}<br />
				{/foreach}<br />
				<div class="row">
				<div class="col-xs-12 col-md-6 form-group">
				<button id="addnew" class="btn">{l s='Add a new card' mod='bluesnap'}</button>
				</div></div>
				<input type="submit" value="{l s='Submit Payment' mod='bluesnap'}" id="bluesnap-submit-button-saved" class="bluesnap-submit-button btn btn-success btn-lg col-xs-12" data-icon="check"/><br />
				</div></div>
				<input type="hidden" name="bluesnap_uuid" id="bluesnap_uuid" value="{$bluesnap_uuid|escape:'htmlall':'UTF-8'}" />
				</form>
			{/if}
			<form data-ajax="false" action="{$link->getModuleLink('bluesnap', 'validation', [], true)|escape:'html'}" method="POST" id="bluesnap-payment-form"{if sizeof($existingCustomer)>0} style="display:none;"{/if}>
				{if isset($smarty.get.bluesnap_error)}<a id="bluesnap_error" name="bluesnap_error"></a><div class="bluesnap-payment-errors">{l s='There was a problem processing your credit card, please double check your data and try again.' mod='bluesnap'}</div>{/if}
				{if sizeof($existingCustomer)>0}<button id="usesaved" class="btn">{l s='Use an existing card' mod='bluesnap'}</button><br /><br />{/if}
				<div class="row">
				<div class="col-xs-12 col-md-6 form-group">
				<label for="card-number">{l s='Card Number' mod='bluesnap'}</label><br />
				<div class="input-group">
					<div data-bluesnap="ccn" id="card-number" class="form-control"></div>
				</div>
				<span class="helper-text" id="card-help"></span>
				</div>
				<div class="col-xs-12 col-md-6">
					<label>{l s='Card Type' mod='bluesnap'}</label><br />
					<img class="cc-icon disable" id="BSVisa" alt="" src="{$module_dir|escape:'html':'UTF-8'}views/img/cc-visa.png" />
					<img class="cc-icon disable" id="BSMasterCard" alt="" src="{$module_dir|escape:'html':'UTF-8'}views/img/cc-mastercard.png" />
					<img class="cc-icon disable" id="BSDiscover" alt="" src="{$module_dir|escape:'html':'UTF-8'}views/img/cc-discover.png" />
					<img class="cc-icon disable" id="BSAmericanExpress" alt="" src="{$module_dir|escape:'html':'UTF-8'}views/img/cc-amex.png" />
					<img class="cc-icon disable" id="BSJCB" alt="" src="{$module_dir|escape:'html':'UTF-8'}views/img/cc-jcb.png" />
					<img class="cc-icon disable" id="BSDinersClub" alt="" src="{$module_dir|escape:'html':'UTF-8'}views/img/cc-diners.png" />
				</div>
				</div>
				<div class="row">
				<div class="col-xs-12 col-md-6 form-group">
					<label for="cvv">{l s='CVC' mod='bluesnap'}</label><br />
					<div class="input-group">
						<div data-bluesnap="cvv" id="cvv" class="form-control"></div>
					</div>
					 <span class="helper-text"></span>
					<a href="javascript:void(0)" class="bluesnap-card-cvc-info" style="border: none;">
						{l s='What\'s this?' mod='bluesnap'}
						<div class="cvc-info">
						{l s='The CVC (Card Validation Code) is a 3 or 4 digit code on the reverse side of Visa, MasterCard and Discover cards and on the front of American Express cards.' mod='bluesnap'}
						</div>
					</a>
				</div>
				<div class="col-xs-12 col-md-6 form-group">
				<label for="exp-date">{l s='Expiration (MM/YYYY)' mod='bluesnap'}</label><br />
				<div class="input-group">
					<div data-bluesnap="exp" id="exp-date" class="form-control"></div>
				</div>
				 <span class="helper-text"></span>
				</div></div>
				<br />
				<input type="hidden" name="bluesnap_token" id="bluesnap_token" value="{$bluesnap_token|escape:'htmlall':'UTF-8'}" />
				<input type="hidden" name="bluesnap_uuid" id="bluesnap_uuid" value="{$bluesnap_uuid|escape:'htmlall':'UTF-8'}" />
				<input type="hidden" name="bluesnap_card-last-four-digits" id="bluesnap_card-last-four-digits" value="" />
				<input type="hidden" name="bluesnap_card-type" id="bluesnap_card-type" value="" />
				<input type="submit" value="{l s='Submit Payment' mod='bluesnap'}" id="bluesnap-submit-button" class="bluesnap-submit-button btn btn-success btn-lg col-xs-6 col-xs-offset-3" data-icon="check"/>

				<script type="text/javascript">
					$(document).ready(function() {
						{if $bluesnap_error}
						var p = $("#bluesnap_payment_module").offset();
						$(window).scrollTop(p.top);
						{/if}
						$('#usesaved').click(function(event) { event.preventDefault(); $('#bluesnap-payment-form-saved').show(); $('#bluesnap-payment-form').hide(); });
						$('#addnew').click(function(event) { event.preventDefault(); $('#bluesnap-payment-form-saved').hide(); $('#bluesnap-payment-form').show(); });
						var bsObj = {
							hostedPaymentFields: {
								ccn: "ccn", // name cannot contain spaces or special characters 
								cvv: "cvv", // name cannot contain spaces or special characters 
								exp: "exp"  // name cannot contain spaces or special characters  
							},
							onFieldEventHandler: {
								onFocus: function(tagId) {
									if (tagId == "ccn") {
              							$( "#card-number" ).addClass( "hosted-field-focus" );
           							 } else if (tagId == "exp") {
              							$( "#exp-date" ).addClass( "hosted-field-focus" ); 
            						} else if (tagId == "cvv") {
              							$( "#cvv" ).addClass( "hosted-field-focus" );
            						}  
								}, // Handle focus
								onBlur: function(tagId) {
									if (tagId == "ccn") {
									  $( "#card-number" ).removeClass( "hosted-field-focus" );
									} else if (tagId == "exp") {
									  $( "#exp-date" ).removeClass( "hosted-field-focus" ); 
									} else if (tagId == "cvv") {
									  $( "#cvv" ).removeClass( "hosted-field-focus" );
									}								
								}, // Handle blur 
								onError: function(tagId, errorCode) {
									if (tagId == "ccn" && errorCode == "001") {
									  $( "#card-number" ).removeClass( "hosted-field-focus hosted-field-valid" ).addClass( "hosted-field-invalid" );
									  $( "#card-help" ).text('{l s='Please enter a valid credit card number' mod='bluesnap'}');
									} else if (tagId == "exp" && errorCode == "003") {
									  $( "#exp-date" ).removeClass( "hosted-field-focus hosted-field-valid" ).addClass( "hosted-field-invalid" ).parent().next('span').text('{l s='Please enter the expiration date (MM/YYYY)' mod='bluesnap'}'); 
									} else if (tagId == "cvv" && errorCode == "002" ) {
									  $( "#cvv" ).removeClass( "hosted-field-focus hosted-field-valid" ).addClass( "hosted-field-invalid" ).parent().next('span').text('{l s='Please enter the CVV/CVC of your card' mod='bluesnap'}');
									}
									if (errorCode == "004") {
										$( "#card-number, #exp-date, #cvv" ).removeClass( "hosted-field-focus hosted-field-valid" ).addClass( "hosted-field-invalid" );
										$('#bluesnaperror').show();
										$('#tokenexpired').show();
										$('#bluesnap-ajax-loader').hide();
									} else {
										$('#bluesnap-submit-button').prop('disabled', false);
										$('#bluesnap-submit-button-saved').prop('disabled', false);
										$('#bluesnap-ajax-loader').hide();
									}
								}, // Handle a change in validation
								onEmpty: function(tagId, errorCode) {
									if (tagId == "ccn") {
									  $( "#card-number" ).removeClass( "hosted-field-focus hosted-field-valid" ).addClass( "hosted-field-invalid" );
									  $( "#card-help" ).text('{l s='Please enter a valid credit card number' mod='bluesnap'}');
									   $('.cc-icon').removeClass('enable').removeClass('disable').addClass('disable');
									} else if (tagId == "exp") {
									  $( "#exp-date" ).removeClass( "hosted-field-focus hosted-field-valid" ).addClass( "hosted-field-invalid").parent().next('span').text('{l s='Please enter the expiration date (MM/YYYY)' mod='bluesnap'}');
									} else if (tagId == "cvv") {
									  $( "#cvv" ).removeClass( "hosted-field-focus hosted-field-valid" ).addClass( "hosted-field-invalid" ).parent().next('span').text('{l s='Please enter the CVV/CVC of your card' mod='bluesnap'}');
									}
									$('#bluesnap-submit-button').prop('disabled', false);
									$('#bluesnap-submit-button-saved').prop('disabled', false);
									$('#bluesnap-ajax-loader').hide();
								}, // Handle a change in validation
								onType: function(tagId, cardType) {
									 $('.cc-icon').removeClass('enable').removeClass('disable').addClass('disable');
									if (cardType == "AmericanExpress") { 
										$('#BSAmericanExpress').removeClass('disable').addClass('enable');
									} else if (cardType == "CarteBleue") { 
										$('#BSVisa').removeClass('disable').addClass('enable');
									} else if (cardType == "DinersClub") { 
										$('#BSDinersClub').removeClass('disable').addClass('enable');
									} else if (cardType == "Discover") { 
										$('#BSDiscover').removeClass('disable').addClass('enable');
									} else if (cardType == "JCB") { 
										$('#BSJCB').removeClass('disable').addClass('enable');
									} else if (cardType == "MaestroUK") { 
										$('#BSVisa').removeClass('disable').addClass('enable');
									} else if (cardType == "MasterCard") { 
										$('#BSMasterCard').removeClass('disable').addClass('enable');
									} else if (cardType == "Solo") { 
										$('#BSVisa').removeClass('disable').addClass('enable');
									} else if (cardType == "Visa") { 
										$('#BSVisa').removeClass('disable').addClass('enable');
									}
								}, // cardType will give card type, and only applies to ccn: CarteBleue, Visa, MasterCard, AmericanExpress, Discover, DinersClub, JCB, Solo, MaestroUK, ChinaUnionPay
								onValid: function(tagId) {
						            if (tagId == "ccn") {
						              $( "#card-number" ).removeClass( "hosted-field-focus hosted-field-invalid" ).addClass( "hosted-field-valid" );
						              $( "#card-help" ).text('');
						            } else if (tagId == "exp") {
						              $( "#exp-date" ).removeClass( "hosted-field-focus hosted-field-invalid" ).addClass( "hosted-field-valid" ).parent().next('span').text('');
						            } else if (tagId == "cvv") {
						              $( "#cvv" ).removeClass( "hosted-field-focus hosted-field-invalid" ).addClass( "hosted-field-valid" ).parent().next('span').text('');
						            }									
								}, // Handle a change in validation
							},
		                style: {
		                    // Styling all Hosted Payment Field inputs
		                    "input": {
		                        "font-size": "14px",
		            			"font-family": "Helvetica Neue,Helvetica,Arial,sans-serif",
		            			"line-height": "1.42857143",
		            			"color": "#555"
		                    },
		                    
		                    // Styling a specific field
		                    /*"#ccn": {
		                        
		                    },*/
		                    
		                    // Styling Hosted Payment Field input state
		                    ":focus": {
		                        "color": "#555"
		                    }
		                },
							ccnPlaceHolder: "1234 5678 9012 3456", //for example
							cvvPlaceHolder: "123", //for example
							expPlaceHolder: "00/0000" //for example
						};
						bluesnap.hostedPaymentFieldsCreation ("{$bluesnap_token|escape:'htmlall':'UTF-8'}", bsObj);

						$( "#bluesnap-submit-button-saved" ).click(function(event) {
							$('#bluesnap-submit-button').prop('disabled', true);
							$('#bluesnap-submit-button-saved').prop('disabled', true);
							$('#bluesnap-ajax-loader').show();
							$('#bluesnap-payment-form-saved').submit();
						});

						$( "#bluesnap-submit-button" ).click(function(event) {
							$('#bluesnap-submit-button').prop('disabled', true);
							$('#bluesnap-submit-button-saved').prop('disabled', true);
							$('#bluesnap-ajax-loader').show();
							event.preventDefault();

							bluesnap.submitCredentials(function(cardData){
								$('#bluesnap_card-last-four-digits').val(cardData.last4Digits);
								$('#bluesnap_card-type').val(cardData.ccType);
								$('#bluesnap-payment-form').submit();
							});

						});

		  			});
				</script>
			</form>
        </div>
    </div>
</div>