<?php


/**


 * GMCReporting.php file defines method to manage reporting content


 * @author Business Tech (www.businesstech.fr) - Contact: modules@businesstech.fr


 * @category admin collection


 * @license Business Tech


 * @uses Please read included installation and configuration instructions (PDF format)


 * @see BT_IInstall Interface


 */





class BT_GmcReporting


{


	/**


	 * @var array $aReport : stock msg reported


	 */


	public $aReport = array();





    /**


     * @var string $sFileName : store file name


     */


    public $sFileName = '';





	/**


	 * @var bool $bActivate : activate or not reporting


	 */


	public $bActivate = array();





	/**


	 * Magic Method __construct


	 * @author Business Tech (www.businesstech.fr) - Contact: modules@businesstech.fr


	 * @category admin collection


	 *


	 * @param bool $bActivate


	 */


	public function __construct($bActivate = true)


	{


		$this->bActivate = $bActivate;


	}





	/**


	 * Magic Method __destruct


	 * @author Business Tech (www.businesstech.fr) - Contact: modules@businesstech.fr


	 * @category admin collection


	 *


	 */


	public function __destruct()


	{





	}





    /**


     * set() method stock reporting


     * @see


     *


     * @param string $Key


     * @param array $aParams


     * @return array


     */


    public function set($Key, $aParams)


    {


        if ($this->bActivate) {


            $this->aReport[$Key][] = $aParams;


        }


    }





	/**


	 * setFileName() method set file name


	 * @see


	 *


	 * @param string $sFileName


	 */


	public function setFileName($sFileName)


	{


		$this->sFileName = $sFileName;


	}





	/**


	 * get() method return available serialized content


	 * @see


	 *


	 * @return array


	 */


	public function get()


	{





        $aData = array();





        if ($this->bActivate && file_exists($this->sFileName) && filesize($this->sFileName)) {


            $sContent = file_get_contents($this->sFileName);





            if (!empty($sContent)) {


                $aData = unserialize($sContent);


            }


        }





        return $aData;


	}





	/**


	 * delete() method delete reporting file


	 * @see


	 *


	 * @return bool


	 */


	public function delete()


	{


		return (


			is_file($this->sFileName) && unlink($$this->sFileName)? true : false


		);


	}//delete





    /**


     * mergeData() merge data between current data and stored data in reporting file


     * @see


     *


     * @return array


     */


    public function mergeData()


    {


        $aReport = array();





        if ($this->bActivate && !empty($this->aReport)) {


            // get unserialized reporting


            $aReport = $this->get();





            if (!empty($aReport) && is_array($aReport)) {


                foreach ($aReport as $sKeyName => $aProducts) {


                    if (array_key_exists($sKeyName, $this->aReport)) {


                        foreach ($this->aReport[$sKeyName] as $iKey => $mValue) {


                            $aReport[$sKeyName][] = $mValue;


                        }


                    }


                }


            }


            else {


                $aReport = $this->aReport;


            }


        }





        return $aReport;


    }








	/**


	 * writeFile() method write Reporting file


	 * @see


	 *


	 * @param string $sContent


	 * @param string $sMode


	 * @param bool $bDebug


	 * @return int


	 */


	public function writeFile($sContent, $sMode = 'w', $bDebug = false)


	{


        $bWritten = 0;





        $rFile = @fopen($this->sFileName, $sMode);





        if (!empty($rFile)) {


           $bWritten = @fwrite($rFile, $sContent);





            if (!empty($bWritten)) {


                @fclose($rFile);


            }


        }





		return $bWritten;


	}





	/**


	 * run() method creates singleton


	 * @version 1.0.3


	 * @category admin collection


     *


	 * @param bool $bActivate


	 * @return array


	 */


	public static function create($bActivate = true)


	{


		static $oReporting;





		if( null === $oReporting) {


			$oReporting = new BT_GmcReporting($bActivate);


		}


		return $oReporting;


	}


}


