<html class="-webkit- wf-anonymouspro1-n4-active wf-anonymouspro1-n7-active wf-europa1-n4-active wf-europa1-n7-active wf-active"><head>

  <meta charset="UTF-8">
  <title>CodePen - Responsive Infinite Carousel</title>

  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, user-scalable=no">
<script type="text/javascript" src="//use.typekit.net/kei2cfp.js"></script>
<style type="text/css">.tk-anonymous-pro{font-family:"anonymous-pro-1","anonymous-pro-2",sans-serif;}.tk-europa{font-family:"europa-1","europa-2",sans-serif;}</style><link rel="stylesheet" href="http://use.typekit.net/c/81d756/1w;anonymous-pro-1,2,SC9:P:n4,SC6:P:n7;europa-1,2,X9J:P:n4,X9K:P:n7/d?3bb2a6e53c9684ffdc9a9bf5185b2a62abc3a59fc2e19ea405b94f82b6d9eb97015b5ebe5e0e6ce564d945a444ca77091fe489e10d8d4331fc69dfd43d75c47fc8bc8da31e7993afe9cced1a537c38f4155733edf4ea51907c4b5b27ce874770392cd3de8d6cf046e1de138ecafdad04c48cc9469176db9cc83ab986ad2e7ca51801cf12"><script type="text/javascript">try{Typekit.load();}catch(e){}</script>

  <style>
  * {
  -webkit-box-sizing: border-box;
  -moz-box-sizing: border-box;
  box-sizing: border-box;
}

body, html {
  font-family: "europa-1","europa-2", sans-serif;
  overflow: hidden;
}

.wrapper {
  max-width: 940px;
  width: 100%;
  position: relative;
  overflow: hidden;
  margin: 0 auto;
}

/**
 * Use this wrapper only for demo purposes
 * So you can show the items outside the wrapper
 */
.wrapper--demo {
  overflow: visible;
}
.wrapper--demo:after, .wrapper--demo:before {
  content: "";
  position: absolute;
  width: 800px;
  height: 100%;
  top: 0;
  left: 100%;
  background: rgba(255, 255, 255, 0.8);
  z-index: 2;
}
.wrapper--demo:before {
  left: -800px;
}

.carousel {
  width: 100%;
  position: relative;
}
.carousel .carousel__content {
  width: auto;
  position: relative;
  overflow: hidden;
  -webkit-backface-visibility: hidden;
  -webkit-transition: translate3d(0, 0, 0);
}
.carousel .carousel__content .item {
  display: block;
  float: left;
  width: 100%;
  position: relative;
}
.carousel .carousel__content .item .title {
  position: absolute;
  top: 50%;
  left: 0;
  margin: -33px 0 0 0;
  padding: 0;
  font-size: 3rem;
  width: 100%;
  text-align: center;
  letter-spacing: .3rem;
  color: #FFF;
}
.carousel .carousel__content .item .title--sub {
  margin-top: 20px;
  font-size: 1.2em;
  opacity: .5;
}
.carousel .carousel__content .item img {
  width: 100%;
  max-width: 100%;
  display: block;
}
.carousel .carousel__nav {
  position: absolute;
  width: 100%;
  top: 50%;
  margin-top: -17px;
  left: 0;
  z-index: 1;
}
.carousel .carousel__nav .nav {
  position: absolute;
  top: 0;
  color: #000;
  background: #FFF;
  padding: 8px 12px;
  font-weight: bold;
  text-decoration: none;
  font-size: .8rem;
  transition: padding .25s ease;
}
.carousel .carousel__nav .nav:hover {
  padding: 8px 20px;
}
.carousel .carousel__nav .nav--left {
  border-radius: 0px 3px 3px 0px;
}
.carousel .carousel__nav .nav--right {
  right: 0;
  border-radius: 3px 0px 0px 3px;
}

  </style>

  <script>
    window.console = window.console || function(t) {};
    window.open = function(){ console.log('window.open is disabled.'); };
    window.print = function(){ console.log('window.print is disabled.'); };
    // Support hover state for mobile.
    if (false) {
      window.ontouchstart = function(){};
    }
  </script>

    <script src="//assets.codepen.io/assets/libs/prefixfree.min-de773054e90c52a3c2631c944681b64e.js">"></script>

</head>

<body>

  <div class="wrapper wrapper--demo">
	<div class="carousel">
		<div class="carousel__content" style="width: 600%; transform: translate(-66.6666666666667%, 0px);">
			<div class="item" style="width: 16.6666666666667%;">
        <p class="title">First</p>
        <img src="http://placehold.it/1800x850/70AD96/FFF&amp;text=&nbsp;" alt="">
      </div>
			<div class="item" style="width: 16.6666666666667%;">
        <p class="title">Second</p>
        <img src="http://placehold.it/1800x850/EA4E23/FFF&amp;text=&nbsp;" alt="">
      </div>
			<div class="item" style="width: 16.6666666666667%;">
        <p class="title">Third</p>
        <img src="http://placehold.it/1800x850/9BA452/FFF&amp;text=&nbsp;" alt="">
      </div>
			<div class="item" style="width: 16.6666666666667%;">
        <p class="title">Fourth</p>
        <img src="http://placehold.it/1800x850/472D38/FFF&amp;text=&nbsp;" alt="">
      </div>
			<div class="item" style="width: 16.6666666666667%;">
        <p class="title">Fifth</p>
        <img src="http://placehold.it/1800x850/F77C85/FFF&amp;text=&nbsp;" alt="">
      </div>
			<div class="item" style="width: 16.6666666666667%;">
        <p class="title">Sixth</p>
        <p class="title title--sub">Last Item</p>
        <img src="http://placehold.it/1800x850/00FFAE/FFF&amp;text=&nbsp;" alt="">
      </div>
		</div>

    <div class="carousel__nav">
      <a href="#" class="nav nav--left">Previous</a>
      <a href="#" class="nav nav--right">Next</a>
    </div>

	</div>
</div>

  <script src="//assets.codepen.io/assets/libs/fullpage/jquery-c152c51c4dda93382a3ae51e8a5ea45d.js"></script>
  <script src="http://cdnjs.cloudflare.com/ajax/libs/jquery.transit/0.9.9/jquery.transit.min.js"></script>

  <script>
    if (document.location.search.match(/type=embed/gi)) {
      window.parent.postMessage('resize', "*");
    }
  </script>

  <script src="//assets.codepen.io/assets/common/stopExecutionOnTimeout-6c99970ade81e43be51fa877be0f7600.js"></script>

  <script>
    (function () {
    var carouselContent, carouselIndex, carouselLength, firstClone, firstItem, isAnimating, itemWidth, lastClone, lastItem;
    carouselContent = $('.carousel__content');
    carouselIndex = 0;
    carouselLength = carouselContent.children().length;
    isAnimating = false;
    itemWidth = 100 / carouselLength;
    firstItem = $(carouselContent.children()[0]);
    lastItem = $(carouselContent.children()[carouselLength - 1]);
    firstClone = null;
    lastClone = null;
    carouselContent.css('width', carouselLength * 100 + '%');
    carouselContent.transition({ x: carouselIndex * -itemWidth + '%' }, 0);
    $.each(carouselContent.children(), function () {
        return $(this).css('width', itemWidth + '%');
    });
    $('.nav--left').on('click', function () {
        if (isAnimating) {
            return;
        }
        isAnimating = true;
        carouselIndex--;
        if (carouselIndex === -1) {
            lastItem.prependTo(carouselContent);
            carouselContent.transition({ x: (carouselIndex + 2) * -itemWidth + '%' }, 0);
            return carouselContent.transition({ x: (carouselIndex + 1) * -itemWidth + '%' }, 1000, 'easeInOutExpo', function () {
                carouselIndex = carouselLength - 1;
                lastItem.appendTo(carouselContent);
                carouselContent.transition({ x: carouselIndex * -itemWidth + '%' }, 0);
                return isAnimating = false;
            });
        } else {
            return carouselContent.transition({ x: carouselIndex * -itemWidth + '%' }, 1000, 'easeInOutExpo', function () {
                return isAnimating = false;
            });
        }
    });
    $('.nav--right').on('click', function () {
        if (isAnimating) {
            return;
        }
        isAnimating = true;
        carouselIndex++;
        return carouselContent.transition({ x: carouselIndex * -itemWidth + '%' }, 1000, 'easeInOutExpo', function () {
            isAnimating = false;
            if (firstClone) {
                carouselIndex = 0;
                carouselContent.transition({ x: carouselIndex * -itemWidth + '%' }, 0);
                firstClone.remove();
                firstClone = null;
                carouselLength = carouselContent.children().length;
                itemWidth = 100 / carouselLength;
                carouselContent.css('width', carouselLength * 100 + '%');
                $.each(carouselContent.children(), function () {
                    return $(this).css('width', itemWidth + '%');
                });
                return;
            }
            if (carouselIndex === carouselLength - 1) {
                carouselLength++;
                itemWidth = 100 / carouselLength;
                firstClone = firstItem.clone();
                firstClone.addClass('clone');
                firstClone.appendTo(carouselContent);
                carouselContent.css('width', carouselLength * 100 + '%');
                $.each(carouselContent.children(), function () {
                    return $(this).css('width', itemWidth + '%');
                });
                return carouselContent.transition({ x: carouselIndex * -itemWidth + '%' }, 0);
            }
        });
    });
}.call(this));
    //@ sourceURL=pen.js
  </script>




</body></html>