<?php

class QuantityDiscounts extends Module
{
	function __construct()
	{
		$this->name = 'quantitydiscounts';
		$this->tab = 'Presto-Changeo';
		$this->version = "1.2.1";

		parent::__construct();

		$this->displayName = $this->l('Quantity Discounts');
		$this->description = $this->l('Display quantity discounts in a more visible location.');
	}

	function install()
	{
		if (!parent::install())
			return false;
		if (!$this->registerHook('top'))
			return false;
		return true;
	}

	/**
	* Returns module content
	*
	* @param array $params Parameters
	* @return string Content
	*/
	function hookTop($params)
	{
		global $smarty, $cookie;
		if (!array_key_exists('id_product',$_GET))
			return;
		$product = new Product(intval($_GET['id_product']), true, intval($cookie->id_lang));
		$quantity_discounts = QuantityDiscount::getQuantityDiscounts(intval($product->id), $product->getPriceWithoutReduct()); 
		if (sizeof($quantity_discounts) < 1)
			return;
		$smarty->assign('qd_quantity_discounts', $quantity_discounts);
		return $this->display(__FILE__, 'quantitydiscounts.tpl');
	}

}
?>
