<!-- MODULE Discounts -->
{if isset($qd_quantity_discounts) AND $qd_quantity_discounts}
<style>
ul#idTab
{ldelim}
	display: none;
{rdelim}
</style>
<script>

/**
 * fetch the current price from the buy block text, parse it into a float and return it
 */
function fetchCurrentPrice() {ldelim}
	var val = $("#our_price_display").text().replace(currencySign,'');
	var qd_price = "";
	for (var i = 0 ; i < val.length ; i++)
		if (/[0-9.,]/.test(val.charAt(i)))
			qd_price += val.charAt(i);
	var arr = qd_price.split(",");
	if (arr[arr.length - 1].length == 2)
		qd_price = qd_price.replace(/,/g,'.');
	else
		qd_price = qd_price.replace(/,/g,'');
	return parseFloat(qd_price);
{rdelim}

/**
 * generate the discount area content (quantities and calculated discounted price)
 * using the given single unit price
 */
function writeDiscountsContent(price) {ldelim}
	var discountStr = "<p id=\"discounts_block\" class=\"price\" style=\"color:black\">";
	var discountedPrice = 0;

	{foreach from=$qd_quantity_discounts item='qd_quantity_discount' name='quantity_discounts'}
		discountStr += "<span id=\"our_price_display\">{$qd_quantity_discount.quantity|intval} ";
		{if $qd_quantity_discount.quantity|intval > 1}
			discountStr += "{l s='PZAS, C/U EN' mod='quantitydiscounts'}: ";
		{else}
			discountStr += "{l s='quantity' mod='quantitydiscounts'}: ";
		{/if}
		{if $qd_quantity_discount.id_discount_type|intval == 1}
			discountedPrice = price - (price * {$qd_quantity_discount.value} / 100);
		{else}
			discountedPrice = price - {$qd_quantity_discount.value}; 
		{/if}
		discountStr += formatCurrency(discountedPrice, currencyFormat, currencySign, currencyBlank) + "</span><br />";
	{/foreach}		
	discountStr += "</p>";

	return discountStr;
{rdelim}

$(document).ready(function () {ldelim}
	// remove the legacy quantities div and the tab above it
	$("#quantityDiscount").prev().css('display','none');
	$("#quantityDiscount").css('display','none');

	// hook the updateDisplay javascript call
	var origUpdateDisplay = window.updateDisplay;

	window.updateDisplay = function() {ldelim}
		origUpdateDisplay();

		var discountStr = writeDiscountsContent(fetchCurrentPrice());
		$('#discounts_block').replaceWith(discountStr);
	{rdelim}

	var discountStr = writeDiscountsContent(fetchCurrentPrice());

	price_found = false;
	$("#buy_block").children().each(function() {ldelim}
		// skip anything before the price div
		if ( $(this).attr('class') == "price" ) {ldelim}
			price_found = true;
		{rdelim}

		if (!price_found) {ldelim}
			return;
		{rdelim}

		// now skip any of the price sub items (old_price, reduction_percent, pack_price, price-ecotax)
		id = $(this).attr('id');
		if ( id == "" || id == "old_price" || id == "reduction_percent" || id == "pack_price" || id == "price-ecotax" )
			return;

		// ok, found something else so this is the end of the price block - print our stuff and reset the
		//  found flag (so we don't print on the next element as well)
		$(discountStr).insertBefore($(this));
		price_found = false;
	{rdelim});

{rdelim});
</script>

{/if}
<!-- / MODULE Discounts -->
