<?php
/**
* Newsletter Popup Module 
* 2007-2015 logicalit.com
* NOTICE OF LICENSE
*
* Copy Right, all rights reserved: logicalit.com
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customise this module for your
* needs please contact http://www.logicalit.com/contact-us/
*
*    @author logicalit.com
*    @copyright  2007-2015 logicalit.com
*    @version  Release: $Revision: 1.0
*    @license  http://www.logicalit.com/shop/en/content/3-terms-and-conditions-of-use
*/

if (!defined('_PS_VERSION_'))
	exit;

class NewsletterPopUpLi extends Module
{
	const GUEST_NOT_REGISTERED = -1;
	const CUSTOMER_NOT_REGISTERED = 0;
	const GUEST_REGISTERED = 1;
	const CUSTOMER_REGISTERED = 2;

	private $post_errors = array();

	public function __construct()
	{
		$this->name = 'newsletterpopupli';
		$this->tab = 'front_office_features';
		$this->need_instance = 0;
		$this->secure_key = Tools::encrypt($this->name);

		if (version_compare(_PS_VERSION_, '1.6.0', '>=') === true)
			$this->bootstrap = true;

		parent::__construct();

		$this->displayName = $this->l('Newsletter Popup');
		$this->description = $this->l('Displays a Popup newsletter subscription.');
		$this->confirmUninstall = $this->l('Are you sure that you want to delete the module? Note: The newsletter database table will not be deleted.');
		//$this->ps_versions_compliancy = array('min' => '1.5', 'max' => _PS_VERSION_);
		$this->module_key = '5f300a444e1ae134d6d0c405c1455b6f';
		
		$this->version = '1.3.0';
		$this->author = 'logicalit.com';
		$this->error = false;
		$this->valid = false;
		$this->_files = array(
			'name' => array('newspopup_confirmation', 'newspopup_voucher'),
			'ext' => array(
				0 => 'html',
				1 => 'txt'
			)
		);

		$this->_searched_email = null;

		$this->_html = '';
	}

	public function install()
	{
		if (!parent::install()
			|| !$this->registerHook('actionCustomerAccountAdd')
			|| !$this->registerHook('displayTop')
			|| !$this->registerHook('displayHeader'))
			return false;
		
		// reset style sheets
		
		if (version_compare(_PS_VERSION_, '1.6.0', '<') === true)
		{
			if (!file_put_contents(dirname(__FILE__).'/css/newsletterpopupli.css', TOOLS::file_get_contents(dirname(__FILE__).'/css/newsletterpopupli_reset_15.css')))
				return false;
		}
		else
			if (!file_put_contents(dirname(__FILE__).'/css/newsletterpopupli.css', TOOLS::file_get_contents(dirname(__FILE__).'/css/newsletterpopupli_reset_16.css')))
				return false;
		
		$bf_msg = '<h1 style="text-align: center;">Welcome</h1> <h3 style="text-align: center;">Signup to our newsletter below and get 10% off your first order.</h3>';
		$af_msg = '<p style="text-align: center;"><sup>We respect your privacy. We will never share or sell your information. </sup></p>';
		$thankyou_msg = '<h1 style="text-align: center;"><strong>Thank You</strong></h1><h3 style="text-align: center;">Please check your inbox for your welcome voucher code.&nbsp; </h3>';
		
		$languages = Language::getLanguages(false);
		$arr = array();

		foreach ($languages as $lang)
		{
			$arr['NWP_MESSAGE_BF_BTN'][$lang['id_lang']] = $bf_msg;
			$arr['NWP_MESSAGE_AFTER_BTN'][$lang['id_lang']] = $af_msg;
			$arr['NWP_MESSAGE_THANKYOU'][$lang['id_lang']] = $thankyou_msg;
			$arr['NWP_NO_THANKS_CLOSE'][$lang['id_lang']] = 'No Thanks, I want to pay full price.';
			$arr['NWP_SIGN_UP_TEXT'][$lang['id_lang']] = 'Sign Up';
		}

		Configuration::updateValue('NWP_MESSAGE_BF_BTN', $arr['NWP_MESSAGE_BF_BTN'], true);
		Configuration::updateValue('NWP_MESSAGE_AFTER_BTN', $arr['NWP_MESSAGE_AFTER_BTN'], true);
		Configuration::updateValue('NWP_MESSAGE_THANKYOU', $arr['NWP_MESSAGE_THANKYOU'], true);
		Configuration::updateValue('NWP_NO_THANKS_CLOSE', $arr['NWP_NO_THANKS_CLOSE'], true);
		Configuration::updateValue('NWP_SIGN_UP_TEXT', $arr['NWP_SIGN_UP_TEXT'], true);
		Configuration::updateValue('NWP_SALT', Tools::passwdGen(16));
		Configuration::updateValue('NWP_SHOW_ON_ANY_PAGE', '1');
		Configuration::updateValue('NWP_ENABLE', '0');
		Configuration::updateValue('NWP_MODAL', '0');
		Configuration::updateValue('NWP_BUTTON_COLOR', '#991D57');
		Configuration::updateValue('NWP_BUTTON_TEXT_COLOR', '#FFFFFF');
		Configuration::updateValue('NWP_OPACITY_LEVEL', '0.4');
		Configuration::updateValue('NWP_TIMER', '0');
		Configuration::updateValue('NWP_CONFIRMATION_EMAIL', '0');
		Configuration::updateValue('NWP_VERIFICATION_EMAIL', '0');
		Configuration::updateValue('NWP_SHOW_POPUP_ONCE', '1');
		Configuration::updateValue('NWP_FLUSH_COOKIE', '0');
		Configuration::updateValue('NWP_RESET_COOKIE', '365'); //never

		Db::getInstance()->execute('
		CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'li_newsletter_popup` (
			`id` int(6) NOT NULL AUTO_INCREMENT,
			`id_shop` INTEGER UNSIGNED NOT NULL DEFAULT \'1\',
			`cookie_time` INTEGER(32) UNSIGNED NOT NULL,
			PRIMARY KEY(`id`, `id_shop`)
		) ENGINE='._MYSQL_ENGINE_.' default CHARSET=utf8');

		// insert initial cookie record
		$sql = 'INSERT INTO `'._DB_PREFIX_.'li_newsletter_popup` (`cookie_time`, `id_shop`)
				VALUES('.time().','.(int)$this->context->shop->id.')';

		Db::getInstance()->execute($sql);

		return Db::getInstance()->execute('
		CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'newsletter` (
			`id` int(6) NOT NULL AUTO_INCREMENT,
			`id_shop` INTEGER UNSIGNED NOT NULL DEFAULT \'1\',
			`id_shop_group` INTEGER UNSIGNED NOT NULL DEFAULT \'1\',
			`email` varchar(255) NOT NULL,
			`newsletter_date_add` DATETIME NULL,
			`ip_registration_newsletter` varchar(15) NOT NULL,
			`http_referer` VARCHAR(255) NULL,
			`active` TINYINT(1) NOT NULL DEFAULT \'0\',
			PRIMARY KEY(`id`)
		) ENGINE='._MYSQL_ENGINE_.' default CHARSET=utf8');
	}

	public function uninstall()
	{
		//Db::getInstance()->execute('DROP TABLE '._DB_PREFIX_.'newsletter');

		$this->context->controller->getLanguages();

		Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'li_newsletter_popup`');

		foreach ($this->context->controller->_languages as $language)
		{
			Configuration::deleteByName('NWP_MESSAGE_BF_BTN_'.(int)$language['id_lang']);
			Configuration::deleteByName('NWP_MESSAGE_AFTER_BTN_'.(int)$language['id_lang']);
			Configuration::deleteByName('NWP_MESSAGE_THANKYOU_'.(int)$language['id_lang']);
			Configuration::deleteByName('NWP_NO_THANKS_CLOSE_'.(int)$language['id_lang']);
			Configuration::deleteByName('NWP_SIGN_UP_TEXT_'.(int)$language['id_lang']);
		}

		if (!parent::uninstall()
			|| !Configuration::deleteByName('NWP_SHOW_ON_ANY_PAGE')
			|| !Configuration::deleteByName('NWP_MODAL')
			|| !Configuration::deleteByName('NWP_ENABLE')
			|| !Configuration::deleteByName('NWP_OPACITY_LEVEL')
			|| !Configuration::deleteByName('NWP_TIMER')
			|| !Configuration::deleteByName('NWP_CSS')
			|| !Configuration::deleteByName('NWP_SHOW_POPUP_ONCE')
			|| !Configuration::deleteByName('NWP_RESET_COOKIE')
			|| !Configuration::deleteByName('NWP_FLUSH_COOKIE')
			|| !Configuration::deleteByName('NWP_CONFIRMATION_EMAIL')
			|| !Configuration::deleteByName('NWP_VERIFICATION_EMAIL')
			|| !Configuration::deleteByName('NWP_VOUCHER_CODE')
			|| !Configuration::deleteByName('NWP_BUTTON_COLOR')
			|| !Configuration::deleteByName('NWP_BUTTON_TEXT_COLOR'))
			return false;

		return true;
	}

	public function getContent()
	{
		if (Tools::isSubmit('submitUpdate'))
		{
			$languages = Language::getLanguages(false);
			$arr = array();

			foreach ($languages as $lang)
			{
				$arr['NWP_MESSAGE_BF_BTN'][$lang['id_lang']] = Tools::getValue('NWP_MESSAGE_BF_BTN_'.$lang['id_lang']);
				$arr['NWP_MESSAGE_AFTER_BTN'][$lang['id_lang']] = Tools::getValue('NWP_MESSAGE_AFTER_BTN_'.$lang['id_lang']);
				$arr['NWP_MESSAGE_THANKYOU'][$lang['id_lang']] = Tools::getValue('NWP_MESSAGE_THANKYOU_'.$lang['id_lang']);
				$arr['NWP_NO_THANKS_CLOSE'][$lang['id_lang']] = Tools::getValue('NWP_NO_THANKS_CLOSE_'.$lang['id_lang']);
				$arr['NWP_SIGN_UP_TEXT'][$lang['id_lang']] = Tools::getValue('NWP_SIGN_UP_TEXT_'.$lang['id_lang']);
			}

			Configuration::updateValue('NWP_MESSAGE_BF_BTN', $arr['NWP_MESSAGE_BF_BTN'], true);
			Configuration::updateValue('NWP_MESSAGE_AFTER_BTN', $arr['NWP_MESSAGE_AFTER_BTN'], true);
			Configuration::updateValue('NWP_MESSAGE_THANKYOU', $arr['NWP_MESSAGE_THANKYOU'], true);
			Configuration::updateValue('NWP_NO_THANKS_CLOSE', $arr['NWP_NO_THANKS_CLOSE'], true);
			Configuration::updateValue('NWP_SIGN_UP_TEXT', $arr['NWP_SIGN_UP_TEXT'], true);
			Configuration::updateValue('NWP_SHOW_ON_ANY_PAGE', (int)Tools::getValue('NWP_SHOW_ON_ANY_PAGE'));
			Configuration::updateValue('NWP_ENABLE', (int)Tools::getValue('NWP_ENABLE'));
			Configuration::updateValue('NWP_MODAL', (int)Tools::getValue('NWP_MODAL'));
			Configuration::updateValue('NWP_OPACITY_LEVEL', Tools::getValue('NWP_OPACITY_LEVEL'));
			Configuration::updateValue('NWP_TIMER', (int)Tools::getValue('NWP_TIMER'));
			Configuration::updateValue('NWP_CSS', (int)Tools::getValue('NWP_CSS'));
			Configuration::updateValue('NWP_SHOW_POPUP_ONCE', (int)Tools::getValue('NWP_SHOW_POPUP_ONCE'));
			Configuration::updateValue('NWP_RESET_COOKIE', (int)Tools::getValue('NWP_RESET_COOKIE'));

			Configuration::updateValue('NWP_VERIFICATION_EMAIL', (int)Tools::getValue('NWP_VERIFICATION_EMAIL'));

			Configuration::updateValue('NWP_BUTTON_COLOR', Tools::getValue('NWP_BUTTON_COLOR'));
			Configuration::updateValue('NWP_BUTTON_TEXT_COLOR', Tools::getValue('NWP_BUTTON_TEXT_COLOR'));

			$conf_email = Tools::getValue('NWP_CONFIRMATION_EMAIL');
			if ($conf_email && Validate::isBool((int)$conf_email))
				Configuration::updateValue('NWP_CONFIRMATION_EMAIL', (int)$conf_email);

			//$verif_email = Tools::getValue('NWP_VERIFICATION_EMAIL');
			//if ($verif_email && Validate::isBool((int)$verif_email))

			// check if cookie needs to be flushed
			if (Tools::getValue('NWP_FLUSH_COOKIE') == '1')
			{
				$sql = 'UPDATE `'._DB_PREFIX_.'li_newsletter_popup`
						SET `cookie_time` = '.time().'
			            WHERE `id` = 1 AND `id_shop` = '.(int)$this->context->shop->id;
				Db::getInstance()->execute($sql);
			}
			
			$voucher = Tools::getValue('NWP_VOUCHER_CODE');
			if ($voucher && !Validate::isDiscountName($voucher))
				$this->post_errors[] = $this->l('The voucher code is invalid.');
			else
				Configuration::updateValue('NWP_VOUCHER_CODE', pSQL($voucher));

			foreach ($languages as $lang)
			{
				if (!Validate::isCleanHtml(Tools::getValue('NWP_MESSAGE_BF_BTN_'.$lang['id_lang'])))
					$this->post_errors[] = sprintf( $this->l('Invalid message above submit button for %s'), $lang['name']);

				if (!Validate::isCleanHtml(Tools::getValue('NWP_MESSAGE_AFTER_BTN_'.$lang['id_lang'])))
					$this->post_errors[] = sprintf( $this->l('Invalid message below submit button for %s'), $lang['name']);

				if (!Validate::isCleanHtml(Tools::getValue('NWP_MESSAGE_THANKYOU_'.$lang['id_lang'])))
					$this->post_errors[] = sprintf( $this->l('Invalid thank you message for %s'), $lang['name']);

				if (!Validate::isCleanHtml(Tools::getValue('NWP_NO_THANKS_CLOSE_'.$lang['id_lang'])))
					$this->post_errors[] = sprintf( $this->l('Invalid thank you message for %s'), $lang['name']);

				if (!Validate::isCleanHtml(Tools::getValue('NWP_SIGN_UP_TEXT_'.$lang['id_lang'])))
					$this->post_errors[] = sprintf( $this->l('Invalid sign up button text %s'), $lang['name']);
			}

			if (!Validate::isCleanHtml( Tools::getValue('NWP_CSS' )))
				$this->post_errors[] = sprintf( $this->l('Invalid css '), $lang['name']);
			else
			if (!file_put_contents(dirname(__FILE__).'/css/newsletterpopupli.css', Tools::getValue('NWP_CSS')))
				$this->post_errors[] = $this->l('Error while saving  .css');

			if (!count($this->post_errors))
				$this->_html .= $this->displayConfirmation($this->l('Settings updated'));
			else
				foreach ($this->post_errors as $err)
					$this->_html .= $this->displayError($err);
		}
		elseif (Tools::isSubmit('subscribedmerged'))
		{
			$id = Tools::getValue('id');

			if (preg_match('/(^N)/', $id))
			{
				$id = (int)Tools::substr($id, 1);
				$sql = 'UPDATE '._DB_PREFIX_.'newsletter SET active = 0 WHERE id = '.$id;
				Db::getInstance()->execute($sql);
			}
			else
			{
				$c = new Customer((int)$id);
				$c->newsletter = (int)!$c->newsletter;
				$c->update();
			}
			Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&conf=4&token='.Tools::getAdminTokenLite('AdminModules'));
		}
		elseif (Tools::isSubmit('exportSubscribers'))
		{
			$header = array('id', 'shop_name', 'gender', 'lastname', 'firstname', 'email', 'subscribed', 'subscribed_on'); // TODO
			$array_to_export = array_merge(array($header), $this->getSubscribers(1));

			$file_name = time().'.csv';
			$fd = fopen($this->getLocalPath().$file_name, 'w+');
			foreach ($array_to_export as $tab)
			{
				$line = implode(';', $tab);
				$line .= "\n";
				fwrite($fd, $line, 4096);
			}
			fclose($fd);
			Tools::redirect(_PS_BASE_URL_.__PS_BASE_URI__.'modules/'.$this->name.'/'.$file_name);
		}
		elseif (Tools::isSubmit('searchEmail'))
			$this->_searched_email = Tools::getValue('searched_email');

		// check for missing iso code templates
		$languages = Language::getLanguages();
		$missing_templates = array();
		foreach ($languages as $language)
		{
			if (!file_exists(dirname(__FILE__).'/mails/'.$language['iso_code']))
				$missing_templates[] = $language['name'].' ISO Code: \''.$language['iso_code'].'\'';
		}

		$this->context->smarty->assign(array(
			'module_dir' => $this->_path,
			'missing_templates' => $missing_templates
		));

		$this->_html .= $this->context->smarty->fetch($this->local_path.'views/templates/admin/configure.tpl');
		$this->_html .= $this->renderForm();
		$this->_html .= $this->renderSearchForm();
		$this->_html .= $this->renderList();
		$this->_html .= '<div class="panel"><a href="'.$this->context->link->getAdminLink('AdminModules', false).'&exportSubscribers&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'">
    <button class="btn btn-default btn-lg"><span class="icon icon-share"></span> '.$this->l('Export as CSV').'</button>
</a></div>';

		if (Tools::isSubmit('viewpopup') && !count($this->post_errors))
		{ 
			$msg_before_button = Configuration::get('NWP_MESSAGE_BF_BTN', $this->context->language->id);
			$msg_after_button = Configuration::get('NWP_MESSAGE_AFTER_BTN', $this->context->language->id);
			$msg_thankyou = Configuration::get('NWP_MESSAGE_THANKYOU', $this->context->language->id);
			$msg_no_thanks_close = Configuration::get('NWP_NO_THANKS_CLOSE', $this->context->language->id);
			$button_color = Configuration::get('NWP_BUTTON_COLOR');
			$button_text_color = Configuration::get('NWP_BUTTON_TEXT_COLOR');
			$sign_up_text = Configuration::get('NWP_SIGN_UP_TEXT', $this->context->language->id);
			$opacity = 'rgba(255, 255, 255, '.Configuration::get('NWP_OPACITY_LEVEL').')';
		// load css file
		$this->hookDisplayHeader();

		$this->_html .= '
<!-- Newsletter Popup module by logicalit.com -->
<script text="javascript">
    $(document).ready(function() {
         $("#trigger").fancybox({
		            
                   closeBtn    : true ,
                    type        : "inline",
                    maxWidth    : 500, 
                    fitToView	: false,
                    padding     : 0,
                    width	: "70%",
                    height	: "70%",
                    autoHeight  : true,
                    autoSize	: false,
                    openEffect	: "elastic",
                    closeEffect	: "none",
                    closeClick  : false,
                    modal: false,
                    helpers : {
                            overlay : {
                                css : {
                                    "background" : "'.$opacity.'"
									    }
                                }
                    }
        });
         
        $("#trigger").fancybox().trigger("click");
		//$("#trigger").trigger("click");
   
        $(".closefancybox").on("click", function(event){
            event.stopPropagation();
            $.fancybox.close();
        });
            
        $("#popupnews-submit").click(function(){	    
            
            // validate email address
            var datas = [];
		$("#popupnews-form").find("input").each(function(index){
			var o = {};
			o.key = $(this).attr("name");
			o.value = $(this).val();
			if (o.value != "")
				datas.push(o);
		});
                    
            $.ajax({
     url: "../modules/newsletterpopupli/subscribe-ajax.php",
                        type: "POST",
                        headers: {"cache-control": "no-cache"},
			data: {ajax: true, 
                               action: "subscribe", 
                                secure_key: "'.$this->secure_key.'",
                               enquiry: unescape(JSON.stringify(datas))},
                        context: document.body,
                        dataType: "json",
                        context: this,
                        async: false,
                        success: function(data) {
                                if(data.err == 1) {
                                     $("#form-error").text(data.msg);
                                     $("#form-error").show(); 
                                } else {
                                     $("#form-error").hide(); 
                                     $("#email-input").hide();     
                                     $("#form-success").show(); 
				}
			}  
                });
        });            
    });
</script>

<a id="trigger" href="#popupli" ></a>

<div  style="display:none;" class="popupnews-wrapper">
    <div id="popupli">

        <div id="popupnews-form">
			<div style="color: blue">** Preview Mode ** Please do a final test in front end as default styles maybe different from back office. <br />
			The following options are disabled in preview node: timer, modal, and some language translations. <br />Please also test any changes you make in front end. 
			<br /> Note: if you made some css changes and you dont see the changes you will need to do a hard browser refresh (CTRL F5 on windows)
			</div>  
            <div id="form-error" style="display: none;" class="error"></div>
            <div id="form-success" style="display: none;">
                '.$msg_thankyou.'
                 <div>
                    <a href="#" class="closefancybox">Close</a>
                </div>
            </div>
            <div id="email-input">
                <div>'.$msg_before_button.'</div>
                <div>
                    <input style="width: 95%" placeholder="Please enter your email address" type="email" name="email" required>
                </div>
                <div>
                    <button  name="submit" type="submit" id="popupnews-submit" style="background-color: '.$button_color.'; color: '.$button_text_color.';" >'.$sign_up_text.'</button>
                </div>
                  <div>'.$msg_after_button.'</div>
                <div>
                    <a href="#" class="closefancybox">'.$msg_no_thanks_close.'</a>
                </div>
            </div>
        </div>
    </div>
</div>
';
		}

		return $this->_html;
	}

	public function renderList()
	{
		$fields_list = array(
			'id' => array(
				'title' => $this->l('ID'),
				'search' => false,
			),
			'shop_name' => array(
				'title' => $this->l('Shop'),
				'search' => false,
			),
			'gender' => array(
				'title' => $this->l('Gender'),
				'search' => false,
			),
			'lastname' => array(
				'title' => $this->l('Lastname'),
				'search' => false,
			),
			'firstname' => array(
				'title' => $this->l('Firstname'),
				'search' => false,
			),
			'email' => array(
				'title' => $this->l('Email'),
				'search' => false,
			),
			'subscribed' => array(
				'title' => $this->l('Subscribed'),
				'type' => 'bool',
				'active' => 'subscribed',
				'search' => false,
			),
			'newsletter_date_add' => array(
				'title' => $this->l('Subscribed on'),
				'type' => 'date',
				'search' => false,
			)
		);

		if (!Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE'))
			unset($fields_list['shop_name']);

		$helper_list = New HelperList();
		$helper_list->module = $this;
		$helper_list->title = $this->l('Newsletter Subscribers and Pending registrations');
		$helper_list->shopLinkType = '';
		$helper_list->no_link = true;
		$helper_list->show_toolbar = true;
		$helper_list->simple_header = false;
		$helper_list->identifier = 'id';
		$helper_list->table = 'merged';
		$helper_list->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name;
		$helper_list->token = Tools::getAdminTokenLite('AdminModules');
		$helper_list->actions = array('viewCustomer');
		$helper_list->toolbar_btn['export'] = array(
			'href' => $helper_list->currentIndex.'&amp;exportSubscribers&amp;token='.$helper_list->token,
			'desc' => $this->l('Export')
		);

		/* Before 1.6.0.7 displayEnableLink() could not be overridden in Module class we declare another row action instead */
		if (version_compare(_PS_VERSION_, '1.6.0.7', '<'))
		{
			unset($fields_list['subscribed']);
			$helper_list->actions = array_merge($helper_list->actions, array('unsubscribe'));
		}

		// This is needed for displayEnableLink to avoid code duplication
		$this->_helperlist = $helper_list;

		/* Retrieve list data */
		$subscribers = $this->getSubscribers(0);
		$helper_list->listTotal = count($subscribers);

		/* Paginate the result */
		$page = ($page = Tools::getValue('submitFilter'.$helper_list->table)) ? $page : 1;
		$pagination = ($pagination = Tools::getValue($helper_list->table.'_pagination')) ? $pagination : 50;
		$subscribers = $this->paginateSubscribers($subscribers, $page, $pagination);

		return $helper_list->generateList($subscribers, $fields_list);
	}

	public function displayViewCustomerLink($id)
	{
		$this->smarty->assign(array(
			'href' => 'index.php?controller=AdminCustomers&id_customer='.(int)$id.'&updatecustomer&token='.Tools::getAdminTokenLite('AdminCustomers'),
			'action' => $this->l('View'),
			'disable' => !((int)$id > 0),
		));

		return $this->display(__FILE__, 'views/templates/admin/list_action_viewcustomer.tpl');
	}

	public function displayEnableLink($token, $id, $value, $active, $id_category = null, $id_product = null, $ajax = false)
	{
		$this->smarty->assign(array(
			'ajax' => $ajax,
			'enabled' => (bool)$value,
			'url_enable' => Tools::safeOutput($this->_helperlist->currentIndex.'&'.$this->_helperlist->identifier.'='.$id.'&'.$active.$this->_helperlist->table.($ajax ? '&action='.$active.$this->_helperlist->table.'&ajax='.(int)$ajax : '').
				((int)$id_category && (int)$id_product ? '&id_category='.(int)$id_category : '').'&token='.$token)
		));

		return $this->display(__FILE__, 'views/templates/admin/list_action_enable.tpl');
	}


	/**
	 * Check if this mail is registered for newsletters
	 *
	 * @param string $customer_email
	 *
	 * @return int -1 = not a customer and not registered
	 *                0 = customer not registered
	 *                1 = registered in block or popup
	 *                2 = registered in customer
	 */
	private function isNewsletterRegistered($customer_email)
	{
		$sql = 'SELECT `email`
				FROM '._DB_PREFIX_.'newsletter
				WHERE `email` = \''.pSQL($customer_email).'\'
				AND id_shop = '.$this->context->shop->id;

		if (Db::getInstance()->getRow($sql))
			return self::GUEST_REGISTERED;

		$sql = 'SELECT `newsletter`
				FROM '._DB_PREFIX_.'customer
				WHERE `email` = \''.pSQL($customer_email).'\'
				AND id_shop = '.$this->context->shop->id;

		if (!$registered = Db::getInstance()->getRow($sql))
			return self::GUEST_NOT_REGISTERED;

		if ($registered['newsletter'] == '1')
			return self::CUSTOMER_REGISTERED;

		return self::CUSTOMER_NOT_REGISTERED;
	}

	public function subscribeNewsletter($email)
	{
		if (empty($email) || !Validate::isEmail($email))
			return array('msg' => $this->l('Please enter your email address.'), 'err' => 1);
		else
		{
			$this->newsletterRegistration($email);
			if ($this->error)
				return array('msg' => $this->error, 'err' => 1);
			elseif ($this->valid)
				return array('msg' => $this->valid, 'err' => 0);
			else
				return array('msg' => $this->l('Unknown error.'), 'err' => 1);
		}
	}

	/**
	 * Register in popup newsletter
	 */
	private function newsletterRegistration($email)
	{
		if (!$email)
			return $this->error = $this->l('Invalid email address.');

		$register_status = $this->isNewsletterRegistered($email);

		if ($register_status > 0)
			return $this->error = $this->l('This email address is already registered.');

		/* Subscription */
		if (!$this->isRegistered($register_status))
		{
			if (Configuration::get('NWP_VERIFICATION_EMAIL'))
			{
				// create an unactive entry in the newsletter database
				if ($register_status == self::GUEST_NOT_REGISTERED)
					$this->registerGuest($email, false);

				if (!$token = $this->getToken($email, $register_status))
					return $this->error = $this->l('An error occurred during the subscription process.');

				$this->sendVerificationEmail($email, $token);

				return $this->valid = 'Subscription Successful';
			}
			else
			{
				if ($this->register($email, $register_status))
					$this->valid = 'Subscription Successful';
				else
					return $this->error = $this->l('An error occurred during the subscription process.');

				if (Configuration::get('NWP_VOUCHER_CODE') != '')
					$this->sendVoucher($email, Configuration::get('NWP_VOUCHER_CODE'));

				if (Configuration::get('NWP_CONFIRMATION_EMAIL'))
					$this->sendConfirmationEmail($email);
			}
		}
	}

	public function getSubscribers($subscribers_only)
	{
		$dbquery = new DbQuery();
		$dbquery->select('c.`id_customer` AS `id`, s.`name` AS `shop_name`, gl.`name` AS `gender`, c.`lastname`, c.`firstname`, c.`email`, c.`newsletter` AS `subscribed`, c.`newsletter_date_add`');
		$dbquery->from('customer', 'c');
		$dbquery->leftJoin('shop', 's', 's.id_shop = c.id_shop');
		$dbquery->leftJoin('gender', 'g', 'g.id_gender = c.id_gender');
		$dbquery->leftJoin('gender_lang', 'gl', 'g.id_gender = gl.id_gender AND gl.id_lang = '.$this->context->employee->id_lang);
		$dbquery->where('c.`newsletter` = 1'); 
		if ($this->_searched_email)
			$dbquery->where('c.`email` LIKE \'%'.bqSQL($this->_searched_email).'%\' ');

		$customers = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($dbquery->build());

		$dbquery = new DbQuery();
		$dbquery->select('CONCAT(\'N\', n.`id`) AS `id`, s.`name` AS `shop_name`, NULL AS `gender`, NULL AS `lastname`, NULL AS `firstname`, n.`email`, n.`active` AS `subscribed`, n.`newsletter_date_add`');
		$dbquery->from('newsletter', 'n');
		$dbquery->leftJoin('shop', 's', 's.id_shop = n.id_shop');
		if ($subscribers_only) $dbquery->where('n.`active` = 1');
		if ($this->_searched_email)
			$dbquery->where('n.`email` LIKE \'%'.bqSQL($this->_searched_email).'%\' ');

		$non_customers = Db::getInstance()->executeS($dbquery->build());

		$subscribers = array_merge($customers, $non_customers);

		return $subscribers;
	}

	public function paginateSubscribers($subscribers, $page = 1, $pagination = 50)
	{
		if (count($subscribers) > $pagination)
			$subscribers = array_slice($subscribers, $pagination * ($page - 1), $pagination);

		return $subscribers;
	}

	/**
	 * Return true if the registered status correspond to a registered user
	 *
	 * @param int $register_status
	 *
	 * @return bool
	 */
	protected function isRegistered($register_status)
	{
		return in_array(
				$register_status, array(self::GUEST_REGISTERED, self::CUSTOMER_REGISTERED)
		);
	}

	/**
	 * Subscribe an email to the newsletter. It will create an entry in the newsletter table
	 * or update the customer table depending of the register status
	 *
	 * @param string $email
	 * @param int    $register_status
	 */
	protected function register($email, $register_status)
	{
		if ($register_status == self::GUEST_NOT_REGISTERED)
			return $this->registerGuest($email);

		if ($register_status == self::CUSTOMER_NOT_REGISTERED)
			return $this->registerUser($email);

		return false;
	}

	protected function unregister($register_status)
	{
		if ($register_status == self::GUEST_REGISTERED)
			$sql = 'DELETE FROM '._DB_PREFIX_.'newsletter WHERE `email` = \''.pSQL(Tools::getValue('email')).'\' AND id_shop = '.$this->context->shop->id;
		else if ($register_status == self::CUSTOMER_REGISTERED)
			$sql = 'UPDATE '._DB_PREFIX_.'customer SET `newsletter` = 0 WHERE `email` = \''.pSQL(Tools::getValue('email')).'\' AND id_shop = '.$this->context->shop->id;

		if (!isset($sql) || !Db::getInstance()->execute($sql))
			return false;

		return true;
	}

	/**
	 * Subscribe a customer to the newsletter
	 *
	 * @param string $email
	 *
	 * @return bool
	 */
	protected function registerUser($email)
	{
		$sql = 'UPDATE '._DB_PREFIX_.'customer
				SET `newsletter` = 1, newsletter_date_add = NOW(), `ip_registration_newsletter` = \''.pSQL(Tools::getRemoteAddr()).'\'
				WHERE `email` = \''.pSQL($email).'\'
				AND id_shop = '.$this->context->shop->id;

		return Db::getInstance()->execute($sql);
	}

	/**
	 * Subscribe a guest to the newsletter
	 *
	 * @param string $email
	 * @param bool   $active
	 *
	 * @return bool
	 */
	protected function registerGuest($email, $active = true)
	{
		$sql = 'INSERT INTO '._DB_PREFIX_.'newsletter (id_shop, id_shop_group, email, newsletter_date_add, ip_registration_newsletter, http_referer, active)
				VALUES
				('.$this->context->shop->id.',
				'.$this->context->shop->id_shop_group.',
				\''.pSQL($email).'\',
				NOW(),
				\''.pSQL(Tools::getRemoteAddr()).'\',
				(
					SELECT c.http_referer
					FROM '._DB_PREFIX_.'connections c
					WHERE c.id_guest = '.(int)$this->context->customer->id.'
					ORDER BY c.date_add DESC LIMIT 1
				),
				'.(int)$active.'
				)';

		return Db::getInstance()->execute($sql);
	}

	public function activateGuest($email)
	{
		return Db::getInstance()->execute(
				'UPDATE `'._DB_PREFIX_.'newsletter`
						SET `active` = 1
						WHERE `email` = \''.pSQL($email).'\''
		);
	}

	/**
	 * Returns a guest email by token
	 *
	 * @param string $token
	 *
	 * @return string email
	 */
	protected function getGuestEmailByToken($token)
	{
		$sql = 'SELECT `email`
				FROM `'._DB_PREFIX_.'newsletter`
				WHERE MD5(CONCAT( `email` , `newsletter_date_add`, \''.pSQL(Configuration::get('NWP_SALT')).'\')) = \''.pSQL($token).'\'
				AND `active` = 0';

		return Db::getInstance()->getValue($sql);
	}

	/**
	 * Returns a customer email by token
	 *
	 * @param string $token
	 *
	 * @return string email
	 */
	protected function getUserEmailByToken($token)
	{
		$sql = 'SELECT `email`
				FROM `'._DB_PREFIX_.'customer`
				WHERE MD5(CONCAT( `email` , `date_add`, \''.pSQL(Configuration::get('NWP_SALT')).'\')) = \''.pSQL($token).'\'
				AND `newsletter` = 0';

		return Db::getInstance()->getValue($sql);
	}

	/**
	 * Return a token associated to an user
	 *
	 * @param string $email
	 * @param string $register_status
	 */
	protected function getToken($email, $register_status)
	{
		if (in_array($register_status, array(self::GUEST_NOT_REGISTERED, self::GUEST_REGISTERED)))
		{
			$sql = 'SELECT MD5(CONCAT( `email` , `newsletter_date_add`, \''.pSQL(Configuration::get('NWP_SALT')).'\')) as token
					FROM `'._DB_PREFIX_.'newsletter`
					WHERE `active` = 0
					AND `email` = \''.pSQL($email).'\'';
		} 
		else if ($register_status == self::CUSTOMER_NOT_REGISTERED)
		{
			$sql = 'SELECT MD5(CONCAT( `email` , `date_add`, \''.pSQL(Configuration::get('NWP_SALT')).'\' )) as token
					FROM `'._DB_PREFIX_.'customer`
					WHERE `newsletter` = 0
					AND `email` = \''.pSQL($email).'\'';
		}

		return Db::getInstance()->getValue($sql);
	}

	/**
	 * Ends the registration process to the newsletter
	 *
	 * @param string $token
	 *
	 * @return string
	 */
	public function confirmEmail($token)
	{
		$activated = false;

		if ($email = $this->getGuestEmailByToken($token))
			$activated = $this->activateGuest($email);
		else if ($email = $this->getUserEmailByToken($token))
			$activated = $this->registerUser($email);

		if (!$activated)
			return $this->l('This email is already registered and/or invalid.');

		if ($discount = Configuration::get('NWP_VOUCHER_CODE'))
			$this->sendVoucher($email, $discount);

		if (Configuration::get('NWP_CONFIRMATION_EMAIL'))
			$this->sendConfirmationEmail($email);

		return $this->l('Thank you for subscribing to our newsletter.');
	}

	/**
	 * Send the confirmation mails to the given $email address if needed.
	 *
	 * @param string $email Email where to send the confirmation
	 *
	 * @note the email has been verified and might not yet been registered. Called by AuthController::processCustomerNewsletter
	 *
	 */
	public function confirmSubscription($email)
	{
		if ($email)
		{
			if ($discount = Configuration::get('NWP_VOUCHER_CODE'))
				$this->sendVoucher($email, $discount);

			if (Configuration::get('NWP_CONFIRMATION_EMAIL'))
				$this->sendConfirmationEmail($email);
		}
	}

	/**
	 * Send an email containing a voucher code
	 *
	 * @param $email
	 * @param $code
	 *
	 * @return bool|int
	 */
	protected function sendVoucher($email, $code)
	{
		return Mail::Send($this->getLanguageId(), 'newspopup_voucher', Mail::l('Newsletter voucher', $this->context->language->id), array('{discount}' => $code), $email, null, null, null, null, null, dirname(__FILE__).'/mails/', false, $this->context->shop->id);
	}

	/**
	 * Send a confirmation email
	 *
	 * @param string $email
	 *
	 * @return bool
	 */
	protected function sendConfirmationEmail($email)
	{
		return Mail::Send($this->getLanguageId(), 'newspopup_confirmation', Mail::l('Newsletter confirmation', $this->context->language->id), array(), pSQL($email), null, null, null, null, null, dirname(__FILE__).'/mails/', false, $this->context->shop->id);
	}

	/**
	 * Send a verification email
	 *
	 * @param string $email
	 * @param string $token
	 *
	 * @return bool
	 */
	protected function sendVerificationEmail($email, $token)
	{
		$verif_url = Context::getContext()->link->getModuleLink(
			'newsletterpopupli', 'verification', array(
			'token' => $token,
			)
		);

		return Mail::Send($this->getLanguageId(), 'newspopup_verify', Mail::l('Email verification', $this->context->language->id), array('{verif_url}' => $verif_url), $email, null, null, null, null, null, dirname(__FILE__).'/mails/', false, $this->context->shop->id);
	}


	public function hookDisplayTop()
	{
		if (!Configuration::get('NWP_ENABLE')) return;
		
		//check if user is logged in and a subscriber
		if (Configuration::get('NWP_SHOW_POPUP_ONCE') == 1 && $this->context->customer->isLogged() && $this->isNewsletterRegistered($this->context->customer->email)) 
			return; 

		if (!Configuration::get('NWP_SHOW_ON_ANY_PAGE') && Tools::getValue('controller') != 'index') return;

		if (!Configuration::get('NWP_RESET_COOKIE') || Configuration::get('NWP_RESET_COOKIE') == 0) 
			$expire = 0; 
		else
			$expire = time() + 60 * 60 * 24 * (!Configuration::get('NWP_RESET_COOKIE') ? 365 : Configuration::get('NWP_RESET_COOKIE'));
		
		$show_popup = false;
		
		//debug
		//$expire = time()+60; //expires in one minute 
		$popup_cookie = 'nwp_cookie_'.$this->getCookie();
		
		if (Configuration::get('NWP_SHOW_POPUP_ONCE') == 1)
		{
			if (!isset($_COOKIE[$popup_cookie]))
			{
				$this->_setCookie($popup_cookie, 1, $expire);
				$show_popup = true;
			}
			//else { echo "COOKIE IS SET"; } 
		}
		else
			$show_popup = true;

		if ($show_popup)
		{
			$this->context->smarty->assign(array(
				'delay_popup' => (Configuration::get('NWP_TIMER') * 1000),
				'opacity' => Configuration::get('NWP_OPACITY_LEVEL'),
				'modal' => Configuration::get('NWP_MODAL'),
				'button_color' => Configuration::get('NWP_BUTTON_COLOR'),
				'button_text_color' => Configuration::get('NWP_BUTTON_TEXT_COLOR'),
				'nwp_secure_key' => $this->secure_key,
				'msg_before_button' => Configuration::get('NWP_MESSAGE_BF_BTN', $this->context->language->id),
				'msg_after_button' => Configuration::get('NWP_MESSAGE_AFTER_BTN', $this->context->language->id),
				'msg_thankyou' => Configuration::get('NWP_MESSAGE_THANKYOU', $this->context->language->id),
				'msg_no_thanks_close' => Configuration::get('NWP_NO_THANKS_CLOSE', $this->context->language->id),
				'sign_up_text' => Configuration::get('NWP_SIGN_UP_TEXT', $this->context->language->id),
			));

			return $this->display(__FILE__, 'newsletterpopupli.tpl');

		}
	}

	/**
	 * Setcookie according to php version
	 */
	protected function _setcookie($name, $content, $time, $path = '', $domain = null)
	{
		if (PHP_VERSION_ID <= 50200) /* PHP version > 5.2.0 */
			return setcookie($name, $content, $time, $path, $domain, 0);
		else
			return setcookie($name, $content, $time, $path, $domain, 0, true);
	}

	public function hookDisplayHeader()
	{
		$this->context->controller->addCSS(($this->_path).'js/fancybox/jquery.fancybox.css', 'all');
														 
		$this->context->controller->addJS(($this->_path).'js/fancybox/jquery.fancybox.js');
	
		$this->context->controller->addCSS($this->_path.'css/newsletterpopupli.css', 'all');
	}

	/**
	 * Deletes duplicates email in newsletter table
	 *
	 * @param $params
	 *
	 * @return bool
	 */
	public function hookActionCustomerAccountAdd($params)
	{
		//if e-mail of the created user address has already been added to the newsletter through the newsletterpopupli module,
		//we delete it from newsletter table to prevent duplicates
		$id_shop = $params['newCustomer']->id_shop;
		$email = $params['newCustomer']->email;
		$newsletter = $params['newCustomer']->newsletter;
		if ($newsletter && Validate::isEmail($email))
			return (bool)Db::getInstance()->execute('DELETE FROM '._DB_PREFIX_.'newsletter WHERE id_shop='.(int)$id_shop.' AND email=\''.pSQL($email)."'");

		return true;
	}

	public function renderForm()
	{		
		$switch = (version_compare(_PS_VERSION_, '1.6.0', '>=') === true) ? 'switch' : 'radio';   
		
		$fields_form = array(
			'form' => array(
				'legend' => array(
					'title' => $this->l('Newsletter Pop Up Settings'),
					'icon' => 'icon-cogs'),
				'tabs' => array(
					'config' => $this->l('Configuration'),
					'popupcontent' => $this->l('Popup Content'),
					'css' => $this->l('CSS'),
					'help' => $this->l('Help Guide'),
					),
				'input' => array(
					array(
						'type' => $switch,
						'label' => $this->l('Enable'),
						'is_bool' => true,
						'class' => 't',
						'tab' => 'config',
						'name' => 'NWP_ENABLE',
						'values' => array(
							array(
								'id' => 'active_on',
								'value' => 1,
								'label' => $this->l('Yes')
							),
							array(
								'id' => 'active_off',
								'value' => 0,
								'label' => $this->l('No')
							)
						),
					),
					array(
						'type' => 'select',
						'label' => $this->l('Show on pages'),
						'name' => 'NWP_SHOW_ON_ANY_PAGE',
						'tab' => 'config',
						'options' => array(
							'query' => array(
								array(
									'id' => 0,
									'name' => $this->l('Home Page')
								),
								array(
									'id' => 1,
									'name' => $this->l('Any Page')
								)
							),
							'id' => 'id',
							'name' => 'name',
						)
					),
					array(
						'type' => 'text',
						'label' => $this->l('Start Timer'),
						'name' => 'NWP_TIMER',
						'tab' => 'config',
						'class' => 'fixed-width-md',
						'desc' => $this->l('Enter 0 to show popup immediately. Enter -1 to show popup on exit intent. Enter n number of seconds to set a delay.')
					),
					array(
						'type' => 'select',
						'label' => $this->l('When to show popup to user'),
						'name' => 'NWP_SHOW_POPUP_ONCE',
						'tab' => 'config',
						'options' => array(
							'query' => array(
								array(
									'id' => 0,
									'name' => $this->l('Always (useful when testing)')
								),
								array(
									'id' => 1,
									'name' => $this->l('First time (set cookie timeout below)')
								)
							),
							'id' => 'id',
							'name' => 'name',
						)
					),
					array(
						'type' => 'text',
						'tab' => 'config',
						'label' => $this->l('Cookie Timeout (in days)'),
						'name' => 'NWP_RESET_COOKIE',
						'class' => 'fixed-width-md',
						'desc' => $this->l('Enter the number of days when cookie will expire. (Set to 0 to create a cookie that will expire at the end of the browser session.) ')
					),
				
					array(
						'type' => $switch,
						'tab' => 'config',
						'label' => $this->l('Would you like to send a verification email after subscription?'),
						'name' => 'NWP_VERIFICATION_EMAIL',
						'is_bool' => true,
						'class' => 't',
						'values' => array(
							array(
								'id' => 'active_on',
								'value' => 1,
								'label' => $this->l('Yes')
							),
							array(
								'id' => 'active_off',
								'value' => 0,
								'label' => $this->l('No')
							)
						),
					),
					array(
						'type' => $switch,
						'tab' => 'config',
						'label' => $this->l('Would you like to send a confirmation email after subscription?'),
						'name' => 'NWP_CONFIRMATION_EMAIL',
						'is_bool' => true,
						'class' => 't',
						'values' => array(
							array(
								'id' => 'active_on',
								'value' => 1,
								'label' => $this->l('Yes')
							),
							array(
								'id' => 'active_off',
								'value' => 0,
								'label' => $this->l('No')
							)
						),
					),
					array(
						'type' => 'text',
						'tab' => 'config',
						'label' => $this->l('Welcome Voucher Code'),
						'name' => 'NWP_VOUCHER_CODE',
						'class' => 'fixed-width-md',
						'desc' => $this->l('Leave blank to disable by default. User will receive a seperate email with voucher code. Disable confirmation email if you only want the user to receive one welcome email.')
					),
					array(
						'type' => $switch,
						'tab' => 'config',
						'label' => $this->l('Modal'),
						'name' => 'NWP_MODAL',
						'is_bool' => true,
						'class' => 't',
						'values' => array(
							array(
								'id' => 'active_on',
								'value' => 1,
								'label' => $this->l('Yes')
							),
							array(
								'id' => 'active_off',
								'value' => 0,
								'label' => $this->l('No')
							)
						),
						'desc' => $this->l('If set to yes, will disable closing. User must sign up or click on close link if enabled. '),
					),
					array(
					'name' => 'NWP_MESSAGE_BF_BTN',
					'tab' => 'popupcontent',
					'type' => 'textarea',
					'label' => $this->l('Message above submit button'),
					'desc' => $this->l('The message to be displayed above email input and submit button.'),
					'lang' => true,
					'cols' => 60,
					'rows' => 10,
					'class' => 'rte',
					'autoload_rte' => true,
					),
					array(
					'name' => 'NWP_MESSAGE_AFTER_BTN',
					'tab' => 'popupcontent',
					'type' => 'textarea',
					'label' => $this->l('Message below submit button'),
					'desc' => $this->l('The message to be displayed below email input and submit button.'),
					'lang' => true,
					'cols' => 60,
					'rows' => 10,
					'class' => 'rte',
					'autoload_rte' => true,
					),
					array(
					'name' => 'NWP_MESSAGE_THANKYOU',
					'type' => 'textarea',
					'tab' => 'popupcontent',
					'label' => $this->l('Thank you Message'),
					'desc' => $this->l('The message to be displayed when user has successfully subscribed.'),
					'lang' => true,
					'cols' => 60,
					'rows' => 10,
					'class' => 'rte',
					'autoload_rte' => true,
					),
					array(
						'type' => 'text',
						'label' => $this->l('Sign Up Button Text'),
						'name' => 'NWP_SIGN_UP_TEXT',
						'lang' => true,
						'tab' => 'popupcontent',
						'desc' => $this->l('Sign Up Button Text')
					),
					array(
						'type' => 'text',
						'label' => $this->l('Close Message'),
						'name' => 'NWP_NO_THANKS_CLOSE',
						'lang' => true,
						'tab' => 'popupcontent',
						'desc' => $this->l('Close messsage link appears below sign up button. Leave blank to hide.')
					),
					array(
						'type' => 'text',
						'tab' => 'config',
						'label' => $this->l('Opacity Level'),
						'name' => 'NWP_OPACITY_LEVEL',
						'class' => 'fixed-width-md',
						'desc' => $this->l('Opacity level of overlay (from 0 to 1)')
					),
					array(
						'type' => 'color',
						'tab' => 'config',
						'label' => $this->l('Button Background Color'),
						'name' => 'NWP_BUTTON_COLOR',	
						'desc' => $this->l('Enter hex color value or select from color picker')
					),
					array(
						'type' => 'color',
						'tab' => 'config',
						'label' => $this->l('Button Text Color'),
						'name' => 'NWP_BUTTON_TEXT_COLOR',	
						'desc' => $this->l('Enter hex color value or select from color picker')
					),
					array(
						'type' => $switch,
						'tab' => 'config',
						'label' => $this->l('Generate New Cookies'),
						'name' => 'NWP_FLUSH_COOKIE',
						'is_bool' => true,
						'class' => 't',
						'values' => array(
							array(
								'id' => 'active_on',
								'value' => 1,
								'label' => $this->l('Yes')
							),
							array(
								'id' => 'active_off',
								'value' => 0,
								'label' => $this->l('No')
							)
						),
						'desc' => $this->l('Select "yes" to make the popup show for all visitors again, even for those who already saw it. This can be useful when you are running a new incentive campaign.')
					),
					array(
					'name' => 'NWP_CSS',
					'tab' => 'css',
					'type' => 'textarea',
					'label' => $this->l('CSS'),
					'desc' => $this->l('Edit .css file'),
					'lang' => false,
					'cols' =>100,
					'rows' => 10,
					),
				),
				'submit' => array(
					'title' => $this->l('Save'),
				),
				'buttons' => array(
				'save_and_preview' => array(
					'name' => 'viewpopup',
					'type' => 'submit',
					'title' => $this->l('Save & Preview'),
					'class' => 'btn btn-default pull-right',
					'icon' => 'process-icon-preview'
					)
				)
			),
		);

		$helper = new HelperForm();
		$helper->show_toolbar = false;
		$helper->table = $this->table;
		$lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
		$helper->default_form_language = $lang->id;
		$helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
		$helper->identifier = $this->identifier;
		$helper->submit_action = 'submitUpdate';
		$helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues(),
			'languages' => $this->context->controller->getLanguages(),
			'id_language' => $this->context->language->id
		);

		return $helper->generateForm(array($fields_form));
	}

	public function renderSearchForm()
	{
		$fields_form = array(
			'form' => array(
				'legend' => array(
					'title' => $this->l('Search for addresses'),
					'icon' => 'icon-search'
				),
				'input' => array(
					array(
						'type' => 'text',
						'label' => $this->l('Email address to search'),
						'name' => 'searched_email',
						'class' => 'fixed-width-xxl',
						'desc' => $this->l('Example: contact@prestashop.com or @prestashop.com')
					),
				),
				'submit' => array(
					'title' => $this->l('Search'),
					'icon' => 'process-icon-refresh',
				)
			),
		);

		$helper = new HelperForm();
		$helper->table = $this->table;
		$helper->identifier = $this->identifier;
		$helper->submit_action = 'searchEmail';
		$helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->tpl_vars = array(
			'fields_value' => array('searched_email' => $this->_searched_email),
			'languages' => $this->context->controller->getLanguages(),
			'id_language' => $this->context->language->id
		);

		return $helper->generateForm(array($fields_form));
	}

	public function getConfigFieldsValues()
	{
		$languages = Language::getLanguages(false);
		$fields = array();

		foreach ($languages as $lang)
		{
			$fields['NWP_MESSAGE_BF_BTN'][$lang['id_lang']] = Tools::getValue('NWP_MESSAGE_BF_BTN_'.$lang['id_lang'], Configuration::get('NWP_MESSAGE_BF_BTN', $lang['id_lang']));
			$fields['NWP_MESSAGE_AFTER_BTN'][$lang['id_lang']] = Tools::getValue('NWP_MESSAGE_AFTER_BTN_'.$lang['id_lang'], Configuration::get('NWP_MESSAGE_AFTER_BTN', $lang['id_lang']));
			$fields['NWP_MESSAGE_THANKYOU'][$lang['id_lang']] = Tools::getValue('NWP_MESSAGE_THANKYOU_'.$lang['id_lang'], Configuration::get('NWP_MESSAGE_THANKYOU', $lang['id_lang']));
			$fields['NWP_NO_THANKS_CLOSE'][$lang['id_lang']] = Tools::getValue('NWP_NO_THANKS_CLOSE_'.$lang['id_lang'], Configuration::get('NWP_NO_THANKS_CLOSE', $lang['id_lang']));
			$fields['NWP_SIGN_UP_TEXT'][$lang['id_lang']] = Tools::getValue('NWP_SIGN_UP_TEXT_'.$lang['id_lang'], Configuration::get('NWP_SIGN_UP_TEXT', $lang['id_lang']));		
		}

		$css_file = Tools::file_get_contents(dirname(__FILE__).'/css/newsletterpopupli.css');

		return array(
			'NWP_MESSAGE_BF_BTN' => $fields['NWP_MESSAGE_BF_BTN'],
			'NWP_MESSAGE_AFTER_BTN' => $fields['NWP_MESSAGE_AFTER_BTN'],
			'NWP_MESSAGE_THANKYOU' => $fields['NWP_MESSAGE_THANKYOU'],
			'NWP_NO_THANKS_CLOSE' => $fields['NWP_NO_THANKS_CLOSE'],
			'NWP_SIGN_UP_TEXT' => $fields['NWP_SIGN_UP_TEXT'],
			'NWP_CSS' => $css_file,
			'NWP_OPACITY_LEVEL' => Tools::getValue('NWP_OPACITY_LEVEL', Configuration::get('NWP_OPACITY_LEVEL')),
			'NWP_ENABLE' => Tools::getValue('NWP_ENABLE', Configuration::get('NWP_ENABLE')),
			'NWP_MODAL' => Tools::getValue('NWP_MODAL', Configuration::get('NWP_MODAL')),
			'NWP_TIMER' => Tools::getValue('NWP_TIMER', Configuration::get('NWP_TIMER')),
			'NWP_SHOW_ON_ANY_PAGE' => Tools::getValue('NWP_SHOW_ON_ANY_PAGE', Configuration::get('NWP_SHOW_ON_ANY_PAGE')),
			'NWP_SHOW_POPUP_ONCE' => Tools::getValue('NWP_SHOW_POPUP_ONCE', Configuration::get('NWP_SHOW_POPUP_ONCE')),
			'NWP_RESET_COOKIE' => Tools::getValue('NWP_RESET_COOKIE', Configuration::get('NWP_RESET_COOKIE')),
			'NWP_FLUSH_COOKIE' => '0',
			'NWP_VERIFICATION_EMAIL' => Tools::getValue('NWP_VERIFICATION_EMAIL', Configuration::get('NWP_VERIFICATION_EMAIL')),
			'NWP_CONFIRMATION_EMAIL' => Tools::getValue('NWP_CONFIRMATION_EMAIL', Configuration::get('NWP_CONFIRMATION_EMAIL')),
			'NWP_VOUCHER_CODE' => Tools::getValue('NWP_VOUCHER_CODE', Configuration::get('NWP_VOUCHER_CODE')),
			'NWP_BUTTON_COLOR' => Tools::getValue('NWP_BUTTON_COLOR', Configuration::get('NWP_BUTTON_COLOR')),
			'NWP_BUTTON_TEXT_COLOR' => Tools::getValue('NWP_BUTTON_TEXT_COLOR', Configuration::get('NWP_BUTTON_TEXT_COLOR')),
		);
	}

	private function getLanguageId()
	{
		$iso_code = Language::getIsoById($this->context->language->id);
		if (!file_exists(dirname(__FILE__).'/mails/'.$iso_code))
			return 1;
		else
			return $this->context->language->id;
	}

	private function getCookie()
	{
		$result = Db::getInstance()->getRow('
		SELECT `cookie_time`
		FROM `'._DB_PREFIX_.'li_newsletter_popup`
		WHERE `id` = 1 AND `id_shop` = '.(int)$this->context->shop->id);

		return $result['cookie_time'];
	}

}
