<?php
/**
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2014 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

include_once(dirname(__FILE__).'/tvhtmlclass.php');
class tvhtmlblock extends Module
{
	protected $error = false;
	private $html;
	private $myHook = array('displayNav','displayTop','displayHome','homeright','homebottom','displayFooter','footertop','footerright','copyright','displayLeftColumn','displayRightColumn','imagecategory');
	
public function __construct()
{
	 	$this->name = 'tvhtmlblock';
	 	$this->tab = 'others';
	 	$this->version = '1.0';
		$this->author = 'ThemesVip';
		$this->module_key = '4ddaa2f6c66dba43730094b1749fabba';
		$this->bootstrap = true;
	 	parent::__construct();

		$this->displayName = $this->l('TV HTML block');
		$this->description = $this->l('Adds html blocks on your site');
		$this->confirmUninstall = $this->l('Are you sure that you want to delete your html blocks?');
	
}

public function init_data()
{
		$content_nav_en = '<div class="header-free-shipping"><span class="bold">Free shipping</span> on Order over <span class="bold">890$</span> start 30 June</div>';
		$content_nav_fr = $content_nav_en;
		$content_nav_es = $content_nav_en;
		
		$content_top_en = '<div id="block-support-moneyback" class="col-sm-5 clearfix">
						<div class="col1">
						<p class="support-block">Support 24/7</p>
						<p class="small">Call <span class="red">1900 - 1521523</span> to support</p>
						</div>
						<div class="col2">
						<p class="moneyback">Money back guarantee</p>
						<p class="small">free returns with collect +</p>
						</div>
						</div>';
		$content_top_fr = $content_top_en;
		$content_top_es = $content_top_en;
		
		$content_left_column_en = '<div id="tv_banner-left" class="banner-left-1"><a class="banner_image" href="#"><img title="one market 	theme" src="{html_block_url}/themes/onemarket/img/cms/banner-home-right1.png" alt="" /><span class="hover_bkg_light"><span style="display: none;">effect hover</span></span></a></div>';
		$content_left_column_fr = $content_left_column_en;
		$content_left_column_es = $content_left_column_en;
		
		$content_home_en = '<div class="top-banner-home"><a href="#"><img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/banner-home1.png" alt="" /></a></div>';
		$content_home_fr = $content_home_en;
		$content_home_es = $content_home_en;
		
		$content_home_right_en = '<div id="banner-home-right" class="col-xs-12 col-sm-4 col-md-3">
								<div class="banner-1"><a class="banner_image" href="#"><img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/banner-home-right1.png" alt="" /><span class="hover_bkg_light"><span style="display: none;">effect hover</span></span></a></div>
								<div class="banner-2"><a class="banner_image" href="#"><img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/banner-home-right2.png" alt="" /><span class="hover_bkg_light"><span style="display: none;">effect hover</span></span></a></div>
								<div class="banner-3"><a class="banner_image" href="#"><img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/banner-home-right3.png" alt="" /><span class="hover_bkg_light"><span style="display: none;">effect hover</span></span></a></div>
								</div>';
		$content_home_right_fr = $content_home_right_en;
		$content_home_right_es = $content_home_right_en;
		
		$content_home_bottom_en = '<div id="banner-home-bottom" class="center_column col-xs-12 col-sm-12">
								<div class="banner-1 col-md-4"><a class="banner_image" href="#"><img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/banner-home-bottom1.png" alt="" /><span class="hover_bkg_light"><span style="display: none;">effect hover</span></span></a></div>
								<div class="banner-2 col-md-4"><a class="banner_image" href="#"><img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/banner-home-bottom2.png" alt="" /><span class="hover_bkg_light"><span style="display: none;">effect hover</span></span></a></div>
								<div class="banner-3 col-md-4"><a class="banner_image" href="#"><img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/banner-home-bottom3.png" alt="" /><span class="hover_bkg_light"><span style="display: none;">effect hover</span></span></a></div>
								</div>';	
		$content_home_bottom_fr = $content_home_bottom_en;
		$content_home_bottom_es = $content_home_bottom_en;
		
		$content_footer_top_en = '<div class="banner-home-footer"><a href="#"><img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/banner-footer-top.png" alt="" /></a></div>';	
		$content_footer_top_fr = $content_footer_top_en;
		$content_footer_top_es = $content_footer_top_en;
		
		$content_footer_en = '<div id="tv-footer-about-us" class="footer-block col-xs-12 col-sm-3">
								<h4>About us</h4>
								<div class="content toggle-footer"><img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/about-us.png" alt="" />
								<p class="text">We are a group of expert professionals with experience and alway use new technology, so we will bring best solutions for your site....</p>
								<p class="location">Location: Company, 42 avenue des Champs Elys&eacute;es 75000 Paris</p>
								<p class="email">Email: your-email@gmail.com</p>
								<p class="phone">Phone: 01234567890</p>
								<div class="social"><a href="#"><img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/facebook.png" alt="" /> </a>
								<a href="#"> <img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/twitter.png" alt="" /> </a>
								<a href="#"> <img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/youtube.png" alt="" /></a>
								<a href="#"> <img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/google.png" alt="" /></a>
								<a href="#"> <img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/be.png" alt="" /> </a>
								<a href="#"> <img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/rss.png" alt="" /></a>
								</div>
								</div>
								</div>';
		$content_footer_fr = $content_footer_en;
		$content_footer_es = $content_footer_en;
		
		$content_footer_right_en = '<div id="footer-block-customerservice" class="footer-block col-xs-12 col-sm-2">
									<h4>Customer Service</h4>
									<div class="block_content toggle-footer">
									<ul class="bullet">
									<li><a title="Secure payment" href="#" rel="nofollow">Secure payment</a></li>
									<li><a title="Discount" href="#" rel="nofollow">Discount</a></li>
									<li><a title="On Sale Now" href="#" rel="nofollow">On Sale Now</a></li>
									<li><a title="Terms of Use" href="#" rel="nofollow">Terms of Use</a></li>
									<li><a title="Privacy Policy" href="#" rel="nofollow">Privacy Policy</a></li>
									<li><a title="Affiliate Policy" href="#" rel="nofollow">Affiliate Policy</a></li>
									</ul>
									</div>
									</div>';	
		$content_footer_right_fr = $content_footer_right_en;
		$content_footer_right_es = $content_footer_right_en;
		
		$content_copyright_en = '<div class="copyright">
									<p>Copyright &copy; 2014 One Market. Atl Rights Reserved. PrestaShop Theme by ThemesVIP</p>
									</div>
									<div class="payment">
									<a href="#"><img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/paypal.png" alt="" /> </a>
									<a href="#"><img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/visa.png" alt="" /> </a>
									<a href="#"><img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/express.png" alt="" /> </a>
									<a href="#"><img title="one market theme" src="{html_block_url}/themes/onemarket/img/cms/mastercard.png" alt="" />
									</a></div>';
		$content_copyright_fr = $content_copyright_en;
		$content_copyright_es = $content_copyright_en;
		
		$content_imagecat_en = '';
		$content_imagecat_fr = $content_imagecat_en;
		$content_imagecat_es = $content_imagecat_en;
		
		$id_hook_top = Hook::getIdByName('displayTop');
		$id_hook_nav = Hook::getIdByName('displayNav');
		$id_hook_leftcolumn = Hook::getIdByName('displayLeftColumn');
		$id_hook_rightcolumn = Hook::getIdByName('displayRightColumn');
		$id_hook_home = Hook::getIdByName('displayHome');
		$id_hook_homeright = Hook::getIdByName('homeright');
		$id_hook_homebottom = Hook::getIdByName('homebottom');
		$id_hook_footertop = Hook::getIdByName('footertop');
		$id_hook_footer = Hook::getIdByName('displayFooter');	
		$id_hook_footerright = Hook::getIdByName('footerright');
		$id_hook_copyright = Hook::getIdByName('copyright');
		$id_hook_imagecat = Hook::getIdByName('imagecategory');

		$id_en = Language::getIdByIso('en');
		$id_fr = Language::getIdByIso('fr');
		if(!$id_fr)
		$id_fr = 3;
		$id_es = Language::getIdByIso('es');
		if(!$id_es)
		$id_es = 4;
		$id_shop = Configuration::get('PS_SHOP_DEFAULT');
		
		if(!Db::getInstance()->Execute('INSERT INTO `'._DB_PREFIX_.'tvhtmlblock` (`id_htmlblock`, `identifier_block`, `hook`, `is_active`) 
			VALUES (1, "nav_header","'.$id_hook_nav.'", 1),
			     (2, "top_header","'.$id_hook_top.'", 1),
				(3, "left_column","'.$id_hook_leftcolumn.'", 1),
				(4, "home_content","'.$id_hook_home.'", 1),
				(5, "home_content_right","'.$id_hook_home.'", 1),
				(6, "home_content_bottom","'.$id_hook_homebottom.'", 1),
				(7, "footer_top","'.$id_hook_footertop.'", 1),
				(8, "footer","'.$id_hook_footer.'", 1),	
				(9, "footer_right","'.$id_hook_footerright.'", 1),
				(10, "copyright","'.$id_hook_copyright.'", 1),
				(11, "image_category","'.$id_hook_imagecat.'", 1),								
				(12, "right_column","'.$id_hook_rightcolumn.'", 1);') OR				
	
		!Db::getInstance()->Execute('INSERT INTO `'._DB_PREFIX_.'tvhtmlblock_shop` (`id_htmlblock`, `id_shop`,`hook`,`is_active`)
			VALUES 	(1,"'.$id_shop.'","'.$id_hook_nav.'",1),
					(2,"'.$id_shop.'","'.$id_hook_top.'", 1),
					(3,"'.$id_shop.'","'.$id_hook_leftcolumn.'", 1),
					(4,"'.$id_shop.'","'.$id_hook_home.'", 1),
					(5,"'.$id_shop.'","'.$id_hook_home.'", 1),
					(6,"'.$id_shop.'","'.$id_hook_homebottom.'", 1),
					(7,"'.$id_shop.'","'.$id_hook_footertop.'", 1),
					(8,"'.$id_shop.'","'.$id_hook_footer.'", 1),
					(9,"'.$id_shop.'","'.$id_hook_footerright.'", 1),
					(10,"'.$id_shop.'","'.$id_hook_copyright.'", 1),
					(11,"'.$id_shop.'","'.$id_hook_imagecat.'", 1),					
					(12,"'.$id_shop.'","'.$id_hook_rightcolumn.'", 1);') OR

		!Db::getInstance()->Execute('INSERT INTO `'._DB_PREFIX_.'tvhtmlblock_lang` (`id_htmlblock`, `id_lang`, `id_shop`, `title`, `content`) 
			VALUES 
			( "1", "'.$id_en.'","'.$id_shop.'","Free Shipping - Nav Header", \''.$content_nav_en.'\'),
			( "1", "'.$id_fr.'","'.$id_shop.'","Free Shipping - Nav Header", \''.$content_nav_fr.'\'),
			( "1", "'.$id_es.'","'.$id_shop.'","Free Shipping - Nav Header", \''.$content_nav_es.'\'),
			( "2", "'.$id_en.'","'.$id_shop.'","Support - Top Header", \''.$content_top_en.'\'),
			( "2", "'.$id_fr.'","'.$id_shop.'","Support - Top Header", \''.$content_top_fr.'\'),
			( "2", "'.$id_es.'","'.$id_shop.'","Support - Top Header", \''.$content_top_es.'\'),
			( "3", "'.$id_en.'","'.$id_shop.'","Banner - Left Column", \''.$content_left_column_en.'\'),
			( "3", "'.$id_fr.'","'.$id_shop.'","Banner - Left Column", \''.$content_left_column_fr.'\'),
			( "3", "'.$id_es.'","'.$id_shop.'","Banner - Left Column", \''.$content_left_column_es.'\'),
			( "4", "'.$id_en.'","'.$id_shop.'","Banner - Home Content Top", \''.$content_home_en.'\'),
			( "4", "'.$id_fr.'","'.$id_shop.'","Banner - Home Content Top", \''.$content_home_fr.'\'),
			( "4", "'.$id_es.'","'.$id_shop.'","Banner - Home Content Top", \''.$content_home_es.'\'),
			( "5", "'.$id_en.'","'.$id_shop.'","Banner - Home Content Right", \''.$content_home_right_en.'\'),
			( "5", "'.$id_fr.'","'.$id_shop.'","Banner - Home Content Right", \''.$content_home_right_fr.'\'),
			( "5", "'.$id_es.'","'.$id_shop.'","Banner - Home Content Right", \''.$content_home_right_es.'\'),
			( "6", "'.$id_en.'","'.$id_shop.'","Banner - Home Content Bottom", \''.$content_home_bottom_en.'\'),
			( "6", "'.$id_fr.'","'.$id_shop.'","Banner - Home Content Bottom", \''.$content_home_bottom_fr.'\'),
			( "6", "'.$id_es.'","'.$id_shop.'","Banner - Home Content Bottom", \''.$content_home_bottom_es.'\'),
			( "7", "'.$id_en.'","'.$id_shop.'","Banner - Footer Top", \''.$content_footer_top_en.'\'),
			( "7", "'.$id_fr.'","'.$id_shop.'","Banner - Footer Top", \''.$content_footer_top_fr.'\'),
			( "7", "'.$id_es.'","'.$id_shop.'","Banner - Footer Top", \''.$content_footer_top_es.'\'),
			( "8", "'.$id_en.'","'.$id_shop.'"," About Us - Footer", \''.$content_footer_en.'\'),
			( "8", "'.$id_fr.'","'.$id_shop.'"," About Us - Footer", \''.$content_footer_fr.'\'),
			( "8", "'.$id_es.'","'.$id_shop.'"," About Us - Footer", \''.$content_footer_es.'\'),
			( "9", "'.$id_en.'","'.$id_shop.'","Customer Service - Footer Right", \''.$content_footer_right_en.'\'),
			( "9", "'.$id_fr.'","'.$id_shop.'","Customer Service - Footer Right", \''.$content_footer_right_fr.'\'),
			( "9", "'.$id_es.'","'.$id_shop.'","Customer Service - Footer Right", \''.$content_footer_right_es.'\'),
			( "10", "'.$id_en.'","'.$id_shop.'","Copyright", \''.$content_copyright_en.'\'),
			( "10", "'.$id_fr.'","'.$id_shop.'","Copyright", \''.$content_copyright_fr.'\'),
			( "10", "'.$id_es.'","'.$id_shop.'","Copyright", \''.$content_copyright_es.'\'),
			( "11", "'.$id_en.'","'.$id_shop.'","Image Category", \''.$content_imagecat_en.'\'),
			( "11", "'.$id_fr.'","'.$id_shop.'","Image Category", \''.$content_imagecat_fr.'\'),
			( "11", "'.$id_es.'","'.$id_shop.'","Image Category", \''.$content_imagecat_es.'\');')
		)
			return false;
		return true;	
}
	
public function install()
{		
	 	if (parent::install() == false OR !$this->registerHook('header') OR !$this->registerHook('actionShopDataDuplication'))
	 		return false;
		foreach ($this->myHook AS $hook){
			if ( !$this->registerHook($hook))
				return false;
		}
	 	if (!Db::getInstance()->Execute('CREATE TABLE '._DB_PREFIX_.'tvhtmlblock (`id_htmlblock` int(10) unsigned NOT NULL AUTO_INCREMENT, `identifier_block` varchar(255) NOT NULL DEFAULT \'\', `hook` int(10) unsigned, `is_active` tinyint(1) NOT NULL DEFAULT \'1\', PRIMARY KEY (`id_htmlblock`),UNIQUE KEY `identifier_block` (`identifier_block`)) ENGINE=InnoDB default CHARSET=utf8'))
	 		return false;
		if (!Db::getInstance()->Execute('CREATE TABLE '._DB_PREFIX_.'tvhtmlblock_shop (`id_htmlblock` int(10) unsigned NOT NULL,`id_shop` int(10) unsigned NOT NULL,`hook` int(10) unsigned,`is_active` tinyint(1) NOT NULL DEFAULT \'1\',PRIMARY KEY (`id_htmlblock`,`id_shop`)) ENGINE=InnoDB default CHARSET=utf8'))
	 		return false;
		if (!Db::getInstance()->Execute('CREATE TABLE '._DB_PREFIX_.'tvhtmlblock_lang (`id_htmlblock` int(10) unsigned NOT NULL, `id_lang` int(10) unsigned NOT NULL,`id_shop` int(10) unsigned NOT NULL, `title` varchar(255) NOT NULL DEFAULT \'\', `content` mediumtext, PRIMARY KEY (`id_htmlblock`,`id_lang`,`id_shop`)) ENGINE=InnoDB default CHARSET=utf8'))
	 		return false;
		
		$this->init_data();
	 	return true;
}

public function uninstall()
{	
	 	if (parent::uninstall() == false)
	 		return false;
	 	if (!Db::getInstance()->Execute('DROP TABLE '._DB_PREFIX_.'tvhtmlblock') OR !Db::getInstance()->Execute('DROP TABLE '._DB_PREFIX_.'tvhtmlblock_shop') OR !Db::getInstance()->Execute('DROP TABLE '._DB_PREFIX_.'tvhtmlblock_lang'))
	 		return false;
	 	return true;
}



public function getContent()
{
		$this->html = '<h2><img src="'.$this->_path.'logo.png" alt="" /> '.$this->displayName.'</h2>';
		$this->postProcess();
		if (Tools::isSubmit('addBlock') || Tools::isSubmit('editBlock') || Tools::isSubmit('saveBlock'))
			$this->initForm();
		else
		$this->displayForm();
		$this->displayHelp();
		return $this->html;
}

public function displayHelp()
{
		
}

private function postProcess()
{
		$errors = array();
		if (Tools::isSubmit('saveBlock'))
		{
			$block = new TVHtmlClass(Tools::getValue('id_htmlblock'));
			$block->copyFromPost();
			$errors = $block->validateController();		
			if (sizeof($errors))
			{
				$this->html .= $this->displayError(implode('<br />', $errors));
			}
			else
			{
				Tools::getValue('id_htmlblock') ? $block->update() : $block->add();
				Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&saveBlockConfirmation');
			}
		}
		elseif (Tools::isSubmit('changeStatusblock') AND Tools::getValue('id_htmlblock'))
		{
			$stblock = new TVHtmlClass(Tools::getValue('id_htmlblock'));
			$stblock->updateStatus(Tools::getValue('status'));
			Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'));
		}
		elseif (Tools::isSubmit('deleteBlock') AND Tools::getValue('id_htmlblock'))
		{
			$block = new TVHtmlClass(Tools::getValue('id_htmlblock'));
			$block->delete();
			Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&deleteBlockConfirmation');
		}
		elseif (Tools::isSubmit('saveBlockConfirmation'))
			$this->html = $this->displayConfirmation($this->l('HTML block has been saved successfully'));
		elseif (Tools::isSubmit('deleteBlockConfirmation'))
			$this->html = $this->displayConfirmation($this->l('HTML block deleted successfully'));
}

private function getHookName($id_hook)
{
		if (!$result = Db::getInstance()->getRow('
		SELECT `name`,`title`
		FROM `'._DB_PREFIX_.'hook` 
		WHERE `id_hook` = '.(int)($id_hook)))
			return false;
		return $result['name'];
}

private function getBlocks()
{
		$this->context = Context::getContext();
		$id_lang = $this->context->language->id;
		$id_shop = $this->context->shop->id;
	 	if (!$result = Db::getInstance()->ExecuteS(
			'SELECT b.id_htmlblock, b.identifier_block, bs.hook, bs.is_active, bl.`title`, bl.`content` 
			FROM `'._DB_PREFIX_.'tvhtmlblock` b 
			LEFT JOIN `'._DB_PREFIX_.'tvhtmlblock_shop` bs ON (b.`id_htmlblock` = bs.`id_htmlblock` )
			LEFT JOIN `'._DB_PREFIX_.'tvhtmlblock_lang` bl ON (b.`id_htmlblock` = bl.`id_htmlblock`'.( $id_shop ? 'AND bl.`id_shop` = '.$id_shop : ' ' ).') 
			WHERE bl.id_lang = '.(int)$id_lang.
			( $id_shop ? ' AND bs.`id_shop` = '.$id_shop : ' ').' ORDER BY b.`id_htmlblock` ASC'))
	 		return false;
	return $result;
}

private function getHookTitle($id_hook,$name=false)
{
		if (!$result = Db::getInstance()->getRow('
			SELECT `name`,`title`
			FROM `'._DB_PREFIX_.'hook` 
			WHERE `id_hook` = '.(int)($id_hook)))
			return false;
		return (($result['title'] != "" && $name) ? $result['title'] : $result['name']);
}

private function displayForm()
{
		$this->html .= '
		<fieldset>
		<p style="text-align:left;"><a style="text-align:center; font-weight:bold;" href="'.$this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&addBlock"><img src="'.$this->_path.'img/add.png" alt="" /> '.$this->l('Add a new block').'</a></p>
			<table width="100%" class="table" cellspacing="0" cellpadding="0">
			<thead>
			<tr class="nodrag nodrop">
				<th>'.$this->l('ID').'</th>
				<th class="left">'.$this->l('Title').'</th>
				<th class="center">'.$this->l('Identifier').'</th>
				<th class="center">'.$this->l('Hook into').'</th>
				<th class="center">'.$this->l('Active').'</th>
				<th class="center">'.$this->l('Delete').'</th>
			</tr>
			</thead>
			<tbody>';
		$s_blocks = $this->getBlocks();
		if (is_array($s_blocks))
		{
			static $irow;
			foreach ($s_blocks as $block)
			{
				$stringConfirm='onclick="if (!confirm(\'Are you sure that you want to delete item block id = '.$block['id_htmlblock'].' ?\')) return false "';
				$this->html .= '
				<tr class="'.($irow++ % 2 ? 'alt_row' : '').'">
					<td class="pointer" onclick="document.location = \''.$this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&editBlock&id_htmlblock='.$block['id_htmlblock'].'\'">'.$block['id_htmlblock'].'</td>
					<td class="pointer left" onclick="document.location = \''.$this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&editBlock&id_htmlblock='.$block['id_htmlblock'].'\'">'.$block['title'].'</td>
					<td class="pointer center" onclick="document.location = \''.$this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&editBlock&id_htmlblock='.$block['id_htmlblock'].'\'">'.$block['identifier_block'].'</td>
					<td class="pointer center" onclick="document.location = \''.$this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&editBlock&id_htmlblock='.$block['id_htmlblock'].'\'">'.(Validate::isInt($block['hook']) ? $this->getHookTitle($block['hook']) : '').'</td>
					<td class="pointer center"> <a href="'.$this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&changeStatusblock&id_htmlblock='.$block['id_htmlblock'].'&status='.$block['is_active'].'&hook='.$block['hook'].'">'.($block['is_active'] ? '<img src="'.$this->_path.'img/active.png" alt="Enabled" title="Enabled" />' : '<img src="'.$this->_path.'img/disable.png" alt="Disabled" title="Disabled" />').'</a> </td>
					<td class="pointer center">
					<a href="'.$this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&deleteBlock&id_htmlblock='.$block['id_htmlblock'].'\'"'.$stringConfirm.'><img src="'.$this->_path.'img/delete.png" alt="delete" title="Delete" /></a>
					</td>
				</tr>';
			}
		}
		$this->html .= '
			</tbody>
			</table>
			</fieldset>';
}

public function getHookList()
{
		$hooks = array();
		foreach ($this->myHook as $key=>$hook)
		{
			$id_hook = Hook::getIdByName($hook);
			$name_hook = $this->getHookTitle($id_hook);
			$hooks[$key]['key']= $id_hook;
			$hooks[$key]['name']= $name_hook;
		}
		return $hooks;
}

public function initForm()
{
		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');
		$hooks = $this->getHookList();
		$this->fields_form[0]['form'] = array(
					'tinymce' => true,
					'legend' => array(
					'title' => $this->l('Block item'),
			),
			'input' => array(
				array(
					'type' => 'text',
					'label' => $this->l('Title'),
					'lang' => true,
					'name' => 'title',
					'cols' => 40,
					'rows' => 10
					
				),
				array(
					'type' => 'text',
					'label' => $this->l('Identifier'),
					'name' => 'identifier_block',
					'cols' => 30,
					'rows' => 10,
					'hint' => $this->l('Identifier must be unique').'. '.$this->l('Match a-zA-Z-_0-9')
					
				),
				array(
					'type' => 'select',
					'label' => $this->l('Hook into'),
					'name' => 'hook',
					'options' => array(
						'query' => $hooks, 
						'id' => 'key',
						'name' => 'name'
					)
					
				),
				array(
						'type' => 'switch',
						'label' => $this->l('Displayed'),
						'name' => 'is_active',
						'values' => array(
									array(
										'id' => 'is_active_on',
										'value' => 1,
										'label' => $this->l('Enabled')
									),
									array(
										'id' => 'is_active_off',
										'value' => 0,
										'label' => $this->l('Disabled')
									)
						),
			  ),
			  array(
					'type' => 'textarea',
					'label' => $this->l('Content'),
					'name' => 'content',
					'lang' => true,
					'autoload_rte' => true,
					'cols' => 40,
					'rows' => 10
				),
			),
			'submit' => array(
				'title' => $this->l('Save'),
			)
		);
		
		$helper = new HelperForm();
		$helper->module = $this;
		$helper->name_controller = 'tvhtmlblock';
		$helper->identifier = $this->identifier;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->show_cancel_button = true;
		$helper->back_url = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules');
		foreach (Language::getLanguages(false) as $lang)
			$helper->languages[] = array(
				'id_lang' => $lang['id_lang'],
				'iso_code' => $lang['iso_code'],
				'name' => $lang['name'],
				'is_default' => ($default_lang == $lang['id_lang'] ? 1 : 0)
			);

		$helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name;
		$helper->default_form_language = $default_lang;
		$helper->allow_employee_form_lang = $default_lang;
		$helper->toolbar_scroll = true;
		$helper->title = $this->displayName;
		$helper->submit_action = 'saveBlock';
		$helper->toolbar_btn =  array(
			'save' =>
			array(
				'desc' => $this->l('Save'),
				'href' => $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&save'.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
			),
			'back' =>
			array(
				'href' => $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
				'desc' => $this->l('Back to list')
			)
		);
		
		$id_htmlblock = Tools::getValue('id_htmlblock');
		if (Tools::isSubmit('id_htmlblock') && $id_htmlblock)
		{
			$block = new TVHtmlClass((int)$id_htmlblock);
			$this->fields_form[0]['form']['input'][] = array('type' => 'hidden', 'name' => 'id_htmlblock');
			$helper->fields_value['id_htmlblock'] = (int)Tools::getValue('id_htmlblock', $block->id_htmlblock);	
		}
		else
			$block = new TVHtmlClass();
		foreach (Language::getLanguages(false) as $lang)
		{
			$helper->fields_value['title'][(int)$lang['id_lang']] = Tools::getValue('title_'.(int)$lang['id_lang'],$block->title[(int)$lang['id_lang']]);
			$helper->fields_value['content'][(int)$lang['id_lang']] =  Tools::getValue('content_'.(int)$lang['id_lang'],$block->content[(int)$lang['id_lang']]);
		}
		$helper->fields_value['identifier_block'] = Tools::getValue('identifier_block',$block->identifier_block);
			
		$helper->fields_value['hook'] = Tools::getValue('hook',$block->hook);
		$helper->fields_value['is_active'] = Tools::getValue('is_active',$block->is_active);
		$this->html .= $helper->generateForm($this->fields_form);
}

public function contentById($id_htmlblock)
{
		$id_lang = (int)$this->context->language->id;
		$htmlblock = new TVHtmlClass($id_htmlblock);
		return ($htmlblock->is_active ? $htmlblock->content[$id_lang] : '');
}

public function contentByIdentifier($identifier)
{
		$id_lang = (int)$this->context->language->id;
		if (!$result = Db::getInstance()->getRow('
			SELECT `id_htmlblock`,`identifier_block`
			FROM `'._DB_PREFIX_.'tvhtmlblock` 
			WHERE `identifier_block` = \''.$identifier.'\''))
			return false;
		$htmlblock = new TVHtmlClass($result['id_htmlblock']);
		return ($htmlblock->is_active ? $htmlblock->content[$id_lang] : '');
}

private function getBlockInHook($hook_name)
{
		$block_list = array();
		$this->context = Context::getContext();
		$id_shop = $this->context->shop->id;
		$id_hook = Hook::getIdByName($hook_name);
		if ($id_hook)
		{
			$results = Db::getInstance()->ExecuteS('SELECT b.`id_htmlblock` FROM `'._DB_PREFIX_.'tvhtmlblock` b
			LEFT JOIN `'._DB_PREFIX_.'tvhtmlblock_shop` bs ON (b.id_htmlblock = bs.id_htmlblock)
			WHERE bs.is_active = 1 AND (bs.id_shop = '.(int)$id_shop.') AND bs.`hook` = '.(int)($id_hook));
			foreach ($results as $row)
			{
				$temp = new TVHtmlClass($row['id_htmlblock']);
				$block_list[] = $temp;
			}
		}	
		return $block_list;
}

public function hookHeader()
{
		$this->context->smarty->assign(array(
		    'HOOK_HOME_RIGHT' => Hook::Exec('homeright'), 
			'HOOK_HOME_BOTTOM' => Hook::Exec('homebottom'),
			'HOOK_FOOTER_TOP' => Hook::Exec('footertop'),
			'HOOK_FOOTER_RIGHT' => Hook::Exec('footerright'),
			'HOOK_COPYRIGHT' => Hook::Exec('copyright'),
			'HOOK_IMAGECAT' => Hook::Exec('imagecategory')
		));
}

public function hookDisplayNav()
{
		$block_list = $this->getBlockInHook('displayNav');
		$this->context->smarty->assign(array(
			'block_list' => $block_list
		));
		return $this->display(__FILE__, 'tvhtmlblock_nav_header.tpl');
}

public function hookDisplayTop()
{
		$block_list = $this->getBlockInHook('displayTop');
		$this->context->smarty->assign(array(
			'block_list' => $block_list
		));
		return $this->display(__FILE__, 'tvhtmlblock_top_header.tpl');
}

public function hookDisplayLeftColumn()
{
		$block_list = $this->getBlockInHook('displayLeftColumn');
		
		$this->context->smarty->assign(array(
			'block_list' => $block_list
		));	
		return $this->display(__FILE__, 'tvhtmlblock_left_column.tpl');
}

public function hookDisplayRightColumn()
{
		$block_list = $this->getBlockInHook('displayRightColumn');
		$this->context->smarty->assign(array(
			'block_list' => $block_list
		));
		return $this->display(__FILE__, 'tvhtmlblock_right_column.tpl');
}

public function hookDisplayFooter()
{
			$block_list = $this->getBlockInHook('displayFooter');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		return $this->display(__FILE__, 'tvhtmlblock_footer.tpl');
}

public function hookFooterTop()
{	
			$block_list = $this->getBlockInHook('footertop');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		return $this->display(__FILE__, 'tvhtmlblock_footer_top.tpl');
}

public function hookDisplayHome()
{	
		$block_list = $this->getBlockInHook('displayHome');
		$this->context->smarty->assign(array(
			'block_list' => $block_list
		));
		return $this->display(__FILE__, 'tvhtmlblock_home.tpl');
}

public function hookHomeRight()
{
			$block_list = $this->getBlockInHook('homeright');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		return $this->display(__FILE__, 'tvhtmlblock_home_right.tpl');
}

public function hookHomeBottom()
{
			$block_list = $this->getBlockInHook('homebottom');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		
		return $this->display(__FILE__, 'tvhtmlblock_home_bottom.tpl');
}

public function hookFooterRight()
{
			$block_list = $this->getBlockInHook('footerright');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		return $this->display(__FILE__, 'tvhtmlblock_footer_right.tpl');
}

public function hookCopyRight()
{
			$block_list = $this->getBlockInHook('copyright');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		return $this->display(__FILE__, 'tvhtmlblock_copyright.tpl');
}
	
public function hookImageCategory()
{
		
			$block_list = $this->getBlockInHook('imagecategory');
			$this->context->smarty->assign(array(
				'block_list' => $block_list
			));
		return $this->display(__FILE__, 'tvhtmlblock_imagecategory.tpl');
}

public function hookActionShopDataDuplication($params)
{
		Db::getInstance()->execute('
		INSERT IGNORE INTO '._DB_PREFIX_.'tvhtmlblock_shop (id_htmlblock, id_shop,hook, is_active)
		SELECT id_htmlblock, '.(int)$params['new_id_shop'].',hook, is_active
		FROM '._DB_PREFIX_.'tvhtmlblock_shop
		WHERE id_shop = '.(int)$params['old_id_shop']);
		
		Db::getInstance()->execute('
		INSERT IGNORE INTO '._DB_PREFIX_.'tvhtmlblock_lang (id_htmlblock, id_lang, id_shop, title, content)
		SELECT id_htmlblock, id_lang, '.(int)$params['new_id_shop'].', title, content
		FROM '._DB_PREFIX_.'tvhtmlblock_lang
		WHERE id_shop = '.(int)$params['old_id_shop']);
		
}

}
?>
