<?php
/**
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2014 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class TVHtmlClass extends ObjectModel
{
	public $id_htmlblock;
	public $title;
	public $content;
	public $identifier_block;
	public $is_active;
	public $hook;
	
	public static $definition = array(
		'table' => 'tvhtmlblock',
		'primary' => 'id_htmlblock',
		'multilang' => true,
		'multilang_shop' => true,
		'fields' => array(
			//basic fields
			'identifier_block' =>	array('type' => self::TYPE_STRING, 'validate' => 'isCleanHtml', 'required' => true, 'size' => 255),
			// Lang fields
			'title' =>			array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCleanHtml', 'required' => true, 'size' => 255),
			'content' => 	array('type' => self::TYPE_HTML, 'lang' => true, 'validate' => 'isString'),
			//Shop fields
			'hook' =>		array('type' => self::TYPE_INT,'shop' => true, 'validate' => 'isunsignedInt'),
			'is_active' =>		array('type' => self::TYPE_INT,'shop' => true, 'validate' => 'isunsignedInt'),
		)
	);
	
public $temp_url = "{html_block_url}";
	
public	function __construct($id_tab = null, $id_lang = null, $id_shop = null, Context $context = null)
{
		parent::__construct($id_tab, $id_lang, $id_shop);
		
		Shop::addTableAssociation('tvhtmlblock', array('type' => 'shop'));
		Shop::addTableAssociation('tvhtmlblock_lang', array('type' => 'fk_shop'));
		if ($this->id)
		{
			$this->is_active = $this->getFieldShop('is_active');
			$this->hook = $this->getFieldShop('hook');
			$languages = Language::getLanguages(false);
			foreach ($languages as $language)
			{
				if (isset($this->content[(int)($language['id_lang'])]) AND !empty($this->content[(int)($language['id_lang'])]))
				{
					$temp = str_replace($this->temp_url, _PS_BASE_URL_.__PS_BASE_URI__, $this->content[(int)($language['id_lang'])]);
					$this->content[(int)($language['id_lang'])] = $temp;
				}
			}
		}
		
}
	
public function getFieldShop($field)
{
		$id_shop = (int)Context::getContext()->shop->id;
		$sql = 'SELECT bs.'.$field.' FROM '._DB_PREFIX_.'tvhtmlblock b
		LEFT JOIN '._DB_PREFIX_.'tvhtmlblock_shop bs ON (b.id_htmlblock = bs.id_htmlblock)
		WHERE b.id_htmlblock = '.$this->id.' AND bs.id_shop = '.$id_shop.'';
		$result = Db::getInstance()->getValue($sql);
		return $result;
}

public function copyFromPost()
{
		$this->identifier_block = Tools::getValue('identifier_block');
		$this->hook = Tools::getValue('hook');
		$this->is_active = Tools::getValue('is_active');	
		if (sizeof($this->fieldsValidateLang))
		{
			$languages = Language::getLanguages(false);
			foreach ($languages AS $language)
				foreach ($this->fieldsValidateLang AS $field => $validation){
					$temp = Tools::getValue($field.'_'.(int)($language['id_lang']));
					if (isset($temp))
					{
						$temp = str_replace(_PS_BASE_URL_.__PS_BASE_URI__, $this->temp_url, $temp);
						$this->{$field}[(int)($language['id_lang'])] = $temp;
					}
				}
		}
}
	
public function uniqueIndentifier_block($identifier_block, $id_htmlblock = null)
{
		$result = Db::getInstance()->getRow('
			SELECT `identifier_block`
			FROM `'._DB_PREFIX_.'tvhtmlblock` 
			WHERE `identifier_block` LIKE \''.$identifier_block.'\''.($id_htmlblock ? ' AND `id_htmlblock` != '.$id_htmlblock : ''));
		$isUnique = ($result['identifier_block']) ? false : true ;
		return $isUnique;
}

public function updateStatus($status)
{
		$id = (int)Context::getContext()->shop->id;
		$id_shop = $id ? $id: Configuration::get('PS_SHOP_DEFAULT');
		if (!isset($status))
			return false;
		if ($status == 0)
			$status = 1;
		else 
			$status = 0;
		$result = (Db::getInstance()->Execute('
			UPDATE `'._DB_PREFIX_.'tvhtmlblock_shop`
			SET `is_active`='.$status.'
			WHERE `id_shop` = '.$id_shop.' AND `id_htmlblock`='.(int)($this->id_htmlblock)));
		return $result;
}

public function validateController($htmlentities = true, $copy_post = false)
{
		$errors = array();
		$field = "identifier_block"; 
		$value = Tools::getValue($field, $this->{$field});
		if (Tools::getValue($field, $this->{$field}) == false AND (string)$value != '0')
			$errors[] = '<b>Identifier block</b> '.Tools::displayError('is required.');
		
		$field = "identifier_block";
		if ($value)
		{
			if (!Validate::isConfigName($value))
				$errors[] = '<b>Identifier block</b> '.Tools::displayError('is invalid.');
		}
		
		if ($this->identifier_block and !$this->uniqueIndentifier_block($this->identifier_block, (int)($this->id_htmlblock)))
		{
			$errors[] = '<b>Identifier </b> '.Tools::displayError('must be unique.');
		}
		
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$field = "title";

		if (!$this->{$field} OR !sizeof($this->{$field}) OR ($this->{$field}[$defaultLanguage] !== '0' AND empty($this->{$field}[$defaultLanguage])))
		{
			$errors[] = '<b>Title</b> '.Tools::displayError('is empty for default language.');
		}
	

		$validate = new Validate();
		foreach ($this->fieldsValidateLang as $fieldArray => $method)
		{
			if (!is_array($this->{$fieldArray}))
				continue ;
			foreach ($this->{$fieldArray} as $k => $value)
				if (!method_exists($validate, $method))
					die (Tools::displayError('Validation function not found.').' '.Tools::safeOutput($method));
				elseif (!empty($value) AND !call_user_func(array('Validate', $method), $value))
				{
					$errors[] = Tools::displayError('The following field is invalid according to the validate method ').'<b>'.$method.'</b>:<br/> ('.self::displayFieldName($fieldArray, get_class($this), $htmlentities).' = '.$value.' '.Tools::displayError('for language').' '.$k;
				}
		}
		return $errors;
}
}

?>
