<?php
/**
* 2007-2017 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    Cedric Fontaine <contact@prestashop.com>
*  @copyright 2007-2017 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

/**
 * Class bluesnapvalidationModuleFrontController
 *
 * after placing order at BlueSnap payment gateway uses redirect to this controller
 */
class BluesnapValidationModuleFrontController extends ModuleFrontController
{
    /**
     * flag allow use ssl for this controller
     *
     * @var bool
     */
    public $ssl = true;

    /**
     * redirect to order-confirmation (success) page
     */
    public function initContent()
    {
        parent::initContent();

        //Check Cart and Customer
        $customer = new Customer($this->context->cart->id_customer);
        if (!Validate::isLoadedObject($customer)) {
            Tools::redirectLink(__PS_BASE_URI__.'order.php?step=1');
        }

        if (!Validate::isLoadedObject($this->context->cart)) {
            Tools::redirectLink(__PS_BASE_URI__.'order.php?step=1');
        }

        $total = $this->context->cart->getOrderTotal(true, Cart::BOTH);

        $invoice_address = new Address($this->context->cart->id_address_invoice);
        $delivery_address = new Address($this->context->cart->id_address_delivery);
        $country = new Country($delivery_address->id_country);

        // API Call
        // http://developers.bluesnap.com/v2.0/docs/auth-capture
        $userpass =  ($this->module->getUserConfig('user').':'.$this->module->getUserConfig('pswd'));

        $vaulted = array();
        $lastfour = "";
        $cardtype = "";

        // Remove cookie token here
        $bscookie = new Cookie('Bluesnap');
        $bscookie->__unset('token');
        $bscookie->write();

        // Update Token
        /* Save the Customer ID in PrestaShop to re-use it later */
        if (Tools::getValue('bluesnap_token')) {
            $data = array("paymentSources"=>array("creditCardInfo"=>array(array("pfToken"=>Tools::getValue('bluesnap_token'),"billingContactInfo"=>array("firstName"=>$invoice_address->firstname,"lastName"=>$invoice_address->lastname,'zip'=>$invoice_address->postcode)))),"firstName"=>$invoice_address->firstname,"lastName"=>$invoice_address->lastname,'zip'=>$invoice_address->postcode,"email"=>$customer->email);

            // Existing ?
            if ($row = Db::getInstance()->getRow(
                'SELECT *
				FROM `'._DB_PREFIX_.'bluesnap_customer`
				WHERE `id_customer` = '.$this->module->bluesnap_prefix.$this->context->cart->id_customer
            )) {
                $url = $this->module->bluesnap_url.'2/vaulted-shoppers/'.$row['id_bluesnap_customer'];
                $curl = curl_init();
                curl_setopt($curl, CURLOPT_URL, $url);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
                curl_setopt($curl, CURLOPT_USERPWD, $userpass);
                curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 30);
                curl_setopt($curl, CURLOPT_TIMEOUT, 30);
                curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'PUT');
                curl_setopt($curl, CURLOPT_POSTFIELDS, Tools::jsonEncode($data));
                $curl_response = curl_exec($curl); // Execute REST Request
                $this->module->log("PUT : ".$url."\n".Tools::jsonEncode($data)."\nRESPONSE:\n".print_r($curl_response, true));
            } else {
                $url = $this->module->bluesnap_url.'2/vaulted-shoppers';
                $curl = curl_init();
                curl_setopt($curl, CURLOPT_URL, $url);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
                curl_setopt($curl, CURLOPT_USERPWD, $userpass);
                curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 30);
                curl_setopt($curl, CURLOPT_TIMEOUT, 30);
                curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, Tools::jsonEncode($data));
                $curl_response = curl_exec($curl); // Execute REST Request
                $this->module->log("POST : ".$url."\n".Tools::jsonEncode($data)."\nRESPONSE:\n".print_r($curl_response, true));
            }
            

            if (!curl_errno($curl) && curl_getinfo($curl, CURLINFO_HTTP_CODE)=='200') {
                $response = Tools::jsonDecode($curl_response);
                $vaultedShopperId = $response->vaultedShopperId;
                if (isset($vaultedShopperId) && $vaultedShopperId!='') {
                    Db::getInstance()->Execute('
						INSERT IGNORE INTO '._DB_PREFIX_.'bluesnap_customer (id_bluesnap_customer, id_customer)
						VALUES (\''.pSQL($vaultedShopperId).'\', '.$this->module->bluesnap_prefix.(int)$this->context->cookie->id_customer.');');
                }
                $vaulted = array('vaulted-shopper-id'=>$vaultedShopperId);
                $lastfour = Tools::getValue('bluesnap_card-last-four-digits');
                $cardtype = Tools::getValue('bluesnap_card-type');
            } else {
                $response = Tools::jsonDecode($curl_response);
                $this->module->log('No vaulted shopper : '.curl_errno($curl)." ".curl_getinfo($curl, CURLINFO_HTTP_CODE)." ".print_r($curl_response, true));
                $bscookie->error = 1;
                foreach ($response->message as $messages) {
                    $message = $messages->errorName." ".$messages->description;

                    if (strpos(Tools::strtolower($message), "not currently supported for this transaction")!==false) {
                        $bscookie->error = 3;
                        $bscookie->write();
                    }
                }
                $this->module->log('No vaulted shopper : '.$message);

                $bscookie->write();
                Tools::redirectLink(__PS_BASE_URI__.'order.php?step=3');
            }
        } elseif (Tools::getValue('bluesnap_vaulted')) {
            if ($row = Db::getInstance()->getRow(
                'SELECT *
				FROM `'._DB_PREFIX_.'bluesnap_customer`
				WHERE `id_customer` = '.$this->module->bluesnap_prefix.$this->context->cart->id_customer
            )) {
                $ccdata = explode("#", Tools::getValue('bluesnap_vaulted'));
                $lastfour = $ccdata[0];
                $cardtype = $ccdata[1];
                $data = array("paymentSources"=>array("creditCardInfo"=>array(array("creditCard"=>array("cardLastFourDigits"=>$lastfour,"cardType"=>$cardtype),"billingContactInfo"=>array("firstName"=>$invoice_address->firstname,"lastName"=>$invoice_address->lastname,'zip'=>$invoice_address->postcode)))),"firstName"=>$invoice_address->firstname,"lastName"=>$invoice_address->lastname,'zip'=>$invoice_address->postcode,"email"=>$customer->email);
                $url = $this->module->bluesnap_url.'2/vaulted-shoppers/'.$row['id_bluesnap_customer'];
                $curl = curl_init();
                curl_setopt($curl, CURLOPT_URL, $url);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
                curl_setopt($curl, CURLOPT_USERPWD, $userpass);
                curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 30);
                curl_setopt($curl, CURLOPT_TIMEOUT, 30);
                curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'PUT');
                curl_setopt($curl, CURLOPT_POSTFIELDS, Tools::jsonEncode($data));
                $curl_response = curl_exec($curl); // Execute REST Request
                $this->module->log("PUT : ".$url."\n".Tools::jsonEncode($data)."\nRESPONSE:\n".print_r($curl_response, true));

                $vaulted = array('vaulted-shopper-id'=>$row['id_bluesnap_customer']);
            }
        } else {
            $bscookie->error = 1;
            $bscookie->write();
            Tools::redirectLink(__PS_BASE_URI__.'order.php?step=3');
        }

        $cookie = new Cookie('psAdmin', '', (int)Configuration::get('PS_COOKIE_LIFETIME_BO'));
        $isLoggedAdmin = isset($cookie->id_employee) && isset($cookie->passwd) && Employee::checkPassword($cookie->id_employee, $cookie->passwd);

        if ($isLoggedAdmin) {
            $ip = '10.0.0.1';
            $bluesnap_uuid = md5(_COOKIE_KEY_.$cookie->id_employee);
        } else {
            $ip = Tools::getRemoteAddr();
            $bluesnap_uuid = md5(_COOKIE_KEY_.$this->context->cart->id_guest);
        }

        $url = $this->module->bluesnap_url.'2/transactions';
        $data = array();
        $data = array('amount'=>$total,'recurringTransaction'=>'ECOMMERCE','merchantTransactionId'=>(int)$this->context->cart->id,'softDescriptor'=>$this->module->getUserConfig('softdescriptor'),'currency'=>$this->context->currency->iso_code,'cardTransactionType'=>'AUTH_CAPTURE');
        $shippingcontactinfo = array('lastName'=>$delivery_address->lastname,'firstName'=>$delivery_address->firstname,'country'=>$country->iso_code,'city'=>$delivery_address->city,'address1'=>$delivery_address->address1,'address2'=>$delivery_address->address2,'zip'=>$delivery_address->postcode);
        $data['transactionFraudInfo']=array('fraudSessionId'=>$bluesnap_uuid,'shopperIpAddress'=>$ip,'company'=>$delivery_address->company, 'shippingContactInfo'=>$shippingcontactinfo);
        $data['vaultedShopperId'] = $vaulted['vaulted-shopper-id'];
        $data['creditCard'] = array('cardLastFourDigits'=>$lastfour,'cardType'=>$cardtype);
        //$data['pfToken'] = Tools::getValue('bluesnap_token');

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($curl, CURLOPT_USERPWD, $userpass);
        curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 30);
        curl_setopt($curl, CURLOPT_TIMEOUT, 30);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, Tools::jsonEncode($data));
        $curl_response = curl_exec($curl); // Execute REST Request
        $this->module->log("POST : ".$url."\n".Tools::jsonEncode($data)."\nRESPONSE:\n".print_r($curl_response, true));
        
        if (!curl_errno($curl) && curl_getinfo($curl, CURLINFO_HTTP_CODE)=='200') {
            $response = Tools::jsonDecode($curl_response);

            Db::getInstance()->Execute('
				INSERT IGNORE INTO '._DB_PREFIX_.'bluesnap_order (id_cart, bluesnap_reference)
				VALUES ('.(int)$this->context->cart->id.', \''.pSQL($response->transactionId).'\');');

            $message = 'transactionId: '.$response->transactionId.'
				Status: '.$response->processingInfo->processingStatus.'
				ReturnMessage: '.$response->processingInfo->processingStatus.'
				CVC: '.$response->processingInfo->cvvResponseCode.'
				Final amount charged: '.$response->amount.'
				Card: '.$response->creditCard->cardSubType.' '.$response->creditCard->cardType.' '.$response->creditCard->cardLastFourDigits;

            if ($response->processingInfo && $response->processingInfo->processingStatus == 'success') {
                $this->module->validateOrder((int)$this->context->cart->id, Configuration::get('PS_OS_PAYMENT'), $response->amount, $this->module->displayName, $message, array(), null, false, $this->context->customer->secure_key);
            } else {
                $this->module->validateOrder((int)$this->context->cart->id, Configuration::get('PS_OS_ERROR'), $response->amount, $this->module->displayName, $message, array(), null, false, $this->context->customer->secure_key);
            }

            $url = 'index.php?controller=order-confirmation&';
            Tools::redirect($url.'id_module='.(int)$this->module->id.'&id_cart='.(int)$this->context->cart->id.'&key='.$this->context->secure_key);
            exit;
        } else {
            $response = Tools::jsonDecode($curl_response);
            $message = "";
            foreach ($response->message as $messages) {
                $message = $messages->errorName." ".$messages->description;
                $errorcode = $messages->code;
                if ($errorcode == 10000 || $errorcode == 14002 || $errorcode == 14002 || strpos(Tools::strtolower($message), "expiration date")!==false) {
                    $bscookie->error = 1;
                    $bscookie->write();
                    $this->module->log('Order not validated : '.curl_errno($curl)." ".curl_getinfo($curl, CURLINFO_HTTP_CODE)." ".print_r($curl_response, true));
                    $this->module->log('Order not validated : '.$message);
                    Tools::redirectLink(__PS_BASE_URI__.'order.php?step=3');
                } elseif ($errorcode == 14016) {
                    $bscookie->error = 2;
                    $bscookie->write();
                    $this->module->log('Order not validated : '.curl_errno($curl)." ".curl_getinfo($curl, CURLINFO_HTTP_CODE)." ".print_r($curl_response, true));
                    $this->module->log('Order not validated : '.$message);
                    Tools::redirectLink(__PS_BASE_URI__.'order.php?step=3');
                } elseif (strpos(Tools::strtolower($message), "not currently supported for this transaction")!==false) {
                    $bscookie->error = 3;
                    $bscookie->write();
                    $this->module->log('Order not validated : '.curl_errno($curl)." ".curl_getinfo($curl, CURLINFO_HTTP_CODE)." ".print_r($curl_response, true));
                    $this->module->log('Order not validated : '.$message);
                    Tools::redirectLink(__PS_BASE_URI__.'order.php?step=3');
                }
            }
            $this->module->validateOrder((int)$this->context->cart->id, Configuration::get('PS_OS_ERROR'), $response->amount, $this->module->displayName, $message, array(), null, false, $this->context->customer->secure_key);
            $url = 'index.php?controller=order-confirmation&';
            Tools::redirect($url.'id_module='.(int)$this->module->id.'&id_cart='.(int)$this->context->cart->id.'&key='.$this->context->secure_key);
        }
    }
}
