<?php
/**
 * Install File
 * Does the stuff for the specific extensions
 *
 * @package         Advanced Module Manager
 * @version         4.4.7
 *
 * @author          Peter van Westen <peter@nonumber.nl>
 * @link            http://www.nonumber.nl
 * @copyright       Copyright © 2012 NoNumber All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

function install(&$states, &$ext)
{
	$name = 'Advanced Module Manager';
	$alias = 'advancedmodules';
	$ext = $name . ' (admin component & system plugin)';

	// COMPONENT
	$states[] = installExtension($states, $alias, $name, 'component', array('link' => '', 'admin_menu_link' => ''));

	// SYSTEM PLUGIN
	$states[] = installExtension($states, $alias, 'System - ' . $name, 'plugin', array('folder' => 'system'));
}

// Stuff to do after installation / update
function afterInstall(&$db)
{
	// hide admin menu
	$query = $db->getQuery(true);
	$query->delete('#__menu')
		->where($db->quoteName('path').' = '.$db->quote('advancedmodules'))
		->where($db->quoteName('type').' = '.$db->quote('component'))
		->where($db->quoteName('client_id').' = 1');
	$db->setQuery($query);
	$db->execute();

	// main table
	$query = "CREATE TABLE IF NOT EXISTS `#__advancedmodules` (
		`moduleid` INT(11) UNSIGNED NOT NULL DEFAULT '0',
		`asset_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
		`params` TEXT NOT NULL,
		PRIMARY KEY (`moduleid`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
	$db->setQuery($query);
	$db->execute();

	// add asset_id column
	$query = "SHOW COLUMNS FROM `" . $db->getPrefix() . "advancedmodules` LIKE 'asset_id'";
	$db->setQuery($query);
	$hasasset = $db->loadResult();
	if (!$hasasset) {
		$query = "ALTER TABLE `#__advancedmodules` ADD `asset_id` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER `moduleid`";
		$db->setQuery($query);
		$db->execute();
	}

	// convert old J1.5 params syntax to new
	$query = $db->getQuery(true);
	$query->select('a.moduleid,a. params')
		->from('#__advancedmodules as a')
		->where('a.params REGEXP ' . $db->quote('^[^\{]'));
	$db->setQuery($query);
	$rows = $db->loadObjectList();
	foreach ($rows as $row) {
		if (empty($row->params)) {
			continue;
		}
		$row->params = str_replace('assignto_secscats', 'assignto_cats', $row->params);
		$row->params = str_replace('flexicontent', 'fc', $row->params);

		$params = JRegistryFormat::getInstance('INI')->stringToObject($row->params);
		foreach ($params as $key => $val) {
			if (is_string($val) && !(strpos($val, '|') === false)) {
				$params->{$key} = explode('|', $val);
			}
		}
		if (isset($params->assignto_cats_selection) && !empty($params->assignto_cats_selection)) {
			foreach ($params->assignto_cats_selection as $key => $val) {
				if (!(strpos($val, ':') === false)) {
					$params->assignto_cats_selection[$key] = substr($val, strpos($val, ':') + 1);
				}
			}
		}
		if (isset($params->tooltip) && !empty($params->tooltip)) {
			$query = $db->getQuery(true);
			$query->update('#__modules as m')
				->set('m.note = ' . $db->quote($params->tooltip))
				->where('m.id = ' . (int) $row->moduleid);
			$db->setQuery($query);
			$db->execute();
			unset($params->tooltip);
		}
		$query = $db->getQuery(true);
		$query->update('#__advancedmodules as a')
			->set('a.params = ' . $db->quote(json_encode($params)))
			->where('a.moduleid = ' . (int) $row->moduleid);
		$db->setQuery($query);
		$db->execute();
	}

	// remove initial menu assignment settings
	$query = $db->getQuery(true);
	$query->update('#__advancedmodules as a')
		->set('a.params = ' . $db->quote(''))
		->where('a.params = ' . $db->quote('{"assignto_menuitems":0,"assignto_menuitems_selection":[]}'));
	$db->setQuery($query);
	$db->execute();

	// concatenates the sef and non-sef url fields
	$query = $db->getQuery(true);
	$query->update('#__advancedmodules as a')
		->set(
			'a.params = replace( replace( replace( replace( `params`,'
				. $db->quote('"assignto_urls_selection_sef"') . ',' . $db->quote('"assignto_urls_selection"') . '),'
				. $db->quote('"assignto_urls_selection":"","assignto_browsers"') . ',' . $db->quote('"assignto_browsers"') . '),'
				. $db->quote('","show_url_field":"0","assignto_urls_selection":"') . ',' . $db->quote('\n') . '),'
				. $db->quote('","show_url_field":"1","assignto_urls_selection":"') . ',' . $db->quote('\n') . ')'
		)
		->where('a.params LIKE ' . $db->quote('%"assignto_urls_selection_sef"%'));
	$db->setQuery($query);
	$db->execute();

	// add url_regex value to filled in url fields
	$query = $db->getQuery(true);
	$query->update('#__advancedmodules as a')
		->set(
			'a.params = replace( replace( replace( replace( `params`,'
				. $db->quote('"assignto_os"') . ',' . $db->quote('"assignto_urls_regex":"1","assignto_os"') . '),'
				. $db->quote('"","assignto_urls_regex":"1"') . ',' . $db->quote('""') . '),'
				. $db->quote('"assignto_urls_regex":"0","assignto_urls_regex":"1"') . ',' . $db->quote('"assignto_urls_regex":"0"') . '),'
				. $db->quote('"assignto_urls_regex":"1","assignto_urls_regex":"1"') . ',' . $db->quote('"assignto_urls_regex":"1"') . ')'
		)
		->where('a.params LIKE ' . $db->quote('%"assignto_urls":"1"%'))
		->where('a.params NOT LIKE ' . $db->quote('%"assignto_urls_regex"%'));
	$db->setQuery($query);
	$db->execute();
}
