<?php

/**

 *  2016 ModuleFactory.co

 *

 *  @author    ModuleFactory.co <info@modulefactory.co>

 *  @copyright 2016 ModuleFactory.co

 *  @license   ModuleFactory.co Commercial License

 */



class FsAdConversionModel extends ObjectModel

{

    /** @var integer fsadconversion id*/

    public $id;



    /** @var integer fsadconversion id shop*/

    public $id_shop;



    /** @var string fsadconversion hook */

    public $type;



    /** @var string fsadconversion conversion_id*/

    public $conversion_id;



    /** @var string fsadconversion conversion_label*/

    public $conversion_label;



    /** @var string fsadconversion price_calculation*/

    public $price_calculation;



    /** @var boolean fsadconversion dpa enabled */

    public $dpa = false;



    /** @var boolean fsadconversion statuts */

    public $active = true;



    /** @var string fsadconversion creation date */

    public $date_add;



    /** @var string fsadconversion last modification date */

    public $date_upd;



    /**

     * @see ObjectModel::$definition

     */

    public static $definition = array(

        'table' => 'fsadconversion',

        'primary' => 'id_fsadconversion',

        'multilang' => false,

        'fields' => array(

            'id_shop' =>           array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),

            'type' =>

                array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true),

            'conversion_id' =>

                array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true),

            'conversion_label' =>  array('type' => self::TYPE_STRING, 'validate' => 'isGenericName'),

            'price_calculation' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),

            'dpa' =>               array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),

            'active' =>            array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),

            'date_add' =>          array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat'),

            'date_upd' =>          array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat'),

        )

    );



    public function copyFromPost()

    {

        foreach (self::$definition['fields'] as $key => $properties) {

            if (!isset($properties['lang'])) {

                if ($key != 'date_add' && $key != 'date_upd') {

                    $this->{$key} = Tools::getValue($key);

                }

            }

        }

    }



    public static function getListContent($filter)

    {

        $id_shop = (int)Context::getContext()->shop->id;



        $where = ' WHERE `id_shop` = \''.pSQL($id_shop).'\'';

        if (isset($filter['id_fsadconversion']) && $filter['id_fsadconversion'] != '') {

            $where .= ' AND `id_fsadconversion` = \''.pSQL($filter['id_fsadconversion']).'\'';

        }



        if (isset($filter['conversion_id']) && $filter['conversion_id'] != '') {

            $where .= ' AND `conversion_id` LIKE \'%'.pSQL($filter['conversion_id']).'%\'';

        }



        if (isset($filter['type']) && $filter['type'] != '') {

            $where .= ' AND `type` = \''.pSQL($filter['type']).'\'';

        }



        if (isset($filter['active']) && $filter['active'] != '') {

            $where .= ' AND `active` = \''.pSQL($filter['active']).'\'';

        }



        return Db::getInstance()->executeS(

            'SELECT * FROM `'._DB_PREFIX_.'fsadconversion`'.$where.' ORDER BY `type` ASC LIMIT '.

            (($filter['page'] - 1) * $filter['limit']).', '.$filter['limit']

        );

    }



    public static function getAllActive()

    {

        $id_shop = (int)Context::getContext()->shop->id;

        $where = ' WHERE `id_shop` = \''.pSQL($id_shop).'\'';

        $where .= ' AND `active` = \'1\'';



        return Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.'fsadconversion`'.$where);

    }

}

