<?php

class Tools extends ToolsCore

{

	/**

	 * Set cookie currency from POST or default currency

	 *

	 * Overriden by Business Tech to allow setting from $_GET as well

	 * for our Google Merchant Center module

	 *

	 * @return Currency object

	 */

	public static function setCurrency()

	{

		global $cookie;

		

		// ### MOD BY BUSINESS TECH ###

		if (isset($_GET['gmc_currency']) && is_numeric($_GET['gmc_currency']))

		{

			$currency = Currency::getCurrencyInstance((int)$_GET['gmc_currency']);

			if ($currency->id && !$currency->deleted && $currency->active)

			{

				$cookie->id_currency = (int)$currency->id;

				return $currency;

			}

		}

		// ### END MOD BY BUSINESS TECH ###



		if (self::isSubmit('SubmitCurrency'))

			if (isset($_POST['id_currency']) && is_numeric($_POST['id_currency']))

			{

				$currency = Currency::getCurrencyInstance((int)$_POST['id_currency']);

				if (is_object($currency) AND $currency->id AND !$currency->deleted)

				{

					$cookie->id_currency = (int)$currency->id;



				}

			}



		if ((int)$cookie->id_currency)

		{

			$currency = Currency::getCurrencyInstance((int)$cookie->id_currency);

			if ((int)$currency->id && !$currency->deleted && $currency->active)

				return $currency;

		}

		$currency = Currency::getCurrencyInstance((int)_PS_CURRENCY_DEFAULT_);

		if ($currency->id)

			$cookie->id_currency = (int)$currency->id;

		return $currency;

	}

}