<?php
/**
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer tohttp://www.prestashop.com for more information.
 * We offer the best and most useful modules PrestaShop and modifications for your online store.
 *
 * @category  PrestaShop Module
 * @author    knowband.com <support@knowband.com>
 * @copyright 2015 Knowband
 * @license   see file: LICENSE.txt
 *
 * Description
 *
 * Admin can change text color,translations,font style
 */

class OneClickCheckout extends Module
{

    public function __construct()
    {
        $this->name = 'oneclickcheckout';
        $this->tab = 'front_office_features';
        $this->version = '1.0.0';
        $this->author = 'Knowband';
        $this->need_instance = 0;
        $this->module_key = '3f96ad8299076c1faae227334cec4ab5';
        //$this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('One Click Checkout');
        $this->description = $this->l('This is the module for facilitate user to purchase particular product.');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');

        if (!Configuration::get('oneclickcheckout')) {
            $this->warning = $this->l('No name provided');
        }
    }

    public function install()
    {
        if (Shop::isFeatureActive()) {

            Shop::setContext(Shop::CONTEXT_ALL);
        }

        if (!parent::install() ||
                !$this->registerHook('displayProductButtons') ||
                !$this->registerHook('displayOrderConfirmation') ||
                !$this->registerHook('actionDispatcher')
        ) {

            return false;
        }
        $defaultsettings = $this->getDefaultSettings();
        $defaultsettings = serialize($defaultsettings);
        Configuration::updateValue('oneclickcheckout', $defaultsettings);
        //return parent::install() && $this->registerHook('hookoneclickcheckout');
        return true;
    }

    public function uninstall()
    {
        if (!parent::uninstall() ||
                !$this->unregisterHook('displayProductButtons') ||
                !$this->unregisterHook('displayOrderConfirmation') ||
                !$this->unregisterHook('actionDispatcher')
        ) {

            return false;
        }

        return true;
    }

    public function getContent()
    {

        $output = null;

        if (Tools::isSubmit('oneclickcheckout')) {
            $formvalue = Tools::getValue('oneclickcheckout');
            $content = serialize($formvalue);
            Configuration::updateValue('oneclickcheckout', $content);
            $output .= $this->displayConfirmation($this->l('Configuration has been saved successfully.'));
        }
        return $output . $this->displayForm();
    }

    private function defaultTitles($tag)
    {
        $titles = array($this->l('Share this product with your friends'),
        );

        return $titles[$tag];
    }

    private function getDefaultSettings()
    {
        $settings = array(
            'enable' => 0,
            'title_1_style' => array(
                'bold' => 0,
                'italic' => 0,
                'color' => '#000000'
            )
        );
        foreach (Language::getLanguages(true) as $lang) {
            $settings['title_1'][$lang['id_lang']]['text'] = $this->defaultTitles('title_1');
        }
        return $settings;
    }

    public function displayForm()
    {
        if (version_compare(_PS_VERSION_, '1.6.0.1', '<')) {
            $enable_button_type = 'radio';
        } else {
            $enable_button_type = 'switch';
        }
        $default_lang = (int) Configuration::get('PS_LANG_DEFAULT');
        $fields_form = array();
        $fields_form[0]['form'] = array(
            'legend' => array(
                'title' => $this->l('General Settings'),
            ),
            'input' => array(
                array(
                    'type' => $enable_button_type,
                    'label' => $this->l('Enable/Disable'),
                    'name' => 'oneclickcheckout[choose]',
                    'class' => 't',
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Enabled')
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('Disabled')
                        )
                    ),
                ),
                array(
                    'label' => $this->l('Background Color'),
                    'type' => 'color',
                    'class' => 'general_tab',
                    'name' => 'oneclickcheckout[background]',
                    'hint' => $this->l('Choose the background color for the display button.')
                ),
                array(
                    'label' => $this->l('Text Color'),
                    'type' => 'color',
                    'class' => 'general_tab',
                    'name' => 'oneclickcheckout[text]',
                    'hint' => $this->l('Choose the text color for the display button.')
                ),
                array(
                    'label' => $this->l('Border Color'),
                    'type' => 'color',
                    'class' => 'general_tab',
                    'name' => 'oneclickcheckout[border]',
                    'hint' => $this->l('Choose the border color for the display button.')
                ),
            ),
            'submit' => array(
                'title' => $this->l('Submit'),
                'class' => 'button'
            ),
        );

        $helper = new HelperForm();

        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $form_data = Tools::getValue('oneclickcheckout'); //Array from submit form
        $helper->default_form_language = $default_lang;
        $helper->allow_employee_form_lang = $default_lang;
        $helper->title = $this->displayName;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = true;
        $helper->submit_action = 'submit' . $this->name;
        $helper->toolbar_btn = array(
            'save' =>
            array(
                'desc' => $this->l('Save'),
                'href' => AdminController::$currentIndex . '&configure=' . $this->name . '&save' . $this->name .
                '&token=' . Tools::getAdminTokenLite('AdminModules'),
            ),
            'back' => array(
                'href' => AdminController::$currentIndex . '&token=' . Tools::getAdminTokenLite('AdminModules'),
                'desc' => $this->l('Back to list'),
            )
        );
        $config = Configuration::get('oneclickcheckout');
        $this->oneclickcheckout_settings = Tools::unSerialize($config);
        if (!empty($this->oneclickcheckout_settings)) {
            if (isset($this->oneclickcheckout_settings['choose'])) {
                $reg_data = $this->oneclickcheckout_settings;
            } else {
                $reg_data = array(
                    'choose' => '',
                    'background' => '#70a4ff',
                    'text' => '#ffffff',
                    'border' => '#602f00'
                );
            }
        } else {
            $reg_data = null;
        }
        $helper->fields_value['oneclickcheckout[choose]'] = isset($form_data['choose'])
                ? $form_data['choose'] :Tools::htmlentitiesDecodeUTF8($reg_data['choose']);
        $helper->fields_value['oneclickcheckout[background]'] = isset($form_data['background'])
                ? $form_data['background'] : Tools::htmlentitiesDecodeUTF8($reg_data['background']);
        $helper->fields_value['oneclickcheckout[text]'] = isset($form_data['text'])
                ? $form_data['text'] : Tools::htmlentitiesDecodeUTF8($reg_data['text']);
        $helper->fields_value['oneclickcheckout[border]'] = isset($form_data['border'])
                ? $form_data['border'] : Tools::htmlentitiesDecodeUTF8($reg_data['border']);
        return $helper->generateForm($fields_form);
    }

    public function hookDisplayProductButtons($params)
    {
        //d(Configuration::get('PS_CATALOG_MODE'));
        //d($this->context->smarty->tpl_vars);
        $yes='yes';
        if ((Configuration::get('PS_CATALOG_MODE')) == '1') {
            $this->smarty->assign(array(
                'catalog_mode' => $yes
            ));
        }
        if (version_compare(_PS_VERSION_, '1.6.0.1', '<')) {
            $this->smarty->assign(array(
                'reduce_height' => $yes
            ));
        }
        if ((empty($this->context->smarty->tpl_vars['hide_left_column']->value))) {
            $this->smarty->assign(array(
                'left_coulmn_set' => $yes
            ));
        }
        if ((empty($this->context->smarty->tpl_vars['hide_right_column']->value))) {
            $this->smarty->assign(array(
                'right_coulmn_set' => $yes
            ));
        }
        $config = Configuration::get('oneclickcheckout');
        $this->oneclickcheckout_settings = Tools::unSerialize($config);
        $settings = $this->oneclickcheckout_settings;
        $link = $this->context->link->getModuleLink('oneclickcheckout', 'oneclickcheckout');
        $link_oreder = 'index.php?controller=order&' . (isset($this->id_product) ? 'ipa=' . $this->id_product : '');
        if (isset($settings['choose']) && $settings['choose'] == 1) {
            $this->smarty->assign(array(
                'background' => $settings['background'],
                'text' => $settings['text'],
                'border' => $settings['border'],
                'link' => $link,
                'link_order' => $link_oreder,
            ));
            return $this->display(__FILE__, 'views/templates/hook/show_button.tpl');
        }
    }

    public function hookDisplayOrderConfirmation($params)
    {

        $new_cart_id = $params['objOrder']->id_cart;
        $this->context->cart = new Cart($new_cart_id);
        $cart_products = $this->context->cart->getProducts();
        $id_product = $cart_products[0]['id_product'];
        $id_product_attribute = $cart_products[0]['id_product_attribute'];
        $quantity = $cart_products[0]['quantity'];

        if ((Context::getContext()->cookie->old_cart_id) != null) {
            $id_cart = Context::getContext()->cookie->old_cart_id;
            $this->context->cart = new Cart($id_cart);
            $new_cart_products = $this->context->cart->getProducts('', $id_product);
            if ($new_cart_products[0]['quantity'] == $quantity) {
                $this->context->cart->deleteProduct($id_product, $id_product_attribute, null);
            } else {
                $new_quantity = $new_cart_products[0]['quantity'] - $quantity;
                $this->context->cart->deleteProduct($id_product, $id_product_attribute, null);
                $this->context->cart->updateQty($new_quantity, $id_product, $id_product_attribute);
            }
            $this->context->cart->save();
            $this->context->cookie->id_cart = (int) $this->context->cart->id;
            $this->context->cookie->write();
            $this->context->cart->autosetProductAddress();
            $this->context->cookie->__unset('old_cart_id');
            $this->context->cookie->__unset('on_order_page_set');
        }
    }

    public function notconfirmorder()
    {

        if ((Context::getContext()->cookie->old_cart_id) != null) {
            $id_cart = Context::getContext()->cookie->old_cart_id;
            $this->context->cart = new Cart($id_cart);
            $this->context->cart->save();
            $this->context->cookie->id_cart = (int) $this->context->cart->id;
            $this->context->cookie->write();
            $this->context->cart->autosetProductAddress();
            if ($this->context->cookie->on_order_page_set == 'NO') {
                $this->context->cookie->__unset('old_cart_id');
                $this->context->cookie->__unset('on_order_page_set');
            }
        }
    }

    public function hookActionDispatcher($params)
    {
        if (isset($this->context->cookie->old_cart_id)) {
            $heystack = $params['controller_class'];
            $a = "ModuleFrontController";
            $b = "OrderConfirmationController";
            $c = "OrderController";
            $d = "AuthController";
            $e = "CartController";
            if (!(($params['controller_class'] == "OrderController")||
                    ($params['controller_class'] == "AuthController")||
                    ($params['controller_class'] == "CartController")||
                    ($params['controller_class'] == "ModuleFrontController")||
                    ($params['controller_class'] == "OrderConfirmationController")||
                    (strpos($heystack, $a)) || (strpos($heystack, $b))||
                    (strpos($heystack, $c)) || (strpos($heystack, $d))||
                    (strpos($heystack, $e)))) {
                $this->context->cookie->on_order_page_set = 'NO';
                $this->notconfirmorder();
            }
        }
    }
}
