<?php
/**
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2014 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

/**
 * @since   1.5.0
 * @version 1.3 (2012-03-14)
 */

if (!defined('_PS_VERSION_'))
	exit;

include_once(_PS_MODULE_DIR_.'tvmenuicon/tvmenuiconclass.php');

class tvmenuicon extends Module
{
	private $_html = '';

	public function __construct()
	{
		$this->name = 'tvmenuicon';
		$this->tab = 'others';
		$this->version = '1.0';
		$this->author = 'Themesvip';
		$this->need_instance = 0;
		$this->secure_key = Tools::encrypt($this->name);
		$this->module_key = '4ddaa2f6c66dba43730094b1749fabba';
		$this->bootstrap = true;

		parent::__construct();

		$this->displayName = $this->l('TV Menu Icon');
		$this->description = $this->l('Add menu icon on site');
		$this->confirmUninstall = $this->l('Are you sure that you want to delete your Menu Icon?');
		$this->ps_versions_compliancy = array('min' => '1.6.0.4', 'max' => _PS_VERSION_);
	}

	/**
	 * @see Module::install()
	 */
	public function install()
	{
		/* Adds Module */
		if (parent::install() &&
			$this->registerHook('displayHeader') &&
			$this->registerHook('tvmenuicon') &&
			$this->registerHook('actionShopDataDuplication')
		)
		{
			/* Creates tables */
			$res = $this->createTables();

			/* Adds samples */
			if ($res)
				$this->installSamples();

			// Disable on mobiles and tablets
			$this->disableDevice(Context::DEVICE_MOBILE);

			return (bool)$res;
		}

		return false;
	}

	/**
	 * Adds samples
	 */
	private function installSamples()
	{
		$languages = Language::getLanguages(false);
		$title_1 = 'Smartphone'; $icon_1 = 'icon_1_1.png';
		$title_2 = 'Laptop'; $icon_2 = 'icon_1_2.png';
		$title_3 = 'Computers'; $icon_3 = 'icon_1_3.png';
		$title_4 = 'Games'; $icon_4 = 'icon_1_4.png';
		$title_5 = 'Camera'; $icon_5 = 'icon_1_5.png';
		$title_6 = 'Musics'; $icon_6 = 'icon_1_6.png';
		$title_7 = 'Beauty'; $icon_7 = 'icon_1_7.png';
		$title_8 = 'Clothings'; $icon_8 = 'icon_1_8.png';
		$title_9 = 'Health'; $icon_9 = 'icon_1_9.png';
		$title_10 = 'Shoes'; $icon_10 = 'icon_1_10.png';
		$title_11 = 'Tool kits'; $icon_11 = 'icon_1_11.png';
		$title_12 = 'Jewelry'; $icon_12 = 'icon_1_12.png';
		$title_13 = 'Baby'; $icon_13 = 'icon_1_13.png';
		$title_14 = 'Toys'; $icon_14 = 'icon_1_14.png';
		
		for ($i = 1; $i <= 14; ++$i)
		{
			$menu = new TVMenuiconClass();
			$menu->position = $i;
			$menu->active = 1;
			if($i==1)
			$menu->color = '#ff8a00'; 
			if($i==2)
			$menu->color = '#bf0497'; 
			if($i==3)
			$menu->color = '#d9532d'; 
			if($i==4)
			$menu->color = '#d9532d'; 
			if($i==5)
			$menu->color = '#9f005d'; 
			if($i==6)
			$menu->color = '#cc6e00'; 
			if($i==7)
			$menu->color = '#669500'; 
			if($i==8)
			$menu->color = '#0f63a3'; 
			if($i==9)
			$menu->color = '#1e6e04';
			if($i==10)
			$menu->color = '#d9532d';
			if($i==11)
			$menu->color = '#ce00a2';
			if($i==12)
			$menu->color = '#cc6e00';
			if($i==13)
			$menu->color = '#811dba';
			if($i==14)
			$menu->color = '#ff8a00'; 
			
			foreach ($languages as $language)
			{
			    if($i==1)
				{
					$menu->title[$language['id_lang']] = $title_1;
					$menu->image[$language['id_lang']] = $icon_1;
					
				}
				if($i==2)
				{
					$menu->title[$language['id_lang']] = $title_2;
					$menu->image[$language['id_lang']] = $icon_2;
				}
				if($i==3)
				{
					$menu->title[$language['id_lang']] = $title_3;
					$menu->image[$language['id_lang']] = $icon_3;
				}
				if($i==4)
				{
					$menu->title[$language['id_lang']] = $title_4;
					$menu->image[$language['id_lang']] = $icon_4;
				}
				if($i==5)
				{
					$menu->title[$language['id_lang']] = $title_5;
					$menu->image[$language['id_lang']] = $icon_5;
				}
				if($i==6)
				{
					$menu->title[$language['id_lang']] = $title_6;
					$menu->image[$language['id_lang']] = $icon_6;
				}
				if($i==7)
				{
					$menu->title[$language['id_lang']] = $title_7;
					$menu->image[$language['id_lang']] = $icon_7;
				}
				if($i==8)
				{
					$menu->title[$language['id_lang']] = $title_8;
					$menu->image[$language['id_lang']] = $icon_8;
				}
				if($i==9)
				{
					$menu->title[$language['id_lang']] = $title_9;
					$menu->image[$language['id_lang']] = $icon_9;
				}
				if($i==10)
				{
					$menu->title[$language['id_lang']] = $title_10;
					$menu->image[$language['id_lang']] = $icon_10;
				}
				if($i==11)
				{
					$menu->title[$language['id_lang']] = $title_11;
					$menu->image[$language['id_lang']] = $icon_11;
				}
				if($i==12)
				{
					$menu->title[$language['id_lang']] = $title_12;
					$menu->image[$language['id_lang']] = $icon_12;
				}
				if($i==13)
				{
					$menu->title[$language['id_lang']] = $title_13;
					$menu->image[$language['id_lang']] = $icon_13;
				}
				if($i==14)
				{
					$menu->title[$language['id_lang']] = $title_14;
					$menu->image[$language['id_lang']] = $icon_14;
				}
				$menu->url[$language['id_lang']] = '3-women';
			}
			$menu->add();
		}
	}

	/**
	 * @see Module::uninstall()
	 */
	public function uninstall()
	{
		/* Deletes Module */
		if (parent::uninstall())
		{
			/* Deletes tables */
			$res = $this->deleteTables();
			/* Unsets configuration */
			return (bool)$res;
		}

		return false;
	}

	/**
	 * Creates tables
	 */
	protected function createTables()
	{
		/* Menus */
		$res = (bool)Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'tvmenuicon` (
				`id_menu` int(10) unsigned NOT NULL AUTO_INCREMENT,
				`id_shop` int(10) unsigned NOT NULL,
				PRIMARY KEY (`id_menu`, `id_shop`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
		');

		/* Menus configuration */
		$res &= Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'tvmenuicon_menus` (
			  `id_menu` int(10) unsigned NOT NULL AUTO_INCREMENT,
			  `position` int(10) unsigned NOT NULL DEFAULT \'0\',
			  `active` tinyint(1) unsigned NOT NULL DEFAULT \'0\',
			  `color` varchar(255) NOT NULL,
			  PRIMARY KEY (`id_menu`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
		');

		/* Menus lang configuration */
		$res &= Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'tvmenuicon_menus_lang` (
			  `id_menu` int(10) unsigned NOT NULL,
			  `id_lang` int(10) unsigned NOT NULL,
			  `title` varchar(255) NOT NULL,
			  `url` varchar(255) NOT NULL,
			  `image` varchar(255) NOT NULL,
			  PRIMARY KEY (`id_menu`,`id_lang`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
		');

		return $res;
	}

	/**
	 * deletes tables
	 */
	protected function deleteTables()
	{
		$menus = $this->getMenus();
		foreach ($menus as $menu)
		{
			$to_del = new TVMenuiconClass($menu['id_menu']);
			$to_del->delete();
		}

		return Db::getInstance()->execute('
			DROP TABLE IF EXISTS `'._DB_PREFIX_.'tvmenuicon`, `'._DB_PREFIX_.'tvmenuicon_menus`, `'._DB_PREFIX_.'tvmenuicon_menus_lang`;
		');
	}

	public function getContent()
	{
	$this->_html = '<h2><img src="'.$this->_path.'logo.png" alt="" /> '.$this->displayName.'</h2>';
		
		$this->_html .= $this->headerHTML();
		
		/* Validate & process */
		if (Tools::isSubmit('submitMenu') || Tools::isSubmit('delete_id_menu') ||
			Tools::isSubmit('submitMenus') ||
			Tools::isSubmit('changeStatus'))
		{
			if ($this->_postValidation())
			{
				$this->_postProcess();
				$this->_html .= $this->renderList();		
			}
			else
				$this->_html .= $this->renderAddForm();

			$this->clearCache();
		}
		elseif (Tools::isSubmit('addMenu') || (Tools::isSubmit('id_menu') && $this->slideExists((int)Tools::getValue('id_menu'))))
			$this->_html .= $this->renderAddForm();
		else
		{
			$this->_html .= $this->renderList();
		}

		return $this->_html;
	}

	private function _postValidation()
	{
		$errors = array();

		/* Validation for Menus configuration */
		if (Tools::isSubmit('submitMenus'))
		{


		} /* Validation for status */
		elseif (Tools::isSubmit('changeStatus'))
		{
			if (!Validate::isInt(Tools::getValue('id_menu')))
				$errors[] = $this->l('Invalid menu');
		}
		/* Validation for Menu */
		elseif (Tools::isSubmit('submitMenu'))
		{
			/* Checks state (active) */
			if (!Validate::isInt(Tools::getValue('active_menu')) || (Tools::getValue('active_menu') != 0 && Tools::getValue('active_menu') != 1))
				$errors[] = $this->l('Invalid menu state.');
			/* Checks position */
			if (!Validate::isInt(Tools::getValue('position')) || (Tools::getValue('position') < 0))
				$errors[] = $this->l('Invalid menu position.');
				
			if (Tools::strlen(Tools::getValue('color')) > 7)
					$errors[] = $this->l('The color is too long.');	
			
			
			
				
			/* If edit : checks id_menu */
			if (Tools::isSubmit('id_menu'))
			{

				//d(var_dump(Tools::getValue('id_menu')));
				if (!Validate::isInt(Tools::getValue('id_menu')) && !$this->slideExists(Tools::getValue('id_menu')))
					$errors[] = $this->l('Invalid id_menu');
			}
			/* Checks title/url/legend/description/image */
			$languages = Language::getLanguages(false);
			foreach ($languages as $language)
			{
				if (Tools::strlen(Tools::getValue('title_'.$language['id_lang'])) > 255)
					$errors[] = $this->l('The title is too long.');
				if (Tools::strlen(Tools::getValue('url_'.$language['id_lang'])) > 255)
					$errors[] = $this->l('The URL is too long.');
				if (Tools::strlen(Tools::getValue('url_'.$language['id_lang'])) > 0 && !Validate::isUrl(Tools::getValue('url_'.$language['id_lang'])))
					$errors[] = $this->l('The URL format is not correct.');
				if (Tools::getValue('image_'.$language['id_lang']) != null && !Validate::isFileName(Tools::getValue('image_'.$language['id_lang'])))
					$errors[] = $this->l('Invalid filename.');
				if (Tools::getValue('image_old_'.$language['id_lang']) != null && !Validate::isFileName(Tools::getValue('image_old_'.$language['id_lang'])))
					$errors[] = $this->l('Invalid filename.');
			}

			/* Checks title/url/legend/description for default lang */
			$id_lang_default = (int)Configuration::get('PS_LANG_DEFAULT');
			if (Tools::strlen(Tools::getValue('title_'.$id_lang_default)) == 0)
				$errors[] = $this->l('The title is not set.');
				
			if (Tools::strlen(Tools::getValue('color')) == 0)
				$errors[] = $this->l('Please choice the color.');	

			if (Tools::strlen(Tools::getValue('url_'.$id_lang_default)) == 0)
				$errors[] = $this->l('The URL is not set.');
			if (!Tools::isSubmit('has_picture') && (!isset($_FILES['image_'.$id_lang_default]) || empty($_FILES['image_'.$id_lang_default]['tmp_name'])))
				$errors[] = $this->l('The image is not set.');
			if (Tools::getValue('image_old_'.$id_lang_default) && !Validate::isFileName(Tools::getValue('image_old_'.$id_lang_default)))
				$errors[] = $this->l('The image is not set.');
		} /* Validation for deletion */
		elseif (Tools::isSubmit('delete_id_menu') && (!Validate::isInt(Tools::getValue('delete_id_menu')) || !$this->slideExists((int)Tools::getValue('delete_id_menu'))))
			$errors[] = $this->l('Invalid id_menu');

		/* Display errors if needed */
		if (count($errors))
		{
			$this->_html .= $this->displayError(implode('<br />', $errors));

			return false;
		}

		/* Returns if validation is ok */

		return true;
	}

	private function _postProcess()
	{
		$errors = array();

		/* Processes Menus */
	  if (Tools::isSubmit('changeStatus') && Tools::isSubmit('id_menu'))
		{
			$menu = new TVMenuiconClass((int)Tools::getValue('id_menu'));
			if ($menu->active == 0)
				$menu->active = 1;
			else
				$menu->active = 0;
			$res = $menu->update();
			$this->clearCache();
			$this->_html .= ($res ? $this->displayConfirmation($this->l('Configuration updated')) : $this->displayError($this->l('The configuration could not be updated.')));
		}
		/* Processes Menu */
		elseif (Tools::isSubmit('submitMenu'))
		{
			/* Sets ID if needed */
			if (Tools::getValue('id_menu'))
			{
				$menu = new TVMenuiconClass((int)Tools::getValue('id_menu'));
				if (!Validate::isLoadedObject($menu))
				{
					$this->_html .= $this->displayError($this->l('Invalid id_menu'));

					return false;
				}
			}
			else
				$menu = new TVMenuiconClass();
			/* Sets position */
			$menu->position = (int)Tools::getValue('position');
			/* Sets active */
			$menu->active = (int)Tools::getValue('active_menu');
			
			$menu->color = Tools::getValue('color');
			
			/* Sets each langue fields */
			$languages = Language::getLanguages(false);
			foreach ($languages as $language)
			{
				$menu->title[$language['id_lang']] = Tools::getValue('title_'.$language['id_lang']);
				$menu->url[$language['id_lang']] = Tools::getValue('url_'.$language['id_lang']);
				/* Uploads image and sets slide */
				$type = Tools::strtolower(Tools::substr(strrchr($_FILES['image_'.$language['id_lang']]['name'], '.'), 1));
				$imagesize = @getimagesize($_FILES['image_'.$language['id_lang']]['tmp_name']);
				if (isset($_FILES['image_'.$language['id_lang']]) &&
					isset($_FILES['image_'.$language['id_lang']]['tmp_name']) &&
					!empty($_FILES['image_'.$language['id_lang']]['tmp_name']) &&
					!empty($imagesize) &&
					in_array(
						Tools::strtolower(Tools::substr(strrchr($imagesize['mime'], '/'), 1)), array(
							'jpg',
							'gif',
							'jpeg',
							'png'
						)
					) &&
					in_array($type, array('jpg', 'gif', 'jpeg', 'png'))
				)
				{
					$temp_name = tempnam(_PS_TMP_IMG_DIR_, 'PS');
					$salt = sha1(microtime());
					if ($error = ImageManager::validateUpload($_FILES['image_'.$language['id_lang']]))
						$errors[] = $error;
					elseif (!$temp_name || !move_uploaded_file($_FILES['image_'.$language['id_lang']]['tmp_name'], $temp_name))
						return false;
					elseif (!ImageManager::resize($temp_name, dirname(__FILE__).'/images/'.Tools::encrypt($_FILES['image_'.$language['id_lang']]['name'].$salt).'.'.$type, null, null, $type))
						$errors[] = $this->displayError($this->l('An error occurred during the image upload process.'));
					if (isset($temp_name))
						@unlink($temp_name);
					$menu->image[$language['id_lang']] = Tools::encrypt($_FILES['image_'.($language['id_lang'])]['name'].$salt).'.'.$type;
				}
				elseif (Tools::getValue('image_old_'.$language['id_lang']) != '')
					$menu->image[$language['id_lang']] = Tools::getValue('image_old_'.$language['id_lang']);
			}

			/* Processes if no errors  */
			if (!$errors)
			{
				/* Adds */
				if (!Tools::getValue('id_menu'))
				{
					if (!$menu->add())
						$errors[] = $this->displayError($this->l('The menu could not be added.'));
				}
				/* Update */
				elseif (!$menu->update())
					$errors[] = $this->displayError($this->l('The menu could not be updated.'));
				$this->clearCache();
			}
		} /* Deletes */
		elseif (Tools::isSubmit('delete_id_menu'))
		{
			$menu = new TVMenuiconClass((int)Tools::getValue('delete_id_menu'));
			$res = $menu->delete();
			$this->clearCache();
			if (!$res)
				$this->_html .= $this->displayError('Could not delete.');
			else
				Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules', true).'&conf=1&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name);
		}

		/* Display errors if needed */
		if (count($errors))
			$this->_html .= $this->displayError(implode('<br />', $errors));
		elseif (Tools::isSubmit('submitMenu') && Tools::getValue('id_menu'))
			Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules', true).'&conf=4&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name);
		elseif (Tools::isSubmit('submitMenu'))
			Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules', true).'&conf=3&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name);
	
	}

	private function _prepareHook()
	{
		if (!$this->isCached('tvmenuicon.tpl', $this->getCacheId()))
		{
			$menus = $this->getMenus(true);
			if (is_array($menus))
				foreach ($menus as &$menu)
				{
					$menu['sizes'] = @getimagesize((dirname(__FILE__).DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.$menu['image']));
					if (isset($menu['sizes'][3]) && $menu['sizes'][3])
						$menu['size'] = $menu['sizes'][3];
				}

			if (!$menus)
				return false;

			$this->smarty->assign(array('tvmenuicon_menus' => $menus));
		}

		return true;
	}

	public function hookdisplayHeader($params)
	{
		if (!isset($this->context->controller->php_self) || $this->context->controller->php_self != 'index')
			return;
		$this->context->smarty->assign(array(
			'TV_MENU_ICON' => Hook::Exec('tvmenuicon')
		));
		$this->context->controller->addCss($this->_path.'css/tvmenuicon.css', 'all');	
	}

	public function hookdisplayTop($params)
	{
		return $this->hookTVMenuIcon($params);
	}

	public function hookTVMenuIcon($params)
	{
		if (!isset($this->context->controller->php_self) || $this->context->controller->php_self != 'index')
			return;

		
		$menus = $this->getMenus(true);
			if (is_array($menus))
				foreach ($menus as &$menu)
				{
					$menu['sizes'] = @getimagesize((dirname(__FILE__).DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.$menu['image']));
					if (isset($menu['sizes'][3]) && $menu['sizes'][3])
						$menu['size'] = $menu['sizes'][3];
				}

			if (!$menus)
				return false;
		$this->smarty->assign(array(
			'path' => $this->_path,
			'menus' => $menus
		));
		return $this->display(__FILE__, 'views/templates/hook/tvmenuicon.tpl',$this->getCacheId());			
	}


	public function clearCache()
	{
		$this->_clearCache('tvmenuicon.tpl');
	}

	public function hookActionShopDataDuplication($params)
	{
		Db::getInstance()->execute('
			INSERT IGNORE INTO '._DB_PREFIX_.'tvmenuicon (id_menu, id_shop)
			SELECT id_menu, '.(int)$params['new_id_shop'].'
			FROM '._DB_PREFIX_.'tvmenuicon
			WHERE id_shop = '.(int)$params['old_id_shop']
		);
		$this->clearCache();
	}

	public function headerHTML()
	{
		if (Tools::getValue('controller') != 'AdminModules' && Tools::getValue('configure') != $this->name)
			return;

		$this->context->controller->addJqueryUI('ui.sortable');
		/* Style & js for fieldset 'slides configuration' */
		$html = '<script type="text/javascript">
			$(function() {
				var $mySlides = $("#menus");
				$mySlides.sortable({
					opacity: 0.6,
					cursor: "move",
					update: function() {
						var order = $(this).sortable("serialize") + "&action=updateMenusPosition";
						$.post("'.$this->context->shop->physical_uri.$this->context->shop->virtual_uri.'modules/'.$this->name.'/ajax_'.$this->name.'.php?secure_key='.$this->secure_key.'", order);
						}
					});
				$mySlides.hover(function() {
					$(this).css("cursor","move");
					},
					function() {
					$(this).css("cursor","auto");
				});
			});
		</script>';

		return $html;
	}

	public function getNextPosition()
	{
		$row = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow('
			SELECT MAX(ms.`position`) AS `next_position`
			FROM `'._DB_PREFIX_.'tvmenuicon_menus` ms, `'._DB_PREFIX_.'tvmenuicon` m
			WHERE ms.`id_menu` = m.`id_menu` AND m.`id_shop` = '.(int)$this->context->shop->id
		);

		return (++$row['next_position']);
	}

	public function getMenus($active = null)
	{
		$this->context = Context::getContext();
		$id_shop = $this->context->shop->id;
		$id_lang = $this->context->language->id;

		return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT m.`id_menu` as id_menu, msl.`image`, ms.`position`, ms.`active`, ms.`color`, msl.`title`,
			msl.`url`, msl.`image`
			FROM '._DB_PREFIX_.'tvmenuicon m
			LEFT JOIN '._DB_PREFIX_.'tvmenuicon_menus ms ON (m.id_menu = ms.id_menu)
			LEFT JOIN '._DB_PREFIX_.'tvmenuicon_menus_lang msl ON (ms.id_menu = msl.id_menu)
			WHERE id_shop = '.(int)$id_shop.'
			AND msl.id_lang = '.(int)$id_lang.
			($active ? ' AND ms.`active` = 1' : ' ').'
			ORDER BY ms.position'
		);
	}

	public function getAllImagesBySlidesId($id_menus, $active = null, $id_shop = null)
	{
		$this->context = Context::getContext();
		$images = array();

		if (!isset($id_shop))
			$id_shop = $this->context->shop->id;

		$results = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT msl.`image`, msl.`id_lang`
			FROM '._DB_PREFIX_.'tvmenuicon m
			LEFT JOIN '._DB_PREFIX_.'tvmenuicon_menus ms ON (m.id_menu = ms.id_menu)
			LEFT JOIN '._DB_PREFIX_.'tvmenuicon_menus_lang msl ON (ms.id_menu = msl.id_menu)
			WHERE m.`id_menu` = '.(int)$id_menus.' AND m.`id_shop` = '.(int)$id_shop.
			($active ? ' AND ms.`active` = 1' : ' ')
		);

		foreach ($results as $result)
			$images[$result['id_lang']] = $result['image'];

		return $images;
	}

	public function displayStatus($id_menu, $active)
	{
		$title = ((int)$active == 0 ? $this->l('Disabled') : $this->l('Enabled'));
		$icon = ((int)$active == 0 ? 'icon-remove' : 'icon-check');
		$class = ((int)$active == 0 ? 'btn-danger' : 'btn-success');
		$html = '<a class="btn '.$class.'" href="'.AdminController::$currentIndex.
			'&configure='.$this->name.'
				&token='.Tools::getAdminTokenLite('AdminModules').'
				&changeStatus&id_menu='.(int)$id_menu.'" title="'.$title.'"><i class="'.$icon.'"></i> '.$title.'</a>';

		return $html;
	}

	public function slideExists($id_menu)
	{
		$req = 'SELECT m.`id_menu` as id_menu
				FROM `'._DB_PREFIX_.'tvmenuicon` m
				WHERE m.`id_menu` = '.(int)$id_menu;
		$row = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($req);

		return ($row);
	}

public function renderList()
	{
		$menus = $this->getMenus();
		foreach ($menus as $key => $menu)
			$menus[$key]['status'] = $this->displayStatus($menu['id_menu'], $menu['active']);

		$this->context->smarty->assign(
			array(
				'link' => $this->context->link,
				'menus' => $menus,
				'image_baseurl' => $this->_path.'images/',
				'path'	=> $this->_path
			)
		);

		return $this->display(__FILE__, 'list.tpl');
}

	public function renderAddForm()
	{
		$fields_form = array(
			'form' => array(
				'legend' => array(
					'title' => $this->l('Menu informations'),
					'icon' => 'icon-cogs'
				),
				'input' => array(
				array(
						'type' => 'text',
						'label' => $this->l('Title'),
						'name' => 'title',
						'lang' => true,
					),
					array(
						'type' => 'file_lang',
						'label' => $this->l('Select a file'),
						'name' => 'image',
						'lang' => true,
						'desc' => $this->l(sprintf('Max image size %s', ini_get('upload_max_filesize')))
					),				
					array(
						'type' => 'text',
						'label' => $this->l('URL'),
						'name' => 'url',
						'lang' => true,
					),
					array(
						'type' => 'color',
						'label' => $this->l('Background color'),
						'name' => 'color',
						'class' => 'color mColorPickerInput',
					),
					array(
						'type' => 'switch',
						'label' => $this->l('Active'),
						'name' => 'active_menu',
						'is_bool' => true,
						'values' => array(
							array(
								'id' => 'active_on',
								'value' => 1,
								'label' => $this->l('Yes')
							),
							array(
								'id' => 'active_off',
								'value' => 0,
								'label' => $this->l('No')
							)
						),
					),
				),
				'submit' => array(
					'title' => $this->l('Save'),
				)
			),
		);

		if (Tools::isSubmit('id_menu') && $this->slideExists((int)Tools::getValue('id_menu')))
		{
			$menu = new TVMenuiconClass((int)Tools::getValue('id_menu'));
			$fields_form['form']['input'][] = array('type' => 'hidden', 'name' => 'id_menu');
			$fields_form['form']['images'] = $menu->image;

			$has_picture = true;

			foreach (Language::getLanguages(false) as $lang)
				if (!isset($menu->image[$lang['id_lang']]))
					$has_picture &= false;

			if ($has_picture)
				$fields_form['form']['input'][] = array('type' => 'hidden', 'name' => 'has_picture');
		}

		$helper = new HelperForm();
		$helper->show_toolbar = false;
		$helper->table = $this->table;
		$lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
		$helper->default_form_language = $lang->id;
		$helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
		$this->fields_form = array();
		$helper->module = $this;
		$helper->identifier = $this->identifier;
		$helper->submit_action = 'submitMenu';
		$helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$language = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
		$helper->tpl_vars = array(
			'base_url' => $this->context->shop->getBaseURL(),
			'language' => array(
				'id_lang' => $language->id,
				'iso_code' => $language->iso_code
			),
			'fields_value' => $this->getAddFieldsValues(),
			'languages' => $this->context->controller->getLanguages(),
			'id_language' => $this->context->language->id,
			'image_baseurl' => $this->_path.'images/'
		);

		$helper->override_folder = '/';

		return $helper->generateForm(array($fields_form));
	}

	public function getAddFieldsValues()
	{
		$fields = array();

		if (Tools::isSubmit('id_menu') && $this->slideExists((int)Tools::getValue('id_menu')))
		{
			$menu = new TVMenuiconClass((int)Tools::getValue('id_menu'));
			$fields['id_menu'] = (int)Tools::getValue('id_menu', $menu->id);
		}
		else
			$menu = new TVMenuiconClass();

		$fields['active_menu'] = Tools::getValue('active_menu', $menu->active);
		$fields['color'] = Tools::getValue('color', $menu->color);
		$fields['has_picture'] = true;

		$languages = Language::getLanguages(false);

		foreach ($languages as $lang)
		{
			$fields['image'][$lang['id_lang']] = Tools::getValue('image_'.(int)$lang['id_lang']);
			$fields['title'][$lang['id_lang']] = Tools::getValue('title_'.(int)$lang['id_lang'], $menu->title[$lang['id_lang']]);
			$fields['url'][$lang['id_lang']] = Tools::getValue('url_'.(int)$lang['id_lang'], $menu->url[$lang['id_lang']]);
		}

		return $fields;
	}
}
