<?php
/**
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2014 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class TVMenuiconClass extends ObjectModel
{
	public $title;
	public $url;
	public $image;
	public $active;
	public $position;
	public $color;

	/**
	 * @see ObjectModel::$definition
	 */
	public static $definition = array(
		'table' => 'tvmenuicon_menus',
		'primary' => 'id_menu',
		'multilang' => true,
		'fields' => array(
			'active' =>			array('type' => self::TYPE_BOOL, 'validate' => 'isBool', 'required' => true),
			'position' =>		array('type' => self::TYPE_INT, 'validate' => 'isunsignedInt', 'required' => true),
			'color' =>			array('type' => self::TYPE_STRING, 'validate' => 'isCleanHtml', 'required' => true, 'size' => 255),
			// Lang fields
			'title' =>			array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCleanHtml', 'required' => true, 'size' => 255),
			'url' =>			array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isUrl', 'required' => true, 'size' => 255),
			'image' =>			array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCleanHtml', 'size' => 255),
		)
	);

	public	function __construct($id_menu = null, $id_lang = null, $id_shop = null, Context $context = null)
	{
		parent::__construct($id_menu, $id_lang, $id_shop);
	}

	public function add($autodate = true, $null_values = false)
	{
		$context = Context::getContext();
		$id_shop = $context->shop->id;

		$res = parent::add($autodate, $null_values);
		$res &= Db::getInstance()->execute('
			INSERT INTO `'._DB_PREFIX_.'tvmenuicon` (`id_shop`, `id_menu`)
			VALUES('.(int)$id_shop.', '.(int)$this->id.')'
		);
		return $res;
	}

	public function delete()
	{
		$res = true;

		
		$res &= $this->reOrderPositions();

		$res &= Db::getInstance()->execute('
			DELETE FROM `'._DB_PREFIX_.'tvmenuicon`
			WHERE `id_menu` = '.(int)$this->id
		);

		$res &= parent::delete();
		return $res;
	}

	public function reOrderPositions()
	{
		$id_menu = $this->id;
		$context = Context::getContext();
		$id_shop = $context->shop->id;

		$max = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT MAX(ms.`position`) as position
			FROM `'._DB_PREFIX_.'tvmenuicon_menus` ms, `'._DB_PREFIX_.'tvmenuicon` m
			WHERE ms.`id_menu` = m.`id_menu` AND m.`id_shop` = '.(int)$id_shop
		);

		if ((int)$max == (int)$id_menu)
			return true;

		$rows = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT ms.`position` as position, ms.`id_menu` as id_menu
			FROM `'._DB_PREFIX_.'tvmenuicon_menus` ms
			LEFT JOIN `'._DB_PREFIX_.'tvmenuicon` m ON (ms.`id_menu` = m.`id_menu`)
			WHERE m.`id_shop` = '.(int)$id_shop.' AND ms.`position` > '.(int)$this->position
		);

		foreach ($rows as $row)
		{
			$current_menu = new TVMenuiconClass($row['id_menu']);
			--$current_menu->position;
			$current_menu->update();
			unset($current_menu);
		}

		return true;
	}

}
