<?php
/**
* 2013-2014 Top1Extensions
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize module for your
* needs please refer to http://top1extensions.com for more information.
*
*  @author    Top1Extensions <support@top1extensions.com>
*  @copyright 2013-2014 Top1Extensions
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*/

if (!defined('_PS_VERSION_'))
exit;
class tvproductmanufacture extends Module
{
	public $html = '';
	public $success = '';
public function __construct()
{
		$this->name = 'tvproductmanufacture';
		$this->tab = 'others';
		$this->version = '1.0';
		$this->author = 'Themesvip';
		$this->need_instance = 0;
		$this->module_key = '4ddaa2f6c66dba43730094b1749fabba';
		$this->bootstrap = true;
		parent::__construct();
		$this->displayName = $this->l('TV Manufacture On Product Page');
		$this->description = $this->l('Display manufacture or supplier on product page');
		$this->confirmUninstall = $this->l('Are you sure that you want to delete your Manufacture on product page?');
}

public function install()
{
		Configuration::updateValue('SHOW_ADV', 1);
		Configuration::updateValue('TITLE_MANU', 1);
		Configuration::updateValue('IMG_MANU', 1);
		Configuration::updateValue('NAME_MANU', 1);
		Configuration::updateValue('TITLE_SUPP', 1);
		Configuration::updateValue('IMG_SUPP', 1);
		Configuration::updateValue('NAME_SUPP', 1);
		if (!parent::install()
		|| !$this->registerHook('extraRight')
		|| !$this->registerHook('Header')
		|| !$this->registerHook('Custome'))
			return false;
		return true;
}
public function uninstall()
{
		Configuration::deleteByName('NAME_MANU');
		Configuration::deleteByName('TITLE_MANU');
		Configuration::deleteByName('IMG_MANU');
		Configuration::deleteByName('NAME_SUPP');
		Configuration::deleteByName('TITLE_SUPP');
		Configuration::deleteByName('IMG_SUPP');
		Configuration::deleteByName('SHOW_ADV');
		if (parent::uninstall() == false)
			return false;
		return true;
}
public function displayHelp()
{
		
}


public function getContent()
{
		$this->html = '<h2><img src="'.$this->_path.'logo.png" alt="" /> '.$this->displayName.'</h2>';
		$this->postProcess();
		$this->displayForm();
		return $this->success.$this->html;
}
private function postProcess()
{
		if (Tools::isSubmit('saveManufacture'))
		{
			$name_manu = Tools::getValue('name_manu');
			Configuration::updateValue('NAME_MANU', $name_manu);
			$title_manu = Tools::getValue('title_manu');
			Configuration::updateValue('TITLE_MANU', $title_manu);
			$img_manu = Tools::getValue('img_manu');
			Configuration::updateValue('IMG_MANU', $img_manu);
			$name_supp = Tools::getValue('name_supp');
			Configuration::updateValue('NAME_SUPP', $name_supp);
			$title_supp = Tools::getValue('title_supp');
			Configuration::updateValue('TITLE_SUPP', $title_supp);
			$img_supp = Tools::getValue('img_supp');
			Configuration::updateValue('IMG_SUPP', $img_supp);
			$this->html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		
}

private function displayForm()
{
		$fields_form1 = array(
			'form' => array(
				'legend' => array(
					'title' => $this->l('Configuration'),
					'icon' => 'icon-cogs'
				),
				'input' => array(
					array(
						'type' => 'switch',
						'label' => $this->l('Show name manufacture'),
						'name' => 'name_manu',
						//'desc' => $this->l('Display list other modue below.'),
						//'thumb' => $this->context->link->protocol_content.$this->adv_img,
							'values' => array(
									array(
										'id' => 'display_on',
										'value' => 1,
										'label' => $this->l('Enabled')
									),
									array(
										'id' => 'display_off',
										'value' => 0,
										'label' => $this->l('Disabled')
									)
						),
					),
					array(
						'type' => 'switch',
						'label' => $this->l('Show title manufacture'),
						'name' => 'title_manu',
						//'desc' => $this->l('Display list other modue below.'),
						//'thumb' => $this->context->link->protocol_content.$this->adv_img,
							'values' => array(
									array(
										'id' => 'display_on',
										'value' => 1,
										'label' => $this->l('Enabled')
									),
									array(
										'id' => 'display_off',
										'value' => 0,
										'label' => $this->l('Disabled')
									)
						),
					),
					array(
						'type' => 'switch',
						'label' => $this->l('Show image manufacture'),
						'name' => 'img_manu',
						//'desc' => $this->l('Display list other modue below.'),
						//'thumb' => $this->context->link->protocol_content.$this->adv_img,
							'values' => array(
									array(
										'id' => 'display_on',
										'value' => 1,
										'label' => $this->l('Enabled')
									),
									array(
										'id' => 'display_off',
										'value' => 0,
										'label' => $this->l('Disabled')
									)
						),
					),
					array(
						'type' => 'switch',
						'label' => $this->l('Show name supplier'),
						'name' => 'name_supp',
						//'desc' => $this->l('Display list other modue below.'),
						//'thumb' => $this->context->link->protocol_content.$this->adv_img,
							'values' => array(
									array(
										'id' => 'display_on',
										'value' => 1,
										'label' => $this->l('Enabled')
									),
									array(
										'id' => 'display_off',
										'value' => 0,
										'label' => $this->l('Disabled')
									)
						),
					),
					array(
						'type' => 'switch',
						'label' => $this->l('Show title supplier'),
						'name' => 'title_supp',
						//'desc' => $this->l('Display list other modue below.'),
						//'thumb' => $this->context->link->protocol_content.$this->adv_img,
							'values' => array(
									array(
										'id' => 'display_on',
										'value' => 1,
										'label' => $this->l('Enabled')
									),
									array(
										'id' => 'display_off',
										'value' => 0,
										'label' => $this->l('Disabled')
									)
						),
					),
					array(
						'type' => 'switch',
						'label' => $this->l('Show image supplier'),
						'name' => 'img_supp',
						//'desc' => $this->l('Display list other modue below.'),
						//'thumb' => $this->context->link->protocol_content.$this->adv_img,
							'values' => array(
									array(
										'id' => 'display_on',
										'value' => 1,
										'label' => $this->l('Enabled')
									),
									array(
										'id' => 'display_off',
										'value' => 0,
										'label' => $this->l('Disabled')
									)
						),
					),
				),
				'submit' => array(
					'title' => $this->l('Save'),
				)
			),
		);
		$helper = new HelperForm();
		$helper->show_toolbar = false;
		$helper->table = $this->table;
		$this->fields_form = array();
		$helper->identifier = $this->identifier;
		$helper->submit_action = 'saveManufacture';
		$helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'
		&tab_module='.$this->tab.'&module_name='.$this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues1()
		);
		$this->html .= '
			<legend><img src="'.$this->_path.'img/setting.png" alt="" title="" /> '.$this->l('Options').'</legend>';
		$this->html .= $helper->generateForm(array($fields_form1));
}
public function getConfigFieldsValues1()
{
		return array(
			'name_manu' => Tools::getValue('name_manu', Configuration::get('NAME_MANU')),
			'title_manu' => Tools::getValue('title_manu', Configuration::get('TITLE_MANU')),
			'img_manu' => Tools::getValue('img_manu', Configuration::get('IMG_MANU')),
			'name_supp' => Tools::getValue('name_supp', Configuration::get('NAME_SUPP')),
			'title_supp' => Tools::getValue('title_supp', Configuration::get('TITLE_SUPP')),
			'img_supp' => Tools::getValue('img_supp', Configuration::get('IMG_SUPP')),
		);
}
public function hookextraRight()
{
	$id_product = (int)Tools::getValue('id_product');
	$product = new Product($id_product, true, (int)Context::getContext()->language->id);
	$link_manu = Tools::link_rewrite($product->manufacturer_name);
	$link_supp = Tools::link_rewrite($product->supplier_name);
	$this->context->smarty->assign(array(
				'show_title_manu' => Configuration::get('TITLE_MANU'),
				'show_name_manu' => Configuration::get('NAME_MANU'),
				'show_img_manu' => Configuration::get('IMG_MANU'),
				'show_title_supp' => Configuration::get('TITLE_SUPP'),
				'show_name_supp' => Configuration::get('NAME_SUPP'),
				'show_img_supp' => Configuration::get('IMG_SUPP'),
				'link_manu' => $link_manu,
				'link_supp' => $link_supp,
				'product' => $product
		));
	return $this->display(__FILE__, '/views/templates/hook/tvproductmanufacture.tpl');
}
public function hookCustome()
{
	$id_product = (int)Tools::getValue('id_product');
	$product = new Product($id_product, true, (int)Context::getContext()->language->id);
	$link_manu = Tools::link_rewrite($product->manufacturer_name);
	$link_supp = Tools::link_rewrite($product->supplier_name);
	$this->context->smarty->assign(array(
				'show_title_manu' => Configuration::get('TITLE_MANU'),
				'show_name_manu' => Configuration::get('NAME_MANU'),
				'show_img_manu' => Configuration::get('IMG_MANU'),
				'show_title_supp' => Configuration::get('TITLE_SUPP'),
				'show_name_supp' => Configuration::get('NAME_SUPP'),
				'show_img_supp' => Configuration::get('IMG_SUPP'),
				'link_manu' => $link_manu,
				'link_supp' => $link_supp,
				'product' => $product
		));
	return $this->display(__FILE__, '/views/templates/hook/tvproductmanufacture.tpl');
}
public function hookHeader()
{
		$this->context->controller->addCSS(($this->_path).'css/style.css', 'all');
		$this->context->smarty->assign(array(
		'HOOK_CUSTOME' => Hook::Exec('custome'),
		));
}
}
?>