<?php
/**
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2014 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
exit;
include_once(dirname(__FILE__).'/specialproductclass.php');
class TVSpecialProduct extends Module
{
private $html;
public function __construct()
{
		$this->name = 'tvspecialproduct';
		$this->tab = 'others';
		$this->version = 0.1;
		$this->author = 'Themesvip';
		$this->module_key = '4ddaa2f6c66dba43730094b1749fabba';
		$this->need_instance = 0;

		parent::__construct();

		$this->displayName = $this->l('TV Special products block');
		$this->description = $this->l('Displays a block featuring your store\'s special products.');
}

public function install()
{
			Configuration::updateValue('NB_SPECIAL_PRODUCT', '6');
			Configuration::updateValue('ALWAY_DISPLAY_SPECIAL', '1');
			Configuration::updateValue('SHOW_ADV', '1');
			if (parent::install() == false || $this->registerHook('displayTopColumn') == false || $this->registerHook('displayHeader') == false)
			return false;
			return true;
}

public function uninstall()
{
		Configuration::deleteByName('NB_SPECIAL_PRODUCT');
		Configuration::deleteByName('ALWAY_DISPLAY_SPECIAL');
		Configuration::deleteByName('SHOW_ADV');
	 	if (parent::uninstall() == false)
	 		return false;
	 	return true;
}


public function getContent()
{
		$this->html = '<h2><img src="'.$this->_path.'logo.png" alt="" /> '.$this->displayName.'</h2>';
		$this->postProcess();
		if (Tools::isSubmit('saveOptionSpecialProduct'))
		{
			$nb_special_product = Tools::getValue('nb_special_product');
            Configuration::updateValue('NB_SPECIAL_PRODUCT', $nb_special_product);
			$alway_display = Tools::getValue('alway_display');
            Configuration::updateValue('ALWAY_DISPLAY_SPECIAL', $alway_display);
			$this->html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		else
			$this->displayForm();
		return $this->html;
}
private function postProcess()
{

}
public function displayForm()
{
		$this->html = '
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
		<fieldset><legend><img src="'.$this->_path.'img/setting.png" alt="" title="" />'.$this->l('Settings').'</legend>
				<label>'.$this->l('Products to display.').'</label>
					<div class="margin-form">
						<input type="text" name="nb_special_product" value="'.(int)(Configuration::get('NB_SPECIAL_PRODUCT')).'" />
						<p class="clear">'.$this->l('Define the number of products to be displayed in this block.').'</p>
					</div>
					<label>'.$this->l('Always display this block.').'</label>
					<div class="margin-form">
						<input type="radio" name="always_display" id="display_on" value="1" '.(Tools::getValue('alway_display', Configuration::get('ALWAY_DISPLAY_SPECIAL')) ? 'checked="checked" ' : '').'/>
						<label class="t" for="display_on"> <img src="'.$this->_path.'img/active.png" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
						<input type="radio" name="always_display" id="display_off" value="0" '.(!Tools::getValue('alway_display', Configuration::get('ALWAY_DISPLAY_SPECIAL')) ? 'checked="checked" ' : '').'/>
						<label class="t" for="display_off"> <img src="'.$this->_path.'img/disable.png" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
						<p class="clear">'.$this->l('Show the block even if no products are available.').'</p>
					</div>
					<center><input type="submit" name="saveOptionSpecialProduct" value="'.$this->l('Save').'" class="button" /></center>
				</fieldset>
			</form>';
		return $this->html;
}

public function hookdisplayTopColumn($params)
{
		$temp = new SpecialProductClass();
			$specialProducts = $temp->getSpecialProductList(Configuration::get('NB_SPECIAL_PRODUCT'));
		if (!$specialProducts && Configuration::get('ALWAY_DISPLAY_SPECIAL') == 0)
			return;
		if (!empty($specialProducts))
			$this->smarty->assign(array(
				'new_products' => $specialProducts,
				'mediumSize' => Image::getSize(ImageType::getFormatedName('medium')),
			));
		return $this->display(__FILE__, 'views/templates/hook/tvspecialproduct.tpl');
}

public function hookHeader($params)
{
		$this->context->controller->addCSS($this->_path.'css/tvspecialproduct.css', 'all');
}
}


