{*
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2014 PrestaShop SA

*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<!-- MODULE Block new products -->
<div id="tv-special-products" class="col-xs-12 col-sm-4 col-md-8">
	<div class="new_content">
	<h4 class="title_block"><a href="{$link->getPageLink('prices-drop')|escape}" title="{l s='Special products' mod='tvspecialproduct'}">{l s='Special products' mod='tvspecialproduct'}</a></h4>
	<a id="prev_tv_special_product" class="prev btn" href="#">&lt;</a>
		<a id="next_tv_special_product" class="next btn" href="#">&gt;</a>
	<div class="block_content">
	{if isset($new_products) && $new_products|@count > 0}
		<ul id="tv_special_product" class="product-list">
		{foreach from=$new_products item='product' name='specialProducts'}
				<li class="ajax_block_product item">								
				<a class="product_image" href="{$product.link|escape:html:'UTF-8'}" title="{$product.legend|escape:html:'UTF-8'}">
				{if isset($product.new) && $product.new == 1}
					<p class="new-bkg" href="{$product.link|escape:'html':'UTF-8'}">
						<span class="new">{l s='New' mod='tvspecialproduct'}</span>
					</p>
				{/if}
				{if isset($product.show_price) && $product.show_price && !isset($restricted_country_mode)}
					{if $priceDisplay && $product.reduction}
					<p class="sale-bkg" href="{$product.link|escape:'html':'UTF-8'}">
						<span class="sale">-{$product.specific_prices.reduction|escape * 100}%</span>
					</p>
				{/if}
				{/if}
				<img class="new_item" src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'home_default')}" alt="{$product.legend|escape:html:'UTF-8'}" /></a>
				
				<h3 class="name_product"><a href="{$product.link}" title="{$product.name|escape:html:'UTF-8'}">{$product.name|truncate:50:'...'|strip_tags|escape:html:'UTF-8'}</a></h3>
				{if $product.ratting}
				<div class="star_content clearfix">
									{section name="i" start=0 loop=5 step=1}
										{if $product.ratting le $smarty.section.i.index}
											<div class="star"></div>
										{else}
											<div class="star star_on"></div>
										{/if}
									{/section}
				</div>
				{/if}
				<div class="content_price">
							{if isset($product.show_price) && $product.show_price && !isset($restricted_country_mode)}
								{if $priceDisplay && $product.reduction}<span class="price-discount">{convertPrice price=$product.price_without_reduction}</span>{/if}
								<span class="price">{if !$priceDisplay}{convertPrice price=$product.price}{else}{convertPrice price=$product.price_tax_exc}{/if}</span>
							{/if}
				</div>
				<div class="content_hide">
						<h3 class="name_product"><a href="{$product.link}" title="{$product.name|escape:html:'UTF-8'}">{$product.name|truncate:50:'...'|strip_tags|escape:html:'UTF-8'}</a>
						</h3>
					   <div class="content_price">
								{if isset($product.show_price) && $product.show_price && !isset($restricted_country_mode)}
									{if $priceDisplay && $product.reduction}<span class="price-discount">{convertPrice price=$product.price_without_reduction}</span>{/if}
									<span class="price">{if !$priceDisplay}{convertPrice price=$product.price}{else}{convertPrice price=$product.price_tax_exc}{/if}</span>
								{/if}
					  </div>
						<div class="button-container">
						<div class="group-content">
							{if ($product.id_product_attribute == 0 || (isset($add_prod_display) && ($add_prod_display == 1))) && $product.available_for_order && !isset($restricted_country_mode) && $product.minimal_quantity <= 1 && $product.customizable != 2 && !$PS_CATALOG_MODE}
									{if ($product.allow_oosp || $product.quantity > 0)}
										<p class="addcart_icon">
											{if isset($static_token)}
												<a class="button ajax_add_to_cart_button " href="{$link->getPageLink('cart',false, NULL, "add=1&amp;id_product={$product.id_product|intval}&amp;token={$static_token}", false)|escape:'html':'UTF-8'}" rel="nofollow" title="{l s='Add to cart' mod='tvspecialproduct'}" data-id-product="{$product.id_product|intval}"></a>
											{else}
												<a class="button ajax_add_to_cart_button " href="{$link->getPageLink('cart',false, NULL, 'add=1&amp;id_product={$product.id_product|intval}', false)|escape:'html':'UTF-8'}" rel="nofollow" title="{l s='Add to cart' mod='tvspecialproduct'}" data-id-product="{$product.id_product|intval}"></a>
											{/if}
										</p>
									{/if}
								{/if}
								<p class="wishlist_icon"><a href="#" id="wishlist_button_special_{$product.id_product|intval}" onclick="WishlistCart('wishlist_button_special_{$product.id_product|intval}', 'wishlist_block_list', 'add', '{$product.id_product|intval}', false, 1); return false;" class="addToWishlist"></a>
								</p>
								<p class="quickview_icon"><a class="quick-view" href="{$product.link|escape:'html':'UTF-8'}" rel="{$product.link|escape:'html':'UTF-8'}"></a>
								</p>
							</div>
						</div>
				</div>
				</li>
		{/foreach}
		</ul>
		
	{else}
		<p class="no-product">{l s='No products at this time.' mod='tvspecialproduct'}</p>
	{/if}
	</div>
	</div>
</div>
<script type="text/javascript">

	$(window).load(function(){
		runSliderSpecial ();
	});
	
	$(window).resize(function(){
		if(!isMobile())
			runSliderSpecial();
	});

function runSliderSpecial()
{
		var item_special = 4;
		
		if(getWidthBrowser() > 1180)
		{	
			item_special = 4; 
		}
		else
		if(getWidthBrowser() > 991)
		{	
			item_special = 3; 
		}
		else
		if(getWidthBrowser() > 767)
		{	
			item_special = 2; 
		}
		else
		if(getWidthBrowser() > 540)
		{	
			item_special = 3; 
		}
		else
		if(getWidthBrowser() > 360)
		{	
			item_special = 1; 
		}		
		
	$("ul#tv_special_product").carouFredSel({
		auto: false,
		responsive: true,
			width: '100%',
			prev: '#prev_tv_special_product',
			next: '#next_tv_special_product',
			swipe: {
				onTouch : true
			},
			items: {
				width: 162,
				visible: {
					min: 1,
					max: item_special
				}
			},
			scroll: {
				items : item_special ,       //  The number of items scrolled.
				direction : 'left',    //  The direction of the transition.
				duration  : 800   //  The duration of the transition.
			}

	});
}
</script>
<!-- /MODULE Block special products -->
