SET FOREIGN_KEY_CHECKS = 0;
-- REQUEST --
DROP TABLE IF EXISTS `{PREFIXE}emc_categories`;
-- REQUEST --
DROP TABLE IF EXISTS `{PREFIXE}emc_dimensions`;
-- REQUEST --
DROP TABLE IF EXISTS `{PREFIXE}emc_documents`;
-- REQUEST --
DROP TABLE IF EXISTS `{PREFIXE}emc_operators`;
-- REQUEST --
DROP TABLE IF EXISTS `{PREFIXE}emc_orders`;
-- REQUEST --
DROP TABLE IF EXISTS `{PREFIXE}emc_orders_tmp`;
-- REQUEST --
DROP TABLE IF EXISTS `{PREFIXE}emc_points`;
-- REQUEST --
DROP TABLE IF EXISTS `{PREFIXE}emc_services`;
-- REQUEST --
DROP TABLE IF EXISTS `{PREFIXE}emc_operators_authorized_contents`;
-- REQUEST --
DROP TABLE IF EXISTS `{PREFIXE}emc_tracking`;
-- REQUEST --
DROP TABLE IF EXISTS `{PREFIXE}emc_cache`;
-- REQUEST --
DROP TABLE IF EXISTS `{PREFIXE}emc_cart_tmp`;
-- REQUEST --
SET FOREIGN_KEY_CHECKS = 1;
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_categories` (
	`id_eca` int(11) NOT NULL,
	`emc_categories_id_eca` int(11) NOT NULL,
	`name_eca` varchar(100) NOT NULL,
  `prohibited_eca` int(1) NOT NULL DEFAULT '0',
	PRIMARY KEY (`id_eca`)
) DEFAULT CHARSET=utf8;
-- REQUEST --
INSERT INTO `{PREFIXE}emc_categories` (`id_eca`, `emc_categories_id_eca`, `name_eca`, `prohibited_eca`) VALUES
(10000, 0, "Livres et documents", 0),
(10100, 10000, "Documents sans valeur commerciale", 0),
(10120, 10000, "Journaux", 0),
(10130, 10000, "Magazines, revues", 0),
(10140, 10000, "Manuels techniques", 0),
(10150, 10000, "Livres", 0),
(10160, 10000, "Passeports", 0),
(10170, 10000, "Billets d\'avion", 0),
(10180, 10000, "Radiographies", 0),
(10190, 10000, "Photographies", 0),
(10200, 10000, "Courrier interne d\'entreprise", 0),
(10210, 10000, "Propositions commerciales", 0),
(10220, 10000, "Documents publicitaires", 0),
(10230, 10000, "Catalogues, rapports annuels", 0),
(10240, 10000, "Listings informatiques", 0),
(10250, 10000, "Plans, dessins", 0),
(10260, 10000, "Documents d\'impression", 0),
(10280, 10000, "Patrons", 0),
(10290, 10000, "Etiquettes, autocollants", 0),
(10300, 10000, "Documents d\'appels d\'offres", 0),
(20000, 0, "Alimentation et matières périssables", 0),
(20100, 20000, "Denrées alimentaires non périssables", 0),
(20102, 20000, "Produits frais et périssables", 1),
(20103, 20000, "Produits réfrigérés", 1),
(20105, 20000, "Produits surgelés", 1),
(20110, 20000, "Boissons non alcoolisées", 0),
(20120, 20000, "Boissons alcoolisées", 0),
(20130, 20000, "Plantes, fleurs, semences", 1),
(30000, 0, "Produits", 0),
(30100, 30000, "Cosmétiques, bien-être", 0),
(30200, 30000, "Pharmacie, médicaments", 1),
(30300, 30000, "Chimie, droguerie, produits d\'entretien", 0),
(40000, 0, "Habillement et accessoires", 0),
(40100, 40000, "Chaussures", 0),
(40110, 40000, "Tissus, vêtements neufs", 0),
(40120, 40000, "Vêtements usagés", 0),
(40125, 40000, "Accessoires vestimentaires, de mode", 0),
(40130, 40000, "Cuirs, peaux, maroquinerie", 0),
(40150, 40000, "Bijoux fantaisie", 0),
(50000, 0, "Appareils et matériels", 0),
(50100, 50000, "Matériel médical", 0),
(50110, 50000, "Informatique, High tech, téléphonie fixe", 0),
(50113, 50000, "Téléphonie mobile et accessoires", 0),
(50114, 50000, "Téléviseurs, écrans d\'ordinateur", 0),
(50120, 50000, "Autres appareils et matériels", 0),
(50130, 50000, "Supports numériques, CD, DVD", 0),
(50140, 50000, "Pièces de rechange et accessoires (auto)", 0),
(50150, 50000, "Pièces de rechange et accessoires (autres)", 0),
(50160, 40000, "Bijoux, objets précieux", 1),
(50170, 50000, "Montres, horlogerie (hors bijoux)", 0),
(50180, 70000, "Cadeaux, cadeaux entreprise", 0),
(50190, 30000, "Tabac", 1),
(50200, 30000, "Parfums", 1),
(50330, 50000, "Articles de camping, de pêche", 0),
(50350, 50000, "Articles de sport (hors vêtement)", 0),
(50360, 50000, "Instruments de musique et accessoires", 0),
(50380, 50000, "Matériel de chauffage, chaudronnerie", 0),
(50390, 50000, "Matériel de labo, optique, de mesure", 0),
(50395, 50000, "Matériel électrique, transfo., câbles", 0),
(50400, 50000, "Fournitures de bureau, papeterie, recharges", 0),
(50420, 50000, "Moteurs", 0),
(50430, 50000, "Motos, scooters", 1),
(50440, 50000, "Vélos, cycles sans moteur", 0),
(50450, 50000, "Outillage, outils, bricolage", 0),
(50490, 50000, "Plomberie, tubes plastiques", 0),
(50500, 50000, "Quincaillerie, robinetterie, serrurerie", 0),
(60000, 0, "Mobilier et décoration", 0),
(60100, 60000, "Mobilier d\'habitation", 0),
(60102, 60000, "Mobilier de bureau", 0),
(60105, 60000, "Mobilier démonté sous emballage", 0),
(60108, 60000, "Mobilier ancien (antiquité)", 0),
(60110, 60000, "Electroménager", 1),
(60112, 60000, "Petit électroménager, petits appareils ménagers", 0),
(60120, 60000, "Objets ou tableaux cotés, de collection, miroirs, vitres", 1),
(60122, 60000, "Objets et tableaux courants", 0),
(60124, 60000, "Lampes, luminaire", 0),
(60126, 60000, "Tapis", 0),
(60128, 60000, "Toiles, rideaux, draps", 0),
(60129, 60000, "Sanitaires, verres, cristallerie, bibelots", 0),
(60130, 60000, "Autres objets fragiles et sculptures", 0),
(70000, 0, "Effets personnels, cadeaux", 0),
(70100, 70000, "Bagages, valises, malles", 0),
(70200, 70000, "Petit déménagement, cartons, effets personnels", 0),
(80000, 0, "Loisirs, produits d\'agrément", 0),
(80100, 80000, "Produits culturels : livres, jeux, CD, DVD etc", 0),
(80200, 80000, "Appareils électroniques, Image et son etc", 0),
(80300, 80000, "Bien-être et santé : crèmes, huiles, appareils etc", 0),
(80400, 80000, "Puériculture, jouets, objets pour enfants etc", 0),
(80500, 80000, "Loisirs créatifs, matériaux, art et artisanat etc", 0);
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_dimensions` (
	`id_ed` int(3) NOT NULL AUTO_INCREMENT,
	`length_ed` int(3) NOT NULL,
	`width_ed` int(3) NOT NULL,
	`height_ed` int(3) NOT NULL,
	`weight_from_ed` float NOT NULL,
	`weight_ed` float NOT NULL,
	PRIMARY KEY (`id_ed`)
)  DEFAULT CHARSET=utf8;
-- REQUEST --
INSERT INTO {PREFIXE}emc_dimensions (`id_ed`, `length_ed`, `width_ed`, `height_ed`, `weight_from_ed`, `weight_ed`) VALUES
(1, 18, 18, 18, 0, 1),
(2, 22, 22, 22, 1, 2),
(3, 26, 26, 26, 2, 3),
(4, 28, 28, 28, 3, 4),
(5, 31, 31, 31, 4, 5),
(6, 33, 33, 33, 5, 6),
(7, 34, 34, 34, 6, 7),
(8, 36, 36, 36, 7, 8),
(9, 37, 37, 37, 8, 9),
(10, 39, 39, 39, 9, 10),
(11, 44, 44, 44, 10, 15),
(12, 47, 47, 47, 15, 20),
(13, 49, 49, 49, 20, 50);
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_documents` (
	`id_ed` int(11) NOT NULL AUTO_INCREMENT,
	`{PREFIXE}orders_id_order` int(10) unsigned NOT NULL,
	`{PREFIXE}cart_id_cart` int(10) unsigned NOT NULL,
	`link_ed` varchar(255) NOT NULL,
	`generated_ed` int(1) NOT NULL DEFAULT 0,
	`type_ed` varchar(100) NOT NULL,
	PRIMARY KEY (`id_ed`),
	KEY `{PREFIXE}orders_id_order` (`{PREFIXE}orders_id_order`)
) DEFAULT CHARSET=utf8;
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_operators` (
	`id_eo` int(2) NOT NULL AUTO_INCREMENT,
	`name_eo` varchar(100) NOT NULL,
	`code_eo` char(4) NOT NULL,
	PRIMARY KEY (`id_eo`)
)  DEFAULT CHARSET=utf8;
-- REQUEST --
INSERT INTO `{PREFIXE}emc_operators` (`id_eo`, `name_eo`, `code_eo`) VALUES
(1, "DHL Freight", "DHLF"),
(2, "FedEx", "FEDX"),
(3, "Sodexi", "SODX"),
(4, "Relais Colis", "SOGP"),
(5, "TNT Express", "TNTE"),
(6, "UPS", "UPSE"),
(7, "Chronopost", "CHRP"),
(8, "Mondial Relay", "MONR"),
(9, "DHL Express", "DHLE"),
(10, "La Poste", "POFR"),
(11, "Happy Post", "IMXE");
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_orders` (
	`{PREFIXE}orders_id_order` int(10) unsigned NOT NULL,
	`emc_operators_code_eo` char(4) NOT NULL,
	`price_ht_eor` float NOT NULL,
	`price_ttc_eor` float NOT NULL,
	`ref_emc_eor` char(20) NOT NULL,
	`service_eor` varchar(256) NOT NULL,
	`date_order_eor` datetime NOT NULL,
	`ref_ope_eor` varchar(20) NOT NULL,
	`info_eor` varchar(20) NOT NULL,
	`date_collect_eor` datetime NOT NULL,
	`date_del_eor` datetime NOT NULL,
	`date_del_real_eor` datetime NOT NULL,
	`tracking_eor` CHAR(255) NOT NULL,
	`parcels_eor` INT(4) NOT NULL,
	`base_url_eor` VARCHAR(255) NOT NULL,
	PRIMARY KEY (`{PREFIXE}orders_id_order`),
	KEY `emc_operators_code_eo`(`emc_operators_code_eo`)
) DEFAULT CHARSET=utf8;
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_orders_errors` (
	`{PREFIXE}orders_id_order` int(10) unsigned NOT NULL,
	`errors_eoe` TEXT NOT NULL,
	PRIMARY KEY (`{PREFIXE}orders_id_order`)
) DEFAULT CHARSET=utf8;
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_orders_parcels` (
	`{PREFIXE}orders_id_order` int(10) unsigned NOT NULL,
	`number_eop` INT(10) unsigned NOT NULL,
	`weight_eop` DECIMAL(5,2) NOT NULL,
	`length_eop` INT(3) NOT NULL,
	`width_eop` INT(3) NOT NULL,
	`height_eop` INT(3) NOT NULL,
	PRIMARY KEY (`{PREFIXE}orders_id_order`, `number_eop`)
) DEFAULT CHARSET=utf8;
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_orders_plannings` (
	`id_eopl` INT (10) unsigned NOT NULL AUTO_INCREMENT,
	`orders_eopl` TEXT NOT NULL,
	`stats_eopl` VARCHAR(500) NOT NULL,
	`errors_eopl` TEXT NOT NULL,
	`date_eopl` DATETIME NOT NULL,
	`type_eopl` INT(1) NOT NULL,
	PRIMARY KEY (`id_eopl`)
) DEFAULT CHARSET=utf8;
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_orders_post` (
	`{PREFIXE}orders_id_order` int(10) unsigned NOT NULL,
	`data_eopo` TEXT NOT NULL,
	`date_eopo` DATETIME NOT NULL,
	`type`  VARCHAR(20) NOT NULL DEFAULT 'eem',
	PRIMARY KEY ( `{PREFIXE}orders_id_order`, `type`)
) DEFAULT CHARSET=utf8;
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_orders_tmp` (
	`{PREFIXE}orders_id_order` int(10) unsigned NOT NULL,
	`data_eot` text NOT NULL,
	`date_eot` datetime NOT NULL,
	`errors_eot` text NOT NULL,
	PRIMARY KEY (`{PREFIXE}orders_id_order`)
) DEFAULT CHARSET=utf8;
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_points` (
	`{PREFIXE}orders_id_order` int(10) unsigned NOT NULL,
	`point_ep` varchar(10) NOT NULL,
	`emc_operators_code_eo` char(4) NOT NULL,
	PRIMARY KEY (`{PREFIXE}orders_id_order`)
) DEFAULT CHARSET=utf8;
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_services` (
  `id_es` int(3) NOT NULL AUTO_INCREMENT,
  `id_carrier` int(11) NOT NULL DEFAULT 0,
  `ref_carrier` int(11) NOT NULL DEFAULT 0,
  `code_es` varchar(128) NOT NULL,
  `emc_operators_code_eo` char(4) NOT NULL,
  `label_es` TEXT NOT NULL,
  `desc_store_es` TEXT NOT NULL,
  `label_store_es` TEXT DEFAULT NULL,
  `srv_name_fo_es` TEXT NOT NULL,
  `family_es` int(1) NOT NULL,
  `zone_fr_es` int(1) NOT NULL,
  `zone_es_es` int(1) NOT NULL,
  `zone_eu_es` int(1) NOT NULL,
  `zone_int_es` int(1) NOT NULL,
  `zone_restriction_es` TEXT DEFAULT NULL,
  `details_es` TEXT DEFAULT NULL,
  `delivery_due_time_es` TEXT NOT NULL,
  `delivery_type_es` int(1) NOT NULL,
  `is_parcel_pickup_point_es` int(1) NOT NULL,
  `is_parcel_dropoff_point_es` int(1) NOT NULL,
  `pickup_place_es` TEXT DEFAULT NULL,
  `dropoff_place_es` TEXT DEFAULT NULL,
  `pricing_es` int(1) NOT NULL,
  PRIMARY KEY (`id_es`),
  KEY `id_carrier` (`id_carrier`),
  KEY `emc_operators_code_eo` (`emc_operators_code_eo`),
  KEY `code_es` (`code_es`)
) DEFAULT CHARSET=utf8;
-- REQUEST --
INSERT INTO `{PREFIXE}emc_services` (`id_es`, `id_carrier`, `ref_carrier`, `code_es`, `emc_operators_code_eo`, `label_es`, `desc_store_es`, `label_store_es`, `srv_name_fo_es`, `family_es`, `zone_fr_es`, `zone_es_es`, `zone_eu_es`, `zone_int_es`, `zone_restriction_es`, `details_es`, `delivery_due_time_es`, `delivery_type_es`, `is_parcel_pickup_point_es`, `is_parcel_dropoff_point_es`, `pickup_place_es`, `dropoff_place_es`, `pricing_es`) VALUES
(1, 0, 0, 'ChronoRelais', 'CHRP', 'Chronopost (Chrono Relais)', 'a:4:{s:5:"en-us";s:35:"Next day delivery to a pickup point";s:5:"it-it";s:48:"Consegna in punto di ritiro il giorno successivo";s:5:"es-es";s:47:"Entrega en puntos de recogida al día siguiente";s:5:"fr-fr";s:26:"Livraison en relais en 24h";}', 'a:4:{s:5:"en-us";s:13:"Chrono Relais";s:5:"it-it";s:13:"Chrono Relais";s:5:"es-es";s:13:"Chrono Relais";s:5:"fr-fr";s:13:"Chrono Relais";}', 'a:4:{s:5:"en-us";s:10:"Chronopost";s:5:"it-it";s:10:"Chronopost";s:5:"es-es";s:10:"Chronopost";s:5:"fr-fr";s:10:"Chronopost";}', 1, 1, 0, 0, 0, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 20";i:1;s:61:"Maximum dimensions (cm): L + 2 X W + 2 X H ≤ 250, L ≤ 100";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 20";i:1;s:61:"Dimensioni massime (cm): L + 2 X l + 2 X A ≤ 250, L ≤ 100";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 20";i:1;s:65:"Dimensiones máximas (cm): L + 2 X An + 2 X Al ≤ 250, L ≤ 100";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 20";i:1;s:64:"Dimensions maximales (cm) : L + 2 X l + 2 X h ≤ 250, L ≤ 100";}}', 'a:4:{s:5:"en-us";s:3:"24h";s:5:"it-it";s:6:"24 ore";s:5:"es-es";s:3:"24h";s:5:"fr-fr";s:3:"24h";}', 3, 1, 2, 'a:4:{s:5:"en-us";s:13:"Chrono Relais";s:5:"it-it";s:13:"Chrono Relais";s:5:"es-es";s:13:"Chrono Relais";s:5:"fr-fr";s:16:"en Chrono Relais";}', 'a:4:{s:5:"en-us";s:11:"Post Office";s:5:"it-it";s:15:"ufficio postale";s:5:"es-es";s:18:"oficina de correos";s:5:"fr-fr";s:15:"bureau de Poste";}', 1),
(2, 0, 0, 'ChronoRelaisEurope', 'CHRP', 'Chronopost (Chrono Relais Europe)', 'a:4:{s:5:"en-us";s:41:"Delivery to a pickup point in 2 to 3 days";s:5:"it-it";s:39:"Consegna in punto di ritiro, da 2 a 3gg";s:5:"es-es";s:46:"Entrega en punto de recogida entre 2 y 3 días";s:5:"fr-fr";s:35:"Livraison en relais en 2 à 3 jours";}', 'a:4:{s:5:"en-us";s:20:"Chrono Relais Europe";s:5:"it-it";s:20:"Chrono Relais Europa";s:5:"es-es";s:20:"Chrono Relais Europa";s:5:"fr-fr";s:20:"Chrono Relais Europe";}', 'a:4:{s:5:"en-us";s:10:"Chronopost";s:5:"it-it";s:10:"Chronopost";s:5:"es-es";s:10:"Chronopost";s:5:"fr-fr";s:10:"Chronopost";}', 1, 0, 0, 1, 0, 'a:4:{s:5:"en-us";s:16:"Germany, Benelux";s:5:"it-it";s:17:"Germania, Benelux";s:5:"es-es";s:17:"Alemania, Benelux";s:5:"fr-fr";s:18:"Allemagne, Benelux";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 20";i:1;s:61:"Maximum dimensions (cm): L + 2 X W + 2 x H ≤ 250, L ≤ 100";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 20";i:1;s:61:"Dimensioni massime (cm): L + 2 X l + 2 X A ≤ 250, L ≤ 100";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 20";i:1;s:65:"Dimensiones máximas (cm): L + 2 X An + 2 X Al ≤ 250, L ≤ 100";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 20";i:1;s:64:"Dimensions maximales (cm) : L + 2 X l + 2 X h ≤ 250, L ≤ 100";}}', 'a:4:{s:5:"en-us";s:11:"2 to 3 days";s:5:"it-it";s:10:"da 2 a 3gg";s:5:"es-es";s:17:"entre 2 y 3 días";s:5:"fr-fr";s:12:"2 à 3 jours";}', 1, 1, 2, 'a:4:{s:5:"en-us";s:13:"Chrono Relais";s:5:"it-it";s:13:"Chrono Relais";s:5:"es-es";s:13:"Chrono Relais";s:5:"fr-fr";s:16:"en Chrono Relais";}', 'a:4:{s:5:"en-us";s:11:"Post Office";s:5:"it-it";s:15:"ufficio postale";s:5:"es-es";s:18:"oficina de correos";s:5:"fr-fr";s:15:"bureau de Poste";}', 1),
(3, 0, 0, 'Chrono13', 'CHRP', 'Chronopost (Chrono13)', 'a:4:{s:5:"en-us";s:37:"Next day home delivery (before 13:00)";s:5:"it-it";s:65:"Consegna a domicilio, il giorno successivo (prima dell''ore 13.00)";s:5:"es-es";s:59:"Entrega a domicilio, al día siguiente (antes de las 13:00)";s:5:"fr-fr";s:40:"Livraison à domicile en 24h (avant 13h)";}', 'a:4:{s:5:"en-us";s:9:"Chrono 13";s:5:"it-it";s:9:"Chrono 13";s:5:"es-es";s:9:"Chrono 13";s:5:"fr-fr";s:9:"Chrono 13";}', 'a:4:{s:5:"en-us";s:10:"Chronopost";s:5:"it-it";s:10:"Chronopost";s:5:"es-es";s:10:"Chronopost";s:5:"fr-fr";s:10:"Chronopost";}', 1, 1, 0, 0, 0, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 30";i:1;s:61:"Maximum dimensions (cm): L + 2 X W + 2 X H ≤ 300, L ≤ 140";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 30";i:1;s:61:"Dimensioni massime (cm): L + 2 X l + 2 X A ≤ 300, L ≤ 140";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 30";i:1;s:65:"Dimensiones máximas (cm): L + 2 X An + 2 X Al ≤ 300, L ≤ 140";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 30";i:1;s:64:"Dimensions maximales (cm) : L + 2 X l + 2 X h ≤ 300, L ≤ 140";}}', 'a:4:{s:5:"en-us";s:18:"24h (before 13:00)";s:5:"it-it";s:29:"24 ore (prima dell''ore 13.00)";s:5:"es-es";s:24:"24h (antes de las 13:00)";s:5:"fr-fr";s:15:"24h (avant 13h)";}', 3, 0, 2, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:11:"Post Office";s:5:"it-it";s:15:"ufficio postale";s:5:"es-es";s:18:"oficina de correos";s:5:"fr-fr";s:15:"bureau de Poste";}', 1),
(4, 0, 0, 'Chrono13Samedi', 'CHRP', 'Chronopost (Chrono13 Samedi)', 'a:4:{s:5:"en-us";s:43:"Saturday delivery within 24h (before 13:00)";s:5:"it-it";s:51:"Consegna de 24 ore il sabato (prima dell''ore 13.00)";s:5:"es-es";s:46:"Entrega en 24h el sábado (antes de las 13:00)";s:5:"fr-fr";s:38:"Livraison en 24h le samedi (avant 13h)";}', 'a:4:{s:5:"en-us";s:16:"Chrono 13 Samedi";s:5:"it-it";s:16:"Chrono 13 Samedi";s:5:"es-es";s:16:"Chrono 13 Samedi";s:5:"fr-fr";s:16:"Chrono 13 Samedi";}', 'a:4:{s:5:"en-us";s:10:"Chronopost";s:5:"it-it";s:10:"Chronopost";s:5:"es-es";s:10:"Chronopost";s:5:"fr-fr";s:10:"Chronopost";}', 1, 1, 0, 0, 0, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 30";i:1;s:61:"Maximum dimensions (cm): L + 2 X W + 2 X H ≤ 300, L ≤ 140";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 30";i:1;s:61:"Dimensioni massime (cm): L + 2 X l + 2 X A ≤ 300, L ≤ 140";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 30";i:1;s:65:"Dimensiones máximas (cm): L + 2 X An + 2 X Al ≤ 300, L ≤ 140";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 30";i:1;s:64:"Dimensions maximales (cm) : L + 2 X l + 2 X h ≤ 300, L ≤ 140";}}', 'a:4:{s:5:"en-us";s:36:"24h (before 13:00 saturday included)";s:5:"it-it";s:47:"24 ore (prima dell''ore 13.00 il sabato incluso)";s:5:"es-es";s:44:"24h (antes de las 13:00 el sábado incluido)";s:5:"fr-fr";s:29:"24h (avant 13h samedi inclus)";}', 3, 0, 2, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:11:"Post Office";s:5:"it-it";s:15:"ufficio postale";s:5:"es-es";s:18:"oficina de correos";s:5:"fr-fr";s:15:"bureau de Poste";}', 1),
(5, 0, 0, 'Chrono18', 'CHRP', 'Chronopost (Chrono18)', 'a:4:{s:5:"en-us";s:37:"Next day home delivery (before 18:00)";s:5:"it-it";s:65:"Consegna a domicilio, il giorno successivo (prima dell''ore 18.00)";s:5:"es-es";s:59:"Entrega a domicilio, al día siguiente (antes de las 18:00)";s:5:"fr-fr";s:40:"Livraison à domicile en 24h (avant 18h)";}', 'a:4:{s:5:"en-us";s:9:"Chrono 18";s:5:"it-it";s:9:"Chrono 18";s:5:"es-es";s:9:"Chrono 18";s:5:"fr-fr";s:9:"Chrono 18";}', 'a:4:{s:5:"en-us";s:10:"Chronopost";s:5:"it-it";s:10:"Chronopost";s:5:"es-es";s:10:"Chronopost";s:5:"fr-fr";s:10:"Chronopost";}', 1, 1, 0, 0, 0, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 30";i:1;s:61:"Maximum dimensions (cm): L + 2 X W + 2 X H ≤ 300, L ≤ 140";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 30";i:1;s:61:"Dimensioni massime (cm): L + 2 X l + 2 X A ≤ 300, L ≤ 140";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 30";i:1;s:65:"Dimensiones máximas (cm): L + 2 X An + 2 X Al ≤ 300, L ≤ 140";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 30";i:1;s:64:"Dimensions maximales (cm) : L + 2 X l + 2 X h ≤ 300, L ≤ 140";}}', 'a:4:{s:5:"en-us";s:18:"24h (before 18:00)";s:5:"it-it";s:29:"24 ore (prima dell''ore 18.00)";s:5:"es-es";s:24:"24h (antes de las 18:00)";s:5:"fr-fr";s:15:"24h (avant 18h)";}', 3, 0, 2, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:11:"Post Office";s:5:"it-it";s:15:"ufficio postale";s:5:"es-es";s:18:"oficina de correos";s:5:"fr-fr";s:15:"bureau de Poste";}', 1),
(6, 0, 0, 'ChronoInternationalClassic', 'CHRP', 'Chronopost (Chrono Classic)', 'a:4:{s:5:"en-us";s:28:"Home delivery in 2 to 4 days";s:5:"it-it";s:32:"Consegna a domicilio, da 2 a 4gg";s:5:"es-es";s:37:"Entrega a domicilio entre 2 y 4 días";s:5:"fr-fr";s:37:"Livraison à domicile en 2 à 4 jours";}', 'a:4:{s:5:"en-us";s:14:"Chrono Classic";s:5:"it-it";s:14:"Chrono Classic";s:5:"es-es";s:14:"Chrono Classic";s:5:"fr-fr";s:14:"Chrono Classic";}', 'a:4:{s:5:"en-us";s:10:"Chronopost";s:5:"it-it";s:10:"Chronopost";s:5:"es-es";s:10:"Chronopost";s:5:"fr-fr";s:10:"Chronopost";}', 1, 0, 0, 1, 0, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 30";i:1;s:61:"Maximum dimensions (cm): L + 2 X W + 2 X H ≤ 300, L ≤ 140";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 30";i:1;s:61:"Dimensioni massime (cm): L + 2 X l + 2 X A ≤ 300, L ≤ 140";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 30";i:1;s:65:"Dimensiones máximas (cm): L + 2 X An + 2 X Al ≤ 300, L ≤ 140";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 30";i:1;s:64:"Dimensions maximales (cm) : L + 2 X l + 2 X h ≤ 300, L ≤ 140";}}', 'a:4:{s:5:"en-us";s:11:"2 to 4 days";s:5:"it-it";s:10:"da 2 a 4gg";s:5:"es-es";s:17:"entre 2 y 4 días";s:5:"fr-fr";s:12:"2 à 4 jours";}', 2, 0, 2, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:11:"Post Office";s:5:"it-it";s:15:"ufficio postale";s:5:"es-es";s:18:"oficina de correos";s:5:"fr-fr";s:15:"bureau de Poste";}', 1),
(7, 0, 0, 'DomesticExpress', 'DHLE', 'DHL (Domestic Express)', 'a:4:{s:5:"en-us";s:22:"Next day home delivery";s:5:"it-it";s:42:"Consegna a domicilio, il giorno successivo";s:5:"es-es";s:37:"Entrega a domicilio al día siguiente";s:5:"fr-fr";s:28:"Livraison à domicile en 24h";}', 'a:4:{s:5:"en-us";s:8:"Domestic";s:5:"it-it";s:8:"Domestic";s:5:"es-es";s:8:"Domestic";s:5:"fr-fr";s:8:"Domestic";}', 'a:4:{s:5:"en-us";s:11:"DHL Express";s:5:"it-it";s:11:"DHL Express";s:5:"es-es";s:11:"DHL Express";s:5:"fr-fr";s:11:"DHL Express";}', 2, 1, 0, 0, 0, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 65";i:1;s:53:"Maximum dimensions (cm): L + W + H ≤ 310, L ≤ 115";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 65";i:1;s:53:"Dimensioni massime (cm): L + l + A ≤ 310, L ≤ 115";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 65";i:1;s:57:"Dimensiones máximas (cm): L + An + Al ≤ 310, L ≤ 115";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 65";i:1;s:56:"Dimensions maximales (cm) : L + l + h ≤ 310, L ≤ 115";}}', 'a:4:{s:5:"en-us";s:3:"24h";s:5:"it-it";s:6:"24 ore";s:5:"es-es";s:3:"24h";s:5:"fr-fr";s:3:"24h";}', 3, 0, 0, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:18:"on-site collection";s:5:"it-it";s:17:"raccolta sul sito";s:5:"es-es";s:19:"recogida en destino";s:5:"fr-fr";s:20:"enlèvement sur site";}', 1),
(8, 0, 0, 'ExpressWorldwide', 'DHLE', 'DHL (Express Worldwide)', 'a:4:{s:5:"en-us";s:35:"Home delivery within 24 to 72 hours";s:5:"it-it";s:36:"Consegna a domicilio, da 24 a 72 ore";s:5:"es-es";s:36:"Entrega a domicilio, entre 24h y 72h";s:5:"fr-fr";s:35:"Livraison à domicile en 24h à 72h";}', 'a:4:{s:5:"en-us";s:9:"Worldwide";s:5:"it-it";s:9:"Worldwide";s:5:"es-es";s:9:"Worldwide";s:5:"fr-fr";s:9:"Worldwide";}', 'a:4:{s:5:"en-us";s:11:"DHL Express";s:5:"it-it";s:11:"DHL Express";s:5:"es-es";s:11:"DHL Express";s:5:"fr-fr";s:11:"DHL Express";}', 2, 0, 0, 0, 1, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 30";i:1;s:53:"Maximum dimensions (cm): L + W + H ≤ 270, L ≤ 120";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 30";i:1;s:53:"Dimensioni massime (cm): L + l + A ≤ 270, L ≤ 120";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 30";i:1;s:57:"Dimensiones máximas (cm): L + An + Al ≤ 270, L ≤ 120";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 30";i:1;s:56:"Dimensions maximales (cm) : L + l + h ≤ 270, L ≤ 120";}}', 'a:4:{s:5:"en-us";s:14:"24 to 72 hours";s:5:"it-it";s:14:"da 24 a 72 ore";s:5:"es-es";s:15:"entre 24h y 72h";s:5:"fr-fr";s:10:"24h à 72h";}', 3, 0, 0, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:18:"on-site collection";s:5:"it-it";s:17:"raccolta sul sito";s:5:"es-es";s:19:"recogida en destino";s:5:"fr-fr";s:20:"enlèvement sur site";}', 1),
(9, 0, 0, 'InternationalEconomy', 'FEDX', 'FedEx (International Economy)', 'a:4:{s:5:"en-us";s:28:"Home delivery in 2 to 6 days";s:5:"it-it";s:56:"Consegna a domicilio da 2 a 6gg (tempi doganali esclusi)";s:5:"es-es";s:37:"Entrega a domicilio entre 2 y 6 días";s:5:"fr-fr";s:37:"Livraison à domicile en 2 à 6 jours";}', 'a:4:{s:5:"en-us";s:21:"International Economy";s:5:"it-it";s:21:"International Economy";s:5:"es-es";s:21:"International Economy";s:5:"fr-fr";s:21:"International Economy";}', 'a:4:{s:5:"en-us";s:5:"FedEx";s:5:"it-it";s:5:"FedEx";s:5:"es-es";s:5:"FedEx";s:5:"fr-fr";s:5:"FedEx";}', 2, 0, 0, 0, 1, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 65";i:1;s:61:"Maximum dimensions (cm): L + 2 X W + 2 X H ≤ 330, L ≤ 175";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 65";i:1;s:61:"Dimensioni massime (cm): L + 2 X l + 2 X A ≤ 330, L ≤ 175";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 65";i:1;s:65:"Dimensiones máximas (cm): L + 2 X An + 2 X Al ≤ 330, L ≤ 175";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 65";i:1;s:64:"Dimensions maximales (cm) : L + 2 X l + 2 X h ≤ 330, L ≤ 175";}}', 'a:4:{s:5:"en-us";s:11:"2 to 6 days";s:5:"it-it";s:10:"da 2 a 6gg";s:5:"es-es";s:17:"entre 2 y 6 días";s:5:"fr-fr";s:12:"2 à 6 jours";}', 2, 0, 0, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:18:"on-site collection";s:5:"it-it";s:17:"raccolta sul sito";s:5:"es-es";s:19:"recogida en destino";s:5:"fr-fr";s:20:"enlèvement sur site";}', 1),
(10, 0, 0, 'InternationalPriorityCC', 'FEDX', 'FedEx (International Priority)', 'a:4:{s:5:"en-us";s:35:"Home delivery within 24 to 48 hours";s:5:"it-it";s:36:"Consegna a domicilio, da 24 a 48 ore";s:5:"es-es";s:36:"Entrega a domicilio, entre 24h y 48h";s:5:"fr-fr";s:35:"Livraison à domicile en 24h à 48h";}', 'a:4:{s:5:"en-us";s:28:"FedEx International Priority";s:5:"it-it";s:28:"FedEx International Priority";s:5:"es-es";s:28:"FedEx International Priority";s:5:"fr-fr";s:22:"International Priority";}', 'a:4:{s:5:"en-us";s:5:"FedEx";s:5:"it-it";s:5:"FedEx";s:5:"es-es";s:5:"FedEx";s:5:"fr-fr";s:5:"FedEx";}', 2, 0, 0, 0, 1, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 65";i:1;s:61:"Maximum dimensions (cm): L + 2 X W + 2 X H ≤ 330, L ≤ 175";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 65";i:1;s:61:"Dimensioni massime (cm): L + 2 X l + 2 X A ≤ 330, L ≤ 175";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 65";i:1;s:65:"Dimensiones máximas (cm): L + 2 X An + 2 X Al ≤ 300, L ≤ 175";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 65";i:1;s:64:"Dimensions maximales (cm) : L + 2 X l + 2 X h ≤ 330, L ≤ 175";}}', 'a:4:{s:5:"en-us";s:14:"24 to 48 hours";s:5:"it-it";s:14:"da 24 a 48 ore";s:5:"es-es";s:15:"entre 24h y 48h";s:5:"fr-fr";s:10:"24h à 48h";}', 3, 0, 0, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:18:"on-site collection";s:5:"it-it";s:17:"raccolta sul sito";s:5:"es-es";s:19:"recogida en destino";s:5:"fr-fr";s:20:"enlèvement sur site";}', 1),
(11, 0, 0, 'CpourToi', 'MONR', 'Mondial Relay (C.pourToi®)', 'a:4:{s:5:"en-us";s:41:"Delivery to a pickup point in 3 to 5 days";s:5:"it-it";s:39:"Consegna in punto di ritiro, da 3 a 5gg";s:5:"es-es";s:46:"Entrega en punto de recogida entre 3 y 5 días";s:5:"fr-fr";s:35:"Livraison en relais en 3 à 5 jours";}', 'a:4:{s:5:"en-us";s:11:"C.pourToi®";s:5:"it-it";s:11:"C.pourToi®";s:5:"es-es";s:11:"C.pourToi®";s:5:"fr-fr";s:11:"C.pourToi®";}', 'a:4:{s:5:"en-us";s:13:"Mondial Relay";s:5:"it-it";s:13:"Mondial Relay";s:5:"es-es";s:13:"Mondial Relay";s:5:"fr-fr";s:13:"Mondial Relay";}', 1, 1, 0, 0, 0, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 30";i:1;s:53:"Maximum dimensions (cm): L + W + H ≤ 150, L ≤ 130";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 30";i:1;s:53:"Dimensioni massime (cm): L + l + A ≤ 150, L ≤ 130";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 30";i:1;s:57:"Dimensiones máximas (cm): L + An + Al ≤ 150, L ≤ 130";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 30";i:1;s:56:"Dimensions maximales (cm) : L + l + h ≤ 150, L ≤ 130";}}', 'a:4:{s:5:"en-us";s:11:"3 to 5 days";s:5:"it-it";s:10:"da 3 a 5gg";s:5:"es-es";s:17:"entre 3 y 5 días";s:5:"fr-fr";s:12:"3 à 5 jours";}', 1, 1, 1, 'a:4:{s:5:"en-us";s:12:"Point Relais";s:5:"it-it";s:12:"Point Relais";s:5:"es-es";s:12:"Point Relais";s:5:"fr-fr";s:15:"en Point Relais";}', 'a:4:{s:5:"en-us";s:12:"Point Relais";s:5:"it-it";s:12:"Point Relais";s:5:"es-es";s:12:"Point Relais";s:5:"fr-fr";s:12:"Point Relais";}', 1),
(12, 0, 0, 'CpourToiEurope', 'MONR', 'Mondial Relay (C.pourToi® - Europe)', 'a:4:{s:5:"en-us";s:41:"Delivery to a pickup point in 3 to 6 days";s:5:"it-it";s:39:"Consegna in punto di ritiro, da 3 a 6gg";s:5:"es-es";s:46:"Entrega en punto de recogida entre 3 y 6 días";s:5:"fr-fr";s:35:"Livraison en relais en 3 à 6 jours";}', 'a:4:{s:5:"en-us";s:20:"C.pourToi® - Europe";s:5:"it-it";s:11:"C.pourToi®";s:5:"es-es";s:11:"C.pourToi®";s:5:"fr-fr";s:20:"C.pourToi® - Europe";}', 'a:4:{s:5:"en-us";s:13:"Mondial Relay";s:5:"it-it";s:13:"Mondial Relay";s:5:"es-es";s:13:"Mondial Relay";s:5:"fr-fr";s:13:"Mondial Relay";}', 1, 0, 0, 1, 0, 'a:4:{s:5:"en-us";s:26:"Belgium, Luxembourg, Spain";s:5:"it-it";s:27:"Belgio, Lussemburgo, Spagna";s:5:"es-es";s:29:"Bélgica, Luxemburgo, España";s:5:"fr-fr";s:29:"Belgique, Luxembourg, Espagne";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 30";i:1;s:53:"Maximum dimensions (cm): L + W + H ≤ 150, L ≤ 130";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 30";i:1;s:53:"Dimensioni massime (cm): L + l + A ≤ 150, L ≤ 130";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 30";i:1;s:57:"Dimensiones máximas (cm): L + An + Al ≤ 150, L ≤ 130";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 30";i:1;s:56:"Dimensions maximales (cm) : L + l + h ≤ 150, L ≤ 130";}}', 'a:4:{s:5:"en-us";s:11:"3 to 6 days";s:5:"it-it";s:10:"da 3 a 6gg";s:5:"es-es";s:17:"entre 3 y 6 días";s:5:"fr-fr";s:12:"3 à 6 jours";}', 1, 1, 1, 'a:4:{s:5:"en-us";s:12:"Point Relais";s:5:"it-it";s:12:"Point Relais";s:5:"es-es";s:12:"Point Relais";s:5:"fr-fr";s:15:"en Point Relais";}', 'a:4:{s:5:"en-us";s:12:"Point Relais";s:5:"it-it";s:12:"Point Relais";s:5:"es-es";s:12:"Point Relais";s:5:"fr-fr";s:12:"Point Relais";}', 1),
(13, 0, 0, 'DomicileEurope', 'MONR', 'Mondial Relay (Domicile Europe)', 'a:4:{s:5:"en-us";s:28:"Home delivery in 3 to 6 days";s:5:"it-it";s:32:"Consegna a domicilio, da 3 a 6gg";s:5:"es-es";s:37:"Entrega a domicilio entre 3 y 6 días";s:5:"fr-fr";s:37:"Livraison à domicile en 3 à 6 jours";}', 'a:4:{s:5:"en-us";s:15:"Domicile Europe";s:5:"it-it";s:16:"Domicilio Europa";s:5:"es-es";s:16:"Domicilio Europa";s:5:"fr-fr";s:15:"Domicile Europe";}', 'a:4:{s:5:"en-us";s:13:"Mondial Relay";s:5:"it-it";s:13:"Mondial Relay";s:5:"es-es";s:13:"Mondial Relay";s:5:"fr-fr";s:13:"Mondial Relay";}', 1, 0, 0, 1, 0, 'a:4:{s:5:"en-us";s:67:"Germany, Belgium, Luxembourg, UK, Spain, Austria, Ireland, Portugal";s:5:"it-it";s:80:"Germania, Belgio, Lussemburgo, Regno Unito, Spagna, Austria, Irlanda, Portogallo";s:5:"es-es";s:90:"Alemania, Bélgica, Luxemburgo, Reino Unido, España, Alemania, Austria, Irlanda, Portugal";s:5:"fr-fr";s:82:"Allemagne, Belgique, Luxembourg, Royaume-Uni, Espagne, Autriche, Irlande, Portugal";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 30";i:1;s:53:"Maximum dimensions (cm): L + W + H ≤ 150, L ≤ 100";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 30";i:1;s:53:"Dimensioni massime (cm): L + l + A ≤ 150, L ≤ 100";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 30";i:1;s:57:"Dimensiones máximas (cm): L + An + Al ≤ 150, L ≤ 100";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 30";i:1;s:56:"Dimensions maximales (cm) : L + l + h ≤ 150, L ≤ 100";}}', 'a:4:{s:5:"en-us";s:11:"3 to 6 days";s:5:"it-it";s:10:"da 3 a 6gg";s:5:"es-es";s:17:"entre 3 y 6 días";s:5:"fr-fr";s:12:"3 à 6 jours";}', 2, 0, 1, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:12:"Point Relais";s:5:"it-it";s:12:"Point Relais";s:5:"es-es";s:12:"Point Relais";s:5:"fr-fr";s:12:"Point Relais";}', 1),
(14, 0, 0, 'ColissimoAccess', 'POFR', 'La Poste (Colissimo Access France)', 'a:4:{s:5:"en-us";s:43:"Home delivery without signature in 48 hours";s:5:"it-it";s:42:"Consegna a domicilio senza firma in 48 ore";s:5:"es-es";s:36:"Entrega a domicilio sin firma en 48h";s:5:"fr-fr";s:43:"Livraison à domicile sans signature en 48h";}', 'a:4:{s:5:"en-us";s:13:"Access France";s:5:"it-it";s:14:"Access Francia";s:5:"es-es";s:14:"Access Francia";s:5:"fr-fr";s:13:"Access France";}', 'a:4:{s:5:"en-us";s:9:"Colissimo";s:5:"it-it";s:9:"Colissimo";s:5:"es-es";s:9:"Colissimo";s:5:"fr-fr";s:9:"Colissimo";}', 1, 1, 0, 0, 0, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:3:{i:0;s:23:"Maximum weight (kg): 30";i:1;s:53:"Maximum dimensions (cm): L + W + H ≤ 150, L ≤ 100";i:2;s:26:"Delivery without signature";}s:5:"it-it";a:3:{i:0;s:21:"Peso massimo (kg): 30";i:1;s:53:"Dimensioni massime (cm): L + l + A ≤ 150, L ≤ 100";i:2;s:20:"Consegna senza firma";}s:5:"es-es";a:3:{i:0;s:19:"Peso máximo (kg): ";i:1;s:57:"Dimensiones máximas (cm): L + An + Al ≤ 150, L ≤ 100";i:2;s:17:"Entrega sin firma";}s:5:"fr-fr";a:3:{i:0;s:23:"Poids maximum (kg) : 30";i:1;s:56:"Dimensions maximales (cm) : L + l + h ≤ 150, L ≤ 100";i:2;s:21:"Remise sans signature";}}', 'a:4:{s:5:"en-us";s:8:"48 hours";s:5:"it-it";s:6:"48 ore";s:5:"es-es";s:3:"48h";s:5:"fr-fr";s:3:"48h";}', 2, 0, 2, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:11:"Post Office";s:5:"it-it";s:15:"ufficio postale";s:5:"es-es";s:18:"oficina de correos";s:5:"fr-fr";s:15:"bureau de Poste";}', 1),
(15, 0, 0, 'ColissimoExpert', 'POFR', 'La Poste (Colissimo Expert France)', 'a:4:{s:5:"en-us";s:52:"Home delivery with a signature within 24 to 48 hours";s:5:"it-it";s:54:"Consegna a domicilio con necessità di firma in 48 ore";s:5:"es-es";s:37:"Entrega a domicilio bajo firma en 48h";s:5:"fr-fr";s:45:"Livraison à domicile contre signature en 48h";}', 'a:4:{s:5:"en-us";s:13:"Expert France";s:5:"it-it";s:14:"Expert Francia";s:5:"es-es";s:14:"Expert Francia";s:5:"fr-fr";s:13:"Expert France";}', 'a:4:{s:5:"en-us";s:9:"Colissimo";s:5:"it-it";s:9:"Colissimo";s:5:"es-es";s:9:"Colissimo";s:5:"fr-fr";s:9:"Colissimo";}', 1, 1, 0, 0, 0, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:3:{i:0;s:23:"Maximum weight (kg): 30";i:1;s:53:"Maximum dimensions (cm): L + W + H ≤ 150, L ≤ 100";i:2;s:25:"Delivery with a signature";}s:5:"it-it";a:3:{i:0;s:21:"Peso massimo (kg): 30";i:1;s:53:"Dimensioni massime (cm): L + l + A ≤ 150, L ≤ 100";i:2;s:32:"Consegna con necessità di firma";}s:5:"es-es";a:3:{i:0;s:21:"Peso máximo (kg): 30";i:1;s:57:"Dimensiones máximas (cm): L + An + Al ≤ 150, L ≤ 100";i:2;s:18:"Entrega bajo firma";}s:5:"fr-fr";a:3:{i:0;s:23:"Poids maximum (kg) : 30";i:1;s:56:"Dimensions maximales (cm) : L + l + h ≤ 150, L ≤ 100";i:2;s:23:"Remise contre signature";}}', 'a:4:{s:5:"en-us";s:8:"48 hours";s:5:"it-it";s:6:"48 ore";s:5:"es-es";s:3:"48h";s:5:"fr-fr";s:3:"48h";}', 2, 0, 2, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:11:"Post Office";s:5:"it-it";s:15:"ufficio postale";s:5:"es-es";s:18:"oficina de correos";s:5:"fr-fr";s:15:"bureau de Poste";}', 1),
(16, 0, 0, 'EconomySelect', 'DHLE', 'DHL Express', 'a:4:{s:5:"en-us";s:28:"Home delivery in 2 to 5 days";s:5:"it-it";s:31:"Consegna a domicilio da 2 a 5gg";s:5:"es-es";s:48:"Entrega a domicilio entre 2 y 5 días, en Europa";s:5:"fr-fr";s:37:"Livraison à domicile en 2 à 5 jours";}', 'a:4:{s:5:"en-us";s:14:"Economy Select";s:5:"it-it";s:14:"Economy Select";s:5:"es-es";s:14:"Economy Select";s:5:"fr-fr";s:14:"Economy Select";}', 'a:4:{s:5:"en-us";s:11:"DHL Express";s:5:"it-it";s:11:"DHL Express";s:5:"es-es";s:11:"DHL Express";s:5:"fr-fr";s:11:"DHL Express";}', 2, 0, 0, 1, 0, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 65";i:1;s:53:"Maximum dimensions (cm): L + W + H ≤ 270, L ≤ 120";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 65";i:1;s:53:"Dimensioni massime (cm): L + l + A ≤ 270, L ≤ 120";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 65";i:1;s:57:"Dimensiones máximas (cm): L + An + Al ≤ 270, L ≤ 120";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 65";i:1;s:56:"Dimensions maximales (cm) : L + l + h ≤ 270, L ≤ 120";}}', 'a:4:{s:5:"en-us";s:11:"2 to 6 days";s:5:"it-it";s:10:"da 2 a 5gg";s:5:"es-es";s:17:"entre 2 y 5 días";s:5:"fr-fr";s:12:"2 à 5 jours";}', 2, 0, 0, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:18:"on-site collection";s:5:"it-it";s:17:"raccolta sul sito";s:5:"es-es";s:19:"recogida en destino";s:5:"fr-fr";s:20:"enlèvement sur site";}', 1),
(17, 0, 0, 'ExpressStandardInterColisMarch', 'SODX', 'Sodexi (Inter Express Standard)', 'a:4:{s:5:"en-us";s:29:"Home delivery in 7 to 10 days";s:5:"it-it";s:33:"Consegna a domicilio, da 7 a 10gg";s:5:"es-es";s:38:"Entrega a domicilio entre 7 y 10 días";s:5:"fr-fr";s:38:"Livraison à domicile en 7 à 10 jours";}', 'a:4:{s:5:"en-us";s:22:"Inter Express Standard";s:5:"it-it";s:22:"Inter Express Standard";s:5:"es-es";s:22:"Inter Express Standard";s:5:"fr-fr";s:22:"Inter Express Standard";}', 'a:4:{s:5:"en-us";s:6:"Sodexi";s:5:"it-it";s:6:"Sodexi";s:5:"es-es";s:6:"Sodexi";s:5:"fr-fr";s:6:"Sodexi";}', 2, 0, 0, 0, 1, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:24:"Maximum weight (kg): 500";i:1;s:61:"Maximum dimensions (cm): L + 2 X W + 2 X H ≤ 300, L ≤ 175";}s:5:"it-it";a:2:{i:0;s:22:"Peso massimo (kg): 500";i:1;s:61:"Dimensioni massime (cm): L + 2 X l + 2 X A ≤ 300, L ≤ 175";}s:5:"es-es";a:2:{i:0;s:22:"Peso máximo (kg): 500";i:1;s:65:"Dimensiones máximas (cm): L + 2 X An + 2 X Al ≤ 300, L ≤ 175";}s:5:"fr-fr";a:2:{i:0;s:24:"Poids maximum (kg) : 500";i:1;s:64:"Dimensions maximales (cm) : L + 2 X l + 2 X h ≤ 300, L ≤ 175";}}', 'a:4:{s:5:"en-us";s:12:"7 to 10 days";s:5:"it-it";s:11:"da 7 a 10gg";s:5:"es-es";s:18:"entre 7 y 10 días";s:5:"fr-fr";s:13:"7 à 10 jours";}', 2, 0, 0, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:18:"on-site collection";s:5:"it-it";s:17:"raccolta sul sito";s:5:"es-es";s:19:"recogida en destino";s:5:"fr-fr";s:20:"enlèvement sur site";}', 1),
(18, 0, 0, 'RelaisColis', 'SOGP', 'Relais Colis (Eco)', 'a:4:{s:5:"en-us";s:41:"Delivery to a pickup point in 4 to 6 days";s:5:"it-it";s:39:"Consegna in punto di ritiro, da 4 a 6gg";s:5:"es-es";s:46:"Entrega en punto de recogida entre 4 y 6 días";s:5:"fr-fr";s:35:"Livraison en relais en 4 à 6 jours";}', 'a:4:{s:5:"en-us";s:14:"Relais Colis®";s:5:"it-it";s:14:"Relais Colis®";s:5:"es-es";s:14:"Relais Colis®";s:5:"fr-fr";s:18:"Relais Colis® Eco";}', 'a:4:{s:5:"en-us";s:12:"Relais Colis";s:5:"it-it";s:12:"Relais Colis";s:5:"es-es";s:12:"Relais Colis";s:5:"fr-fr";s:12:"Relais Colis";}', 1, 1, 0, 0, 0, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 15";i:1;s:53:"Maximum dimensions (cm): L + W + H ≤ 170, L ≤ 130";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 15";i:1;s:53:"Dimensioni massime (cm): L + l + A ≤ 170, L ≤ 130";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 15";i:1;s:57:"Dimensiones máximas (cm): L + An + Al ≤ 170, L ≤ 130";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 15";i:1;s:56:"Dimensions maximales (cm) : L + l + h ≤ 170, L ≤ 130";}}', 'a:4:{s:5:"en-us";s:11:"4 to 6 days";s:5:"it-it";s:10:"da 4 a 6gg";s:5:"es-es";s:17:"entre 4 y 6 días";s:5:"fr-fr";s:12:"4 à 6 jours";}', 1, 1, 1, 'a:4:{s:5:"en-us";s:12:"Relais Colis";s:5:"it-it";s:12:"Relais Colis";s:5:"es-es";s:12:"Relais Colis";s:5:"fr-fr";s:17:"en Relais Colis®";}', 'a:4:{s:5:"en-us";s:12:"Relais Colis";s:5:"it-it";s:12:"Relais Colis";s:5:"es-es";s:12:"Relais Colis";s:5:"fr-fr";s:14:"Relais Colis®";}', 1),
(19, 0, 0, 'ExpressNational', 'TNTE', 'TNT (13:00 Express)', 'a:4:{s:5:"en-us";s:37:"Next day home delivery (before 13:00)";s:5:"it-it";s:65:"Consegna a domicilio, il giorno successivo (prima dell''ore 13.00)";s:5:"es-es";s:58:"Entrega a domicilio al día siguiente (antes de las 13:00)";s:5:"fr-fr";s:40:"Livraison à domicile en 24h (avant 13h)";}', 'a:4:{s:5:"en-us";s:13:"13:00 Express";s:5:"it-it";s:13:"13:00 Express";s:5:"es-es";s:13:"13:00 Express";s:5:"fr-fr";s:12:"National 13H";}', 'a:4:{s:5:"en-us";s:11:"TNT Express";s:5:"it-it";s:11:"TNT Express";s:5:"es-es";s:11:"TNT Express";s:5:"fr-fr";s:11:"TNT Express";}', 1, 1, 0, 0, 0, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 30";i:1;s:53:"Maximum dimensions (cm): L + W + H ≤ 170, L ≤ 130";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 30";i:1;s:53:"Dimensioni massime (cm): L + l + A ≤ 170, L ≤ 130";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 30";i:1;s:57:"Dimensiones máximas (cm): L + An + Al ≤ 170, L ≤ 130";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 30";i:1;s:56:"Dimensions maximales (cm) : L + l + h ≤ 170, L ≤ 130";}}', 'a:4:{s:5:"en-us";s:18:"24h (before 13:00)";s:5:"it-it";s:29:"24 ore (prima dell''ore 13.00)";s:5:"es-es";s:24:"24h (antes de las 13:00)";s:5:"fr-fr";s:15:"24h (avant 13h)";}', 3, 0, 0, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:18:"on-site collection";s:5:"it-it";s:17:"raccolta sul sito";s:5:"es-es";s:19:"recogida en destino";s:5:"fr-fr";s:20:"enlèvement sur site";}', 1),
(20, 0, 0, 'EconomyExpressInternational', 'TNTE', 'TNT (Economy Express)', 'a:4:{s:5:"en-us";s:28:"Home delivery in 2 to 5 days";s:5:"it-it";s:32:"Consegna a domicilio, da 2 a 5gg";s:5:"es-es";s:37:"Entrega a domicilio entre 2 y 5 días";s:5:"fr-fr";s:37:"Livraison à domicile en 2 à 5 jours";}', 'a:4:{s:5:"en-us";s:7:"Economy";s:5:"it-it";s:7:"Economy";s:5:"es-es";s:7:"Economy";s:5:"fr-fr";s:7:"Economy";}', 'a:4:{s:5:"en-us";s:11:"TNT Express";s:5:"it-it";s:11:"TNT Express";s:5:"es-es";s:11:"TNT Express";s:5:"fr-fr";s:11:"TNT Express";}', 2, 0, 0, 0, 1, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 70";i:1;s:54:"Maximum dimensions (cm): L ≤ 100, W ≤ 70, H ≤ 60";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 70";i:1;s:54:"Dimensioni massime (cm): L ≤ 100, l ≤ 70, A ≤ 60";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 70";i:1;s:58:"Dimensiones máximas (cm): L ≤ 100, An ≤ 70, Al ≤ 60";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 70";i:1;s:57:"Dimensions maximales (cm) : L ≤ 100, l ≤ 70, h ≤ 60";}}', 'a:4:{s:5:"en-us";s:11:"2 to 5 days";s:5:"it-it";s:10:"da 2 a 5gg";s:5:"es-es";s:17:"entre 2 y 5 días";s:5:"fr-fr";s:12:"2 à 5 jours";}', 2, 0, 0, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:18:"on-site collection";s:5:"it-it";s:17:"raccolta sul sito";s:5:"es-es";s:19:"recogida en destino";s:5:"fr-fr";s:20:"enlèvement sur site";}', 1),
(21, 0, 0, 'Standard', 'UPSE', 'UPS (Standard)', 'a:4:{s:5:"en-us";s:46:"Home delivery in 24 to 72 hours (before 19:00)";s:5:"it-it";s:59:"Consegna a domicilio, da 24 a 72 ore (prima dell''ore 19.00)";s:5:"es-es";s:56:"Entrega a domicilio entre 24h y 72h (antes de las 19:00)";s:5:"fr-fr";s:47:"Livraison à domicile en 24h à 72h (avant 19h)";}', 'a:4:{s:5:"en-us";s:8:"Standard";s:5:"it-it";s:8:"Standard";s:5:"es-es";s:8:"Standard";s:5:"fr-fr";s:8:"Standard";}', 'a:4:{s:5:"en-us";s:3:"UPS";s:5:"it-it";s:3:"UPS";s:5:"es-es";s:3:"UPS";s:5:"fr-fr";s:3:"UPS";}', 2, 1, 0, 1, 0, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 70";i:1;s:59:"Maximum dimensions (cm): L + 2 X W + 2 X H < 419, L ≤ 270";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 70";i:1;s:59:"Dimensioni massime (cm): L + 2 X l + 2 X A < 419, L ≤ 270";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 70";i:1;s:63:"Dimensiones máximas (cm): L + 2 X An + 2 X Al < 419, L ≤ 270";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 70";i:1;s:62:"Dimensions maximales (cm) : L + 2 X l + 2 X h < 419, L ≤ 270";}}', 'a:4:{s:5:"en-us";s:14:"24 to 72 hours";s:5:"it-it";s:14:"da 24 a 72 ore";s:5:"es-es";s:15:"entre 24h y 72h";s:5:"fr-fr";s:22:"24h à 72h (avant 19h)";}', 3, 0, 0, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:18:"on-site collection";s:5:"it-it";s:17:"raccolta sul sito";s:5:"es-es";s:19:"recogida en destino";s:5:"fr-fr";s:20:"enlèvement sur site";}', 1),
(22, 0, 0, 'ExpressSaver', 'UPSE', 'UPS (Express Saver)', 'a:4:{s:5:"en-us";s:28:"Home delivery in 1 to 5 days";s:5:"it-it";s:32:"Consegna a domicilio, da 1 a 5gg";s:5:"es-es";s:37:"Entrega a domicilio entre 1 y 5 días";s:5:"fr-fr";s:37:"Livraison à domicile en 1 à 5 jours";}', 'a:4:{s:5:"en-us";s:13:"Express Saver";s:5:"it-it";s:13:"Express Saver";s:5:"es-es";s:13:"Express Saver";s:5:"fr-fr";s:13:"Express Saver";}', 'a:4:{s:5:"en-us";s:3:"UPS";s:5:"it-it";s:3:"UPS";s:5:"es-es";s:3:"UPS";s:5:"fr-fr";s:3:"UPS";}', 2, 1, 0, 0, 1, 'a:4:{s:5:"en-us";s:0:"";s:5:"it-it";s:0:"";s:5:"es-es";s:0:"";s:5:"fr-fr";s:0:"";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 70";i:1;s:59:"Maximum dimensions (cm): L + 2 X W + 2 X H < 419, L ≤ 270";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 70";i:1;s:59:"Dimensioni massime (cm): L + 2 X l + 2 X A < 419, L ≤ 270";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 70";i:1;s:63:"Dimensiones máximas (cm): L + 2 X An + 2 X Al < 419, L ≤ 270";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 70";i:1;s:62:"Dimensions maximales (cm) : L + 2 X l + 2 X h < 419, L ≤ 270";}}', 'a:4:{s:5:"en-us";s:11:"1 to 5 days";s:5:"it-it";s:10:"da 1 a 5gg";s:5:"es-es";s:17:"entre 1 y 5 días";s:5:"fr-fr";s:12:"1 à 5 jours";}', 3, 0, 0, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:18:"on-site collection";s:5:"it-it";s:17:"raccolta sul sito";s:5:"es-es";s:19:"recogida en destino";s:5:"fr-fr";s:20:"enlèvement sur site";}', 1),
(23, 0, 0, 'StandardAP', 'UPSE', 'UPS (Standard Access Point)', 'a:4:{s:5:"en-us";s:59:"Delivery to a pickup point in 24 to 72 hours (before 19:00)";s:5:"it-it";s:66:"Consegna in punto di ritiro, da 24 a 72 ore (prima dell''ore 19.00)";s:5:"es-es";s:62:"Entrega en un Punto Kiala entre 24h y 72h (antes de las 19:00)";s:5:"fr-fr";s:45:"Livraison en relais en 24h à 72h (avant 19h)";}', 'a:4:{s:5:"en-us";s:21:"Standard Access Point";s:5:"it-it";s:20:"Standard Punto Kiala";s:5:"es-es";s:20:"Standard Punto Kiala";s:5:"fr-fr";s:21:"Standard Access Point";}', 'a:4:{s:5:"en-us";s:3:"UPS";s:5:"it-it";s:3:"UPS";s:5:"es-es";s:3:"UPS";s:5:"fr-fr";s:3:"UPS";}', 2, 1, 0, 1, 0, 'a:4:{s:5:"en-us";s:30:"UK, Spain, Belgium, Luxembourg";s:5:"it-it";s:40:"Regno Unito, Spagna, Belgio, Lussemburgo";s:5:"es-es";s:42:"Reino Unido, España, Bélgica, Luxemburgo";s:5:"fr-fr";s:42:"Royaume-Uni, Espagne, Belgique, Luxembourg";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 20";i:1;s:33:"Maximum dimensions (cm): L ≤ 80";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 20";i:1;s:33:"Dimensioni massime (cm): L ≤ 80";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 20";i:1;s:35:"Dimensiones máximas (cm): L ≤ 80";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 20";i:1;s:36:"Dimensions maximales (cm) : L ≤ 80";}}', 'a:4:{s:5:"en-us";s:29:"24 to 72 hours (before 19:00)";s:5:"it-it";s:37:"da 24 a 72 ore (prima dell''ore 19.00)";s:5:"es-es";s:36:"entre 24h y 72h (antes de las 19:00)";s:5:"fr-fr";s:22:"24h à 72h (avant 19h)";}', 3, 1, 0, 'a:4:{s:5:"en-us";s:12:"Access Point";s:5:"it-it";s:11:"Punto Kiala";s:5:"es-es";s:11:"Punto Kiala";s:5:"fr-fr";s:12:"Access Point";}', 'a:4:{s:5:"en-us";s:18:"on-site collection";s:5:"it-it";s:17:"raccolta sul sito";s:5:"es-es";s:19:"recogida en destino";s:5:"fr-fr";s:20:"enlèvement sur site";}', 1),
(24, 0, 0, 'PackSuiviEurope', 'IMXE', 'Happy Post (PackSuiviEurope)', 'a:4:{s:5:"en-us";s:28:"Home delivery in 3 to 9 days";s:5:"it-it";s:32:"Consegna a domicilio, da 3 a 9gg";s:5:"es-es";s:37:"Entrega a domicilio entre 3 y 9 días";s:5:"fr-fr";s:37:"Livraison à domicile en 3 à 9 jours";}', 'a:4:{s:5:"en-us";s:17:"Pack suivi Europe";s:5:"it-it";s:29:"Pacchetto monitoraggio Europa";s:5:"es-es";s:29:"Seguimiento de paquete Europa";s:5:"fr-fr";s:15:"PackSuiviEurope";}', 'a:4:{s:5:"en-us";s:10:"Happy-Post";s:5:"it-it";s:10:"Happy-Post";s:5:"es-es";s:10:"Happy-Post";s:5:"fr-fr";s:10:"Happy-Post";}', 1, 0, 0, 1, 0, 'a:4:{s:5:"en-us";s:48:"Germany (4kg), Italy (3kg), United Kingdom (5kg)";s:5:"it-it";s:47:"Germania (4kg), Italia (3kg), Regno Unito (5kg)";s:5:"es-es";s:47:"Alemania (4kg), Italia (3kg), Reino Unido (5kg)";s:5:"fr-fr";s:48:"Allemagne (4kg), Italie (3kg), Royaume-Uni (5kg)";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:22:"Maximum weight (kg): 5";i:1;s:53:"Maximum dimensions (cm): L + W + H ≤ 180, L ≤ 120";}s:5:"it-it";a:2:{i:0;s:20:"Peso massimo (kg): 5";i:1;s:53:"Dimensioni massime (cm): L + l + A ≤ 180, L ≤ 120";}s:5:"es-es";a:2:{i:0;s:20:"Peso máximo (kg): 5";i:1;s:57:"Dimensiones máximas (cm): L + An + Al ≤ 180, L ≤ 120";}s:5:"fr-fr";a:2:{i:0;s:22:"Poids maximum (kg) : 5";i:1;s:56:"Dimensions maximales (cm) : L + l + h ≤ 180, L ≤ 120";}}', 'a:4:{s:5:"en-us";s:11:"3 to 9 days";s:5:"it-it";s:10:"da 3 a 9gg";s:5:"es-es";s:17:"entre 3 y 9 días";s:5:"fr-fr";s:12:"3 à 9 jours";}', 2, 0, 1, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:12:"Point Relais";s:5:"it-it";s:12:"Point Relais";s:5:"es-es";s:12:"Point Relais";s:5:"fr-fr";s:12:"Point Relais";}', 1),
(25, 0, 0, 'StandardDepot', 'UPSE', 'UPS (Standard Dépôt)', 'a:4:{s:5:"en-us";s:46:"Home delivery in 24 to 72 hours (before 19:00)";s:5:"it-it";s:60:"Consegna a domicilio, da 24 a 72 ore (prima delle ore 19.00)";s:5:"es-es";s:56:"Entrega a domicilio entre 24h y 72h (antes de las 19:00)";s:5:"fr-fr";s:47:"Livraison à domicile en 24h à 72h (avant 19h)";}', 'a:4:{s:5:"en-us";s:16:"Standard Dépôt";s:5:"it-it";s:16:"Standard Dépôt";s:5:"es-es";s:16:"Standard Dépôt";s:5:"fr-fr";s:16:"Standard Dépôt";}', 'a:4:{s:5:"en-us";s:3:"UPS";s:5:"it-it";s:3:"UPS";s:5:"es-es";s:3:"UPS";s:5:"fr-fr";s:3:"UPS";}', 2, 1, 0, 1, 0, 'a:4:{s:5:"en-us";s:62:"Belgium, Germany, Italy, Luxembourg, Netherlands, Spain and UK";s:5:"it-it";s:72:"Belgio, Germania, Italia, Lussemburgo, Paesi Bassi, Regno Unito e Spagna";s:5:"es-es";s:77:"Alemania, Bélgica, España, Italia, Luxembourgo, Países Bajos y Reino Unido";s:5:"fr-fr";s:73:"Allemagne, Belgique, Espagne, Italie, Luxembourg, Pays-Bas et Royaume-Uni";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 20";i:1;s:33:"Maximum dimensions (cm): L ≤ 80";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 20";i:1;s:33:"Dimensioni massime (cm): L ≤ 80";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 20";i:1;s:35:"Dimensiones máximas (cm): L ≤ 80";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 20";i:1;s:36:"Dimensions maximales (cm) : L ≤ 80";}}', 'a:4:{s:5:"en-us";s:29:"24 to 72 hours (before 19:00)";s:5:"it-it";s:38:"da 24 a 72 ore (prima delle ore 19.00)";s:5:"es-es";s:22:"24h à 72h (avant 19h)";s:5:"fr-fr";s:22:"24h à 72h (avant 19h)";}', 3, 0, 1, 'a:4:{s:5:"en-us";s:4:"home";s:5:"it-it";s:9:"domicilio";s:5:"es-es";s:9:"domicilio";s:5:"fr-fr";s:11:"à domicile";}', 'a:4:{s:5:"en-us";s:12:"Access Point";s:5:"it-it";s:12:"Access Point";s:5:"es-es";s:12:"Access Point";s:5:"fr-fr";s:12:"Access Point";}', 1),
(26, 0, 0, 'StandardAPDepot', 'UPSE', 'UPS (Standard Access Point Dépôt)', 'a:4:{s:5:"en-us";s:59:"Delivery to a pickup point in 24 to 72 hours (before 19:00)";s:5:"it-it";s:68:"Consegna in puntu de ritirio, da 24 a 72 ore (prima delle ore 19.00)";s:5:"es-es";s:69:"Entrega en un punto Access Point entre 24h y 72h (antes de las 19:00)";s:5:"fr-fr";s:45:"Livraison en relais en 24h à 72h (avant 19h)";}', 'a:4:{s:5:"en-us";s:29:"Standard Access Point Dépôt";s:5:"it-it";s:29:"Standard Access Point Dépôt";s:5:"es-es";s:29:"Standard Access Point Dépôt";s:5:"fr-fr";s:29:"Standard Access Point Dépôt";}', 'a:4:{s:5:"en-us";s:3:"UPS";s:5:"it-it";s:3:"UPS";s:5:"es-es";s:3:"UPS";s:5:"fr-fr";s:3:"UPS";}', 2, 1, 0, 1, 0, 'a:4:{s:5:"en-us";s:62:"Belgium, Germany, Italy, Luxembourg, Netherlands, Spain and UK";s:5:"it-it";s:72:"Belgio, Germania, Italia, Lussemburgo, Paesi Bassi, Regno Unito e Spagna";s:5:"es-es";s:77:"Alemania, Bélgica, España, Italia, Luxembourgo, Países Bajos y Reino Unido";s:5:"fr-fr";s:73:"Allemagne, Belgique, Espagne, Italie, Luxembourg, Pays-Bas et Royaume-Uni";}', 'a:4:{s:5:"en-us";a:2:{i:0;s:23:"Maximum weight (kg): 21";i:1;s:33:"Maximum dimensions (cm): L ≤ 80";}s:5:"it-it";a:2:{i:0;s:21:"Peso massimo (kg): 21";i:1;s:33:"Dimensioni massime (cm): L ≤ 80";}s:5:"es-es";a:2:{i:0;s:21:"Peso máximo (kg): 21";i:1;s:35:"Dimensiones máximas (cm): L ≤ 80";}s:5:"fr-fr";a:2:{i:0;s:23:"Poids maximum (kg) : 21";i:1;s:36:"Dimensions maximales (cm) : L ≤ 80";}}', 'a:4:{s:5:"en-us";s:29:"24 to 72 hours (before 19:00)";s:5:"it-it";s:38:"da 24 a 72 ore (prima delle ore 19.00)";s:5:"es-es";s:36:"entre 24h y 72h (antes de las 19:00)";s:5:"fr-fr";s:22:"24h à 72h (avant 19h)";}', 3, 1, 1, 'a:4:{s:5:"en-us";s:12:"Access Point";s:5:"it-it";s:12:"Access Point";s:5:"es-es";s:12:"Access Point";s:5:"fr-fr";s:12:"Access Point";}', 'a:4:{s:5:"en-us";s:12:"Access Point";s:5:"it-it";s:12:"Access Point";s:5:"es-es";s:12:"Access Point";s:5:"fr-fr";s:12:"Access Point";}', 1);

-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_operators_authorized_contents` (
  `ope_code` char(4) NOT NULL,
  `id_eca` int(11) NOT NULL,
  UNIQUE KEY `pkey` (`ope_code`,`id_eca`)
) DEFAULT CHARSET=utf8;
-- REQUEST --
INSERT INTO `{PREFIXE}emc_operators_authorized_contents` (`ope_code`, `id_eca`) VALUES
('CHRP', 10100),
('CHRP', 10120),
('CHRP', 10130),
('CHRP', 10140),
('CHRP', 10150),
('CHRP', 10160),
('CHRP', 10170),
('CHRP', 10180),
('CHRP', 10190),
('CHRP', 10200),
('CHRP', 10210),
('CHRP', 10220),
('CHRP', 10230),
('CHRP', 10240),
('CHRP', 10250),
('CHRP', 10260),
('CHRP', 10280),
('CHRP', 10290),
('CHRP', 20100),
('CHRP', 20110),
('CHRP', 20120),
('CHRP', 30100),
('CHRP', 40100),
('CHRP', 40110),
('CHRP', 40120),
('CHRP', 40125),
('CHRP', 40130),
('CHRP', 40150),
('CHRP', 50100),
('CHRP', 50110),
('CHRP', 50113),
('CHRP', 50120),
('CHRP', 50130),
('CHRP', 50140),
('CHRP', 50150),
('CHRP', 50170),
('CHRP', 50180),
('CHRP', 50330),
('CHRP', 50350),
('CHRP', 50360),
('CHRP', 50380),
('CHRP', 50390),
('CHRP', 50395),
('CHRP', 50400),
('CHRP', 50440),
('CHRP', 50450),
('CHRP', 50490),
('CHRP', 50500),
('CHRP', 60105),
('CHRP', 60112),
('CHRP', 60122),
('CHRP', 60124),
('CHRP', 60126),
('CHRP', 60128),
('CHRP', 60129),
('CHRP', 60130),
('CHRP', 80100),
('CHRP', 80200),
('CHRP', 80300),
('CHRP', 80400),
('CHRP', 80500),
('DHLE', 10100),
('DHLE', 10120),
('DHLE', 10130),
('DHLE', 10140),
('DHLE', 10150),
('DHLE', 10160),
('DHLE', 10170),
('DHLE', 10180),
('DHLE', 10190),
('DHLE', 10200),
('DHLE', 10210),
('DHLE', 10220),
('DHLE', 10230),
('DHLE', 10240),
('DHLE', 10250),
('DHLE', 10260),
('DHLE', 10280),
('DHLE', 10290),
('DHLE', 30100),
('DHLE', 40100),
('DHLE', 40110),
('DHLE', 40120),
('DHLE', 40125),
('DHLE', 40130),
('DHLE', 40150),
('DHLE', 50100),
('DHLE', 50110),
('DHLE', 50113),
('DHLE', 50114),
('DHLE', 50120),
('DHLE', 50130),
('DHLE', 50140),
('DHLE', 50150),
('DHLE', 50170),
('DHLE', 50180),
('DHLE', 50330),
('DHLE', 50350),
('DHLE', 50360),
('DHLE', 50380),
('DHLE', 50390),
('DHLE', 50395),
('DHLE', 50400),
('DHLE', 50440),
('DHLE', 50450),
('DHLE', 50490),
('DHLE', 50500),
('DHLE', 60100),
('DHLE', 60102),
('DHLE', 60105),
('DHLE', 60112),
('DHLE', 60122),
('DHLE', 60126),
('DHLE', 60128),
('DHLE', 60129),
('DHLE', 80100),
('DHLE', 80200),
('DHLE', 80300),
('DHLE', 80400),
('DHLE', 80500),
('FEDX', 10100),
('FEDX', 10120),
('FEDX', 10130),
('FEDX', 10140),
('FEDX', 10150),
('FEDX', 10160),
('FEDX', 10170),
('FEDX', 10180),
('FEDX', 10190),
('FEDX', 10200),
('FEDX', 10210),
('FEDX', 10220),
('FEDX', 10230),
('FEDX', 10240),
('FEDX', 10250),
('FEDX', 10260),
('FEDX', 10280),
('FEDX', 10290),
('FEDX', 20100),
('FEDX', 20110),
('FEDX', 20120),
('FEDX', 30100),
('FEDX', 40100),
('FEDX', 40110),
('FEDX', 40120),
('FEDX', 40125),
('FEDX', 40130),
('FEDX', 40150),
('FEDX', 50100),
('FEDX', 50110),
('FEDX', 50113),
('FEDX', 50114),
('FEDX', 50120),
('FEDX', 50130),
('FEDX', 50140),
('FEDX', 50150),
('FEDX', 50170),
('FEDX', 50180),
('FEDX', 50330),
('FEDX', 50350),
('FEDX', 50360),
('FEDX', 50380),
('FEDX', 50390),
('FEDX', 50395),
('FEDX', 50400),
('FEDX', 50440),
('FEDX', 50450),
('FEDX', 50490),
('FEDX', 50500),
('FEDX', 60105),
('FEDX', 60112),
('FEDX', 60122),
('FEDX', 60124),
('FEDX', 60126),
('FEDX', 60128),
('FEDX', 60129),
('FEDX', 60130),
('FEDX', 80100),
('FEDX', 80200),
('FEDX', 80300),
('FEDX', 80400),
('FEDX', 80500),
('IMXE', 10100),
('IMXE', 10120),
('IMXE', 10130),
('IMXE', 10140),
('IMXE', 10150),
('IMXE', 10180),
('IMXE', 10190),
('IMXE', 10200),
('IMXE', 10210),
('IMXE', 10220),
('IMXE', 10230),
('IMXE', 10240),
('IMXE', 10250),
('IMXE', 10260),
('IMXE', 10280),
('IMXE', 10290),
('IMXE', 20100),
('IMXE', 20110),
('IMXE', 30100),
('IMXE', 40100),
('IMXE', 40110),
('IMXE', 40120),
('IMXE', 40125),
('IMXE', 40130),
('IMXE', 40150),
('IMXE', 50100),
('IMXE', 50110),
('IMXE', 50113),
('IMXE', 50120),
('IMXE', 50130),
('IMXE', 50140),
('IMXE', 50150),
('IMXE', 50170),
('IMXE', 50180),
('IMXE', 50330),
('IMXE', 50350),
('IMXE', 50360),
('IMXE', 50380),
('IMXE', 50390),
('IMXE', 50395),
('IMXE', 50400),
('IMXE', 50440),
('IMXE', 50450),
('IMXE', 50490),
('IMXE', 50500),
('IMXE', 60105),
('IMXE', 60112),
('IMXE', 60122),
('IMXE', 60124),
('IMXE', 60126),
('IMXE', 60128),
('IMXE', 60129),
('IMXE', 80100),
('IMXE', 80200),
('IMXE', 80300),
('IMXE', 80400),
('IMXE', 80500),
('MONR', 10100),
('MONR', 10120),
('MONR', 10130),
('MONR', 10140),
('MONR', 10150),
('MONR', 10180),
('MONR', 10190),
('MONR', 10200),
('MONR', 10210),
('MONR', 10220),
('MONR', 10230),
('MONR', 10240),
('MONR', 10250),
('MONR', 10260),
('MONR', 10280),
('MONR', 10290),
('MONR', 20100),
('MONR', 20110),
('MONR', 30100),
('MONR', 40100),
('MONR', 40110),
('MONR', 40120),
('MONR', 40125),
('MONR', 40130),
('MONR', 40150),
('MONR', 50100),
('MONR', 50110),
('MONR', 50113),
('MONR', 50120),
('MONR', 50130),
('MONR', 50140),
('MONR', 50150),
('MONR', 50170),
('MONR', 50180),
('MONR', 50330),
('MONR', 50350),
('MONR', 50360),
('MONR', 50380),
('MONR', 50390),
('MONR', 50395),
('MONR', 50400),
('MONR', 50440),
('MONR', 50450),
('MONR', 50490),
('MONR', 50500),
('MONR', 60105),
('MONR', 60112),
('MONR', 60122),
('MONR', 60124),
('MONR', 60126),
('MONR', 60128),
('MONR', 60129),
('MONR', 70200),
('MONR', 80100),
('MONR', 80200),
('MONR', 80300),
('MONR', 80400),
('MONR', 80500),
('POFR', 10100),
('POFR', 10120),
('POFR', 10130),
('POFR', 10140),
('POFR', 10150),
('POFR', 10160),
('POFR', 10170),
('POFR', 10180),
('POFR', 10190),
('POFR', 10200),
('POFR', 10210),
('POFR', 10220),
('POFR', 10230),
('POFR', 10240),
('POFR', 10250),
('POFR', 10260),
('POFR', 10280),
('POFR', 10290),
('POFR', 20100),
('POFR', 20110),
('POFR', 20120),
('POFR', 30100),
('POFR', 40100),
('POFR', 40110),
('POFR', 40120),
('POFR', 40125),
('POFR', 40130),
('POFR', 40150),
('POFR', 50100),
('POFR', 50110),
('POFR', 50113),
('POFR', 50120),
('POFR', 50130),
('POFR', 50140),
('POFR', 50150),
('POFR', 50170),
('POFR', 50180),
('POFR', 50330),
('POFR', 50350),
('POFR', 50360),
('POFR', 50380),
('POFR', 50390),
('POFR', 50395),
('POFR', 50400),
('POFR', 50440),
('POFR', 50450),
('POFR', 50490),
('POFR', 50500),
('POFR', 60105),
('POFR', 60112),
('POFR', 60122),
('POFR', 60124),
('POFR', 60126),
('POFR', 60128),
('POFR', 60129),
('POFR', 60130),
('POFR', 70200),
('POFR', 80100),
('POFR', 80200),
('POFR', 80300),
('POFR', 80400),
('POFR', 80500),
('SODX', 10100),
('SODX', 10120),
('SODX', 10130),
('SODX', 10140),
('SODX', 10150),
('SODX', 10180),
('SODX', 10190),
('SODX', 10200),
('SODX', 10210),
('SODX', 10220),
('SODX', 10230),
('SODX', 10240),
('SODX', 10250),
('SODX', 10260),
('SODX', 10280),
('SODX', 10290),
('SODX', 30100),
('SODX', 40100),
('SODX', 40110),
('SODX', 40125),
('SODX', 40130),
('SODX', 40150),
('SODX', 50100),
('SODX', 50110),
('SODX', 50113),
('SODX', 50120),
('SODX', 50130),
('SODX', 50140),
('SODX', 50150),
('SODX', 50170),
('SODX', 50180),
('SODX', 50330),
('SODX', 50350),
('SODX', 50360),
('SODX', 50380),
('SODX', 50390),
('SODX', 50395),
('SODX', 50400),
('SODX', 50440),
('SODX', 50450),
('SODX', 50490),
('SODX', 50500),
('SODX', 60105),
('SODX', 60112),
('SODX', 60122),
('SODX', 60124),
('SODX', 60126),
('SODX', 60128),
('SODX', 70100),
('SODX', 80100),
('SODX', 80200),
('SODX', 80300),
('SODX', 80400),
('SODX', 80500),
('SOGP', 10100),
('SOGP', 10120),
('SOGP', 10130),
('SOGP', 10140),
('SOGP', 10150),
('SOGP', 10180),
('SOGP', 10190),
('SOGP', 10200),
('SOGP', 10210),
('SOGP', 10220),
('SOGP', 10230),
('SOGP', 10240),
('SOGP', 10250),
('SOGP', 10260),
('SOGP', 10280),
('SOGP', 10290),
('SOGP', 30100),
('SOGP', 40100),
('SOGP', 40110),
('SOGP', 40120),
('SOGP', 40125),
('SOGP', 40130),
('SOGP', 40150),
('SOGP', 50100),
('SOGP', 50110),
('SOGP', 50113),
('SOGP', 50120),
('SOGP', 50130),
('SOGP', 50140),
('SOGP', 50150),
('SOGP', 50170),
('SOGP', 50180),
('SOGP', 50330),
('SOGP', 50350),
('SOGP', 50360),
('SOGP', 50380),
('SOGP', 50390),
('SOGP', 50395),
('SOGP', 50400),
('SOGP', 50440),
('SOGP', 50450),
('SOGP', 50490),
('SOGP', 50500),
('SOGP', 60105),
('SOGP', 60112),
('SOGP', 60122),
('SOGP', 60124),
('SOGP', 60126),
('SOGP', 60128),
('SOGP', 60129),
('SOGP', 70200),
('SOGP', 80100),
('SOGP', 80200),
('SOGP', 80300),
('SOGP', 80400),
('SOGP', 80500),
('TNTE', 10120),
('TNTE', 10130),
('TNTE', 10140),
('TNTE', 10150),
('TNTE', 10160),
('TNTE', 10170),
('TNTE', 10180),
('TNTE', 10190),
('TNTE', 10200),
('TNTE', 10210),
('TNTE', 10220),
('TNTE', 10230),
('TNTE', 10240),
('TNTE', 10250),
('TNTE', 10260),
('TNTE', 10280),
('TNTE', 10290),
('TNTE', 20100),
('TNTE', 20110),
('TNTE', 20120),
('TNTE', 30100),
('TNTE', 40100),
('TNTE', 40110),
('TNTE', 40120),
('TNTE', 40125),
('TNTE', 40130),
('TNTE', 40150),
('TNTE', 50100),
('TNTE', 50110),
('TNTE', 50113),
('TNTE', 50114),
('TNTE', 50120),
('TNTE', 50130),
('TNTE', 50140),
('TNTE', 50150),
('TNTE', 50170),
('TNTE', 50180),
('TNTE', 50330),
('TNTE', 50350),
('TNTE', 50360),
('TNTE', 50380),
('TNTE', 50390),
('TNTE', 50395),
('TNTE', 50400),
('TNTE', 50440),
('TNTE', 50450),
('TNTE', 50490),
('TNTE', 50500),
('TNTE', 60105),
('TNTE', 60112),
('TNTE', 60122),
('TNTE', 60124),
('TNTE', 60126),
('TNTE', 60128),
('TNTE', 60129),
('TNTE', 80100),
('TNTE', 80200),
('TNTE', 80300),
('TNTE', 80400),
('TNTE', 80500),
('UPSE', 10100),
('UPSE', 10120),
('UPSE', 10130),
('UPSE', 10140),
('UPSE', 10150),
('UPSE', 10160),
('UPSE', 10170),
('UPSE', 10180),
('UPSE', 10190),
('UPSE', 10200),
('UPSE', 10210),
('UPSE', 10220),
('UPSE', 10230),
('UPSE', 10240),
('UPSE', 10250),
('UPSE', 10260),
('UPSE', 10280),
('UPSE', 10290),
('UPSE', 20100),
('UPSE', 30100),
('UPSE', 40100),
('UPSE', 40110),
('UPSE', 40120),
('UPSE', 40125),
('UPSE', 40130),
('UPSE', 40150),
('UPSE', 50100),
('UPSE', 50110),
('UPSE', 50113),
('UPSE', 50120),
('UPSE', 50130),
('UPSE', 50140),
('UPSE', 50150),
('UPSE', 50170),
('UPSE', 50180),
('UPSE', 50330),
('UPSE', 50350),
('UPSE', 50360),
('UPSE', 50380),
('UPSE', 50390),
('UPSE', 50395),
('UPSE', 50400),
('UPSE', 50440),
('UPSE', 50450),
('UPSE', 50490),
('UPSE', 50500),
('UPSE', 60105),
('UPSE', 60112),
('UPSE', 60122),
('UPSE', 60126),
('UPSE', 60128),
('UPSE', 80100),
('UPSE', 80200),
('UPSE', 80300),
('UPSE', 80400),
('UPSE', 80500);
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_tracking` (
	`id_et` int(11) NOT NULL AUTO_INCREMENT,
	`{PREFIXE}orders_id_order` int(10) unsigned NOT NULL,
	`state_et` char(4) NOT NULL,
	`date_et` datetime NOT NULL,
	`text_et` text NOT NULL,
	`localisation_et` varchar(50) NOT NULL,
	PRIMARY KEY (`id_et`),
	KEY `{PREFIXE}orders_id_order` (`{PREFIXE}orders_id_order`)
) DEFAULT CHARSET=utf8;
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_cache` (
	`cache_key` VARCHAR(255) NOT NULL,
	`cache_data` longtext NOT NULL,
	`expiration_date` DATETIME NOT NULL,
	PRIMARY KEY (`cache_key`)
) DEFAULT CHARSET=utf8;
-- REQUEST --
CREATE TABLE IF NOT EXISTS `{PREFIXE}emc_cart_tmp` (
	`id_cart` int(10) NOT NULL,
	`selected_point` VARCHAR(40) NOT NULL,
	PRIMARY KEY (`id_cart`)
) DEFAULT CHARSET=utf8;
