/**
 * Common behaviour for modules configuration
 *
 * @category Prestashop
 * @category Module
 * @author Samdha <contact@samdha.net>
 * @copyright Samdha
 * @license commercial license see license.txt
**/

/**
 * Init module interface
 */

; samdha_module.preInit = function() {
	"use strict";

	var $ = samdha_module.$;
	var config = samdha_module.config;

};

samdha_module.postInit = function () {
    "use strict";

    var $ = samdha_module.$;
    var config = samdha_module.config;
    var messages = samdha_module.messages;

	/**
	 * reset columns index
	 */
	var orderColumns = function() {
		var index = 0;
		var $lines = $( "#" + config.short_name + "fields tbody tr" );
		$lines.each(function() {
			var $this = $(this);
			$('select, input', $this).each(function() {
				if ($(this).prop('name')) {
					$(this).prop('name', $(this).prop('name').replace(/\[fields\]\[\d+\]/g, '[fields]['+index+']'));
				}
			});
			if (index%2) {
				$this.addClass('alt_row');
			} else {
				$this.removeClass('alt_row');
			}
			index++;
			if (index == $lines.length) {
				$this.addClass('last');
			} else {
				$this.removeClass('last');
			}
		});
	};

	var columnsTableWidth = function() {
		if (!config.version_15) {
			if ($('#' + config.short_name + 'fields').width() > 413) {
				$('#' + config.short_name + 'fields').parent().css({
					'paddingLeft' : '0',
					'clear' : 'left'
				});
			} else {
				$('#' + config.short_name + 'fields').parent().removeAttr('style');
			}
		}
	};

	var testAjax = function() {
		$.ajax({
			"url": config.module_path + 'export.php',
			"type": "POST",
			"dataType" : "json",
			"data": {
				"ajax": 1,
				"action": "ajaxTest"
			}
		})
		.done(function(json) {
			if (json.status != 'success') {
				samdha_module.displayError(messages.access_error);
			}
		})
		.fail(function() {
			samdha_module.displayError(messages.ajax_error);
		});
	};

	/**
	 * pre export the catalog
	 */
	var exportCatalog = function(current, first_attribute, total, done, filename) {
		$.ajax({
			"url": config.module_path + 'export.php',
			"type": "POST",
			"dataType" : "json",
			"cache": false,
			"data": {
				"ajax": 1,
				"action": "preExportCatalog",
				"current": current,
				"first_attribute": first_attribute,
				"total": total,
				"done": done,
				"filename": filename,
				"model": $('#' + config.short_name + '_model').val(),
				"id_shop": config.models_shop[$('#' + config.short_name + '_model').val()]
			}
		})
		.done(function(json) {
			if (json.status == 'success') {
				if (json.data.next == -1) {
					$("#model_export_image").hide();
					$("#model_export_button").show();
					var parameters = {
						'filename': json.data.filename,
						'model': $("#" + config.short_name + "_model").val(),
						'actionExportModel': 1,
                        'rand': Math.random() 
					};
					window.location = config.module_url + '&' + $.param(parameters);
				} else {
					var percent = 100 * json.data.done / json.data.total;
					$("#model_export_image").html("<span title='" + json.data.done + '/' + json.data.total + "'><img style='vertical-align: middle' src='../img/loader.gif'/> " + percent.toFixed(2) + '%</span>');
					setTimeout(function(){exportCatalog(json.data.next, json.data.last_attribute, json.data.total, json.data.done, json.data.filename);},1);
				}
			} else {
				if (json.message) {
					alert(json.message);
				}
				$("#model_export_image").remove();
				$("#model_export_button").show();
			}
		})
		.fail(function() {
			$("#model_export_image").remove();
			$("#model_export_button").show();
		});
	};

	/**
	 * pre run the export
	 */
	var runExport = function(current, first_attribute, total, done, filename) {
		$.ajax({
			"url": config.module_path + 'export.php',
			"type": "POST",
			"cache": false,
			"dataType" : "json",
			"data": {
				"ajax": 1,
				"action": "preExportCatalog",
				"current": current,
				"first_attribute": first_attribute,
				"done": done,
				"total": total,
				"filename": filename,
				"export": $('#' + config.short_name + '_export').val(),
				"id_shop": config.exports_shop[$('#' + config.short_name + '_export').val()]
			}
		})
		.done(function(json) {
			if (json.status == 'success') {
				if (json.data.next == -1) {
					$.ajax({
						"url": config.module_path + 'export.php',
						"type": "POST",
						"dataType" : "json",
						"cache": false,
						"data": {
							"ajax": 1,
							"action": "postExportCatalog",
							"filename": json.data.filename,
							"export": $('#' + config.short_name + '_export').val(),
							"id_shop": config.exports_shop[$('#' + config.short_name + '_export').val()]
						},
						success: function(json) {
							if (json.status == 'success') {
								alert(messages.done);
							} else {
								if (json.message) {
									alert(json.message);
								}
							}
							$("#run_export_image").remove();
							$("#export_run_button").show();
						}
					});
				} else {
					var percent = 100 * json.data.done / json.data.total;
					$("#run_export_image").html("<span title='" + json.data.done + '/' + json.data.total + "'><img style='vertical-align: middle' src='../img/loader.gif'/> " + percent.toFixed(2) + '%</span>');
					setTimeout(function(){runExport(json.data.next, json.data.last_attribute, json.data.total, json.data.done, json.data.filename);},1);
				}
			} else {
				if (json.message) {
					alert(json.message);
				}
				$("#run_export_image").remove();
				$("#export_run_button").show();
			}
		})
		.fail(function() {
			$("#run_export_image").remove();
			$("#export_run_button").show();
		});
	};

	// fake select
	if (config.active_tab && config.active_tab != 'tabModel') {
		var active = $('#samdha_tab').tabs('option', 'active');
		$('#samdha_tab').tabs("option", 'active', 0);
		if (!config.version_15) {
			$('#' + config.short_name + 'fields').width('413');
		}
		var td_width = $('#' + config.short_name + 'fields td:first').width();
		var td_width2 = $('#' + config.short_name + 'fields td:first').next().width();
		$('#' + config.short_name + 'fields .fake_select').each(function() {
			$(this).width(td_width).addClass('chosen-container chosen-container-single').find('span').wrap('<a/>');
			$('a', this).addClass('chosen-single').append('<div><b/></div>');
		});
		$('#' + config.short_name + 'fields .field_title input').width(td_width2);
		if (!config.version_15) {
			$('#' + config.short_name + 'fields').width('');
		}
		$('#samdha_tab').tabs("option", 'active', active);
	}

	$('#' + config.short_name + '_folder').hide();
	$("#jqueryFileTree_div").fileTree({
		root: "",
		startFolder: $('#' + config.short_name + '_folder').val(),
		script: config.module_url + "&ajax=1&action=getFileTree&dontsave=1"
	}, function(file) {
        $('#' + config.short_name + '_folder').val(file);
    });
	$('#' + config.short_name + '_directory').prop('readonly', 'readonly');
	$("#jqueryFileTree_div2").fileTree({
		root: "",
		startFolder: $('#' + config.short_name + '_directory').val(),
		script: config.module_url + "&ajax=1&action=getFileTree&dontsave=0"
	}, function(file) {
        $('#' + config.short_name + '_directory').val(file);
    });

	// buttons
	$('#samdha_content .actions_list .action_select')
		.button({
			text: false,
			icons: {
				primary: "ui-icon-triangle-1-s"
			}
		})
		.click(function() {
			var menu = $( this ).parent().next().show().position({
				my: "left top",
				at: "left bottom",
				of: this
			});
			$( document ).one( "click", function() {
				menu.hide();
			});
			return false;
		})
		.parent()
			.buttonset()
			.next()
				.hide()
				.menu();
	$('#samdha_content .actions_list button.action').click(function(event) {
		if (!$(this).prop('name')) {
			setTimeout(
				(function(el) {
					return function() {
						el.focus().click();
					};
				})($(this).next()),
				1
			);
			event.preventDefault();
		}
	});
	$('#samdha_content .actions_list ul a')
		.on('click', function(event) {
			event.preventDefault();
			var $current_button = $(this);
			$current_button.tooltip('destroy');
			$('button.action', $(this).parents('.actions_list'))
				.tooltip('destroy')
				.prop('name', $current_button.prop('rel'))
				.prop('title', $current_button.attr('title'))
				.button({label:$current_button.text()})
				.tooltip({
		            position: {
		                my: "center bottom-20",
		                at: "center top",
		                using: function( position, feedback ) {
		                    $( this ).css( position );
		                    $( "<div>" )
		                        .addClass( "arrow" )
		                        .addClass( feedback.vertical )
		                        .addClass( feedback.horizontal )
		                        .appendTo( this );
		                }
		            }
		        })
				.click();
			$current_button.tooltip({
	            position: {
	                my: "right center",
	                at: "left center"
	            }
	        });
		})
		.tooltip('destroy')
		.tooltip({
            position: {
                my: "right center",
                at: "left center"
            }
        });


	$('#samdha_content .actions_list').on('click', 'button[name=actionDeleteModel], button[name=actionDeleteExport]', function (event) {
		if (!confirm(messages.delete_confirmation))
			event.preventDefault();
	});

	$('#samdha_content .actions_list').on('click', 'button[name=actionUploadModel]', function (event) {
		if (!$('#model_upload_input').val()) {
			$('#model_upload_input').focus().click();
			event.preventDefault();
		}
	});

	$("#samdha_content input[name=actionSaveModel]").click(function (event) {
		if ($("#" + config.short_name + "model_name").val() == '') {
			event.preventDefault();
			$("#" + config.short_name + "model_name").focus();
			alert(messages.missing_name);
		}
		if (
			($("#" + config.short_name + "_model").length > 0)
			&& ($("#" + config.short_name + "_model").val() != $("#" + config.short_name + "_current_model").val())
			&& !confirm(messages.override_confirmation)
		) {
			event.preventDefault();
		}
	});

	$("#samdha_content input[name=actionSaveExport]").click(function (event) {
		if ($("#" + config.short_name + "export_name").val() == '') {
			event.preventDefault();
			$("#" + config.short_name + "export_name").focus();
			alert(messages.missing_name);
		}

		if (
			($("#" + config.short_name + "_id_employee").val() == '0')
			&& ($("#" + config.short_name + "_folder").val() == '')
		) {
			event.preventDefault();
			$("#" + config.short_name + "_id_employee").focus();
			alert(messages.missing_action);
		}

		if ($("input." + config.short_name + "_days:checked").length == 0) {
			event.preventDefault();
			$("input." + config.short_name + "_days:first").focus();
			alert(messages.missing_days);
		}

		if (
			($("#" + config.short_name + "_export").length > 0)
			&& ($("#" + config.short_name + "_export").val() != $("#" + config.short_name + "_current_export").val())
			&& !confirm(messages.override_confirmation)
		) {
			event.preventDefault();
		}
	});

	$("#model_export_button").click(function (event) {
		event.preventDefault();
		$(this).hide().after("<span id='model_export_image'><img style='vertical-align: middle' src='../img/loader.gif'/> 0.00%</span>");
		exportCatalog(0, 0, 0, 0, '');
	});

	$("#export_run_button").click(function (event) {
		event.preventDefault();
		$(this).hide().after("<span id='run_export_image'><img style='vertical-align: middle' src='../img/loader.gif'/> 0.00%</span>");
		runExport(0, 0, 0, 0, '');
	});

	$('#samdha_content').on('click', '.field_add', function (event) {
		var $original = $(this).parent().parent();
		$('select', $original).chosen('destroy');
		var $field = $original.clone();
		$field.insertAfter($original);
		orderColumns();
		$('td', $field).removeClass('ui-state-hover');
		$('select', $field)[0].selectedIndex = 0;
		$('input.field_title', $field).val($('select option:selected', $field).text()).data('modified', false);
		$('span', $field).css('display','inline-block');
		$('select', $original).chosen();
		$('.field_value, input', $field).val('');
		$('select', $field).change().chosen().focus();
	});

	$('#samdha_content').on('click', '.field_delete', function (event) {
		$(this).parent().parent().remove();
		orderColumns();
	});

	// update columns title according to column value
	// unless if title has been customized
	$('#' + config.short_name + 'fields').on('change', 'select', function (event) {
		var $line = $(this).parent().parent();
		if (!$('input.field_title', $line).data('modified')) {
			$('input.field_title', $line).val($('option:selected', $(this)).text());
		}
		if ($(this).val() == 'fix') {
			$('div.field_value input', $line).prop('placeholder', messages.value);
			$('div.field_value', $line).show();
		} else if (
			$(this).val() == 'image_url_all'
			|| $(this).val() == 'category_all'
			|| $(this).val() == 'category_name_all'
			|| $(this).val() == 'id_category_all'
			|| $(this).val() == 'tag_all'
			|| $(this).val() == 'legend_all'
		) {
			$('div.field_value input', $line).prop('placeholder', messages.separator);
			$('div.field_value', $line).show();
		} else {
			$('div.field_value', $line).hide();
		}
	});

	// fake select
    if (!config.active_tab) {
        var td_width = $('#' + config.short_name + 'fields td:first').width();
        var td_width2 = $('#' + config.short_name + 'fields td:first').next().width();
        $('#' + config.short_name + 'fields .fake_select').each(function() {
            $(this).width(td_width).addClass('chosen-container chosen-container-single').find('span').wrap('<a/>');
            $('a', this).addClass('chosen-single').append('<div><b/></div>');
        });
        $('#' + config.short_name + 'fields .field_title input').width(td_width2);
    }
	$('#' + config.short_name + 'fields').on('click', '.fake_select', function (event) {
		var $input = $('input', this).first();
		var $select = $('<select/>').addClass('input_large').width($(this).width()).prop('name', $input.prop('name'));

		$('span', this).html('<img style="padding-top: 4px" height="16" src="../img/loader.gif">');
		for (var key in config.possible_fields) {
			$select.append(
				$('<option>', { value : key })
          			.text(config.possible_fields[key])
          	);
		};
		$select.val($input.val());
		$(this).after($select);
		$(this).remove();
		$select.on('chosen:ready', function(event, args) {
			var $this = $(this);
			$this.off('chosen:ready');
			setTimeout(function(){
				$this.trigger('chosen:open');
			},1);
		}).chosen({
			placeholder_text_single: ''
		});
    });

	// set column titles as customized
	$('#' + config.short_name + 'fields').on('change', 'input.field_title', function(event) {
		$(this).data('modified', true);
	});

	// check if column titles have been customized
	$("#" + config.short_name + "fields input.field_title").each(function() {
		var $this = $(this);
		var $line = $this.parent().parent();

		$this.data('modified', $this.val() != $('select option:selected', $line).text());
	});

	$('input[name="model[datas][header]"]').change(function() {
		if ($('input[name="model[datas][header]"]:checked').val() == '1') {
			$('#' + config.short_name + 'fields .field_title').show();
		} else {
			$('#' + config.short_name + 'fields .field_title').hide();
		}
		columnsTableWidth();
	});
	$('input[name="model[datas][decoration]"]').change(function() {
		if ($('input[name="model[datas][decoration]"]:checked').val() == '1') {
			$('#' + config.short_name + 'fields .field_decoration').show();
		} else {
			$('#' + config.short_name + 'fields .field_decoration').hide();
		}
		columnsTableWidth();
	});
	$('input[name="model[datas][separator]"]').keydown(function(event) {
		var code = event.keyCode || event.which;
		if (code == '9') {
			if ($(this).val() == '') {
				$(this).val('	');
				event.preventDefault();
			}
		}
	});

	columnsTableWidth();
	testAjax();
};
