<?php


/**Include for checksystem**/


require_once(_PS_MODULE_DIR_.$this->name.'/lib/GMC_check.php');


$check = new BT_GMCChecks();


$prerequisite = array(


	'output_file' => (int)$check->checkOutputFile(),


);





/* Languages */


$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));


$defaultCurrency = new Currency((int)(Configuration::get('PS_CURRENCY_DEFAULT')));


$languages = $this->getAvailableLanguages($this->id_shop);


$taxonomyCountries = $this->getAvailableTaxonomyCountries();


$iso = Language::getIsoById($defaultLanguage);


$isoCurrent = Language::getIsoById((int)($cookie->id_lang));


$divLangName = 'homecat_div';


global $smarty;





/* Attributes group options */


$attributeGroups = AttributeGroup::getAttributesGroups((int)($cookie->id_lang));





/* Features */


$features = Feature::getFeatures((int)($cookie->id_lang));





/* Product conditions */


$conditions = array(


	'new' => $this->l('New', 'form_config'),


	'used' => $this->l('Used', 'form_config'),


	'refurbished' => $this->l('Refurbished', 'form_config'));





/* Product description type */


$p_description_types = array(


	1 => $this->l('Short description', 'form_config'),


	2 => $this->l('Long description', 'form_config'),


	3 => $this->l('Both', 'form_config'),


	4 => $this->l('Meta-description', 'form_config')


);





/* Selected categories */


$cIndex = array();


$categories = Category::getCategories((int)($cookie->id_lang), true);


$home_categories = $this->getHomeCategories((int)($cookie->id_lang));


$indexedCategories = $this->getCategories();


$bIndex = array();


$indexedBrands = $this->getBrands();








/* Product count */


if ($this->_configuration['GMERCHANTCENTER_EXPORT_MODE'] == 0)


{


	$sql = 'SELECT COUNT(p.`id_product`) as cnt FROM `'._DB_PREFIX_.'product` p'


		. ((version_compare(_PS_VERSION_, '1.5', '>') && Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')) ? Shop::addSqlAssociation('product', 'p', false) : '')


		. ' WHERE p.`active` = 1 '


		. ((version_compare(_PS_VERSION_, '1.5', '>') && Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')) ? ' AND product_shop.id_shop = '.(int)($this->id_shop) : '')


		. ((version_compare(_PS_VERSION_, '1.5', '>') && Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')) ? ' AND product_shop.`id_category_default` IN ' : ' AND p.`id_category_default` IN ')


		. ' (SELECT id_category FROM `'._DB_PREFIX_.'gmc_categories` gc '.((version_compare(_PS_VERSION_, '1.5', '>') && Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')) ? ' WHERE gc.`id_shop` = '.(int)($this->id_shop) : '').')';


}


if ($this->_configuration['GMERCHANTCENTER_EXPORT_MODE'] == 1)


{


	$sql = 'SELECT COUNT(p.`id_product`) as cnt FROM `'._DB_PREFIX_.'product` p'


		. ((version_compare(_PS_VERSION_, '1.5', '>') && Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')) ? Shop::addSqlAssociation('product', 'p', false) : '')


		. ' WHERE p.`active` = 1 '


		. ((version_compare(_PS_VERSION_, '1.5', '>') && Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')) ? ' AND product_shop.id_shop = '.(int)($this->id_shop) : '')


		. ((version_compare(_PS_VERSION_, '1.5', '>') && Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')) ? ' AND product_shop.`id_manufacturer` IN ' : ' AND p.`id_manufacturer` IN ')


		. ' (SELECT id_manufacturer FROM `'._DB_PREFIX_.'gmc_brands` gc '.((version_compare(_PS_VERSION_, '1.5', '>') && Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')) ? ' WHERE gc.`id_shop` = '.(int)($this->id_shop) : '').')';


}





$productCount = Db::getInstance()->getRow($sql);


if ($this->_configuration['GMERCHANTCENTER_EXPORT_MODE'] == 0)


{


	if ($indexedCategories && is_array($indexedCategories))


		foreach ($indexedCategories AS $k => $row)


			$cIndex[] = $row['id_category'];


}


if ($this->_configuration['GMERCHANTCENTER_EXPORT_MODE'] == 1)


{


	if ($indexedBrands && is_array($indexedBrands))


		foreach ($indexedBrands AS $k => $row)


			$bIndex[] = $row['id_brands'];


}





/* Initialize shipping fees array */


$shippingCarriers = array();





/* Set XML dir path */


$this->_setXmlDir();





/* Reporting */


$aLang = $this->getSelectReport();





/* detect version - case of jquery UI depreciated for 1.4.4 core */


$bConflict = version_compare(_PS_VERSION_, '1.4.9.0') != -1? true : false;





$this->_html .= '


			<link rel="stylesheet" type="text/css" href="'._MODULE_DIR_.$this->name.'/css/admin.css" />


			<script type="text/javascript">


			ThickboxI18nImage = \''.$this->l('Image', 'form_config').'\';


			ThickboxI18nOf = \''.$this->l('on', 'form_config').'\';


			ThickboxI18nClose = \''.$this->l('Close', 'form_config').'\';


			ThickboxI18nOrEscKey = \' \';


			ThickboxI18nNext = \''.$this->l('Next', 'form_config').' >\';


			ThickboxI18nPrev = \'< '.$this->l('Previous', 'form_config').'\';


			tb_pathToImage = \''.__PS_BASE_URI__.'img/loadingAnimation.gif\';


			</script>';





		if ($bConflict)


		{


			$this->_html .= '


					<script type="text/javascript" src="'._MODULE_DIR_.$this->name.'/js/jquery-1.4.4.min.js"></script>


					<script type="text/javascript">var JQuery144 = $.noConflict(true);</script>


					<script type="text/javascript" src="'._MODULE_DIR_.$this->name.'/js/thickbox-modified.js"></script>';


		}


		else


		{


			$this->_html .= '


			<script type="text/javascript" src="'.__PS_BASE_URI__.'js/jquery/thickbox-modified.js"></script>


			<script type="text/javascript" src="'._MODULE_DIR_.$this->name.'/js/jquery19-for-147lower.js"></script>


			';


		}


		if(version_compare(_PS_VERSION_, '1.4.9', '<'))


		{


			$this->_html .= '


			<script type="text/javascript" src="'._MODULE_DIR_.$this->name.'/js/jquery.18.js"></script>


			';


		}


		$this->_html .= '<script type="text/javascript" src="'._MODULE_DIR_.$this->name.'/js/jquery-ui-1.5.3.min.js"></script>


			<script type="text/javascript">id_language = Number('.$defaultLanguage.');</script>';


		if(version_compare(_PS_VERSION_, '1.6', '<'))


		{


			$this->_html .='


						<script type="text/javascript" src="'._MODULE_DIR_.$this->name.'/js/bootstrap.js"></script>


						<link rel="stylesheet" type="text/css" href="'._MODULE_DIR_.$this->name.'/css/bootstrap.css" />


						<link rel="stylesheet" type="text/css" href="'._MODULE_DIR_.$this->name.'/css/admin-theme.css" />


						<link rel="stylesheet" type="text/css" href="'._MODULE_DIR_.$this->name.'/css/admin-15-14.css" />


						';


		}











$this->_html .= '


			<style type="text/css">


			.GMCTable th, .GMCTable td, .GMCTable th a, .GMCTable td a { font-size: 12px !important; }


			</style>





			<style type="text/css">


			@import url(\''.self::BT_API_MAIN_URL.'css/styles.css?ts='.time().'\');


			';





				ob_start();


				include dirname(__FILE__).'/css/thickbox.css';


				$this->_html .= ob_get_contents();


				ob_end_clean();





				$this->_html .= '


							</style>';





				$this->_html .= '


			<script>


				  $(function() {


				    $(".icon-question-sign").tooltip();


				  });


				  $(function() {


				    $(".label-tooltip").tooltip();


				  });


			</script>





			<p><img src="'._MODULE_DIR_.$this->name.'/img/admin/gmc.png" width="350" height="62" border="0" /></p>


			<form action="'.$_SERVER['REQUEST_URI'].'" method="post" id"form_gmc">


			<div class="bootstrap">


				<ul class="nav nav-tabs" id="workTabs">


					<li class="active"><a data-toggle="tab" href="#tab-0"><span class="icon-home"></span>&nbsp;'.$this->l('Welcome', 'form_config').'</a></li>


					<li><a data-toggle="tab" href="#tab-1"><span class="icon-globe"></span>&nbsp;'.$this->l('Prerequisite check', 'form_config').'</a></li>


					<li><a data-toggle="tab" href="#tab-2"><span class="icon-cog"></span>&nbsp;'.$this->l('Basic settings', 'form_config').'</a></li>


					<li class="dropdown" >


					<a data-toggle="dropdown" class="dropdown-toggle" href="#"><span class="icon-edit"></span>&nbsp;'.$this->l('Feed management', 'form_config').' <b class="caret"></b></a>


						<ul class="dropdown-menu">


							<li><a data-toggle="tab" href="#dropdown1">'.$this->l('Export method', 'form_config').'</a></li>


							<li><a data-toggle="tab" href="#dropdown2">'.$this->l('Product exclusion rules', 'form_config').'</a></li>


							<li><a data-toggle="tab" href="#dropdown4">'.$this->l('Feed data option', 'form_config').'</a></li>


							<li><a data-toggle="tab" href="#dropdown5">'.$this->l('Apparel feed options', 'form_config').'</a></li>


							<li><a data-toggle="tab" href="#dropdown9">'.$this->l('Tax and shipping fees', 'form_config').'</a></li>


						</ul>


					</li>


					<li class="dropdown" >


					<a data-toggle="dropdown" class="dropdown-toggle" href="#"><span class="icon-briefcase"></span>&nbsp;'.$this->l('Google management', 'form_config').' <b class="caret"></b></a>


						<ul class="dropdown-menu">


							<li><a data-toggle="tab" href="#dropdown6">'.$this->l('Google product categories', 'form_config').'</a></li>


							<li><a data-toggle="tab" href="#dropdown7">'.$this->l('Google Adwords / Custom label integration', 'form_config').'</a></li>


							<li><a data-toggle="tab" href="#dropdown8">'.$this->l('Google Analytics integration', 'form_config').'</a></li>


						</ul>


					</li>


					<li class="feed_generator"><a data-toggle="tab" href="#tab-4"><span class="icon-align-justify"></span>&nbsp;'.$this->l('My feeds', 'form_config').'</a></li>


					<li><a data-toggle="tab" href="#tab-3"><span class="icon-play"></span>&nbsp;'.$this->l('Reporting', 'form_config').'</a></li>


					<li><a data-toggle="tab" href="#tab-5"><span class="icon-question-sign"></span>&nbsp;'.$this->l('Help / FAQ', 'form_config').'</a></li>


				</ul>


				<div class="tab-content">


					<div id="tab-0" class="tab-pane fade in active information">


						<h3>'.$this->l('IMPORTANT INFORMATION: PLEASE READ...', 'form_config').'</h3>


						<div class="clr_hr"></div>


						<div class="clr_20"></div>


						<div class="fbpscClearAdmin"></div>


						<div class="alert alert-info">


							<p>'.$this->l('Register first at http://www.google.com/merchants/', 'form_config', 'form_config').'</p>


							<p>'.$this->l('Please be sure to consult the Help resources section (last tab on the left menu)', 'form_config').'</p>


							<p>'.$this->l('Please be sure to read the documentation carefully and use the help resources available (last tab on the left menu). Please also understand that any errors reported by Google that are due to missing data in your catalog (such as missing EAN or UPC codes) cannot be fixed be us. Only you can fix these problems by making sure your catalog data is complete and accurate.', 'form_config').'</p>


						</div>


						<div class="clr_hr"></div>


						<div class="clr_20"></div>


						<iframe class="btxsellingiframe" src="'.self::BT_API_MAIN_URL.'?ts='.time().'&sName='.$this->name.'&sLang='.$isoCurrent.'"></iframe>


					</div>


					<!-- end of tab 0 -->


					<div id="tab-1" class="tab-pane fade">


						<h3>'.$this->l('Locale prerequisites', 'form_config').'</h3>


						<div class="clr_hr"></div>


						<div class="clr_20"></div>


						<div class="fbpscClearAdmin"></div>


						<div class="alert alert-info">


							<strong style="font-weight: bold; color: red;">'.$this->l('*** NOTE: a country\'s feed will only be generated if the country\'s language and official currency are installed and active on your shop, and if it is part of the countries where Google Shopping is implemented (see http://www.google.com/support/merchants/bin/answer.py?hl=en&answer=160619). The currency\'s exchange rate should also be correctly set.', 'form_config').'</strong><br /><br />'.


							$this->l('You will find below a recap table for each country that Google Shopping is present in, the accepted language(s) and currency, each with the associated ISO codes. If any expected country feeds do not appear in the list of XML files or PHP URL\'s, then you must check your country, language and currency ISO codes in the back-office (Localization tab on PrestaShop 1.5) and respect uppercase or lowercase as shown below.', 'form_config').'<br /><br />


						</div>


						<table border="0" cellpadding="2" cellspacing="2" class="table table-striped" style="min-width: 820px;">


							<tr>


								<th>'.$this->l('Country / (ISO)', 'form_config').'</th>


								<th>'.$this->l('Accepted languages / (ISO)', 'form_config').'</th>


								<th>'.$this->l('Accepted currency / (ISO)', 'form_config').'</th>


							</tr>


							<tr>


								<td>'.$this->l('United States (ISO: US)', 'form_config').'</td>


								<td>'.$this->l('English (ISO: en or en-us)', 'form_config').'</td>


								<td>'.$this->l('US Dollar (ISO: USD)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('United Kingdom (ISO: GB)', 'form_config').'</td>


								<td>'.$this->l('English (ISO: en, gb or en-gb)', 'form_config').'</td>


								<td>'.$this->l('British Pound (ISO: GBP)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Australia (ISO: AU)', 'form_config').'</td>


								<td>'.$this->l('English (ISO: en, gb or en-gb)', 'form_config').'</td>


								<td>'.$this->l('Australian Dollar (ISO: AUD)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('France (ISO: FR)', 'form_config').'</td>


								<td>'.$this->l('French (ISO: fr)', 'form_config').'</td>


								<td>'.$this->l('Euro (ISO: EUR)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Chinese (ISO: CN)', 'form_config').'</td>


								<td>'.$this->l('Chine (ISO: zh)', 'form_config').'</td>


								<td>'.$this->l('Yuan (ISO: CNY)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Germany (ISO: DE)', 'form_config').'</td>


								<td>'.$this->l('German (ISO: de)', 'form_config').'</td>


								<td>'.$this->l('Euro (ISO: EUR)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Italy (ISO: IT)', 'form_config').'</td>


								<td>'.$this->l('Italian (ISO: it)', 'form_config').'</td>


								<td>'.$this->l('Euro (ISO: EUR)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Netherlands (ISO: NL)', 'form_config').'</td>


								<td>'.$this->l('Dutch (ISO: nl)', 'form_config').'</td>


								<td>'.$this->l('Euro (ISO: EUR)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Spain (ISO: ES)', 'form_config').'</td>


								<td>'.$this->l('Spanish (ISO: es)', 'form_config').'</td>


								<td>'.$this->l('Euro (ISO: EUR)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Switzerland (ISO: CH)', 'form_config').'</td>


								<td>'.$this->l('French (ISO: fr), German (ISO: de), Italian (ISO: it), English (en, gb or en-gb)', 'form_config').'</td>


								<td>'.$this->l('Swiss Franc (ISO: CHF)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Czech Republic (ISO: CZ)', 'form_config').'</td>


								<td>'.$this->l('Czech (ISO: cs)', 'form_config').'</td>


								<td>'.$this->l('Czech Crown (ISO: CZK)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Japan (ISO: JP)', 'form_config').'</td>


								<td>'.$this->l('Japanese (ISO: ja)', 'form_config').'</td>


								<td>'.$this->l('Yen (ISO: JPY)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Brazil (ISO: BR)', 'form_config').'</td>


								<td>'.$this->l('Brazilian Portuguese (ISO: br)', 'form_config').'</td>


								<td>'.$this->l('Brazilian Reals (ISO: BRL)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Canada (ISO: CA)', 'form_config').'</td>


								<td>'.$this->l('French (ISO: fr) or English (en or en-us)', 'form_config').'</td>


								<td>'.$this->l('Canadian Dollar (ISO: CAD)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('India (ISO: IN)', 'form_config').'</td>


								<td>'.$this->l('English (en, gb or en-gb)', 'form_config').'</td>


								<td>'.$this->l('Indian Rupees (ISO: INR)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Russia (ISO: RU)', 'form_config').'</td>


								<td>'.$this->l('Russian (ISO: ru)', 'form_config').'</td>


								<td>'.$this->l('Russian rubles (ISO: RUB)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Sweden (ISO: SE)', 'form_config').'</td>


								<td>'.$this->l('Swedish (ISO: sv)', 'form_config').'</td>


								<td>'.$this->l('Swedish Crown (ISO: SEK)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Austria (ISO: AT)', 'form_config').'</td>


								<td>'.$this->l('German (ISO: de)', 'form_config').'</td>


								<td>'.$this->l('Euro (ISO: EUR)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Belgium (ISO: BE)', 'form_config').'</td>


								<td>'.$this->l('French (ISO: fr) or Dutch (ISO: nl)', 'form_config').'</td>


								<td>'.$this->l('Euro (ISO: EUR)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Denmark (ISO: DK)', 'form_config').'</td>


								<td>'.$this->l('Danish (ISO: da)', 'form_config').'</td>


								<td>'.$this->l('Danish Crown (ISO: DKK)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Mexico (ISO: MX)', 'form_config').'</td>


								<td>'.$this->l('Spanish (ISO: es)', 'form_config').'</td>


								<td>'.$this->l('Mexican Pesos (ISO: MXN)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Norway (ISO: NO)', 'form_config').'</td>


								<td>'.$this->l('Norvegian (ISO: no)', 'form_config').'</td>


								<td>'.$this->l('Norvegian Crown (ISO: NOK)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Poland (ISO: PL)', 'form_config').'</td>


								<td>'.$this->l('Polish (ISO: pl)', 'form_config').'</td>


								<td>'.$this->l('Zloty  (ISO: PLN)', 'form_config').'</td>


							</tr>


							<tr>


								<td>'.$this->l('Turkey (ISO: TR)', 'form_config').'</td>


								<td>'.$this->l('Turkish (ISO: tr)', 'form_config').'</td>


								<td>'.$this->l('Turkish Lira (ISO: TRY)', 'form_config').'</td>


							</tr>


						</table>


						<script>


						$( document ).ready(function() {


							if ($("input.categoryBox").is(":checked") == true || $("input.brand").is(":checked") == true)


									{


										$("#prerequisite_data_check").show();


										$("#prerequisite_no_data_check").hide();


									}


									else


									{


										$("#prerequisite_data_check").hide();


										$("#prerequisite_no_data_check").show();


									}


								});


						</script>


					</div>


					<!-- end of tab 1 -->





					<div id="tab-2" class="tab-pane fade">


						<input type="hidden" size="5" name="product_count" id="product_count" value="'.(int)($productCount['cnt']).'" />


						<div class="form-horizontal">


							<h3>'.$this->l('Basic settings', 'form_config').'</h3>


							<div class="clr_hr"></div>


							<div class="clr_20"></div>


							<div class="fbpscClearAdmin"></div>';


									if (!empty($this->_postErrors['link']))


									{


										$sErrorClass = 'form-error';


										$iActiveTab = 1;


									}


									else


									{


										$sErrorClass = '';


									}


									$this->_html .= '


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('Example: http://www.myshop.com - Even if your shop is located in a sub-directory (e.g. http://www.myshop.com/shop), you should still only enter the fully qualified domain name http://www.myshop.com - DO NOT include a trailing slash (/) at the end', 'form_config').'"><b>'.$this->l('Your Prestashop shop\'s URL', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


									<input type="text" class="' . $sErrorClass . '" name="link" value="'.Tools::getValue('link', $this->_configuration['GMERCHANTCENTER_LINK']).'" />


								</div>


								<span class="icon-question-sign" title="'.$this->l('Example: http://www.myshop.com - Even if your shop is located in a sub-directory (e.g. http://www.myshop.com/shop), you should still only enter the fully qualified domain name http://www.myshop.com - DO NOT include a trailing slash (/) at the end', 'form_config').'"></span>


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('Enter a short prefix for your shop. For example, if your shop is called "Janes\'s Flowers", enter jf. This is mandatory if you manage several shop feeds from your Google Merchant Center account', 'form_config').'. '.$this->l('Please enter lowercase letters only.', 'form_config').'"><b>'.$this->l('Product ID prefix for your shop', 'form_config').'</b></span>


								</label>


								<div class="col-xs-1">


									<input type="text" name="id_prefix" value="'.Tools::getValue('id_prefix', $this->_configuration['GMERCHANTCENTER_ID_PREFIX']).'" />


								</div>


								<span class="icon-question-sign" title="'.$this->l('Enter a short prefix for your shop. For example, if your shop is called "Janes\'s Flowers", enter jf. This is mandatory if you manage several shop feeds from your Google Merchant Center account', 'form_config').'. '.$this->l('Please enter lowercase letters only.', 'form_config').'"></span>


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('Example: Clothing', 'form_config').'"><b>'.$this->l('Name for home category', 'form_config').'</b></span>


								</label>


								<div id="homecat" class="col-xs-2" >';


									foreach ($languages as $language)


									{


										if (!empty($this->_postErrors['homecat'.$language['id_lang']]))


										{


											$sErrorClass = 'form-error';


											$iActiveTab = 1;


										}


										else


										{


											$sErrorClass = '';


										}


										$this->_html .= '


										<div id="homecat_div_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';float: left; margin: 0;">


										<input type="text" size="30" class="' . $sErrorClass . '" name="homecat['.$language['id_lang'].']" id="homecat_'.$language['id_lang'].'" value="'.(isset($_POST['homecat'][(int)($language['id_lang'])]) ? stripslashes($_POST['homecat'][(int)($language['id_lang'])]) : ((!empty($this->_configuration['GMERCHANTCENTER_HOME_CAT']))?stripslashes($this->_configuration['GMERCHANTCENTER_HOME_CAT'][(int)($language['id_lang'])]):'')).'" />


										&nbsp;


										<span class="alert-tag">Google: [g:product_type]</span>


									</div>


									';


										}


								$this->_html .= '


								</div>


								'.$this->displayFlags($languages, $defaultLanguage, $divLangName, 'homecat_div', true).'


								<div>


									<span class="icon-question-sign" title="'.$this->l('Example: Clothing', 'form_config').'"></span>


									<span class="icon-info-sign"></span><a href="'.self::BT_FAQ_MAIN_URL.'5&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a>


								</div>


							</div>





							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('This determines how many products are processed per AJAX / CRON cycle. Default is 200. Only increase this value if you have a large shop and run into problems with server limits. Otherwise, leave it at its default 200 value. It should not be higher than 1000 in any case.', 'form_config').'"><b>'.$this->l('Number of products per cycle', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


									<input type="text" name="ajax_cycle" value="'.Tools::getValue('ajax_cycle', $this->_configuration['GMERCHANTCENTER_AJAX_CYCLE']).'" />


								</div>


								<span class="icon-question-sign" title="'.$this->l('This determines how many products are processed per AJAX / CRON cycle. Default is 200. Only increase this value if you have a large shop and run into problems with server limits. Otherwise, leave it at its default 200 value. It should not be higher than 1000 in any case.', 'form_config').'"></span>


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('Choose the largest image size available (such as thickbox). Google requires at least 250x250 and recommends at least 400x400 pixels.', 'form_config').'"><b>'.$this->l('Image size for product photos', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


									<select name="img_size">';


										$available_types = ImageType::getImagesTypes('products');


										foreach ($available_types as $t)


											$this->_html .= '<option value="'.$t['name'].'"'


												.(($t['name'] === Tools::getValue('img_size', $this->_configuration['GMERCHANTCENTER_IMG_SIZE'])) ? ' selected="selected"' : '')


												.'>'.$t['name'].'</option>'."\n";


										$this->_html .= '


								</select>


								<div class="alert-tag">Google: [g:image_link]</div>


								</div>


								<span class="icon-question-sign" title="'.$this->l('Choose the largest image size available (such as thickbox). Google requires at least 250x250 and recommends at least 400x400 pixels.', 'form_config').'"></span>


								<a href="'.self::BT_FAQ_MAIN_URL.'8&lg='.$isoCurrent.'" target="_blank"></span></a>


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('On version 1.5, the Home category may have an ID of 1 or 2, depending on whether it was a fresh install or an upgrade from an older PrestaShop version, so we are unable to determine this automatically but need it for other functions in the module. Please select below the category that is labeled "Home"', 'form_config').'"><b>'.$this->l('Please select your Home category', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


									<select name="home_cat_id">';


										foreach ($home_categories as $c)


											$this->_html .= '<option value="'.$c['id_category'].'"'


												.(($c['id_category'] === Tools::getValue('home_cat_id', $this->_configuration['GMERCHANTCENTER_HOME_CAT_ID'])) ? ' selected="selected"' : '')


												.'>'.stripslashes($c['name']).'</option>'."\n";


										$this->_html .= '


								</select>


								</div>


								<span class="icon-question-sign" title="'.$this->l('On version 1.5, the Home category may have an ID of 1 or 2, depending on whether it was a fresh install or an upgrade from an older PrestaShop version, so we are unable to determine this automatically but need it for other functions in the module. Please select below the category that is labeled "Home"', 'form_config').'"></span>


							</div>


							<div class="form-group">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('If you are submitting your feeds to several countries in the same language but different currencies, for example English in the US ($) and the UK (£), then you need to set this value to Yes (otherwise, set to No), and, if set to Yes, you also need to override the Tools.php class.', 'form_config').''.$this->l('. This way, your website can display prices in the same currency as the feed. Otherwise, this is currently impossible in PrestaShop up to version 1.5.4.1 and Google will refuse your feed due to currencies not matching.', 'form_config').'


									"><b>'.$this->l('Add id_currency in product link ?', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


									<select name="add_currency">


									<option value="0"'


										.(((int)(0) === (int)(Tools::getValue('add_currency', $this->_configuration['GMERCHANTCENTER_ADD_CURRENCY']))) ? ' selected="selected"' : '')


										.'>'.$this->l('No', 'form_config').'</option>'."\n".


										'<option value="1"'


										.(((int)(1) === (int)(Tools::getValue('add_currency', $this->_configuration['GMERCHANTCENTER_ADD_CURRENCY']))) ? ' selected="selected"' : '')


										.'>'.$this->l('Yes', 'form_config').'</option>';


									$this->_html .= '


								</select>


								</div>


								<div>


									<span class="icon-question-sign" title="'.$this->l('If you are submitting your feeds to several countries in the same language but different currencies, for example English in the US ($) and the UK (£), then you need to set this value to Yes (otherwise, set to No), and, if set to Yes, you also need to override the Tools.php class.', 'form_config').''.$this->l('. This way, your website can display prices in the same currency as the feed. Otherwise, this is currently impossible in PrestaShop up to version 1.5.4.1 and Google will refuse your feed due to currencies not matching.', 'form_config').'"></span>


									<span class="icon-info-sign"></span><a target="_blank" href="'._PS_BASE_URL_._MODULE_DIR_.$this->name.'/readme_' .  (GMerchantCenter::$sDefaultLang == 'fr'? 'fr':'en'). '.pdf">&nbsp;PDF</a>


								</div>


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('Note: For Prestashop v1.4.x users, this will be automatically replaced by the product\'s condition for each specific product.', 'form_config').'"><b>'.$this->l('Condition of your products', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


								<select name="cond">';


									$this->_html .= '<option value="0"'.(((int)(0) == (int)(Tools::getValue('cond', $this->_configuration['GMERCHANTCENTER_COND']))) ? ' selected="selected"' : '').'>--</option>';


									foreach ($conditions as $k => $v)


										$this->_html .= '<option value="'.$k.'"'


											.(($k === Tools::getValue('cond', $this->_configuration['GMERCHANTCENTER_COND'])) ? ' selected="selected"' : '')


											.'>'.$v.'</option>';


									$this->_html .= '


								</select>


								<div class="alert-tag">Google: [g:condition]</div>


								</div>


								<div>


									<span class="icon-question-sign" title="'.$this->l('Note: For Prestashop v1.4.x users, this will be automatically replaced by the product\'s condition for each specific product.', 'form_config').'"></span>


									<span class="icon-info-sign"></span><a href="'.self::BT_FAQ_MAIN_URL.'9&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a>


								</div>


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


										<span class="label-tooltip" title="'.$this->l('This option set each product\'s title in your data feed like this : category name + product name' , 'form_config').'"><b>'.$this->l('Advanced product name', 'form_config').'</b></span>


									</label>


									<div class="col-xs-2">


										<select name="advance_product_name" id="advance_product_name">


											<option value="0"'.(((int)(0) == (int)(Tools::getValue('advance_product_name', $this->_configuration['GMERCHANTCENTER_ADV_PRODUCT_NAME']))) ? ' selected="selected"' : '').'>'.$this->l('Just the normal product name','form_config').'</option>


											<option value="1"'.(((int)(1) == (int)(Tools::getValue('advance_product_name', $this->_configuration['GMERCHANTCENTER_ADV_PRODUCT_NAME']))) ? ' selected="selected"' : '').'>'.$this->l('Current category name + Product name','form_config').'</option>


											<option value="2"'.(((int)(2) == (int)(Tools::getValue('advance_product_name', $this->_configuration['GMERCHANTCENTER_ADV_PRODUCT_NAME']))) ? ' selected="selected"' : '').'>'.$this->l('Product name + Current category name','form_config').'</option>


											<option value="3"'.(((int)(3) == (int)(Tools::getValue('advance_product_name', $this->_configuration['GMERCHANTCENTER_ADV_PRODUCT_NAME']))) ? ' selected="selected"' : '').'>'.$this->l('Brand name + Product name','form_config').'</option>


											<option value="4"'.(((int)(4) == (int)(Tools::getValue('advance_product_name', $this->_configuration['GMERCHANTCENTER_ADV_PRODUCT_NAME']))) ? ' selected="selected"' : '').'>'.$this->l('Product name + Brand name','form_config').'</option>


										</select>


										<br/>


										<div class="alert alert-info">





											'.$this->l('Google recommends you include characteristics such as brand in the title which differentiates the item from other products.', 'form_config').'


										</div>


										<div class="alert alert-warning" id="info_title_category">


											'.$this->l('Be careful : this option will set your product\'s title with the current category name. However, Google will still require your product titles to be no more than 150 characters long','form_config').'


										</div>


										<div class="alert alert-warning" id="info_title_brand">


											'.$this->l('Be careful : this option will set your product\'s title with the brand name. However, Google will still require your product titles to be no more than 150 characters long','form_config').'


										</div>


									</div>


								<span class="icon-question-sign" title="'.$this->l('This option set each product\'s title in your data feed like this : category name + product name', 'form_config').'"></span>


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


										<span class="label-tooltip" title="'.$this->l('This is a security measure so people from the outside cannot call the feed URL and be able to view your feed.', 'form_config').'"><b>'.$this->l('Advanced file security', 'form_config').'</b></span>


									</label>


									<div class="col-xs-2">


										<select name="select_protection" id="select_protection">


											<option value="0"'.(((int)(0) == (int)(Tools::getValue('select_protection', $this->_configuration['GMERCHANTCENTER_FEED_PROTECTION']))) ? ' selected="selected"' : '').'>'.$this->l('No','form_config').'</option>


											<option value="1"'.(((int)(1) == (int)(Tools::getValue('select_protection', $this->_configuration['GMERCHANTCENTER_FEED_PROTECTION']))) ? ' selected="selected"' : '').'>'.$this->l('Yes','form_config').'</option>


										</select>


										<br/>


										<div class="alert alert-warning" id="protection_off">


											'.$this->l('You have to generate the feed', 'form_config').'


										</div>


									</div>


									<span class="icon-question-sign" title="'.$this->l('This is a security measure so people from the outside cannot call the feed URL and be able to view your feed.', 'form_config').'"></span>


								</div>


							</div>


							<div id="configure_protection">


								<h3>'.$this->l('Advanced file security', 'form_config').'</h3>


									<div class="clr_hr"></div>


									<div class="clr_20"></div>


									<div class="fbpscClearAdmin"></div>


									<div class="alert alert-info">


										<p>'.$this->l('In order to secure your file PHP URL\'s for on-the-fly output, you should copy the file "gmerchantcenter.feed.php" at website root ','form_config').'</p>


										<p>'.$this->l('This option sets a unique identifier in your xml file name','form_config').'</p>


									</div>';


										if (!empty($prerequisite['output_file']))


										{


											$this->_html .='


												<div class="alert alert-success">


												'.$this->l('gmerchantcenter.feed.php file is present on the website root', 'form_config').'


												</div>


												';


										}


										else


										{


											$this->_html .='


										<div class="alert alert-danger">


										'.$this->l('Please copy the gmerchantcenter.feed.php file from the gmerchantcenter module\'s directory to your shop\'s root directory', 'form_config').'


										</div>


										';


									}


									$this->_html .= '


									<div id="require_field" class="alert alert-danger">


										'.$this->l('Field is required or Token must be 32 characters','form_config').'


									</div>


									<div class="form-group ">


										<label class="control-label col-lg-3">


											<span class="label-tooltip" title="'.$this->l('This is a security measure so people from the outside cannot call the feed URL and be able to view your information. We have automatically generated one on install for your convenience.', 'form_config').'"><b>'.$this->l('Your secure token', 'form_config').'</b></span>


										</label>


										<div class="col-xs-2">


											<input type="text" maxlength="32" name="feed_token" id="feed_token" value="'.Tools::getValue('feed_token', $this->_configuration['GMERCHANTCENTER_FEED_TOKEN']).'" />


										</div>


										<span class="icon-question-sign" title="'.$this->l('This is a security measure so people from the outside cannot call the feed URL and be able to view your information. We have automatically generated one on install for your convenience.', 'form_config').'"></span>


									</div>


									<br/>


									<br/>


							</div>


							<center><input type="submit" class="btn btn-success" name="submitGS" value="'.$this->l('Update settings', 'form_config').'" class="GMCbutton" /></center>


							<script>


								$("#require_field").hide();


								// init display advance protection


								if($("#select_protection").val() == "0")


								{


									$("#configure_protection").hide();


									$("#protection_off").show();


								}


								else


								{


									$("#configure_protection").show();


									$("#protection_off").hide();


								}





								// manage change value for advance protection


								$( "#select_protection" ).change(function() {


									if($("#select_protection").val() == "0")


									{


										$("#configure_protection").hide();


										$("#protection_off").show();


									}


									else


									{


										$("#configure_protection").show();


										$("#protection_off").hide();


									}


								})





								// manage the value of the token


								$("#feed_token").focusout(function() {


									var size = $("#feed_token").val();


									if (size.length < 32 && $("#select_protection").val() == 1 )


									{


										$("#feed_token").css("border-color","red")


										$("#require_field").show();


										$("#require_field").delay(2000).hide(500)


									}


								})


								$( "form" ).submit(function(event) {


									var size = $("#feed_token").val();


									if (size.length < 32 && $("#select_protection").val() == 1)


									{


										$("#feed_token").css("border-color","red")


										$("#require_field").show();


										$("#require_field").delay(2000).hide(500)


										return false;


									}


								})


								//manage information for info title


								if($("#advance_product_name").val() == "0")


								{


									$("#info_title_category").hide();


									$("#info_title_brand").hide();


								}


								if($("#advance_product_name").val() == "1" || $("#advance_product_name").val() == "2")


								{


									$("#info_title_category").show();


									$("#info_title_brand").hide();


								}





								if($("#advance_product_name").val() == "3" || $("#advance_product_name").val() == "4")


								{


									$("#info_title_category").hide();


									$("#info_title_brand").show();


								}





								$( "#advance_product_name" ).change(function() {


									if($("#advance_product_name").val() == "0" )


									{


										$("#info_title_category").hide();


										$("#info_title_brand").hide();


									}


									if($("#advance_product_name").val() == "1" || $("#advance_product_name").val() == "2")


									{


										$("#info_title_category").show();


										$("#info_title_brand").hide();


									}


									if($("#advance_product_name").val() == "3" || $("#advance_product_name").val() == "4")


									{


										$("#info_title_category").hide();


										$("#info_title_brand").show();


									}


								})


							</script>


						</div>


					<!-- end of tab 2 -->


					<div id="dropdown1" class="tab-pane fade">


						<div class="form-horizontal">


							<h3>'.$this->l('Export method', 'form_config').'</h3>


							<div class="clr_hr"></div>


							<div class="clr_20"></div>


							<div class="fbpscClearAdmin"></div>


							<div class="alert alert-info" id="info_export">


								'.$this->l('Select one export method by categories OR by brands', 'form_config').'


							</div>


							<div class="alert alert-info" id="alert_categorie">


								'.$this->l('Only products whose main (default) category is part of the categories checked below will be exported in your feeds.', 'form_config').'


							</div>


							<div class="alert alert-info" id="alert_brands">


								'.$this->l('Select the brands to export in your data feed', 'form_config').'


							</div>


							<div class="form-group" id="optionplus">


							<label class="control-label col-lg-5">


								<span class="label-tooltip" title=""><b>'.$this->l('Select your export method', 'form_config').'</b></span>


							</label>


							<div class="col-xs-1">


								<select name="export" id="export">


									<option value="null">--</option>


									<option value="0"'.(((int)(0) == (int)(Tools::getValue('export', $this->_configuration['GMERCHANTCENTER_EXPORT_MODE']))) ? ' selected="selected"' : '').'>'.$this->l('Export by categories', 'form_config').'</option>


									<option value="1"'.(((int)(1) == (int)(Tools::getValue('export', $this->_configuration['GMERCHANTCENTER_EXPORT_MODE']))) ? ' selected="selected"' : '').'>'.$this->l('Export by brands', 'form_config').'</option>


								</select>


							</div>


							<span class="icon-question-sign" title=""></span>


						</div>


						<div id="category">


						';


						$trads = array(


							'Home' => $this->l('Home', 'form_config'),


							'selected' => $this->l('selected', 'form_config'),


							'Collapse All' => $this->l('Collapse All', 'form_config'),


							'Expand All' => $this->l('Expand All', 'form_config'),


							'Check All' => $this->l('Check All', 'form_config'),


							'Uncheck All'  => $this->l('Uncheck All', 'form_config')


						);


							$this->_html .= '


								<div class="form-group ">


									<label class="control-label col-lg-5">


									<span class="label-tooltip" title="'.$this->l('Only products whose main (default) category is part of the categories checked below will be exported in your feeds.', 'form_config').'"><b>'.$this->l('Categories selection', 'form_config').'</b></span>


								</label>


								<div class="col-xs-1">


									<table cellspacing="0" cellpadding="0" class="table">';


								$this->_html .= '<tr><td colspan="3"><a href="#" onclick="return doCheckAll();">'.$this->l('Check All').'</a> - <a href="#" onclick="return doUncheckAll();">'.$this->l('Uncheck All', 'form_config').'</a></td></tr>';


								$this->recurseCategoryForInclude($cIndex, $categories, $categories[0][1], 1);


								$this->_html .= '


									</table><br /><br />


								</div>


								<!--<span class="icon-question-sign" title="'.$this->l('Only products whose main (default) category is part of the categories checked below will be exported in your feeds.', 'form_config').'"></span>-->


							</div>


						</div>';


						$this->_html .='


						<div id="brands">


							<div class="form-group ">


									<label class="control-label col-lg-5">


									<span class="label-tooltip" title="'.$this->l('Use this option to export your catalog by brands', 'form_config').'"><b>'.$this->l('Brands', 'form_config').'</b></span>


								</label>


								<div class="col-xs-1">


									<table cellspacing="0" cellpadding="0" class="table">';


										$this->_html .= '<tr><td colspan="3"><a href="#" onclick="return doCheckBrand();">'.$this->l('Check All').'</a> - <a href="#" onclick="return doUncheckBrand();">'.$this->l('Uncheck All', 'form_config').'</a></td></tr>';


										$this->recurseBrandForInclude($bIndex);


										$this->_html .= '


									</table><br /><br />


								</div>


								<!--<span class="icon-question-sign" title="'.$this->l('Only products whose main (default) category is part of the categories checked below will be exported in your feeds.', 'form_config').'"></span>-->


							</div>


						</div>


							<center><input type="submit" class="btn btn-success" name="submitGS" value="'.$this->l('Update settings', 'form_config').'" class="GMCbutton" /></center>


							<!-- manage JS for this tab -->


							<script type="text/javascript">





									// function do manage categories select


									function doCheckAll()


									{


										$("input.categoryBox").attr("checked", true);


									}





									function doUncheckAll()


									{


										$("input.categoryBox").attr("checked", false);


									}





									//function to manage brands select


									function doCheckBrand()


									{


										$("input.brand").attr("checked", true);


									}





									function doUncheckBrand()


									{


										$("input.brand").attr("checked", false);


									}





									//init for the 1st configuration


									$("#category").hide();


									$("#brands").hide();


									$("#alert_categorie").hide();





									if ($("#export").val() == "0")


									{


										$("#category").show();


										$("#alert_categorie").show();


										$("#export_require").hide();


										$("#info_export").hide();


										$("#alert_brands").hide();





									}


									if ($("#export").val() == "1")


									{





										$("#category").hide();


										$("#export_require").hide();


										$("#info_export").hide();


										$("#brands").show();


									}





									// manage change select event


									$( "#export" ).change(function() {


										if ($( "#export" ).val() ==  "0")


										{


											$("#info_export").hide();


											$("#category").show();


											$("#alert_categorie").show();


											$("#brands").hide();


											$("#alert_brands").hide();


										}


										else if ($( "#export" ).val() ==  "1")


										{


											$("#info_export").hide();


											$("#category").hide();


											$("#alert_categorie").hide();


											$("#brands").show();


											$("#alert_brands").show();


										}


										else


										{


											$("#info_export").show();


											$("#category").hide();


											$("#alert_categorie").hide();


											$("#brands").hide();


											$("#alert_brands").hide();


											$("input.brand").attr("checked", false);


											$("input.categoryBox").attr("checked", false);


										}


									});





								</script>


						</div>


					</div>


					<!-- end of dd 1 -->





					<div id="dropdown2" class="tab-pane fade">


					<div class="form-horizontal">


						<h3>'.$this->l('Product exclusion rules', 'form_config').'</h3>


							<div class="clr_hr"></div>


							<div class="clr_20"></div>


							<div class="fbpscClearAdmin"></div>


						<div class="form-group ">


							<label class="control-label col-lg-3">


								<span class="label-tooltip" title="'.$this->l('If you select yes, all your active products will be exported. If you select no, only products that you have in stock will be exported.', 'form_config').'"><b>'.$this->l(' Export out of stock products ?', 'form_config').'</b></span>


							</label>


							<div class="col-xs-2">


								<select name="export_oos">


									<option value="0"'


											.(((int)(0) === (int)(Tools::getValue('export_oos', $this->_configuration['GMERCHANTCENTER_EXPORT_OOS']))) ? ' selected="selected"' : '')


											.'>'.$this->l('No', 'form_config').'</option>'."\n".


											'<option value="1"'


											.(((int)(1) === (int)(Tools::getValue('export_oos', $this->_configuration['GMERCHANTCENTER_EXPORT_OOS']))) ? ' selected="selected"' : '')


											.'>'.$this->l('Yes', 'form_config').'</option>';


											$this->_html .= '


									</select>


							</div>


							<span class="icon-question-sign" title="'.$this->l('If you select yes, all your active products will be exported. If you select no, only products that you have in stock will be exported.', 'form_config').'"></span>


							<span class="icon-info-sign"></span><a href="'.self::BT_FAQ_MAIN_URL.'22&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a>


						</div>


						<div class="form-group ">


							<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('If Google is giving you many errors to missing EAN or UPC codes, you may activate this option and none of the products without EAN13 OR UPC will be exported. This will get rid of the Google errors until you are able to get all your product codes from suppliers.', 'form_config').'"><b>'.$this->l('Do not export products without EAN13 or UPC ?', 'form_config').'</b></span>


							</label>


							<div class="col-xs-2">


								<select name="exc_no_ean">


										<option value="0"'


											.(((int)(0) === (int)(Tools::getValue('exc_no_ean', $this->_configuration['GMERCHANTCENTER_EXC_NO_EAN']))) ? ' selected="selected"' : '')


											.'>'.$this->l('No', 'form_config').'</option>'."\n".


											'<option value="1"'


											.(((int)(1) === (int)(Tools::getValue('exc_no_ean', $this->_configuration['GMERCHANTCENTER_EXC_NO_EAN']))) ? ' selected="selected"' : '')


											.'>'.$this->l('Yes', 'form_config').'</option>';


										$this->_html .= '


									</select>


							</div>


							<span class="icon-question-sign" title="'.$this->l('If Google is giving you many errors to missing EAN or UPC codes, you may activate this option and none of the products without EAN13 OR UPC will be exported. This will get rid of the Google errors until you are able to get all your product codes from suppliers.', 'form_config').'"></span>


							<span class="icon-info-sign"></span><a href="'.self::BT_FAQ_MAIN_URL.'22&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a>


						</div>


						<div class="form-group ">


							<label class="control-label col-lg-3">


								<span class="label-tooltip" title="'.$this->l('If Google is giving you many errors to missing MPN codes, you may activate this option and none of the products without a manufacturer reference will be exported. This will get rid of the Google errors until you are able to get all your product codes from suppliers.', 'form_config').'"><b>'.$this->l('Do not export products without a manufacturer reference ?', 'form_config').'</b></span>


							</label>


							<div class="col-xs-2">


								<select name="exc_no_mref">


										<option value="0"'


											.(((int)(0) === (int)(Tools::getValue('exc_no_mref', $this->_configuration['GMERCHANTCENTER_EXC_NO_MREF']))) ? ' selected="selected"' : '')


											.'>'.$this->l('No', 'form_config').'</option>'."\n".


											'<option value="1"'


											.(((int)(1) === (int)(Tools::getValue('exc_no_mref', $this->_configuration['GMERCHANTCENTER_EXC_NO_MREF']))) ? ' selected="selected"' : '')


											.'>'.$this->l('Yes', 'form_config').'</option>';


											$this->_html .= '


									</select>


							</div>


							<span class="icon-question-sign" title="'.$this->l('If Google is giving you many errors to missing MPN codes, you may activate this option and none of the products without a manufacturer reference will be exported. This will get rid of the Google errors until you are able to get all your product codes from suppliers.', 'form_config').'"></span>


							<span class="icon-info-sign"></span><a href="'.self::BT_FAQ_MAIN_URL.'22&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a>


						</div>


						<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('Leave this value at 0 to disable this feature. Otherwise, any product whose CURRENT PRICE (taking specific prices / promotions into account) is lower than this value will be excluded from the feed. Cart rules on version 1.5 are not taken into account, only specific prices. This allows you to exclude low margin products and not pay for²² clicks on them, making your Product Listing Ad campaigns on Google more efficient and profitable.', 'form_config').'"><b>'.$this->l('Do not export products with a price lower than', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


										<input type="text" size="5" name="min_price" value="'.Tools::getValue('min_price', $this->_configuration['GMERCHANTCENTER_MIN_PRICE']).'" />


								</div>


								'.$defaultCurrency->sign.' '.$this->l('Tax excluded', 'form_config').'


								&nbsp;&nbsp;


								<span class="icon-question-sign" title="'.$this->l('Leave this value at 0 to disable this feature. Otherwise, any product whose CURRENT PRICE (taking specific prices / promotions into account) is lower than this value will be excluded from the feed. Cart rules on version 1.5 are not taken into account, only specific prices. This allows you to exclude low margin products and not pay Google Adwords clicks on them, making your Product Listing Ad campaigns on Google more efficient and profitable.', 'form_config').'"></span>


							</div>


							<center><input type="submit" class="btn btn-success" name="submitGS" value="'.$this->l('Update settings', 'form_config').'" class="GMCbutton" /></center>


						</div>


					</div>


					<!-- end of dd 2 -->








					<div id="dropdown4" class="tab-pane fade">


					<div class="form-horizontal">


						<h3>'.$this->l('Feed data options', 'form_config').'</h3>


							<div class="clr_hr"></div>


							<div class="clr_20"></div>


							<div class="fbpscClearAdmin"></div>


						<div class="alert alert-info">


							'.$this->l('The more detailed information your provide to Google, the better your products will rank. Try to include as much information as possible. Please note that some fields are not appropriate for all products. See http://www.google.com/support/merchants/bin/answer.py?answer=171375 for specifications by country and details.', 'form_config').'


						</div>


						<div class="form-group ">


							<label class="control-label col-lg-3">


								<span title=""><b>'.$this->l('Products with combinations / attributes', 'form_config').'</b></span>


							</label>


							<div class="col-xs-2">


								<select name="p_combos">


									<option value="0"'


										.(((int)(0) === (int)(Tools::getValue('p_combos', $this->_configuration['GMERCHANTCENTER_P_COMBOS']))) ? ' selected="selected"' : '')


										.'>'.$this->l('Export only one product', 'form_config').'</option>'."\n".


										'<option value="1"'


										.(((int)(1) === (int)(Tools::getValue('p_combos', $this->_configuration['GMERCHANTCENTER_P_COMBOS']))) ? ' selected="selected"' : '')


										.'>'.$this->l('Export several products: one product per attribute combination', 'form_config').'</option>';


									$this->_html .= '


								</select>


							</div>


						</div>


						<div class="form-group ">


							<label class="control-label col-lg-3">


								<span title=""><b>'.$this->l('Product description', 'form_config').'</b></span>


							</label>


							<div class="col-xs-2">


								<select name="p_descr_type">';


									foreach ($p_description_types as $k => $v)


										$this->_html .= '<option value="'.$k.'"'


											.(((int)($k) === (int)(Tools::getValue('p_descr_type', $this->_configuration['GMERCHANTCENTER_P_DESCR_TYPE']))) ? ' selected="selected"' : '')


											.'>'.$v.'</option>';


									$this->_html .= '


								</select>


								<div class="alert-tag">Google: [description]</div>


							</div>


							<span class="icon-info-sign"></span><a href="'.self::BT_FAQ_MAIN_URL.'3&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a>


						</div>


						<div class="form-group ">


							<label class="control-label col-lg-3">


								<span title=""><b>'.$this->l('Product availability (mandatory on Google)', 'form_config').'</b></span>


							</label>


							<div class="col-xs-2">


								<select name="inc_stock">


									<option value="1"'


										.(((int)(1) === (int)(Tools::getValue('inc_stock', $this->_configuration['GMERCHANTCENTER_INC_STOCK']))) ? ' selected="selected"' : '')


										.'>'.$this->l('Only indicate product as available if it is in stock', 'form_config').'</option>'."\n".


										'<option value="2"'


										.(((int)(2) === (int)(Tools::getValue('inc_stock', $this->_configuration['GMERCHANTCENTER_INC_STOCK']))) ? ' selected="selected"' : '')


										.'>'.$this->l('Always indicate products as available even when product quantity is 0', 'form_config').'</option>';


									$this->_html .= '


								</select>


								<div class="alert-tag">Google: [g:availability]</div>


							</div>


							<span class="icon-info-sign" title=""></span><a href="'.self::BT_FAQ_MAIN_URL.'10&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a>


						</div>


						<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('Use this tag for adult product example : tabacco').'"><b>'.$this->l('Include tag adult ?', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


									<select name="inc_tag_adult" id="tag_adult">


									<option value="0"'


										.(((int)(0) === (int)(Tools::getValue('inc_tag_adult', Tools::getValue('inc_tag_adult', $this->_configuration['GMERCHANTCENTER_INC_TAG_ADULT']))) ? ' selected="selected"' : ''))


										.'>'.$this->l('No', 'form_config').'</option>'."\n".


										'<option value="1"'


										.(((int)(1) === (int)(Tools::getValue('inc_tag_adult',Tools::getValue('inc_tag_adult', $this->_configuration['GMERCHANTCENTER_INC_TAG_ADULT']))) ? ' selected="selected"' : ''))


										.'>'.$this->l('Yes', 'form_config').'</option>


									</select>


									<div class="alert-tag">Google: [g:adult]</div>


									<div id="tag_adult_link">';


										if (Tools::getValue('inc_tag_adult', $this->_configuration['GMERCHANTCENTER_INC_TAG_ADULT']) == 1)


										{


											$this->_html .= '<p class="alert alert-success"><a class="thickbox" style="font-weight: bold; text-decoration: underline;" href="index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminToken('AdminModules'.(int)(Tab::getIdFromClassName('AdminModules')).(Tools::getValue('id_employee', $cookie->id_employee))).'&featurescatlist=1&usetag=adult&id_lang='.(int)($cookie->id_lang).'&TB_iframe=true&width=1000&height=600&thickbox=true">'.$this->l('Click here to configure the Tag for each category','form_config').'</a></p>';


										}


										else


										{


											$this->_html .= '<p class="alert alert-danger" id="save_require">'.$this->l('Save your configuration before configure the TAG', 'form_config').'</p>';


										}


										$this->_html .= '


									</div>


								</div>


								<span class="icon-question-sign" title="'.$this->l('Use this tag for adult product example : tabacco', 'form_config').'"></span>


								<span class="icon-info-sign" title=""></span><a href="'.self::BT_FAQ_MAIN_URL.'15&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a>


							</div>


						<div class="form-group ">


							<label class="control-label col-lg-3">


								<span class="label-tooltip" title="'.$this->l('This is recommended for books, movies, and music. Example: for a book, it might be something like "Book type" with values "paperback" or "pocket book". If applicable, select a feature group.', 'form_config').'"><b>'.$this->l('Include product feature?', 'form_config').'</b></span>


							</label>


							<div class="col-xs-2">


								<select name="inc_feat" id="inc_feat">


									<option value="0"'


										.(((int)(0) === (int)(Tools::getValue('inc_feat', $this->_configuration['GMERCHANTCENTER_INC_FEAT']))) ? ' selected="selected"' : '')


										.'>'.$this->l('No', 'form_config').'</option>'."\n".


										'<option value="1"'


										.(((int)(1) === (int)(Tools::getValue('inc_feat', $this->_configuration['GMERCHANTCENTER_INC_FEAT']))) ? ' selected="selected"' : '')


										.'>'.$this->l('Yes', 'form_config').'</option>


								</select>


								<br/>


								<select name="feat_opt" id="feat_opt">


									<option value="0">--</option>';


										foreach ($features as $feature)


											$this->_html .= '<option value="'.$feature['id_feature'].'"'


												.(((int)($feature['id_feature']) === (int)(Tools::getValue('feat_opt', $this->_configuration['GMERCHANTCENTER_FEAT_OPT']))) ? ' selected="selected"' : '')


												.'>'.$feature['name'].'</option>';


										$this->_html .= '


								</select>


								<div class="alert-tag">Google: [g:feature]</div>


							</div>


							<span class="icon-question-sign" title="'.$this->l('This is recommended for books, movies, and music. Example: for a book, it might be something like "Book type" with values "paperback" or "pocket book". If applicable, select a feature group.', 'form_config').'"></span>


						</div>


						<div class="form-group ">


							<label class="control-label col-lg-3">


								<span class="label-tooltip" title="'.$this->l('This is recommended for media. Example: "Music style" with values such as "Jazz" or "Rock and Roll". If applicable, select a feature group.', 'form_config').'"><b>'.$this->l('Include product genre?', 'form_config').'</b></span>


							</label>


							<div class="col-xs-2">


							<select name="inc_genre" id="inc_genre">


								<option value="0"'


									.(((int)(0) === (int)(Tools::getValue('inc_genre', $this->_configuration['GMERCHANTCENTER_INC_GENRE']))) ? ' selected="selected"' : '')


									.'>'.$this->l('No', 'form_config').'</option>'."\n".


									'<option value="1"'


									.(((int)(1) === (int)(Tools::getValue('inc_genre', $this->_configuration['GMERCHANTCENTER_INC_GENRE']))) ? ' selected="selected"' : '')


									.'>'.$this->l('Yes', 'form_config').'</option>


								<br/>;


								</select>


								<br/>


								<select name="genre_opt" id="genre_opt" >


									<option value="0">--</option>';


										foreach ($features as $feature)


											$this->_html .= '<option value="'.$feature['id_feature'].'"'


												.(((int)($feature['id_feature']) === (int)(Tools::getValue('genre_opt', $this->_configuration['GMERCHANTCENTER_GENRE_OPT']))) ? ' selected="selected"' : '')


												.'>'.$feature['name'].'</option>';


										$this->_html .= '


							</select>


							<div class="alert-tag">Google: [g:genre]</div>


							</div>


							<span class="icon-question-sign" title="'.$this->l('This is recommended for media. Example: "Music style" with values such as "Jazz" or "Rock and Roll". If applicable, select a feature group.', 'form_config').'"></span>


						</div>


						<div class="form-group ">


							<label class="control-label col-lg-3">


								<span class="label-tooltip" title="'.$this->l('This is recommended for clothing. If applicable, select one or more attribute group(s).', 'form_config').' '.$this->l('Note: a maximum of 30 items will be sent to Google, as Google does not accept more.', 'form_config').'"><b>'.$this->l('Include available product sizes?', 'form_config').'</b></span>


							</label>


							<div class="col-xs-2">


								<select name="inc_size" id="inc_size">


									<option value="0"'


										.(((int)(0) === (int)(Tools::getValue('inc_size', $this->_configuration['GMERCHANTCENTER_INC_SIZE']))) ? ' selected="selected"' : '')


										.'>'.$this->l('No', 'form_config').'</option>'."\n".


										'<option value="1"'


										.(((int)(1) === (int)(Tools::getValue('inc_size', $this->_configuration['GMERCHANTCENTER_INC_SIZE']))) ? ' selected="selected"' : '')


										.'>'.$this->l('Yes', 'form_config').'</option>


								</select>


								<br/>


								<select name="size_opt[]" multiple="multiple" size="8" id="size_opt">


									<option value="0">--</option>';


										foreach ($attributeGroups as $group)


											$this->_html .= '<option value="'.$group['id_attribute_group'].'"'


												.((in_array((int)($group['id_attribute_group']), explode(',', $this->_configuration['GMERCHANTCENTER_SIZE_OPT']))) ? ' selected="selected"' : '')


												.'>'.$group['name'].'</option>';


										$this->_html .= '


								</select>


								<div class="alert-tag">Google: [g:size]</div>


							</div>


							<div>


								<span class="icon-question-sign" title="'.$this->l('This is recommended for clothing. If applicable, select one or more attribute group(s).', 'form_config').' '.$this->l('Note: a maximum of 30 items will be sent to Google, as Google does not accept more.', 'form_config').'"></span>


								<span class="icon-info-sign" title=""></span><a href="'.self::BT_FAQ_MAIN_URL.'17&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a>


							</div>


						</div>





						<div class="form-group ">


							<label class="control-label col-lg-3">


								<span class="label-tooltip" title="'.$this->l('This is recommended for clothing. If applicable, select one or more attribute group(s).', 'form_config').' '.$this->l('Note: a maximum of 30 items will be sent to Google, as Google does not accept more.', 'form_config').'"><b>'.$this->l('Include available product colors?', 'form_config').'</b></span>


							</label>


							<div class="col-xs-2">


								<select name="inc_color" id="inc_color">


									<option value="0"'


										.(((int)(0) === (int)(Tools::getValue('inc_color', $this->_configuration['GMERCHANTCENTER_INC_COLOR']))) ? ' selected="selected"' : '')


										.'>'.$this->l('No', 'form_config').'</option>'."\n".


										'<option value="1"'


										.(((int)(1) === (int)(Tools::getValue('inc_color', $this->_configuration['GMERCHANTCENTER_INC_COLOR']))) ? ' selected="selected"' : '')


										.'>'.$this->l('Yes', 'form_config').'</option>


									<br/>;


								</select>


								<br/>


								<select name="color_opt[]" multiple="multiple" size="8" id="color_opt">


									<option value="0">--</option>';


										foreach ($attributeGroups as $group)


											$this->_html .= '<option value="'.$group['id_attribute_group'].'"'


												.((in_array((int)($group['id_attribute_group']), explode(',', $this->_configuration['GMERCHANTCENTER_COLOR_OPT']))) ? ' selected="selected"' : '')


												.'>'.$group['name'].'</option>';


										$this->_html .= '


								</select>


								<div class="alert-tag">Google: [g:color]</div>


							</div>


							<div>


								<span class="icon-question-sign" title="'.$this->l('This is recommended for clothing. If applicable, select one or more attribute group(s).', 'form_config').' '.$this->l('Note: a maximum of 30 items will be sent to Google, as Google does not accept more.', 'form_config').'"></span>


								<span class="icon-info-sign" title=""></span><a href="'.self::BT_FAQ_MAIN_URL.'17&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a>


							</div>


						</div>


						<center><input class="btn btn-success" type="submit" name="submitGS" value="'.$this->l('Update settings', 'form_config').'" class="GMCbutton" /></center>


						</div>


						<script type="text/javascript">


						if($("#inc_feat").val() == "0")


							{


							    $("#feat_opt").hide();


							}


							else


							{


							    $("#feat_opt").show();


							}


						$( "#inc_feat" ).change(function() {


						    if($("#inc_feat").val() == "0")


							{


							    $("#feat_opt").hide();


							}


							else


							{


							    $("#feat_opt").show();


							}


						})


						//g:genre


						if($("#inc_genre").val() == "0")


							{


							    $("#genre_opt").hide();


							}


							else


							{


							    $("#genre_opt").show();


							}


						$( "#inc_genre" ).change(function() {


						    if($("#inc_genre").val() == "0")


							{


							    $("#genre_opt").hide();


							}


							else


							{


							    $("#genre_opt").show();


							}


						})


						//size


						if($("#inc_size").val() == "0")


							{


							    $("#size_opt").hide();


							}


							else


							{


							    $("#size_opt").show();


							}


						$( "#inc_size" ).change(function() {


						    if($("#inc_size").val() == "0")


							{


							    $("#size_opt").hide();


							}


							else


							{


							    $("#size_opt").show();


							}


						})


						//color


						if($("#inc_color").val() == "0")


							{


							    $("#color_opt").hide();


							}


							else


							{


							    $("#color_opt").show();


							}


						$( "#inc_color" ).change(function() {


						    if($("#inc_color").val() == "0")


							{


							    $("#color_opt").hide();


							}


							else


							{


							    $("#color_opt").show();


							}


						})


						//adult


						if($("#tag_adult").val() == "0")


							{


							    $("#tag_adult_link").hide();


							}


							else


							{


							    $("#tag_adult_link").show();


							}


						$( "#tag_adult" ).change(function() {


						    if($("#tag_adult").val() == "0")


							{


							    $("#tag_adult_link").hide();


							}


							else


							{


							    $("#tag_adult_link").show();


							}


						})


					</script>


					</div>





					<!-- end of dd 4 -->





					<div id="dropdown5" class="tab-pane fade">


					<div class="form-horizontal">


						<h3>'.$this->l('Apparel feed options', 'form_config').'</h3>


							<div class="clr_hr"></div>


							<div class="clr_20"></div>


							<div class="fbpscClearAdmin"></div>


							<div class="alert alert-info">


								<p>'.$this->l('If available, clothing and apparel stores should try to include these options.', 'form_config').'</p>


								<p>'.$this->l('For material and pattern you can set these value in "Feature" management from Prestashop ', 'form_config').'</p>


								<p>'.$this->l('For Gender and Age Group you can select the value directly on the dropdown menu', 'form_config').'</p>


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('If available, you should indicate this for all apparel products', 'form_config').'"><b>'.$this->l('Include product material?', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


									<select name="inc_mater" id="material">


										<option value="0"'


											.(((int)(0) === (int)(Tools::getValue('inc_mater', $this->_configuration['GMERCHANTCENTER_INC_MATER']))) ? ' selected="selected"' : '')


											.'>'.$this->l('No', 'form_config').'</option>'."\n".


											'<option value="1"'


											.(((int)(1) === (int)(Tools::getValue('inc_mater', $this->_configuration['GMERCHANTCENTER_INC_MATER']))) ? ' selected="selected"' : '')


											.'>'.$this->l('Yes', 'form_config').'</option>


									</select>


									<div class="alert-tag">Google: [g:material]</div>


									<div id="material_link">';


										if ($this->_configuration['GMERCHANTCENTER_INC_MATER'] == 1)


										{


											$this->_html .= '<p class="alert alert-success"><a class="thickbox" style="font-weight: bold; text-decoration: underline;" href="index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminToken('AdminModules'.(int)(Tab::getIdFromClassName('AdminModules')).(Tools::getValue('id_employee', $cookie->id_employee))).'&featurescatlist=1&usetag=material&featurescatlist=1&id_lang='.(int)($cookie->id_lang).'&TB_iframe=true&width=1000&height=600&thickbox=true">'.$this->l('Click here to configure the Tag for each category','form_config').'</a></p>';


										}


										else


										{


											$this->_html .= '<p class="alert alert-danger" id="save_require">'.$this->l('Save your configuration before configure the TAG', 'form_config').'</p>';


										}


										$this->_html .= '


									</div>


								</div>


								<div>


									<span class="icon-question-sign" title="'.$this->l('If available, you should indicate this for all apparel products', 'form_config').'"></span>


									<span class="icon-info-sign" title=""></span><a href="'.self::BT_FAQ_MAIN_URL.'18&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a>


								</div>


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('If available, you should indicate this for all apparel products', 'form_config').'"><b>'.$this->l('Include product pattern?', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


									<select name="inc_patt" id="pattern">


										<option value="0"'


											.(((int)(0) === (int)(Tools::getValue('inc_patt', $this->_configuration['GMERCHANTCENTER_INC_PATT']))) ? ' selected="selected"' : '')


											.'>'.$this->l('No', 'form_config').'</option>'."\n".


											'<option value="1"'


											.(((int)(1) === (int)(Tools::getValue('inc_patt', $this->_configuration['GMERCHANTCENTER_INC_PATT']))) ? ' selected="selected"' : '')


											.'>'.$this->l('Yes', 'form_config').'</option>


									&nbsp;


									</select>


									<div class="alert-tag">Google: [g:pattern]</div>


									<div id="pattern_link">';


										if ($this->_configuration['GMERCHANTCENTER_INC_PATT'] == 1)


										{


											$this->_html .= '<p class="alert alert-success"><a class="thickbox" style="font-weight: bold; text-decoration: underline;" href="index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminToken('AdminModules'.(int)(Tab::getIdFromClassName('AdminModules')).(Tools::getValue('id_employee', $cookie->id_employee))).'&featurescatlist=1&usetag=pattern&id_lang='.(int)($cookie->id_lang).'&TB_iframe=true&width=1000&height=600&thickbox=true">'.$this->l('Click here to configure the Tag for each category','form_config').'</a>


																										</p>';


										}


										else


										{


											$this->_html .= '<p class="alert alert-danger" id="save_require">'.$this->l('Save your configuration before configure the TAG', 'form_config').'</p>';


										}


										$this->_html .= '


									</div>


								</div>


								<div>


									<span class="icon-question-sign" title="'.$this->l('If available, you should indicate this for all apparel products', 'form_config').'"></span>


									<span class="icon-info-sign" title=""></span><a href="'.self::BT_FAQ_MAIN_URL.'18&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a>


								</div>


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('If available, you should indicate this for all apparel products. See instructions above for this.', 'form_config').'"><b>'.$this->l('Include product gender?', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


									<select name="inc_gend" id="inc_gend">


									<option value="0"'


										.(((int)(0) === (int)(Tools::getValue('inc_gend', $this->_configuration['GMERCHANTCENTER_INC_GEND']))) ? ' selected="selected"' : '')


										.'>'.$this->l('No', 'form_config').'</option>'."\n".


										'<option value="1"'


										.(((int)(1) === (int)(Tools::getValue('inc_gend', $this->_configuration['GMERCHANTCENTER_INC_GEND']))) ? ' selected="selected"' : '')


										.'>'.$this->l('Yes', 'form_config').'</option>


																		&nbsp;


									</select>


									<div class="alert-tag">Google: [g:gender]</div>


									<div id="gender_link">';


										if ($this->_configuration['GMERCHANTCENTER_INC_GEND'] == 1)


										{


											$this->_html .= '<p class="alert alert-success"><a class="thickbox" style="font-weight: bold; text-decoration: underline;" href="index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminToken('AdminModules'.(int)(Tab::getIdFromClassName('AdminModules')).(Tools::getValue('id_employee', $cookie->id_employee))).'&featurescatlist=1&usetag=gender&id_lang='.(int)($cookie->id_lang).'&TB_iframe=true&width=1000&height=600&thickbox=true">'.$this->l('Click here to configure the Tag for each category','form_config').'</a>


																					</p>';


										}


										else


										{


											$this->_html .= '<p class="alert alert-danger" id="save_require">'.$this->l('Save your configuration before configure the TAG', 'form_config').'</p>';


										}


										$this->_html .= '


										</div>


									</div>


								<div>


									<span class="icon-question-sign" title="'.$this->l('If available, you should indicate this for all apparel products. See instructions above for this.', 'form_config').'"></span>


									<span class="icon-info-sign" title=""></span><a href="'.self::BT_FAQ_MAIN_URL.'15&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a>


								</div>


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('If available, you should indicate this for all apparel products. See instructions above for this.', 'form_config').'"><b>'.$this->l('Include product age group?', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


									<select name="inc_age" id="inc_age">


										<option value="0"'


											.(((int)(0) === (int)(Tools::getValue('inc_age', $this->_configuration['GMERCHANTCENTER_INC_AGE']))) ? ' selected="selected"' : '')


											.'>'.$this->l('No', 'form_config').'</option>'."\n".


											'<option value="1"'


											.(((int)(1) === (int)(Tools::getValue('inc_age', $this->_configuration['GMERCHANTCENTER_INC_AGE']))) ? ' selected="selected"' : '')


											.'>'.$this->l('Yes', 'form_config').'</option>


																					&nbsp;


									</select>


								<div class="alert-tag">[g:age_group]</div>


								    <div id="age_group_link">';


											if ($this->_configuration['GMERCHANTCENTER_INC_AGE'] == 1)


											{


												$this->_html .= '<p class="alert alert-success"><a class="thickbox" style="font-weight: bold; text-decoration: underline;" href="index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminToken('AdminModules'.(int)(Tab::getIdFromClassName('AdminModules')).(Tools::getValue('id_employee', $cookie->id_employee))).'&featurescatlist=1&usetag=age&id_lang='.(int)($cookie->id_lang).'&TB_iframe=true&width=1000&height=600&thickbox=true">'.$this->l('Click here to configure the Tag for each category','form_config').'</a>


																						</p>';


											}


											else


											{


												$this->_html .= '<p class="alert alert-danger" id="save_require">'.$this->l('Save your configuration before configure the TAG', 'form_config').'</p>';


											}


											$this->_html .= '


										</div>


									</div>


								<div>


									<span class="icon-question-sign" title="'.$this->l('If available, you should indicate this for all apparel products. See instructions above for this.', 'form_config').'"></span>


									<span class="icon-info-sign" title=""></span><a href="'.self::BT_FAQ_MAIN_URL.'16&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a>


								</div>


							</div>


								<center><input class="btn btn-success" type="submit" name="submitGS" value="'.$this->l('Update settings', 'form_config').'" class="GMCbutton" /></center>


						<script type="text/javascript">


						if($("#material").val() == "0")


							{


							    $("#material_link").hide();


							}


							else


							{


							    $("#material_link").show();


							}


						$( "#material" ).change(function() {


						    if($("#material").val() == "0")


							{


							    $("#material_link").hide();


							}


							else


							{


							    $("#material_link").show();


							}


						})


						//patern


						if($("#pattern").val() == "0")


						    {


						        $("#pattern_link").hide();


						    }


						    else


						    {


                                $("#pattern_link").show();


						    }


						$( "#pattern" ).change(function() {


						    if($("#pattern").val() == "0")


							{


							    $("#pattern_link").hide();


							}


							else


							{


							    $("#pattern_link").show();


							}


						})


						//gender


						if($("#inc_gend").val() == "0")


						    {


						        $("#gender_link").hide();


						    }


						    else


						    {


                                $("#gender_link").show();


						    }


						$( "#inc_gend" ).change(function() {


						    if($("#inc_gend").val() == "0")


							{


							    $("#gender_link").hide();


							}


							else


							{


							    $("#gender_link").show();


							}


						})


						// age group management


						if($("#inc_age").val() == "0")


						    {


						        $("#age_group_link").hide();


						    }


						    else


						    {


                                $("#age_group_link").show();


						    }


						$( "#inc_age" ).change(function() {


						    if($("#inc_age").val() == "0")


							{


							    $("#age_group_link").hide();


							}


							else


							{


							    $("#age_group_link").show();


							}


						})


						</script>


					</div>


				</div>





					<!-- end of dd 5 -->





					<div id="dropdown6" class="tab-pane fade">


						<h3>'.$this->l('Google product categories', 'form_config').'&nbsp;&nbsp;<span class="icon-info-sign" title=""></span><a href="'.self::BT_FAQ_MAIN_URL.'16&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a></h3>


							<div class="alert-tag">


							[g:google_product_category]


						</div>


							<div class="clr_hr"></div>


							<div class="clr_20"></div>


							<div class="fbpscClearAdmin"></div>


							<div class="alert alert-info">


								'.$this->l('Each Google country has its own taxonomy (some countries share the same one though). Therefore, you must match your categories for each country you wish to submit your feed for separately. So if you wish to submit for US and UK / GB, you must match the categories for each of those two, but can leave out any other countries where you do not want to submit your feed. Note that not all product types require a Google product category. Please visit http://www.google.com/support/merchants/bin/answer.py?answer=160081 for more information.', 'form_config').'<br /><br />'.


								$this->l('Use the tool below to manage your Google categories. The pencil icon ', 'form_config').' <span class="icon-pencil"></span> '.$this->l(' allows you to match your PrestaShop categories to the Google taxonomy categories. The reload icon ', 'form_config').' <span class="icon-refresh"></span> '.$this->l(' allows you to do a real-time update of the module\'s database of Google categories. This should not be needed as Google does not update this very often, but if you notice that some categories are missing in the choices you get offered, compared to what can be found on http://www.google.com/support/merchants/bin/answer.py?answer=160081, you can go ahead and update your database.', 'form_config').'<br /><br />';


							$this->_html .='


							</div>


							<table border="0" cellpadding="2" cellspacing="2" width="400px" class="table table-striped">


								<tr>


									<th>'.$this->l('Google ISO code', 'form_config').'</th>


									<th>'.$this->l('Concerned countries', 'form_config').'</th>


									<th align="center">'.$this->l('Update my categories', 'form_config').'</th>


									<th align="center">'.$this->l('Synch from Google', 'form_config').'</th>


								</tr>';


									foreach($taxonomyCountries as $tCode => $data)


									{


										$iso = substr($tCode, 0, 2);


										// fix for Brazil


										if ($tCode == 'pt-BR')


										{


											$iso = ( Language::getIdByIso('pb') ? 'pb' : 'br');


											$id_lang = Language::getIdByIso(strval($iso));


										}


										else


										{


											$id_lang = (int)($data['id_lang']);


										}


										$this->_html .= '<tr><td>'.$tCode.'</td><td>'.implode(', ', $data['countries']).'</td>';


										if (sizeof(Db::getInstance()->ExecuteS('SELECT `id_taxonomy` FROM  '._DB_PREFIX_.'gmc_taxonomy WHERE lang = "'.$tCode.'"')) > 1)


										{


											$this->_html .= '<td  id="gcupd_'.$tCode.'"><a class="thickbox" href="index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminToken('AdminModules'.(int)(Tab::getIdFromClassName('AdminModules')).(Tools::getValue('id_employee', $cookie->id_employee))).'&gcatlist=1&id_lang='.(int)($id_lang).'&glang='.strval($tCode).'&TB_iframe=true&width=1000&height=600&thickbox=true"><span class="icon-pencil"></span></a></td>';


										}


										else


										{


											$this->_html .= '<td id="gcupd_'.$tCode.'">'.$this->l('Please synch first, click there -->', 'form_config').'</td>';


										}


										$this->_html .= '<td><a href="javascript:void(0);" class="regenGTX" id="'.$tCode.'" rel="'.$id_lang.'"><span class="icon-refresh"></span></a>&nbsp;&nbsp;<span id="regen_GTX_'.$tCode.'"></span></td></tr>';


									}


									$this->_html .= '


								</table>


								<center><input class="btn btn-success"type="submit" name="submitGS" value="'.$this->l('Update settings', 'form_config').'" class="GMCbutton" /></center>


								<div id="loadingDiv" style="display: none;"><img src="'._MODULE_DIR_.$this->name.'/img/admin/loading.gif" alt="Loading" /><br /><br />'.$this->l('Update from Google in progress...', 'form_config').'</div>


					</div>


					<!-- end of dd 6-->





					<div id="dropdown7" class="tab-pane fade">


						<h3>'.$this->l('Google Adwords / Custom label integration', 'form_config').'</h3>


						<div class="alert-tag">


							[adwords_grouping], [adwords_labels]


						</div>


						<div class="clr_hr"></div>


						<div class="clr_20"></div>


						<div class="fbpscClearAdmin"></div>


						<div class="alert alert-info">


							<p>'.$this->l('This section allow you to associate adwords_grouping and adwords_labels based on categories, brands and suppliers. This is a pretty advanced feature, so we are assuming you are familiar with how this works on the Google side and we are not going to explain it here. If you have no idea what this is, you may simply ignore this section.<br /><br />For more information, please visit', 'form_config').' <a href="http://support.google.com/merchants/bin/answer.py?answer=188479" target="_blank" style="text-decoration: underline;">http://support.google.com/merchants/bin/answer.py?answer=188479</a>.</p><br />


						</div>


						<a class="thickbox" href="index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminToken('AdminModules'.(int)(Tab::getIdFromClassName('AdminModules')).(Tools::getValue('id_employee', $cookie->id_employee))).'&gadwords=1&TB_iframe=true&width=1000&height=600&thickbox=true">


						<div class="add_adwords"><span class="icon-plus-sign"></span></a>


						<a class="thickbox" href="index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminToken('AdminModules'.(int)(Tab::getIdFromClassName('AdminModules')).(Tools::getValue('id_employee', $cookie->id_employee))).'&gadwords=1&TB_iframe=true&width=1000&height=600&thickbox=true">


						'.$this->l('Add an adwords_labels or adwords_grouping tag or custom_label', 'form_config').'</a></div><br/><br/>


						<div id="tagslist">


						<table id="tags"></table>


						</div>


						<script type="text/javascript">


							function reloadGMCAdwordsTags()


							{


								$.ajax({


								type: "GET",


								url: "'.$_SERVER['REQUEST_URI'].'",


								dataType: "json",


								data: "loadTags=1",


								async : true,


								success: function(data)


								{


								if (data.length > 0)


								{


									$("#tags").remove();


									$(\'<table id="tags" class="table table-striped"></table>\').appendTo("#tagslist");


									$(\'<tr><th>'.$this->l('Tag', 'form_config').'</th><th align="center">'.$this->l('Edit', 'form_config').'</th></tr>\').appendTo("#tags");


									$.each(data, function(i, el) {


										$(\'<tr><td>\'+el.name+\' (\'+el.type+\')</td></td><td><a class="thickbox" href="index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminToken('AdminModules'.(int)(Tab::getIdFromClassName('AdminModules')).(Tools::getValue('id_employee', $cookie->id_employee))).'&gadwords=1&id_tag=\'+el.id_tag+\'&TB_iframe=true&width=1000&height=600&thickbox=true"><span class="icon-pencil"></span></a></td></tr>\').appendTo("#tags");


									tb_init(\'a.thickbox, area.thickbox, input.thickbox\');


									});


								}


							},


							error: function()


							{


								alert("'.$this->l('Error while retrieving list of tags.').'");


							}


							});


							}


						</script>


					</div>


					<!-- end of dd 7 -->





					<div id="dropdown8" class="tab-pane fade">


						<div class="form-horizontal">


							<h3>'.$this->l('Google Analytics integration', 'form_config').'</h3>


								<div class="clr_hr"></div>


								<div class="clr_20"></div>


								<div class="fbpscClearAdmin"></div>


							<div class="alert alert-info">


								<p>'.$this->l('This section allow you to add some parameters in your product links (utm_campaign, utm_source and utm_medium) so that you can better track clicks and sales from your Google Adwords Product Listing Ad campaigns in in your Google Analytics account. If a parameter is left empty below, it will not be added. Please add alphanumerical characters only, without spaces. You can use - or _ signs however.', 'form_config').'</p>


								<p>'.$this->l('Note: if you use this feature, you will want to make sure that the utm_campaign, utm_source and utm_medium parameters are not disallowed in your robots.txt file', 'form_config').'</p><br />


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span title=""><b>'.$this->l('Value of parameter for utm_campaign', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


									<input type="text" name="utm_campaign" value="'.Tools::getValue('utm_campaign', $this->_configuration['GMERCHANTCENTER_UTM_CAMPAIGN']).'" />


								</div>


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span title=""><b>'.$this->l('Value of parameter for utm_source', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


									<input type="text" size="30" name="utm_source" value="'.Tools::getValue('utm_source', $this->_configuration['GMERCHANTCENTER_UTM_SOURCE']).'" />


								</div>


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span title=""><b>'.$this->l('Value of parameter for utm_medium', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


									<input type="text" size="30" name="utm_medium" value="'.Tools::getValue('utm_medium', $this->_configuration['GMERCHANTCENTER_UTM_MEDIUM']).'" />


								</div>


							</div>


							<center><input class="btn btn-success" type="submit" name="submitGS" value="'.$this->l('Update settings', 'form_config').'" class="GMCbutton" /></center>


						</div>


					</div>


					<!-- end of dd 8 -->





					<div id="dropdown9" class="tab-pane fade">


						<div class="form-horizontal">


							<h3>'.$this->l('Tax and shipping fees', 'form_config').'&nbsp;&nbsp;<span class="icon-info-sign"></span><a href="'.self::BT_FAQ_MAIN_URL.'51&lg='.$isoCurrent.'" target="_blank">&nbsp;FAQ</a></h3>


							<div class="alert-tag">


								Google: [g:shipping]


							</div>


									<div class="clr_hr"></div>


									<div class="clr_20"></div>


									<div class="fbpscClearAdmin"></div>


							<div class="alert alert-info">


								<p>'.$this->l('TAXES: Detailed tax information is only required for feeds targeting the United States. If you do not sell in the US, products will automatically have VAT applied to them in the main product price, as required by Google. If you sell in the US and need to specify taxes by state or ZIP code, please simply define them on your Google Merchant Center account, in the "Settings" -> "Tax and shipping" tab.', 'form_config').'</p>


								<p>'.$this->l('SHIPPING: Please select the appropriate default carrier for each country below', 'form_config').':</p>


								<p>&nbsp;</p>


							</div>


							<table>';


								$shipping_html = array();


								foreach ($this->gMerchantCenterCountries as $lang => $countries)


								{


									$check = Db::getInstance()->ExecuteS('SELECT * from `'._DB_PREFIX_.'lang` where `active` = 1 AND `iso_code` = "'.$lang.'"');


									if ($check && sizeof($check))


									{


										foreach ($countries as $country => $localeData)


										{


											$countryId = Country::getByIso($country);


											if (!empty($countryId))


											{


												$countryZone = Country::getIdZone($countryId);


												if (!empty($countryZone))


												{


													$carriers = $this->getAvailableCarriers((int)($countryZone));


													if (Currency::getIdByIsoCode($localeData['currency']))


													{


														$shippingCarriers[$country] = (isset($_POST['ship_carriers'][$country]) ? $_POST['ship_carriers'][$country] :


															(isset($this->_configuration['GMERCHANTCENTER_SHIP_CARRIERS'][$country]) ? $this->_configuration['GMERCHANTCENTER_SHIP_CARRIERS'][$country] : 0) );


														if (!array_key_exists($country, $shipping_html))


															$shipping_html[$country] = '


																							<div class="form-group ">


																								<label class="control-label col-lg-3">


																									<span title=""><b>'.$country.'</b></span>


																								</label>


																								<div class="col-xs-2">


																									<select name="ship_carriers['.$country.']">';


														foreach ($carriers as $c)


															$shipping_html[$country] .= '<option'.(((int)$c['id_carrier'] == (int)$shippingCarriers[$country]) ? ' selected' : '').' value="'.$c['id_carrier'].'">'.$c['name'].'</option>';


														$shipping_html[$country] .= '


																									</select>


																								</div>


																						</div>';


													}


												}


											}


										}


									}


								}


								foreach ($shipping_html as $k => $html)


									$this->_html .= $html;


								$this->_html .= '


								</table>


							<p class="clear">&nbsp;</p><br />


							<center><input class="btn btn-success"type="submit" name="submitGS" value="'.$this->l('Update settings', 'form_config').'" class="GMCbutton" /></center>


						</div>


					</div>


					<!-- end of dd 9 -->





					<div id="tab-3" class="tab-pane fade ">


						<div class="horizontal">


							<h3>'.$this->l('Reporting', 'form_config').'</h3>


							<div class="clr_hr"></div>


							<div class="clr_20"></div>


							<div class="fbpscClearAdmin"></div>


							<div class="alert alert-info">


								<p>'.$this->l('This section allows you to get diagnostic information about the quality of your feed and catch any problems with your data prior to submitting it to Google. For each type of warning, we will provide you with the ability to see which products are affected as well as how to fix the issue.', 'form_config').'<br /><br /><span style="font-weight: bold; color: red!important;">'.$this->l('Please understand that these warnings come from 1) either an incorrect configuration of the module or 2) data missing in your products. WE WILL NOT BE ABLE TO DO ANYTHING ABOUT IT. Either way, please simply refer to the recommendations in the diagnostic tool and you will have the information needed to be able to get rid of all issues.', 'form_config').'</strong></p><br />


							</div>


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('Generate and Show reporting window automatically after regenerating a feed. If you\'ve got an important bulk of products (many thousands), you should leave this option deactivated in order to improve speed and performance of data feed generating. You still can re-activate it the next time if you need information about your missing attributes of products', 'form_config').'"><b>'.$this->l('Activate flux reporting', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">


									<select name="reporting">


										<option value="0"'


											.(((int)(0) === (int)(Tools::getValue('reporting', $this->_configuration['GMERCHANTCENTER_REPORTING']))) ? ' selected="selected"' : '').'>'.$this->l('No', 'form_config').'</option>'."\n".


											'<option value="1"'


											.(((int)(1) === (int)(Tools::getValue('reporting', $this->_configuration['GMERCHANTCENTER_REPORTING']))) ? ' selected="selected"' : '').'>'.$this->l('Yes', 'form_config').'</option>';


										$this->_html .= '


									</select>


								</div>


								<span class="icon-question-sign" title="'.$this->l('Generate and Show reporting window automatically after regenerating a feed. If you\'ve got an important bulk of products (many thousands), you should leave this option deactivated in order to improve speed and performance of data feed generating. You still can re-activate it the next time if you need information about your missing attributes of products', 'form_config').'"></span>


							</div>


							<center><input class="btn btn-success" type="submit" name="submitGS" value="'.$this->l('Update settings', 'form_config').'" class="GMCbutton" /></center>


							<div class="form-group ">


								<label class="control-label col-lg-3">


									<span class="label-tooltip" title="'.$this->l('Select language to get an explicit reporting about products errors and warnings', 'form_config').'"><b>'.$this->l('Select your reporting flux', 'form_config').'</b></span>


								</label>


								<div class="col-xs-2">';


									if (!empty($aLang))


									{


										$this->_html .= '


												<select id="selectReporting" name="selectReporting">


												<option value="">...</option>';


										foreach ($aLang as $sISO) {


											$this->_html .= '<option value="' . $sISO . '">' . $sISO . '</option>';


										}


									}


									else


										$this->_html .= '<div class="alert alert-warning">'.$this->l('There are currently no reports available. Please make sure that the "reporting" folder inside the "gmerchantcenter" module folder has correct write permissions.').'</div>';


									$this->_html .= '


									</select>


								</div>


								<span class="icon-question-sign" title="'.$this->l('Select language to get an explicit reporting about products errors and warnings', 'form_config').'"></span>


							</div>


						</div>


					</div>


					<!-- end of tab 3 -->





					<div id="tab-4" class="tab-pane fade">


						<div class="clr_hr"></div>


						<div class="clr_20"></div>


						<div class="fbpscClearAdmin"></div>


						<div class="alert alert-danger" id="no_data_check">


							'.$this->l('You have to select an export method, and check category or brand tree.','form-config').'


							<a data-toggle="tab" href="#dropdown1">'.$this->l('Click here to configure','form-config').'</a>


						</div>


						<div class="alert alert-success" id="data_check">


							'.$this->l('Your "Export method" is configured','form_config').'


						</div>


						<h3>'.$this->l('Your XML files', 'form_config').'</h3>


						<div class="clr_hr"></div>


						<div class="clr_20"></div>


						<div class="fbpscClearAdmin"></div>


								<div id="syncCounterDiv" style="display: none;">


									<table>


									    <tr>


									        <td>'.$this->l('Number of products generated: ', 'form_config').' <input type="text" size="5" name="regen_counter" id="regen_counter" value="0" /></td>


									        <td>&nbsp;</td>


									        <td>&nbsp;</td>


									        <td>/</td>


									        <td>&nbsp;</td>


									        <td>&nbsp;</td>


									        <td>'.(int)($productCount['cnt']).'</td>


									        <td>&nbsp;</td>


									        <td>&nbsp;</td>


									        <td><div id="loaderbar"><img id="loaderbarImg" src="'._MODULE_DIR_.$this->name.'/img/admin/loadbar.png'.'" width="1" height="16" /></div></td>


									    </tr>


                                    </table>


							</div>


							';





									if (Configuration::get('GMERCHANTCENTER_CHECK_EXPORT') != '')


									{


										// language save


										$aLangCron = unserialize(Configuration::get('GMERCHANTCENTER_CHECK_EXPORT'));


									}


									else


									{


										$aLangCron = array();


									}


									if ($this->_configuration['GMERCHANTCENTER_LINK'] && !empty($this->_configuration['GMERCHANTCENTER_LINK']))


									{


										$this->_html .= '


									<table border="0" cellpadding="2" cellspacing="2" class="table table-striped">


									<tr>


										<th>'.$this->l('Regenerate during CRON', 'form_config').'</th>


										<th>'.$this->l('Language / country', 'form_config').'</th>


										<th>'.$this->l('File (right-click and "Save As" to download)', 'form_config').'</th>


										<th align="center">'.$this->l('Update / regenerate', 'form_config').'</th>


									</tr>';


										foreach ($this->gMerchantCenterCountries as $lang => $countries)


												{


													foreach ($countries as $country => $localeData)


													{


														if (Currency::getIdByIsoCode($localeData['currency']))


														{


															$fileSuffix = $this->_buildFileSuffix($lang, $country);


															if (is_file($this->xmlDir.$this->xmlFilePrefix.'.'.$fileSuffix.'.xml'))


															{


																$link = $this->_configuration['GMERCHANTCENTER_LINK'].__PS_BASE_URI__.$this->xmlFilePrefix.'.'.$fileSuffix.'.xml';


																$this->_html .= '<tr>


																					<td><input type="checkbox" name="cron_export[]" value="'.$country.'" '.(in_array($country, $aLangCron) ? ' checked="checked"' : '').'"/></td>


																					<td>'.$lang.'-'.$country.'</td>


																					<td><a target="_blank" href="'.$link.'">'.$link.'</a></td>


																					<td><a href="javascript:void(0);" class="regenXML" id="'.strtolower($lang).'_'.$country.'"><span class="icon-refresh"></span></a>&nbsp;<span id="regen_XML_'.strtolower($lang).'_'.$country.'"></span></td>


																					</tr>';


															}


												}


											}


										}


										$this->_html .= '</table>


										<center><input class="btn btn-success"type="submit" name="submitGS" value="'.$this->l('Update settings', 'form_config').'" class="GMCbutton" /></center>';


										}


										else


											$this->_html .= $this->l('You must first update the module\'s configuration options before the files can be accessed.', 'form_config');


										$this->_html .='


									<div id="loadingDiv" style="display: none;"><img src="'._MODULE_DIR_.$this->name.'/img/admin/loading.gif" alt="Loading" /><br /><br />'.$this->l('Update from Google in progress...', 'form_config').'</div>


									<div id="reportingDiv" style="display: none;"></div>


									<h3>'.$this->l('Your PHP URL\'s for on-the-fly output:', 'form_config').'</h3>


									<div class="clr_hr"></div>


									<div class="clr_20"></div>


									<div class="fbpscClearAdmin"></div>';


										if ($this->_checkOutputFile())


										{


											if ($this->_configuration['GMERCHANTCENTER_LINK'] && !empty($this->_configuration['GMERCHANTCENTER_LINK']))


											{


												$this->_html .= '


												<table border="0" cellpadding="2" cellspacing="2" class="table table-striped">


													<tr>


														<th>'.$this->l('Language / country', 'form_config').'</th>


														<th>'.$this->l('URL (right-click and "Save As" to download)', 'form_config').'</th>


													</tr>';


													foreach ($languages as $language)


													{


														$countries = $this->gMerchantCenterCountries[$language['iso_code']];


														foreach ($countries as $country => $localeData)


														{


															if (Currency::getIdByIsoCode($localeData['currency']))


															{


																if ($this->_configuration['GMERCHANTCENTER_FEED_PROTECTION'] == 0)


																{


																	$link = $this->_configuration['GMERCHANTCENTER_LINK'].__PS_BASE_URI__.'gmerchantcenter.xml.php?id_shop='.(int)($this->id_shop).'&id_lang='.(int)($language['id_lang']).'&amp;country='.$country.'&amp;currency_iso='.$localeData['currency'];


																}


																else


																{


																	$link = 'http://'.trim(Configuration::get('PS_SHOP_DOMAIN')).'/gmerchantcenter.feed.php?id_shop='.(int)($this->id_shop).'&token='.$this->_configuration['GMERCHANTCENTER_FEED_TOKEN'].'&id_lang='.(int)($language['id_lang']).'&amp;country='.$country.'&amp;currency_iso='.$localeData['currency'];


																}


																$this->_html .= '<tr><td>'.$language['iso_code'].'-'.$country.'</td><td><a target="_blank" href="'.$link.'">'.$link.'</a></td></tr>';


															}


														}


													}


													$this->_html .= '


											 </table>';


											}


											else


												$this->_html .= $this->l('You must first update the module\'s configuration options before the files can be accessed.', 'form_config');


										}


										else


											$this->_html .= $this->l('To use this feature, please copy the gmerchantcenter.xml.php file from the gmerchantcenter module\'s directory to your shop\'s root directory', 'form_config');


										$cron_link = $this->_configuration['GMERCHANTCENTER_LINK']._MODULE_DIR_.$this->name.'/gmerchantcenter.cron.php?id_shop='.(int)($this->id_shop);


										$this->_html .= '


							<h3>'.$this->l('Your CRON URL', 'form_config').'</h3>


							<div class="clr_hr"></div>


							<div class="clr_20"></div>


							<div class="fbpscClearAdmin"></div>';


							if ($this->_configuration['GMERCHANTCENTER_LINK'] && !empty($this->_configuration['GMERCHANTCENTER_LINK']))


								$this->_html .= '


														<table border="0" cellpadding="2" cellspacing="2" class="table table-striped">


															<tr>


																<th>'.$this->l('URL', 'form_config').'</th>


															</tr>


															<tr>


																<td><a target="_blank" href="'.$cron_link.'">'.$cron_link.'</a></td>


															</tr>


														</table>


														<br/>


														<br/>


														<div class="alert alert-warning">'


									.$this->l('You should schedule a CRON task to execute this URL, so that your feeds will be updated automatically in time for the scheduled update you set on your Google Merchant Center account.', 'form_config').


									'</div>';


							else


								$this->_html .= $this->l('You must first update the module\'s configuration options before the files can be accessed.', 'form_config');


							$this->_html .= '


						<script type="text/javascript">


						$( document ).ready(function() {


							if ($("input.categoryBox").is(":checked") == true || $("input.brand").is(":checked") == true)


								{


									$("#data_check").show();


									$("#no_data_check").hide();


								}


								else


								{


									$("#data_check").hide();


									$("#no_data_check").show();


								}


							});


							var blocklinksXML = false;


							var blocklinksGTX = false;





							$(document).ready(function(){


								$("ul.ui-tabs-nav").tabs({selected : ' . ((isset($iActiveTab))? $iActiveTab : 0) . '});





								$("table.table-striped a.regenXML").click(function() {


									if (blocklinksXML == false)


									{


										$("#regen_counter").val(0);


										var lang = $(this).attr("id");


										oDoXMLSync = new DoXMLSync(lang);


									}


									else


										return false;


								});





								$("table.table-striped a.regenGTX").click(function() {


									if (blocklinksGTX == false)


									{


										var iso = $(this).attr("id");


										var id_lang = $(this).attr("rel");


										oDoGTXSync = new DoGTXSync(iso, id_lang);


									}


									else


										return false;


								});





							reloadGMCAdwordsTags();


						});


						';


// use case - activate reporting


				$this->_html .= '


							var DisplayReport = function(language_code)


								{


									$.ajax({


										type: "GET",


										url: "'.str_replace('&updateGMC=1', '', $_SERVER['REQUEST_URI']).'",


										data: "checkReport=1&lang="+language_code,


										async : true,


										success: function(data) {


											if (data == \'1\') {


												tb_remove();


												var sThickBox = \'<a class="thickbox2" href="'. $_SERVER['REQUEST_URI'] .'&displayReport=1&lang=\'+language_code+\'&TB_iframe=true&width=1000&height=600&thickbox=true"></a>\';


												$("#reportingDiv").empty().append(sThickBox);


												tb_init("a.thickbox2");


												$("a.thickbox2").click();


											}


										},


										error: function() {


											alert("'.$this->l('Error check linked report', 'form_config').'");


										}


									});


								};


									$("#selectReporting").bind($.browser.msie ? \'click\' : \'change\', function (event)


									{


										$("#selectReporting option:selected").each(function ()


									{


									if ($(this).val() != "") {


										oDisplayReport = new DisplayReport($(this).val());


									}


								});


							}


						);


			';


$this->_html .= '


					var DoXMLSync = function(language_code)


					{


						//var imgHtml = \'<img src="'._MODULE_DIR_.$this->name.'/img/admin/accept.png'.'" width="16" height="16" />\';


						var imgHtml = \'<span class="icon-ok-sign"></span>\';


						var regenCounter = $("#regen_counter").val();


						var productCount = $("#product_count").val();


						blocklinksXML = true;





						$("#syncCounterDiv").show();


						$("img.reloadXML").css("opacity", 0.4);





						$.ajax({


						type: "GET",


						url: "'.str_replace('&updateGMC=1', '', $_SERVER['REQUEST_URI']).'",


						data: "ajaxregen=1&ajaxfilecode="+language_code+"&ajaxfloor="+regenCounter+"&ajaxtotalproducts="+productCount,


						dataType: "json",


						async : true,


						success: function(txt) {





							$("#regen_counter").val(parseInt(txt));





							var loaderBarWidth = parseInt(txt / parseInt(productCount) * 200);


							$("#loaderbarImg").attr("width", loaderBarWidth);





							if (parseInt(txt) < parseInt(productCount))


								oDoXMLSync = new DoXMLSync(language_code);


							else


							{


								$("#regen_counter").val(productCount);


								$("#loaderbarImg").attr("width", 1);


								$("#syncCounterDiv").hide();


								$("#regen_XML_"+language_code).empty().append(imgHtml);


								$("img.reloadXML").css("opacity", 1);


								blocklinksXML = false;


							';


						// use case - activate reporting


						if ($this->_configuration['GMERCHANTCENTER_REPORTING']) {


							$this->_html .= 'oDisplayReport = new DisplayReport(language_code);';


						}


						$this->_html .= '


							}


						},


						error: function() {


							alert("'.$this->l('Error updating feed', 'form_config').'");


						}


					});


				}





				var DoGTXSync = function(iso_code, id_lang)


				{


					var imgHtml = \'<span class="icon-ok-sign"></span>\';





					var updHtml = \'<a class="thickbox" href="index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminToken('AdminModules'.(int)(Tab::getIdFromClassName('AdminModules')).(Tools::getValue('id_employee', $cookie->id_employee))).'&gcatlist=1&id_lang=\'+id_lang+\'&glang=\'+iso_code+\'&TB_iframe=true&width=1000&height=600&thickbox=true"><span class="icon-pencil"></span></a>\';





					blocklinksGTX = true;





					$("#loadingDiv").show();


					$("img.reloadGTX").css("opacity", 0.4);





					$.ajax({


						type: "GET",


						url: "'.str_replace('&updateGMC=1', '', $_SERVER['REQUEST_URI']).'",


						data: "ajaxupdategtx=1&ajaxgtxlang="+iso_code,


						async : true,


						success: function(txt) {


							if (parseInt(txt) == 0) {


								$("#loadingDiv").hide();


								alert("'.$this->l('Error updating data from Google. You need to have either file_get_contents() with the allow_url_fopen directive enabled in the php.ini file, or have the PHP CURL extension enabled in order to retrieve the file from Google. Please contact your web host. If neither of these options are available to you on your server (but at least one should be in most cases), you will not be able to use this module.', 'form_config').'");


							}


							else


							{


								$("img.reloadGTX").css("opacity", 1);


								$("#loadingDiv").hide();


								blocklinksGTX = false;


								$("#regen_GTX_"+iso_code).empty().append(imgHtml);


								$("#gcupd_"+iso_code).empty().append(updHtml);


								tb_init(\'a.thickbox\');


							}


						},


						error: function() {


							$("#loadingDiv").hide();


							alert("'.$this->l('Error updating feed', 'form_config').'");


						}


					});


				}


			</script>


					</div>





					<div id="tab-5" class="tab-pane fade">


						<h3>'.$this->l('Help resources', 'form_config').'</h3>


						<div class="clr_hr"></div>


						<div class="clr_20"></div>


						<div class="fbpscClearAdmin"></div>


						<p><strong style="font-weight: bold;">'.$this->l('MODULE PDF DOCUMENTATION: ').'</strong> <a target="_blank" href="'._PS_BASE_URL_._MODULE_DIR_.$this->name.'/readme_' .  (GMerchantCenter::$sDefaultLang == 'fr'? 'fr':'en'). '.pdf">readme_' .  (GMerchantCenter::$sDefaultLang == 'fr'? 'fr':'en'). '.pdf</a></p>


						<p><strong style="font-weight: bold;">FAQ: </strong> <a href="http://faq.businesstech.fr/?lg='.$isoCurrent.'" target="_blank">http://faq.businesstech.fr/?lg='.$isoCurrent.'</a></p>


						<p><strong style="font-weight: bold;">'.$this->l('GOOGLE DATA REQUIREMENTS HELP: ', 'form_config').'</strong> <a target="_blank" href="http://www.google.com/support/merchants/bin/answer/188494">http://www.google.com/support/merchants/bin/answer/188494</a></p>


						<p><strong style="font-weight: bold;">'.$this->l('GOOGLE MANDATORY ATTRIBUTES BY INDUSTRY: ', 'form_config').'</strong> <a target="_blank" href="https://support.google.com/merchants/answer/1344057">https://support.google.com/merchants/answer/1344057</a></p>


						<p><strong style="font-weight: bold;">'.$this->l('GOOGLE PRODUCT CATEGORIES HELP: ', 'form_config').'</strong> <a target="_blank" href="http://www.google.com/support/merchants/bin/answer/160081">http://www.google.com/support/merchants/bin/answer/160081</a></p>


						<p><strong style="font-weight: bold;">'.$this->l('CONTACT: ', 'form_config').'</strong> <a target="_blank" href="'.$this->l('http://www.businesstech.fr/en/contact-us', 'form_config').'">'.$this->l('http://www.businesstech.fr/en/contact-us', 'form_config').'</a></p>


					</div>


					<!-- end of tab 5 -->





				</div>


			</div>











';


