<?php
/**
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2014 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
exit;

class tvlogomanufacture extends Module
{

public function __construct()
{
		$this->name = 'tvlogomanufacture';
		$this->tab = 'others';
		$this->version = '1.0';
		$this->author = 'Themesvip';
		$this->module_key = '4ddaa2f6c66dba43730094b1749fabba';
		parent::__construct();

		$this->displayName = $this->l('TV Manufacturer Logo Slider');
		$this->description = $this->l('Adds Slider of Manufacturer logo on your site.');
		$this->confirmUninstall = $this->l('Are you sure that you want to delete your Manufacturer logo?');
		//$this->module_key = "";
}

public function install()
{
		Configuration::updateValue('SHOW_ADV', '1');
		
		if (!parent::install() || !$this->registerHook('header') || !$this->registerHook('displayTopColumn'))
			return false;
		return true;
}

public function uninstall()
{
		Configuration::deleteByName('SHOW_ADV');
	 	if (parent::uninstall() == false)
	 		return false;
	 	return true;
}

private function _displayHelp()
{
		
}


public function hookHeader($params)
{
		$this->context->controller->addCss($this->_path.'css/logo_manufacture.css', 'all');
}

public function hookdisplayTopColumn($params)
{
		$list_manu = Manufacturer::getManufacturers(false,0, true);
		$this->smarty->assign(array(
				'list_manu' => $list_manu,
				'manu_img_dir' => _PS_MANU_IMG_DIR_
			));

	return $this->display(__FILE__, 'views/templates/hook/tvlogomanufacture.tpl');
}

public function hookDisplayHome($params)
{			
		$list_manu = Manufacturer::getManufacturers(false,0, true);
		$this->smarty->assign(array(
				'list_manu' => $list_manu,
				'manu_img_dir' => _PS_MANU_IMG_DIR_
			));

		return $this->display(__FILE__, 'views/templates/hook/tvlogomanufacture.tpl');
}

public function hookDisplayFooter($params)
{		
			
		$list_manu = Manufacturer::getManufacturers(false,0, true);
		  $this->smarty->assign(array(
				'list_manu' => $list_manu,
				'manu_img_dir' => _PS_MANU_IMG_DIR_
			));
		return $this->display(__FILE__, 'views/templates/hook/tvlogomanufacture.tpl');
}
}


