<?php
/**
* WhatsApp Chat - Live chat
*
* NOTICE OF LICENSE
*
* This product is licensed for one customer to use on one installation (test stores and multishop included).
* Site developer has the right to modify this module to suit their needs, but can not redistribute the module in
* whole or in part. Any other use of this module constitues a violation of the user agreement.
*
* DISCLAIMER
*
* NO WARRANTIES OF DATA SAFETY OR MODULE SECURITY
* ARE EXPRESSED OR IMPLIED. USE THIS MODULE IN ACCORDANCE
* WITH YOUR MERCHANT AGREEMENT, KNOWING THAT VIOLATIONS OF
* PCI COMPLIANCY OR A DATA BREACH CAN COST THOUSANDS OF DOLLARS
* IN FINES AND DAMAGE A STORES REPUTATION. USE AT YOUR OWN RISK.
*
*  @author    idnovate.com <info@idnovate.com>
*  @copyright 2017 idnovate.com
*  @license   See above
*/

include_once(_PS_MODULE_DIR_.'whatsappchat/classes/array_column.php');

class WhatsappChatBlock extends ObjectModel
{
    public $id_whatsappchatblock;
    public $id_shop;
    public $id_hook;
    public $open_chat;
    public $message;
    public $position;
    public $color = '#25d366';
    public $mobile_phone;
    public $active;
    public $only_home;
    public $customer_groups;
    public $chat_group = '';
    public $badge_width;
	public $only_mobile;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'whatsappchatblock',
        'primary' => 'id_whatsappchatblock',
        'multilang' => true,
        'fields' => array(
            'id_shop'           => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            'id_hook'           => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName'),
            'open_chat'         => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'message'           => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'lang' => true),
            'position'          => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName'),
            'color'             => array('type' => self::TYPE_STRING, 'validate' => 'isColor'),
            'mobile_phone'      => array('type' => self::TYPE_STRING, 'validate' => 'isPhoneNumber', 'size' => 32, 'lang' => true),
            'active'            => array('type' => self::TYPE_BOOL, 'validate' => 'isBool', 'copy_post' => false),
            'only_home'         => array('type' => self::TYPE_BOOL, 'validate' => 'isBool', 'copy_post' => false),
            'customer_groups'   => array('type' => self::TYPE_STRING),
            'chat_group'        => array('type' => self::TYPE_STRING),
            'badge_width'       => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            'only_mobile'       => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
        ),
    );

    public function add($autodate = true, $null_values = true)
    {
        $this->id_shop = ($this->id_shop) ? $this->id_shop : Context::getContext()->shop->id;
        return parent::add($autodate, $null_values);
    }

    public function getWhatsappChatByHook($id_hook, $active = false, $from_bo, $id_whatsappchatblock = false)
    {
        $shopID = ($this->id_shop) ? $this->id_shop : Context::getContext()->shop->id;
        $langID = Context::getContext()->language->id;

        $sql = 'SELECT `message`, `position`, `open_chat`, `mobile_phone`, `color`, `only_home`, `chat_group`,
            `customer_groups`, `only_mobile`
            FROM `' . _DB_PREFIX_ . bqSQL($this->def['table']) . '` LEFT JOIN `'
            . _DB_PREFIX_ . bqSQL($this->def['table']) . '_lang` ON (`' . _DB_PREFIX_ . bqSQL($this->def['table'])
            . '`.`id_whatsappchatblock` = `' . _DB_PREFIX_ . bqSQL($this->def['table'])
            . '_lang`.`id_whatsappchatblock` AND `id_lang` = ' . (int)$langID.')'
            . ' WHERE `id_hook` = "' . bqSQL($id_hook) . '"'
			. (!$from_bo ? ' AND `id_shop` = ' . (int)$shopID : '')
			. ($id_whatsappchatblock ? ' AND `' . _DB_PREFIX_ . bqSQL($this->def['table']) . '`.`id_whatsappchatblock` = ' . (int)$id_whatsappchatblock : '')
            . ($active ? ' AND `active` = 1' : '');

        return Db::getInstance()->getRow($sql);
    }

    public function getWhatsappChats($active = false)
    {
        $sql = 'SELECT *
            FROM `'._DB_PREFIX_.bqSQL($this->def['table']).'`'.($active ? ' WHERE `active` = 1' : '');

        return Db::getInstance()->executeS($sql);
    }
}
