<?php
/**
 * 2007-2015 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    Needacart.com
 *  @copyright 2007-2015 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */
class AuthController extends AuthControllerCore
{
	/*
    * module: nocaptcharecaptcha
    * date: 2018-06-15 09:26:54
    * version: 2.0.1
    */
    protected function processSubmitLogin()
	{
		if (Configuration::get('RECAPTCHA_LOGIN'))
		{
			
			$recaptcha = Module::getInstanceByName('nocaptcharecaptcha');
			$max_login_attempts = (int)Configuration::get('RECAPTCHA_LOGIN_ATTEMPTS');
			if ($max_login_attempts > 0)
			{
				if ($recaptcha->getLoginAttempts() < $max_login_attempts)
				{
					if ($this->ajax)
					{
						$recaptcha->incrementLoginAttempts(true);
						return parent::processSubmitLogin();
					}
					else
					{
						parent::processSubmitLogin();
						if (count($this->errors))
							$recaptcha->incrementLoginAttempts();
						return;
					}
				}
			}
			
			$responce = $recaptcha->check();
			if (!$responce->success)
				$this->errors[] = $recaptcha->errorText();
			else
			{
				parent::processSubmitLogin();
				if (!count($this->errors))
					$recaptcha->deleteLoginAttempts();
			}
		}
		else
			return parent::processSubmitLogin();
	}
	/*
    * module: nocaptcharecaptcha
    * date: 2018-06-15 09:26:54
    * version: 2.0.1
    */
    protected function processSubmitAccount()
	{
		if (Configuration::get('RECAPTCHA_REGISTER'))
		{
			
			$recaptcha = Module::getInstanceByName('nocaptcharecaptcha');
			
			$response = $recaptcha->check();
			if (!$response->success)
			{
				$this->errors[] = $recaptcha->errorText();
				return;
			}
		}
		return parent::processSubmitAccount();
	}
}