{*
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2014 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
{if count($categoryProducts) > 0 && $categoryProducts !== false}
<div class="page-product-box blockproductscategory">
	<h2 class="productscategory_h3 page-product-heading">{$categoryProducts|@count} {l s='other products in the same category:' mod='productscategory'}</h2>
<div id="{if count($categoryProducts) > 5}productscategory{else}productscategory_noscroll{/if}">
		<div id="productscategory_list" class="list_carousel responsive">
			<ul id="carousel-productscategory">
				{foreach from=$categoryProducts item='categoryProduct' name=categoryProduct}
				<li class="ajax_block_product">
				<div class="center_block">
					<div class="image">
						<a href="{$link->getProductLink($categoryProduct.id_product, $categoryProduct.link_rewrite, $categoryProduct.category, $categoryProduct.ean13)}" class="product_img_link cs_image" title="">					
							<img src="{$link->getImageLink($categoryProduct.link_rewrite, $categoryProduct.id_image, 'home_default')}" alt="{$categoryProduct.name|htmlspecialchars}" />						
						</a>
						<a class="quick-view" href="{$categoryProduct.link|escape:'html':'UTF-8'}" rel="{$categoryProduct.link|escape:'html':'UTF-8'}">
							
						</a>
					</div>
				
					<h3 class="s_title_block"><a href="{$link->getProductLink($categoryProduct.id_product, $categoryProduct.link_rewrite, $categoryProduct.category, $categoryProduct.ean13)}" title="">{$categoryProduct.name|truncate:60:'...'|escape:'htmlall':'UTF-8'}</a>
					</h3>
					
					{if isset($categoryProduct.available_for_order) && $categoryProduct.available_for_order && !isset($restricted_country_mode)}
					{if ($categoryProduct.allow_oosp || $categoryProduct.quantity > 0)}
						<span class="availability">{l s='In stock' mod='productscategory'}</span>
					{elseif (isset($categoryProduct.quantity_all_versions) && $categoryProduct.quantity_all_versions > 0)}
						<span class="availability">{l s='Product available with different options'}</span>
					{else}<span class="cs_out_of_stock">{l s='Out of stock' mod='productscategory'}</span>{/if}
					{/if}
					
					{if $ProdDisplayPrice AND $categoryProduct.show_price == 1 AND !isset($restricted_country_mode) AND !$PS_CATALOG_MODE}
					<div class="content_price">								
									{if $priceDisplay && $categoryProduct.reduction}<span class="price-discount">{convertPrice price=$categoryProduct.price_without_reduction}</span>{/if}
									<span class="price">{if !$priceDisplay}{convertPrice price=$categoryProduct.price}{else}{convertPrice price=$categoryProduct.price_tax_exc}{/if}</span>				
					  </div>
					{/if}

				</div>
				
				</li>
				{/foreach}
			</ul>
			<div class="cclearfix"></div>
			
		</div>
		{if count($categoryProducts)>3}
			<a title="Previous" id="prev-productscategory" class="btn prev" href="javascript:void(0);">&lt;</a>
			<a title="Next" id="next-productscategory" class="btn next" href="javascript:void(0);">&gt;</a>
			{/if}
	</div>
</div>

<script type="text/javascript">
			
function runSliderProductCategory()
{
    var item_productcat = 5;
			var scrollItem=3;
			if(getWidthBrowser() > 1180)
				{	
					item_productcat = 5; 
				}
				else
				if(getWidthBrowser() > 991)
				{	
					item_productcat = 4; 
				}
				else
				if(getWidthBrowser() > 767)
				{	
					item_productcat = 3; 
				}		
				else
				if(getWidthBrowser() > 540)
				{	
					item_productcat = 3; 
				}
				else
				if(getWidthBrowser() > 340)
				{	
					item_productcat = 2; 
				}
		
		
			//	Responsive layout, resizing the items
			$('#carousel-productscategory').carouFredSel({
				responsive: true,
				width: '100%',
				height : 'variable',
				onWindowResize: 'debounce',
				prev: '#prev-productscategory',
				next: '#next-productscategory',
				auto: false,
				swipe: {
					onTouch : false
				},
				items: {
					width: 160,
					height : 'auto',
					visible: {
						min: 2,
						max: item_productcat
					}
				},
				scroll: {
					items:scrollItem,
					direction : 'left',    
					duration  : 500  
				}
			});
}
		$(window).load(function(){
			runSliderProductCategory();
		});
		$(window).resize(function() {
			runSliderProductCategory();	
	});
	</script>
	
{/if}